<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Composite DITA topics to HTML
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:saxon="http://icl.com/saxon"
                xmlns:lxslt="http://xml.apache.org/xslt"
                xmlns:xalanredirect="org.apache.xalan.xslt.extensions.Redirect"
                xmlns:exsl="http://exslt.org/common"
                extension-element-prefixes="saxon xalanredirect lxslt exsl"
				exclude-result-prefixes="html">

<xsl:param name="outputdir">.</xsl:param>

<xsl:variable name="isEXSLT" select="element-available('exsl:document')"/>
<xsl:variable name="isSaxon" select="element-available('saxon:output')"/>
<xsl:variable name="isXalan"
	select="element-available('xalanredirect:write')"/>

<!-- content output utility -->
<xsl:template name="write-html">
  <xsl:param name="outfile"/>
  <xsl:param name="page"/>
  <xsl:variable name="filename" select="concat($outputdir, '/', $outfile)"/>
  <xsl:choose>
  <xsl:when test="$isSaxon">
    <xsl:message>
      <xsl:value-of select="$outfile"/>
    </xsl:message>
    <saxon:output href="{$filename}"
                  method="xml"
                  omit-xml-declaration="no"
                  encoding="UTF-8"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
                  indent="no">
      <xsl:copy-of select="$page"/>
    </saxon:output>
  </xsl:when>
<!-- UNTESTED -->
  <xsl:when test="$isEXSLT">
    <xsl:message>
      <xsl:value-of select="$outfile"/>
    </xsl:message>
    <exsl:document href="{$filename}"
                  method="html"
                   encoding="UTF-8"
                   indent="no">
      <xsl:copy-of select="$page"/>
    </exsl:document>
  </xsl:when>
  <xsl:when test="$isXalan">
    <!-- Xalan preserves relative path to output file,
         so don't prepend output directory -->
    <xalanredirect:write file="{$outfile}">
      <xsl:copy-of select="$page"/>
    </xalanredirect:write>
  </xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes">
      <xsl:text>Cannot generate files with XSLT processor from </xsl:text>
      <xsl:value-of select="system-property('xsl:vendor')"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
