<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Specific override stylesheet for reference topics (demo)
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 |
 *-->

<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- elements reference and refbody will fall through to topic processors -->


<xsl:template match="*[contains(@class,' reference/refsyn ')]">
  <xsl:call-template name="sect-heading"><xsl:with-param name="deftitle">
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Syntax'"/>
      </xsl:call-template>
      </xsl:with-param></xsl:call-template>
    <xsl:apply-templates/>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/properties ')]">
  <xsl:call-template name="sect-heading"><xsl:with-param name="deftitle"></xsl:with-param></xsl:call-template>
  <table border="1">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <tr><th>Type</th><th>Value</th><th>Description</th></tr>
    <xsl:apply-templates/>
  </table>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/property ')]">
  <tr>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates/>
  </tr>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/proptype ')]">
  <td align="left" valign="top">
    <xsl:call-template name="setclass"/>
    <code>
      <xsl:apply-templates/>
    </code>
  </td>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/propvalue ')]">
  <td align="left" valign="top">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates/>
  </td>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/propdesc ')]">
  <td align="left" valign="top">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates/>
  </td>
</xsl:template>



<xsl:template match="*[contains(@class,' reference/prophead ')]">
  <tr>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates/>
  </tr>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/proptypehd ')]">
  <th align="center" valign="top">
    <xsl:call-template name="setclass"/>
    <code>
      <xsl:apply-templates/>
    </code>
  </th>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/propvaluehd ')]">
  <th align="center" valign="top">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates/>
  </th>
</xsl:template>


<xsl:template match="*[contains(@class,' reference/propdeschd ')]">
  <th align="center" valign="top">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates/>
  </th>
</xsl:template>

</xsl:stylesheet>

