<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Composite DITA topics to HTML
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:html="http://www.w3.org/1999/xhtml"
				exclude-result-prefixes="html">

<!-- stylesheet imports -->
<xsl:import href="dita2htmlImpl.xsl"/>
<xsl:import href="mapwalker.xsl"/>

<!-- override -->
<xsl:template match="*[contains(@class,' map/topicref ')]" mode="process">
  <xsl:param name="infile"/>
  <xsl:param name="outroot"/>
  <xsl:param name="outfile"/>
  <xsl:param name="nodeID"/>
  <xsl:param name="isFirst"/>
  <xsl:if test="$isFirst">
    <xsl:if test="$outroot and $outroot != ''">
      <xsl:call-template name="write-html">
        <xsl:with-param name="outfile" select="$outfile"/>
        <xsl:with-param name="page">
          <xsl:apply-templates select="document($infile, /)" mode="toplevel"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:apply-templates select="*[contains(@class,' map/topicref ')]"/>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
