<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                version='1.0'>


<!-- =================== in-editor conref support ==================== -->


<!-- process conref first -->
<xsl:template name="conref-setup">
      <xsl:apply-templates mode="resolve-conref"/> <!-- was "toptopic" -->
</xsl:template>


<!-- RDA: new templates to process conref. Copy everything as-is, unless this is the
          source for a conref. In that case copy everything but @id, then go back
          to the referencing element to get local attributes (except @conref). -->
<xsl:template match="*|@*|comment()|processing-instruction()|text()" mode="resolve-conref">
  <xsl:param name="original-element"/>  <!-- If present, this came from a conref -->
  <xsl:copy>
    <xsl:choose>
      <xsl:when test="$original-element">
        <xsl:apply-templates select="@*" mode="skip-id"/>
        <xsl:apply-templates select="$original-element" mode="original-attributes"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="@*" mode="resolve-conref"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates 
     select="*|comment()|processing-instruction()|text()" mode="resolve-conref"/>
  </xsl:copy>
</xsl:template>

<!-- When in a source element that was referenced by conref, do not use @id -->
<xsl:template match="@*" mode="skip-id">
  <xsl:copy><xsl:value-of select="."/></xsl:copy>
</xsl:template>
<xsl:template match="@id" mode="skip-id"/>

<!-- When re-processing @* on an element with @conref, do not copy @conref -->
<xsl:template match="*" mode="original-attributes">
  <xsl:apply-templates select="@*" mode="original-attributes"/>
</xsl:template>
<xsl:template match="@*" mode="original-attributes">
  <xsl:copy><xsl:value-of select="."/></xsl:copy>
</xsl:template>
<xsl:template match="@conref" mode="original-attributes"/>


<!--xsl:template match="*[@xconref]" priority="10"-->
<xsl:template match="*[@conref]" priority="2" mode="resolve-conref">
  <!--get element local name, parent topic's domains, and then file name, topic id, element id from conref value-->
  <xsl:variable name="element">
    <xsl:value-of select="local-name(.)"/>
  </xsl:variable>
  <xsl:variable name="domains">
    <!--xsl:value-of select="ancestor::*[contains(@class, ' topic/body ')]/parent::*/@domains"/-->
    <xsl:value-of select="ancestor-or-self::*[contains(@class, ' topic/topic ')][1]/@domains"/>
  </xsl:variable>
  <xsl:variable name="file">
    <xsl:choose>
       <xsl:when test="contains(@conref,'#')"><xsl:value-of select="$WORKDIR"/><xsl:value-of select="substring-before(@conref,'#')"/></xsl:when>
       <xsl:otherwise><xsl:value-of select="$WORKDIR"/><xsl:value-of select="@conref"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicid">
    <xsl:choose>
       <xsl:when test="contains(@conref,'#') and contains(substring-after(@conref,'#'),'/')"><xsl:value-of select="substring-before(substring-after(@conref,'#'),'/')"/></xsl:when>
       <xsl:when test="contains(@conref,'#')"><xsl:value-of select="substring-after(@conref,'#')"/></xsl:when>
       <xsl:otherwise>none</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="elemid">
    <xsl:choose>
     <xsl:when test="contains(@conref,'#') and contains(substring-after(@conref,'#'),'/')"><xsl:value-of select="substring-after(substring-after(@conref,'#'),'/')"/></xsl:when>
     <xsl:otherwise>none</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicpos">
    <xsl:choose>
       <xsl:when test="starts-with(@conref,'#')">samefile</xsl:when>
       <xsl:when test="contains(@conref,'#')">otherfile</xsl:when>
       <xsl:otherwise>firstinfile</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <fo:block background-color="#e000e0">
  <!--xsl:variable name="DBG">no</xsl:variable-->
  <xsl:if test="$DBG='yes'">
    <fo:inline font-weight="bold" font-style="italic">Conref trace: </fo:inline>
    <fo:block><fo:inline font-weight="bold" > Element: </fo:inline><xsl:value-of select="name()"/>:<xsl:value-of select="$element"/></fo:block>
    <fo:block><fo:inline font-weight="bold"> Domains: </fo:inline><xsl:value-of select="$domains"/></fo:block>
    <fo:block><fo:inline font-weight="bold"> Working dir: </fo:inline><xsl:value-of select="$WORKDIR"/></fo:block>
    <fo:block><fo:inline font-weight="bold"> File: </fo:inline><xsl:value-of select="$file"/></fo:block>
    <fo:block><fo:inline font-weight="bold"> Topicid: </fo:inline><xsl:value-of select="$topicid"/></fo:block>
    <fo:block><fo:inline font-weight="bold"> Elemid: </fo:inline><xsl:value-of select="$elemid"/></fo:block>
    <fo:block><fo:inline font-weight="bold"> Topic location: </fo:inline><xsl:value-of select="$topicpos"/></fo:block>
  </xsl:if>
<xsl:variable name="copy-tree">
  <xsl:choose>
     <xsl:when test="contains(substring-after(@conref,'#'),'/')"><!--targetting an element inside a topic-->
       <xsl:choose>
          <xsl:when test="$topicpos='samefile'">
            <xsl:apply-templates select="//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains]/*[contains(@class, ' topic/body ')]//*[local-name()=$element][@id=$elemid]"/>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
            <xsl:apply-templates select="document($file,/)//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains]/*[contains(@class, ' topic/body ')]//*[local-name()=$element][@id=$elemid]"/>
          </xsl:when>
          <xsl:otherwise/><!-- error msg -->
       </xsl:choose>
     </xsl:when>
     <xsl:otherwise><!--assume targetting a topic-->
       <xsl:choose>
          <xsl:when test="$topicpos='samefile'">
            <xsl:apply-templates select="//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains][local-name()=$element]"/>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
            <xsl:apply-templates select="document($file,/)//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains][local-name()=$element]"/>
          </xsl:when>
          <xsl:when test="$topicpos='firstinfile'">
            <xsl:apply-templates select="document($file,/)//*[contains(@class, ' topic/topic ')][1][@domains=$domains][local-name()=$element]"/>
          </xsl:when>
          <xsl:otherwise/><!-- error msg -->
       </xsl:choose>
     </xsl:otherwise>
  </xsl:choose>
</xsl:variable>
    <fo:inline background-color="yellow">[<xsl:value-of select="$copy-tree/*"/>]
</fo:inline>
  </fo:block>
</xsl:template>

<!-- =================== end of conref support ====================== -->



</xsl:stylesheet>
