<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | DITA topic to HTML; "single topic to single web page"-level view
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 | 06032002 DRD changed indent="yes" to indent="no" for all html transforms (XSL import constraint)
 | 07102002 DRD Added missing quotes to 'E' and 'F' error tests in output-message
 | 07172002 DRD Added new var for $efill, filler for empty table cells (was hardcoded #160)
 |              Added simple id/headers accessibility for regular tables and simpletables
 |              Changed default fig caption placement from under to over (match table)
 | 08012002 DRD Moved the placement of fig's intial caption maker to just before the div
 | 10232002 DRD Updated gen-dflt-data-hdr from @spectitle to @specentry attr selectors
 | 05282003 DRD Revised the relcolwidth code to work consistently with * wildcards
 | 05292003 DRD separated syntaxdiagram support from domains to allow alternate outputs (braces and svg),
 |              and also fixed the braces support for "or" conditions
 | 06112003 DRD Added flagging hooks into select elements; added flagit template
 +
 | Add list:
 *-->


<!-- BUGS:
1. Excluded footnotes still get generated as endnotes.
   Footnotes located within required cleanup will be rendered whether the doc is output in draft mode or not.
   This is due to pull-based processing of endnotes, which gets content that would ordinarily be excluded by 
   particular processing settings.  This is actually a general problem faced by ANY XSLT processor that
   has pull-based templates intermingled with push-based exclusion logic.  Ideally, exclusion should remove
   an element from the DOM, then you can depend on pull not to find things it shouldn't find!  Can it be done
   with only one pass with XSLT 1.0?
 +-->



<xsl:transform version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- OTHER STYLESHEET INCLUDES/IMPORTS -->
<xsl:import href="xslhtml/topic2htmlImpl.xsl"/>
<xsl:import href="xslhtml/domains2html.xsl"/>

<!-- OUTPUT METHOD -->

<!-- XHTML output with XML syntax) -->
<xsl:output method="xml"
            encoding="utf-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
            cdata-section-elements="codeblockx"
/>

</xsl:transform>
