<?xml version="1.0" encoding="UTF-8" ?>
<!-- syntaxdiagram.xsl
 | DITA topic to HTML; "single topic to single web page"-level view
 |
 | Copyright IBM Corporation, 2002
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
   Transform style for producing HTML from IBMIDDoc Syntax markup.
Based on Dynatext styles for rendering in the DynaText browser... modified
here to produce HTML.

This is a start; It is not yet completed:
     o indicating "default" constructs by wrapping in HTML <u>.
     o provide delimiters for repetition?
     o syntax notes
     o associative links
          - fragref to fragment (this could be done easily through
             explicity id/refid)
          - keywords/variables to description in parameter list
             (depends on adoption of parameter list markup)
5/8:
Added scale processing

8/1/2002: RDA added code to use IDWB intermediate syntax format, for
          use with the existing idsyngen program.
          E003224 change frame attributes from figborder to synborder, when ibmdita.css is updated
          Add image/link to accessible diagram, and link around diagram
E003460 Add link to accessible syntax diagram
7/24/2003: E003761 Update synnote processing to match IBMIDDoc.
-->
<!-- <!DOCTYPE xsl:transform [<!ENTITY nl "&#xd;&#xa;">]>

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"> -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://icl.com/saxon"
                xmlns:xt="http://www.jclark.com/xt"
                extension-element-prefixes="saxon xt">
<!-- <xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                extension-element-prefixes="saxon"/> -->

<xsl:output method="html"/>

<xsl:template match="*[contains(@class, ' pr-d/syntaxdiagram ')]" priority="2">
<xsl:variable name="synfilename">
  <xsl:value-of select="substring-before($FILENAME,'.dita')"/>
  <xsl:text>_syn</xsl:text>
  <xsl:number level="any"/>
  <xsl:text>.syn</xsl:text>
</xsl:variable>
  <xsl:apply-templates select="@id"/>
  <!-- ADD LINK TO ACCESSIBLE DIAGRAM -->
  <!-- ADD LINK AROUND THE DIAGRAM -->
  <xsl:choose>
    <xsl:when test="contains(system-property('xsl:vendor'), 'SAXON') or
                    contains(system-property('xsl:vendor'), 'James Clark')">
      <pre>
      <xsl:call-template name="setscale"/>
      <xsl:call-template name="add-frame-attribute"/>

      <!-- Add link to readable diagram. The span is here to make img valid within pre. -->
      <span><img src="{$PATH2PROJ}c.gif" border="0" >
       <xsl:attribute name="alt">
        <xsl:call-template name="getString">
         <xsl:with-param name="stringName" select="'Read syntax diagram'"/>
        </xsl:call-template>
       </xsl:attribute>
       <!-- longdesc="acc1syn3.htm"  The filename is generated using
                                     {filename}syn{x}.{outext}          -->
       <xsl:variable name="syn-count">          <!-- Number of syntax diags before this one -->
        <xsl:number count="*/*[contains(@class, ' pr-d/syntaxdiagram ')]" level="any"/>
       </xsl:variable>
       <xsl:attribute name="longdesc">
        <xsl:value-of select="substring-before($FILENAME,'.dita')"/>syn<xsl:value-of select="$syn-count"/>.<xsl:value-of select="$OUTEXT"/>
       </xsl:attribute>
      </img></span>

      <!-- Add skip around -->
      <a href="#{generate-id(.)}">
      <img src="{$PATH2PROJ}c.gif" border="0" >
       <xsl:attribute name="alt">
        <xsl:call-template name="getString">
         <xsl:with-param name="stringName" select="'Skip visual syntax diagram'"/>
        </xsl:call-template>
       </xsl:attribute>
      </img></a>

      <!-- Imbed a marker inside a <pre> element. The diagram will be inserted later. -->
      <xsl:text>
.im </xsl:text><xsl:value-of select="$synfilename"/><xsl:text>
</xsl:text>
      </pre>

      <!-- end of skip around -->
      <a name="{generate-id(.)}" />

      <!-- Use the engine-specific output-redirector to output a temporary syntax file -->
      <xsl:choose>
        <xsl:when test="contains(system-property('xsl:vendor'), 'SAXON')">
          <saxon:output href="{$synfilename}">
            <xsl:call-template name="output-railroad-syntax-diagram"/>
          </saxon:output>
        </xsl:when>
        <xsl:otherwise>
          <xt:document method="html" href="{$synfilename}">
            <xsl:call-template name="output-railroad-syntax-diagram"/>
          </xt:document>
        </xsl:otherwise>
      </xsl:choose>

    </xsl:when>
    <!-- If not using saxon (unable to write side files), attempt an inline diagram -->
    <xsl:otherwise>
      <div>
      <xsl:call-template name="setscale"/>
      <xsl:call-template name="add-frame-attribute"/>
      <xsl:call-template name="output-message">
        <xsl:with-param name="msg">Approximating syntax diagram in XSL by using braces and brackets.
Railroad diagram processing is not available.</xsl:with-param>
        <xsl:with-param name="msgnum">002</xsl:with-param>
        <xsl:with-param name="msgsev">I</xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates select="*" mode="fallthrough-syntax"/>
      </div>
    </xsl:otherwise>
  </xsl:choose>

  <!-- If there are any synnote's, place the list after the diagram -->
  <xsl:call-template name="output-synnote-list"/>

  <!-- ADD ANCHOR FOR LINK AROUND DIAGRAM -->
</xsl:template>

<!--Generate a temporary syntax file that can be post-processed into
    a railroad style syntax diagram. -->
<!-- none of these are producing debug information -->
<xsl:template name="output-railroad-syntax-diagram">
  <xsl:text>
(SYNTAX
</xsl:text>
  <!-- To match other syntax formats, all repsep information must be moved
       to the top of the diagram and referenced from below -->
  <xsl:for-each select=".//*[contains(@class, ' pr-d/repsep ')]">
    <xsl:text>(REPSEP
AID </xsl:text><xsl:value-of select="generate-id(.)"/><xsl:text>
</xsl:text>
    <xsl:call-template name="optreq-attribute"/>
    <xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
)REPSEP
</xsl:text>
  </xsl:for-each>
  <xsl:apply-templates select="*" mode="railroad-syntax"/>
  <xsl:text>)SYNTAX
</xsl:text>
</xsl:template>

<xsl:template name="add-frame-attribute">
  <xsl:choose>
    <xsl:when test="@frame='all'">
      <xsl:attribute name="class">synborder</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='sides'">
      <xsl:attribute name="class">synsides</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='top'">
      <xsl:attribute name="class">syntop</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='bottom'">
      <xsl:attribute name="class">synbottom</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='topbot'">
      <xsl:attribute name="class">syntopbot</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
      <!-- @frame = none or blank -->
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Output the optreq attribute for any element that needs it -->
<xsl:template name="optreq-attribute">
  <xsl:if test="@importance">
    <xsl:choose>
      <xsl:when test="contains(@importance,'optional')">
<xsl:text>AOPTREQ OPT
</xsl:text>
      </xsl:when>
      <xsl:when test="contains(@importance,'required')">
<xsl:text>AOPTREQ REQ
</xsl:text>
      </xsl:when>
      <xsl:when test="contains(@importance,'default')">
<xsl:text>AOPTREQ DEF
</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:if>
</xsl:template>

<!-- Use the same processing for each type of group, and set the choiceseq attribute
     based on a parameter -->
<xsl:template name="process-group">
  <xsl:param name="choiceseq"/>
  <xsl:text>(GROUP
ACHOICESEQ </xsl:text><xsl:value-of select="$choiceseq"/><xsl:text>
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <!-- If this group contains a repsep, output the repid -->
  <xsl:if test="./*[contains(@class, ' pr-d/repsep ')]">
<xsl:text>AREPID </xsl:text><xsl:value-of select="generate-id(./*[contains(@class, ' pr-d/repsep ')])"/><xsl:text>
</xsl:text>
  </xsl:if>
  <xsl:apply-templates select="*" mode="railroad-syntax"/>
  <xsl:text>)GROUP
</xsl:text>
</xsl:template>

<!-- Process all 3 types of <group> elements -->
<xsl:template match="*[contains(@class, ' pr-d/groupcomp ')]" mode="railroad-syntax">
  <xsl:call-template name="process-group">
    <xsl:with-param name="choiceseq">COMPOSITE</xsl:with-param>
  </xsl:call-template>
</xsl:template>
<xsl:template match="*[contains(@class, ' pr-d/groupchoice ')]" mode="railroad-syntax">
  <xsl:call-template name="process-group">
    <xsl:with-param name="choiceseq">CHOICE</xsl:with-param>
  </xsl:call-template>
</xsl:template>
<xsl:template match="*[contains(@class, ' pr-d/groupseq ')]" mode="railroad-syntax">
  <xsl:call-template name="process-group">
    <xsl:with-param name="choiceseq">SEQ</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- These are processed using pull processing, so make sure they don't fall through -->
<xsl:template match="*[contains(@class, ' pr-d/repsep ')]" mode="railroad-syntax"/>

<!-- If the diagram contains any synnote elements, list them with the heading "Notes".
     This template should be called after the diagram is processed. -->
<xsl:template name="output-synnote-list">
  <xsl:if test="descendant::*[contains(@class, ' pr-d/synnote ')]">
    <div class="notelisttitle">     <!-- add to CSS file -->
    <xsl:call-template name="getString">
      <xsl:with-param name="stringName" select="'Notes'"/>
    </xsl:call-template>
    <xsl:text>:</xsl:text>
    </div>
    <ol type="1">
      <!-- Process the first note or reference with mode=create-synnote-list.
           It will call the next one recursively. Pass the syntax ID so the template knows
           when it has left the current diagram. -->
      <xsl:apply-templates select="(.//*[contains(@class, ' pr-d/synnote ')][not(@id)][1] |
                                    .//*[contains(@class, ' pr-d/synnoteref ')][1])[1]"
                           mode="create-synnote-list">
        <xsl:with-param name="syntax-id" select="generate-id(.)"/>
      </xsl:apply-templates>
    </ol>
  </xsl:if>
</xsl:template>

<!-- Skip synnotes when creating the ordinary list of end notes in dit2htm -->
<xsl:template match="*[contains(@class, ' pr-d/synnote ')]" mode="genEndnote" priority="1"/>

<!-- Output synnote contents in the synnote list. It only appears if it has no ID; those with
     IDs appear in the order they are referenced. -->
<xsl:template match="*[contains(@class, ' pr-d/synnote ')]" mode="create-synnote-list">
  <xsl:param name="syntax-id"/>
  <xsl:param name="found-references"/>
  <xsl:choose>
    <!-- If we've moved to the next diagram, stop looking -->
    <xsl:when test="$syntax-id != generate-id(ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')])"/>
    <xsl:otherwise>
      <!-- Only output it here if there is no ID. Shouldn't be in this template with an ID: this
           is just a safety check. -->
      <xsl:if test="not(@id)">
        <li><xsl:apply-templates/></li>
      </xsl:if>
      <!-- Move on to the next synnote or synnoteref. -->
      <xsl:apply-templates select="(following::*[contains(@class, ' pr-d/synnote ')][not(@id)] |
                                    following::*[contains(@class, ' pr-d/synnoteref ')])[1]"
                           mode="create-synnote-list">
        <xsl:with-param name="syntax-id"><xsl:value-of select="$syntax-id"/></xsl:with-param>
        <xsl:with-param name="found-references"><xsl:value-of select="$found-references"/></xsl:with-param>
      </xsl:apply-templates>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- When a synnote reference is found, output that synnote in the list. It should only be created
     the first time it appears in the diagram. When it appears, <@href> is added to found-references,
     so that it can be skipped if encountered again. -->
<xsl:template match="*[contains(@class, ' pr-d/synnoteref ')]" mode="create-synnote-list">
  <xsl:param name="syntax-id"/>
  <xsl:param name="found-references"/>
  <xsl:variable name="href-key">&lt;#<xsl:value-of select="substring-after(@href,'#')"/>&gt;</xsl:variable>
  <xsl:choose>
    <!-- If we've moved to the next diagram, stop looking -->
    <xsl:when test="$syntax-id != generate-id(ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')])"/>
    <xsl:otherwise>
      <!-- Only output it here if a reference has not yet been found -->
      <xsl:if test="not(contains($found-references,$href-key))">
        <xsl:variable name="target-id" select="substring-after(substring-after(@href,'#'),'/')"/>
        <li>
          <!-- Should only be one, but for-each allows us to easily get both children and text -->
          <xsl:for-each select="ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')]//
                                *[contains(@class, ' pr-d/synnote ')][@id=$target-id]">
            <xsl:apply-templates/>
          </xsl:for-each>
        </li>
      </xsl:if>
      <!-- Move on to the next synnote or synnoteref -->
      <xsl:apply-templates select="(following::*[contains(@class, ' pr-d/synnote ')][not(@id)] |
                                    following::*[contains(@class, ' pr-d/synnoteref ')])[1]"
                           mode="create-synnote-list">
        <xsl:with-param name="syntax-id"><xsl:value-of select="$syntax-id"/></xsl:with-param>
        <xsl:with-param name="found-references">
          <xsl:value-of select="$found-references"/>
          <xsl:value-of select="$href-key"/>    <!-- Add the href-key to found-references, even if it -->
        </xsl:with-param>                       <!-- was already there -->
      </xsl:apply-templates>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Output a <synnoteref> reference. To do this, first determine the synnote that is being
     referenced. For a synnoteref to be valid, the referenced note should be in this topic,
     and in this syntaxdiagram. An extra check is made to be sure the ID's match, so that
     "ref" will not match "synref", which contains it. If the reference is valid, process
     the referenced synnote. -->
<xsl:template match="*[contains(@class, ' pr-d/synnoteref ')]" mode="railroad-syntax">
  <xsl:if test="@href">
    <xsl:variable name="actualtopicid" select="ancestor::*[contains(@class,' topic/body ')]/parent::*/@id"/>
    <xsl:variable name="targettopicid" select="substring-before(substring-after(@href,'#'),'/')"/>
    <xsl:variable name="targetsynnote" select="substring-after(@href,'/')"/>
    <xsl:choose>
      <!-- When the following are true, in order:
           * this topic's ID contains the target ID
           * the target ID contains this topic's ID
           * There is a synnote in this syntaxdiagram, with an ID, where that ID contains
             the reference, and the reference contains the target ID
           Then apply templates on that selected synnote. -->
      <xsl:when test="contains(actualtopicid,targettopicid) and
                      contains(targettopicid,actualtopicid) and
                      ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')]//
                                *[contains(@class, ' pr-d/synnote ')]
                                 [@id]
                                 [contains(@id,$targetsynnote)]
                                 [contains($targetsynnote,@id)]">
        <xsl:call-template name="output-synnote"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="output-message">
          <xsl:with-param name="msg">A synnoteref element may only reference a synnote within the same syntax diagram.</xsl:with-param>
          <xsl:with-param name="msgnum">003</xsl:with-param>
          <xsl:with-param name="msgsev">W</xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>

<!-- Process a synnote. E003761: if it has an ID, it should only appear when referenced. -->
<xsl:template match="*[contains(@class, ' pr-d/synnote ')]" mode="railroad-syntax">
  <xsl:if test="not(@id)">
    <xsl:call-template name="output-synnote"/>
  </xsl:if>
</xsl:template>

<!-- Output a synnote. Used by synnotes without ID, and by synnoteref. Create the temp file
     format, and then call the complex template to get the correct number. -->
<xsl:template name="output-synnote">
  <xsl:text>(SYNNOTE
-(</xsl:text> 
  <xsl:call-template name="get-current-synnote-number"/>
  <xsl:text>)
)SYNNOTE
</xsl:text>
</xsl:template>

<!-- Use a new mode to count synnotes. They are counted based on which are actually used
     first. Synnotes without an ID get added to the count immediately; synnotes with an ID
     are added to the count the first time they are referenced. 
     The mode "counting-synnotes" goes through each synnote and synnoteref, and adds to the
     count when needed. It stops when it gets to the synnote being tested.
     The ID of the ancestor syntaxdiagram is also sent; if something goes wrong and
     we move to the next diagram, stop counting and return 0 as a fallback. -->
<xsl:template name="get-current-synnote-number">
  <xsl:variable name="target-synnote">
    <!-- Remove the file name, if present, and #; references can only be within this diagram.
         This will let us stop the first time the target synnote is referenced, instead of
         counting up to the current synnoteref. -->
    <xsl:if test="@href"><xsl:value-of select="substring-after(@href,'#')"/></xsl:if>
  </xsl:variable>
  <!-- Go back to the first note in the diagram, and start counting -->
  <xsl:apply-templates select="(ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')][1]//
                                                *[contains(@class, ' pr-d/synnote ')][not(@id)][1] |
                                ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')][1]//
                                                *[contains(@class, ' pr-d/synnoteref ')][1])[1]"
                       mode="counting-synnotes">
    <xsl:with-param name="test-note"><xsl:value-of select="generate-id(.)"/></xsl:with-param>
    <xsl:with-param name="looking-for"><xsl:value-of select="$target-synnote"/></xsl:with-param>
    <xsl:with-param name="syntax-id"><xsl:value-of select="generate-id(ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')])"/></xsl:with-param>
  </xsl:apply-templates>
</xsl:template>

<!-- Count a synnote with no ID. If this is the one we are testing, add to the count
     and return. Otherwise, add to the count and go to the next synnote or synnoteref. -->
<xsl:template match="*[contains(@class, ' pr-d/synnote ')]" mode="counting-synnotes">
  <xsl:param name="test-note"/>         <!-- ID of the node we're counting for -->
  <xsl:param name="looking-for"/>       <!-- Href of the source node, if it was synnoteref -->
  <xsl:param name="syntax-id"/>         <!-- ID of the syntax diagram -->
  <xsl:param name="current-count">0</xsl:param>  
  <xsl:param name="found-references"/>  <!-- HREF values that have already been counted -->
  
  <xsl:choose>
    <!-- If this is the correct node, return the count -->
    <xsl:when test="generate-id(.)=$test-note">
      <xsl:value-of select="$current-count+1"/>
    </xsl:when>
    <!-- If we've left the correct diagram, return 0 as fallback -->
    <xsl:when test="generate-id(ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')])!=$syntax-id">0</xsl:when>
    <xsl:otherwise>
      <!-- Increment the count, and move to the next note or reference -->
      <xsl:apply-templates select="(following::*[contains(@class, ' pr-d/synnote ')][not(@id)] |
                                    following::*[contains(@class, ' pr-d/synnoteref ')])[1]"
                           mode="counting-synnotes">
        <xsl:with-param name="test-note"><xsl:value-of select="$test-note"/></xsl:with-param>
        <xsl:with-param name="looking-for"><xsl:value-of select="$looking-for"/></xsl:with-param>
        <xsl:with-param name="syntax-id"><xsl:value-of select="$syntax-id"/></xsl:with-param>
        <xsl:with-param name="current-count"><xsl:value-of select="$current-count+1"/></xsl:with-param>
        <xsl:with-param name="found-references"><xsl:value-of select="$found-references"/></xsl:with-param>
      </xsl:apply-templates>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Count a synnoteref. The variable found-references keeps track of synnoteref
     values that have already been counted. Each time synnoteref is encountered, 
     <@href> is added to the variable.
     - If <@href> does not appear in the list, this is the first time it has been seen
        - If this is the one we want, increment the count and return it
        - If the href value matches the target href, this is the first time it is referenced;
          increment the count and return it
        - Otherwise, increment and move on to the next item
     - If <@href> appears in the list, we have seen this reference. Do not increment the count.
        - Add <@href> to the list and move to the next note
-->
<xsl:template match="*[contains(@class, ' pr-d/synnoteref ')]" mode="counting-synnotes">
  <xsl:param name="test-note"/>
  <xsl:param name="looking-for"/>
  <xsl:param name="syntax-id"/>
  <xsl:param name="current-count">0</xsl:param>
  <xsl:param name="found-references"/>
  <xsl:variable name="href-key">&lt;#<xsl:value-of select="substring-after(@href,'#')"/>&gt;</xsl:variable>
  <xsl:variable name="new-count">
    <!-- If this synnoteref has appeared before, the count should not go up -->
    <xsl:choose>
      <xsl:when test="contains($found-references,$href-key)"><xsl:value-of select="$current-count"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$current-count+1"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <xsl:choose>
    <!-- If this is the correct synnoteref, or one with the same href value, return the new count -->
    <xsl:when test="(generate-id(.)=$test-note) or (substring-after(@href,'#')=$looking-for)">
      <xsl:value-of select="$new-count"/>
    </xsl:when>
    <!-- If we have passed to the next diagram, return 0 as a fallback -->
    <xsl:when test="generate-id(ancestor::*[contains(@class, ' pr-d/syntaxdiagram ')])!=$syntax-id">0</xsl:when>
    <xsl:otherwise>
      <!-- Move on to the next note. Add @href to the found references. -->
      <xsl:apply-templates select="(following::*[contains(@class, ' pr-d/synnote ')][not(@id)] |
                                    following::*[contains(@class, ' pr-d/synnoteref ')])[1]"
                           mode="counting-synnotes">
        <xsl:with-param name="test-note"><xsl:value-of select="$test-note"/></xsl:with-param>
        <xsl:with-param name="syntax-id"><xsl:value-of select="$syntax-id"/></xsl:with-param>
        <xsl:with-param name="looking-for"><xsl:value-of select="$looking-for"/></xsl:with-param>
        <xsl:with-param name="current-count"><xsl:value-of select="$new-count"/></xsl:with-param>
        <xsl:with-param name="found-references">
          <xsl:value-of select="$found-references"/>
          <xsl:value-of select="$href-key"/>
          <!-- For the future, if needed: found-references can also store the count for this reference;
               that way, if you come to the right node but we've already passed the first appearance,
               it can be pulled from this variable. Should not be needed, assuming $looking-for works. -->
          <!--<xsl:value-of select="$new-count"/>-->
        </xsl:with-param>
      </xsl:apply-templates>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Output a KWD element, with the optreq attribute -->
<xsl:template match="*[contains(@class, ' pr-d/kwd ')]" mode="railroad-syntax">
  <xsl:text>(KWD
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
)KWD
</xsl:text>
</xsl:template>

<!-- Output a VAR element, with the optreq attribute. Add the LINKHI attributes
     to create italics around the contents in the diagram that will be created. -->
<xsl:template match="*[contains(@class, ' pr-d/var ')]" mode="railroad-syntax">
  <xsl:text disable-output-escaping="yes">(VAR
ALINKHISTART &lt;i>
ALINKHIEND &lt;/i>
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
)VAR
</xsl:text>
</xsl:template>

<!-- Output a SEP element, with the optreq attribute -->
<xsl:template match="*[contains(@class, ' pr-d/sep ')]" mode="railroad-syntax">
  <xsl:text>(SEP
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
)SEP
</xsl:text>
</xsl:template>

<!-- Output a DELIM element, with the optreq attribute -->
<xsl:template match="*[contains(@class, ' pr-d/delim ')]" mode="railroad-syntax">
  <xsl:text>(DELIM
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
)DELIM
</xsl:text>
</xsl:template>

<!-- Output a OPER element, with the optreq attribute -->
<xsl:template match="*[contains(@class, ' pr-d/oper ')]" mode="railroad-syntax">
  <xsl:text>(OPER
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
)OPER
</xsl:text>
</xsl:template>

<!-- Output a SYNBLK element with contents -->
<xsl:template match="*[contains(@class, ' pr-d/synblk ')]" mode="railroad-syntax">
  <xsl:text>(SYNBLK
</xsl:text>
  <xsl:apply-templates select="*" mode="railroad-syntax"/>
<xsl:text>)SYNBLK
</xsl:text>
</xsl:template>

<!-- Output a FRAGMENT element with contents -->
<xsl:template match="*[contains(@class, ' pr-d/fragment ')]" mode="railroad-syntax">
  <xsl:text>(FRAGMENT
</xsl:text>
  <xsl:apply-templates select="*" mode="railroad-syntax"/>
<xsl:text>)FRAGMENT
</xsl:text>
</xsl:template>

<!-- will ignore image, boolean, etc in a fragref: is this really a problem? Otherwise, need
     a way to ensure there is no extra formatting here? -->
<xsl:template match="*[contains(@class, ' pr-d/fragref ')]" mode="railroad-syntax">
  <xsl:text>(FRAGREF
</xsl:text>
  <xsl:call-template name="optreq-attribute"/>
  <xsl:text>(TITLE
-</xsl:text>
<xsl:choose>
  <xsl:when test="text()"><xsl:value-of select="normalize-space(.)"/></xsl:when>
  <xsl:when test="@href">
    <!-- Get the ID minus optional file name -->
    <xsl:variable name="target-topic-with-id"><xsl:value-of select="substring-after(@href,'#')"/></xsl:variable>
    <!-- Get the ID minus the topic ID -->
    <xsl:variable name="targetid"><xsl:value-of select="substring-after($target-topic-with-id,'/')"/></xsl:variable>
    <!-- Look for the ancestor syntaxdiagram, then down for a fragment that matches the ID, then title of that fragment -->
    <xsl:variable name="target-title">
      <xsl:value-of select="ancestor::*[contains(@class,' pr-d/syntaxdiagram ')]/
                            descendant::*[contains(@class,' pr-d/fragment ')][@id=$targetid]/
                            *[contains(@class,' topic/title ')]"/>
    </xsl:variable>
    <!-- Use the normalized version of the title, to remove newlines -->
    <xsl:value-of select="normalize-space($target-title)"/>
  </xsl:when>
</xsl:choose>
<xsl:text>
)TITLE
)FRAGREF
</xsl:text>
</xsl:template>

<!-- Match the following, in order:
     * syntaxdiagram/title
     * groupseq/title
     * groupcomp/title
     * groupchoice/title
     * fragment/title -->
<!-- will ignore image, boolean, etc: is this really a problem? -->
<xsl:template match="*[contains(@class, ' pr-d/syntaxdiagram ')]/*[contains(@class, ' topic/title ')] |
                     *[contains(@class, ' pr-d/groupseq ')]/*[contains(@class, ' topic/title ')] |
                     *[contains(@class, ' pr-d/groupcomp ')]/*[contains(@class, ' topic/title ')] |
                     *[contains(@class, ' pr-d/groupchoice ')]/*[contains(@class, ' topic/title ')] |
                     *[contains(@class, ' pr-d/fragment ')]/*[contains(@class, ' topic/title ')] " mode="railroad-syntax">
  <xsl:text>(TITLE
</xsl:text>
<xsl:text>-</xsl:text><xsl:value-of select="normalize-space(.)"/>
<xsl:text>
)TITLE
</xsl:text>
</xsl:template>

<!-- BACKUP PROCESSING FOR NON RAILROAD-STYLE SYNTAX DIAGRAMS -->
<xsl:template match="*[contains(@class, ' pr-d/synnote ')]" priority="2" mode="fallthrough-syntax"/>       <!-- Use the same synnote processing -->
<xsl:template match="*[contains(@class, ' pr-d/synnoteref ')]" priority="2" mode="fallthrough-syntax"/>    <!-- as the railroad diagrams        -->

<xsl:template match="fragment" mode="fallthrough-syntax">
     <div>
     <a><xsl:attribute name="name"><xsl:value-of select="title"/></xsl:attribute> </a>
     <xsl:apply-templates/>
     </div>
</xsl:template>

<!-- Title is optional-->
<xsl:template match="syntaxdiagram/title" mode="fallthrough-syntax">
     <h3>
     <xsl:value-of select="."/>
     </h3>
</xsl:template>

<!-- Basically, we want to hide his content. -->
<xsl:template match="repsep" mode="fallthrough-syntax"/>

<xsl:template match="delim">
     <kbd>
       <xsl:value-of select="."/>
     </kbd>
</xsl:template>

<xsl:template match="kwd" mode="fallthrough-syntax">
<kbd>
  <xsl:if test="parent::groupchoice"><xsl:if test="count(preceding-sibling::*)!=0"> | </xsl:if></xsl:if>
  <xsl:if test="@importance='optional'"> [</xsl:if>
  <xsl:choose>
    <xsl:when test="@importance='default'"><u><xsl:value-of select="."/></u></xsl:when>
    <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
  </xsl:choose>
  <xsl:if test="@importance='optional'">] </xsl:if>
</kbd>
</xsl:template>

<!-- This should test to see if there's a fragment with matching title
and if so, produce an associative link. -->
<xsl:template match="fragref" priority="100" mode="fallthrough-syntax">
     <kbd>
      <a><xsl:attribute name="href">#<xsl:value-of select="."/></xsl:attribute>
     &lt;<xsl:value-of select="."/>&gt;</a>
     </kbd>
</xsl:template>

<!-- Where is the template for var with a priority of 50? -->
<xsl:template match="var" priority="51" mode="fallthrough-syntax">
 <var>
  <xsl:if test="parent::groupchoice"> | </xsl:if>
  <xsl:if test="@importance='optional'"> [</xsl:if>
  <xsl:choose>
    <xsl:when test="@importance='default'"><u><xsl:value-of select="."/></u></xsl:when>
    <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
  </xsl:choose>
  <xsl:if test="@importance='optional'">] </xsl:if>
 </var>
</xsl:template>

<xsl:template match="fragment/title" mode="fallthrough-syntax">
     <h4><xsl:apply-templates/></h4>
</xsl:template>

<xsl:template match="fragment/groupcomp|fragment/groupchoice|fragment/groupseq" mode="fallthrough-syntax">
     <blockquote>
     <xsl:call-template name="dogroup"/>
     </blockquote>
</xsl:template>

<xsl:template match="syntaxdiagram/groupcomp|syntaxdiagram/groupseq|syntaxdiagram/groupchoice" priority="2" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<!-- okay, here we have to work each permutation because figgroup/figroup fallback is too general -->
<xsl:template match="groupcomp/groupcomp" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupchoice/groupchoice" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupseq/groupseq" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupchoice/groupcomp" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>
<xsl:template match="groupchoice/groupseq" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupcomp/groupchoice" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupcomp/groupseq" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupseq/groupchoice" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

<xsl:template match="groupseq/groupcomp" mode="fallthrough-syntax">
     <xsl:call-template name="dogroup"/>
</xsl:template>

     <!--xsl:if test="../@choiceseq='choice'"> | </xsl:if-->
<xsl:template name="dogroup">
     <xsl:if test="parent::groupchoice">
          <xsl:if test="count(preceding-sibling::*)!=0"> | </xsl:if>
     </xsl:if>
     <xsl:if test="@importance='optional'">[</xsl:if>
     <xsl:if test="name()='groupchoice'">{</xsl:if>
       <xsl:text> </xsl:text><xsl:apply-templates/><xsl:text> </xsl:text>
<!-- repid processed here before -->
     <xsl:if test="name()='groupchoice'">}</xsl:if>
     <xsl:if test="@importance='optional'">]</xsl:if>
</xsl:template>

<xsl:template match="groupcomp/title|groupseq/title|groupseq|title" mode="fallthrough-syntax"/>  <!-- Consume title -->

<xsl:template match="oper" mode="fallthrough-syntax">
     <kbd>
     <xsl:value-of select="."/>
     </kbd>
</xsl:template>

<xsl:template match="sep" mode="fallthrough-syntax">
     <kbd>
     <xsl:value-of select="."/>
     </kbd>
</xsl:template>

</xsl:stylesheet>
