<?xml version="1.0" encoding="UTF-8" ?>
<!--  myoverrides.xsl (derived from all2html.xsl)
 | Composite DITA topics to HTML with processing override examples
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- stylesheet imports -->

<xsl:import href="topic2html.xsl"/>
<xsl:import href="xslhtml/domains2html.xsl"/>
<xsl:import href="task2html.xsl"/>
<xsl:import href="ref2html.xsl"/>


<!-- XHTML output with XML syntax -->
<xsl:output method="xml"
            encoding="utf-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>


<xsl:template match="/" priority="3">
  <xsl:comment>Composite DITA to XHTML application by IBM Corp., 2001, 2002, 2003</xsl:comment>
  <xsl:message>DITA File = <xsl:value-of select="$FILENAME"/>, DocID = <xsl:value-of select="generate-id(/)"/></xsl:message>
  <xsl:apply-templates mode="toplevel"/>
</xsl:template>


<!-- =============== start of override tweaks ============== -->

<!-- revise the copyright variable -->
<xsl:variable name="copyright">Copyright MyCompany Ltd., 2002</xsl:variable>

<!-- turn on return links from end of sections -->
<xsl:variable name="link-top-section">yes</xsl:variable> 

<!-- turn on Information Navigation Icons -->
<xsl:variable name="do-place-ing">yes</xsl:variable> 

<!-- cause figure labels to be placed UNDER the figure -->
<xsl:variable name="fmt-fig-lbl-loc">under</xsl:variable>

<!-- force draft mode on all the time -->
<xsl:param name="DRAFT" select="'yes'"/>


<!-- Stub override example (see original stub in topic2html) -->
<xsl:template name="gen-user-sidetoc" priority="100">
<xsl:message>Generating Side Toc</xsl:message>
  <xsl:if test="descendant::*[contains(@class,' topic/topic ')]"><!-- if there are nested topics... -->
<xsl:text>
</xsl:text>
    <xsl:comment> Begin Table of Contents </xsl:comment>
    <!-- Begin Table of Contents -->
    <p>
<xsl:text>
</xsl:text>
      <table width="150" align="right" border="1" frame="box" rules="none">
<xsl:text>
</xsl:text>
        <tr><td height="5" bgcolor="#0033CC" align="center"><b><font color="#FFFFFF">Contents:</font></b></td></tr>
<xsl:text>
</xsl:text>
          <xsl:for-each select="descendant::*[contains(@class,' topic/topic ')]">
            <xsl:variable name="ttext"><xsl:value-of select="*[contains(@class,' topic/title ')]"/></xsl:variable>
            <tr><td class="toc">- <a href="#{generate-id()}"><xsl:value-of select="$ttext"/></a>
            <!--recursive call for subtopics here"/-->
            </td></tr>
<xsl:text>
</xsl:text>
          </xsl:for-each>
      </table>
    </p>
    <xsl:comment> End Table of Contents </xsl:comment>
<xsl:text>
</xsl:text>
  </xsl:if>
</xsl:template>


<!-- template rule override (copy from topic2html and modify the behavior here)-->

<!-- generate an alternative, popup style footnote -->
<xsl:template match="*[contains(@class,' topic/fn ')]">
  <xsl:apply-templates select="@id"/>
  <xsl:variable name="fnid"><xsl:number from="/" level="any"/></xsl:variable>
  <xsl:variable name="callout"><xsl:value-of select="@callout"/></xsl:variable>
  <xsl:variable name="convergedcallout">
    <xsl:choose>
      <xsl:when test="string-length($callout)>'0'"><xsl:value-of select="$callout"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$fnid"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="fnbody"><xsl:apply-templates/></xsl:variable>
  <a OnClick='alert ("{$fnbody}")' style="color: red;" name="fnsrc_{$fnid}" href="#fntarg_{$fnid}">
    <sup><xsl:value-of select="$convergedcallout"/></sup>
  </a>
</xsl:template>


</xsl:stylesheet>
