<?xml version="1.0"?>

<!-- 
     Conversion from DITA map or maplist to HTML Help contents file.
     Input = one DITA map file, or a maplist pointing to multiple maps
     Output = one HHC contents file for use with the HTML Help compiler.
     
     Options:
        /OUTEXT  = XHTML output extension (default is 'html')
        /WORKDIR = The working directory that contains the document being transformed.
                   Needed as a directory prefix for the @href "document()" function calls. 
                   Default is './'

     Updates:
        Rel 3.8: Add support for copy-to attribute in maps
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- Include error message template -->
<xsl:include href="output-message.xsl"/>

<xsl:output method="xml"
            encoding="utf-8"
            doctype-system="ms-help://hx/resources/HelpCollection.DTD"
/>

<!-- Set the prefix for error message numbers -->
<xsl:variable name="msgprefix">IDXS</xsl:variable>
<xsl:variable name="newline"><xsl:text>
</xsl:text></xsl:variable>

<!-- This file contains extra project information, such as a list of
     images. It is produced by the Omnimark pre-processor. -->
<xsl:param name="PROJECTINFO">mapinfo.tmp</xsl:param>

<!-- *************************** Command line parameters *********************** -->
<xsl:param name="WORKDIR" select="'./'"/>
<xsl:param name="BASENAME" select="'doc'"/>

<!-- *********************************************************************************
     Setup the HTML wrapper for the table of contents
     ********************************************************************************* -->
<xsl:template match="/">
  <xsl:variable name="ProjectTitle">
    <xsl:choose>  <!-- Get the title, if possible -->
      <!-- If in a maplist with navigation, find the title in the first map -->
      <xsl:when test="maplist/nav/map[1]/@file">
        <xsl:variable name="MapWithPath"><xsl:value-of select="$WORKDIR"/><xsl:value-of select="/maplist/nav/map[1]/@file"/></xsl:variable>
        <xsl:variable name="FirstMapTitle"><xsl:value-of select="document($MapWithPath)/*[contains(@class, ' map/map ')]/@title"/></xsl:variable>
        <xsl:if test="string-length($FirstMapTitle)>0">
          <xsl:value-of select="$FirstMapTitle"/>
        </xsl:if>
        <xsl:if test="string-length($FirstMapTitle)=0">
          <xsl:text> </xsl:text>
        </xsl:if>
      </xsl:when>
      <!-- Using a single map, so get the title from that map -->
      <xsl:when test="/*[contains(@class, ' map/map ')]/@title">
          <xsl:value-of select="/*[contains(@class, ' map/map ')]/@title"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text> </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <HelpCollection DTDVersion="1.0">
    <!-- Set Language: currently English only -->
    <xsl:attribute name="LangId">1033</xsl:attribute>
    
    <!-- Set Title -->
    <xsl:attribute name="Title"><xsl:value-of select="$ProjectTitle"/></xsl:attribute>
    
    <xsl:value-of select="$newline"/>
    <CompilerOptions CreateFullTextIndex="Yes">
      <IncludeFile>
          <xsl:attribute name="File"><xsl:value-of select="$BASENAME"/>.HxF</xsl:attribute>
       </IncludeFile>
    </CompilerOptions>
    <xsl:value-of select="$newline"/>
    <TOCDef>
       <xsl:attribute name="File"><xsl:value-of select="$BASENAME"/>.HxT</xsl:attribute>
     </TOCDef>
    <xsl:value-of select="$newline"/>
    <!-- If the F1 file is not actually needed, this should remain commented out. -->
    <!--<KeywordIndexDef>
      <xsl:attribute name="File"><xsl:value-of select="$BASENAME"/>.F1.HxK</xsl:attribute>
    </KeywordIndexDef>-->
    
    <!-- Only add the HxK file if one is being created -->
    <xsl:if test="document(concat($WORKDIR,$PROJECTINFO))/*/includeIndex">
      <xsl:value-of select="$newline"/>
      <KeywordIndexDef>
        <xsl:attribute name="File"><xsl:value-of select="$BASENAME"/>.HxK</xsl:attribute>
      </KeywordIndexDef>
    </xsl:if>
    <xsl:value-of select="$newline"/>
    <ItemMoniker Name="!DefaultToc" ProgId="HxDs.HxHierarchy" InitData=""/><xsl:value-of select="$newline"/>
    <ItemMoniker Name="!DefaultFullTextSearch" ProgId="HxDs.HxFullTextSearch" InitData=""/><xsl:value-of select="$newline"/>
    <ItemMoniker Name="!DefaultAssociativeIndex" ProgId="HxDs.HxIndex" InitData="A"/><xsl:value-of select="$newline"/>
    <ItemMoniker Name="!DefaultKeywordIndex" ProgId="HxDs.HxIndex" InitData="K"/><xsl:value-of select="$newline"/>
    <ItemMoniker Name="!SampleInfo" ProgId="HxDs.HxSampleCollection" InitData=""/><xsl:value-of select="$newline"/>
    <xsl:comment>The Tool Data should be set for each project</xsl:comment><xsl:value-of select="$newline"/>
  </HelpCollection>
</xsl:template>

</xsl:stylesheet>
