<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Composite DITA topics to HTML
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- stylesheet imports -->
<xsl:import href="xslhtml/map2TOC.xsl"/>

<xsl:output
    omit-xml-declaration="no"
    method="xml"
    encoding="UTF-8"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    indent="no"
/>

<xsl:param name="contenttarget" select="'contentwin'"/>

<xsl:param name="default-css" select="'swg_info_common.css'"/>
<xsl:param name="CSS" select="''"/>

<!-- /CSSPATH = default CSS path parameter (null)-->
<xsl:param name="CSSPATH" select="''"/>

<xsl:variable name="copyright">Copyright 2004</xsl:variable>

<xsl:template match="*[contains(@class,' map/map ')]" mode="toctop">
  <html>
    <head>
      <xsl:if test="string-length($contenttarget)>0 and
	        $contenttarget!='NONE'">
        <base target="{$contenttarget}"/>
      </xsl:if>
      <xsl:call-template name="gen-user-metadata"/>
      <link rel="stylesheet" type="text/css" href="{$CSSPATH}{$default-css}" />
      <xsl:if test="string-length($CSS)>0">
        <link rel="stylesheet" type="text/css" href="{$CSSPATH}{$CSS}" />
      </xsl:if>
      <title>
        <xsl:value-of select="@title"/>
      </title>
      <xsl:call-template name="gen-user-scripts" />
      <xsl:call-template name="gen-user-styles" />
    </head>
    <body>
      <h1>
        <xsl:value-of select="@title"/>
      </h1>
      <ul>
        <xsl:apply-templates select="*[contains(@class,' map/topicref ')]"/>
      </ul>
    </body>
  </html>
</xsl:template>

<xsl:template match="*[contains(@class,' map/topicref ')]" mode="tocentry">
  <xsl:param name="infile"/>
  <xsl:param name="outroot"/>
  <xsl:param name="outfile"/>
  <xsl:param name="nodeID"/>
  <xsl:param name="isFirst"/>
  <xsl:param name="subtopicNodes"/>
  <xsl:param name="title"/>
  <li>
    <xsl:choose>
    <xsl:when test="$outfile and $outfile!=''">
      <a href="{$outfile}" class="topicref">
        <xsl:value-of select="$title"/>
      </a>
    </xsl:when>
    <xsl:when test="$title">
      <span class="topichead">
        <xsl:value-of select="$title"/>
      </span>
    </xsl:when>
    </xsl:choose>
    <xsl:if test="$subtopicNodes">
      <ul>
        <xsl:apply-templates select="$subtopicNodes"/>
      </ul>
    </xsl:if>
  </li>
</xsl:template>

<!-- customization hooks -->
<xsl:template name="gen-user-styles"/>
<xsl:template name="gen-user-scripts"/>

<xsl:template name="gen-user-metadata">
  <meta http-equiv="generator" content="IBM Darwin Information Typing Architecture map-to-html transform" />
  <xsl:text>
</xsl:text>
  <meta name="copyright" content="(C) {$copyright}" />
  <xsl:text>
</xsl:text>
  <meta name="security" content="public" />
  <xsl:text>
</xsl:text>
</xsl:template>

</xsl:stylesheet>
