<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Composite DITA topics to HTML
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- stylesheet imports -->
<xsl:import href="xslhtml/map2TOC.xsl"/>

<xsl:output method="html"
            encoding="utf-8"
            indent="yes"
            doctype-system="http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd"
            doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
/>

<xsl:template match="*[contains(@class,' map/map ')]" mode="toctop">
  <html>
    <head/>
    <body>
      <ul>
        <xsl:apply-templates select="*[contains(@class,' map/topicref ')]"/>
      </ul>
    </body>
  </html>
</xsl:template>

<xsl:template match="*[contains(@class,' map/topicref ')]" mode="tocentry">
  <xsl:param name="infile"/>
  <xsl:param name="outroot"/>
  <xsl:param name="outfile"/>
  <xsl:param name="nodeID"/>
  <xsl:param name="isFirst"/>
  <xsl:param name="subtopicNodes"/>
  <xsl:param name="title"/>
  <li>
    <object type="text/sitemap">
      <xsl:if test="$title">
        <param name="Name" value="{$title}"/>
      </xsl:if>
      <xsl:if test="$outfile and $outfile!=''">
        <param name="Local" value="{$outfile}"/>
      </xsl:if>
    </object>
    <xsl:if test="$subtopicNodes">
      <ul>
        <xsl:apply-templates select="$subtopicNodes"/>
      </ul>
    </xsl:if>
  </li>
</xsl:template>

</xsl:stylesheet>
