<?xml version="1.0" encoding="UTF-8" ?>

<!--  dit2htm.xsl
     Conversion from DITA xml to XHTML file.
     Input = one DITA xml file.
     Output = one XHTML file.

     Options: See params below.

   Copyright IBM Corporation
   This file is part of the DITA package on IBM's developerWorks site.
   See license.txt for disclaimers.
 +======================================

Changes:
Ensure FN applies template.
Shortdesc appears as 1st para - need to pull it
Added messages.
Added figure description - always
added frame value=bot rule
5/5:
Fixed lines to use break-replace instead of pre - added @frame processing
Fixed @spectitle for several elements by fixed @title with @spectitle
Added setclass to: image, table, row, thead, entry, fig
Started tfoot processing - falling thru for now - tfoot appears under thead...
5/6
Fixed dlentry-plentry message to be generic.
5/8
Fixed @scale processing - use the value as a direct percent
Fixed @id processing - IDs within IDs - xx__xx
5/24/2002
E002719 Required-cleanup message isn't always necessary
6/3/2002
E002788 2nd level of a nested OL ordered lists are not outputting a, b, c...
6/10/2002
E002749 Don't need the DITA Generator comments at the top of the file
E002724 DITA note type "important" is ignored.
E002722 Use br - 9/23/2002 - remove now that we use xhtml
6/17/2002
E002729 Table Title not supporting markup for XHTML transform
E002797 Extra variable definition in dit2htm
E002770 List dingbats not nesting correctly
B000030 Tables should be sizable in XHTML - partially fixed in beta2
E002805 xhtml perils (warning, caution, danger, note, etc) need to match guidelines
7/8/2002
E002718 Dita generated XSLT is not 100% XHTML compliant, & corrected tfoot, title in figgroup
E002834 setscale processor is occurring before the <table> tag is generated
7/15/2002
E002845 Output-message routine is missing some single quotes
E002821 Added outputclass to title - enable it for headings
7/18/2002
E002861 Move output-message template into a new file
Fixed NL quotes, using strings file.
7/21/2002
E002862 Draft-comment should issue a warning when /DRAFT is used
7/28
Updated LQ
Added longdescref to image
8/5
Using the modular piece of conref.xsl - issue on whether to include it or pre-process
Add /ftr, /hdr, /hdf controls, remove unused /ip
B000058 Interactive table PI
9/9/2002
E002717 LINES suppresses tagged output
E002712 DITA footnote processing doesn't work well for XHTML
E002739 Footnote appears when in draft-comment
E002893 @outputclass ignored on section titles
E002916 Problem with processing-instructions in table cells - no nbsp generated
Add object, desc, param
9/26/2002
E002806 Beta3 new DITA DTDs FOSI/XSL needs to handle choicetable (replacing ifcond)
E002923 DITA Scaling for tables & figures not consistent. Why scale in DIT2HTML at all?
10/1/2002
B000114 Lines has no preceding blank line
E002939 XSL copyright notice not defaulting to IBM
E002938 @specentry is not working in simple table headers, or in choicetable
E002942 Trademarks should use Unicode symbols
B000121 Space needed around tables in lists
B000117 valign attribute on table markup is not in XHTML output
E002950 required changes to dit2htm to fit with new rel-links.xsl - parts 1, 2, 3
E002961 table rows, cells, etc do not pass thru the outputclass attr setting
B000074 top bot frame not appearing in html table conversion
E002977 Need NBSP to be placed in 'holes' in simpletable stentries
B000127 Transform formatting errors - extra blank line before sections
11/7/2002
B000150 Allow rules/norules for simpletables
11/11/2002
B000147 Should there be a space between multiple <DD> tags?
B000148 Spaces not provided between <DL> items in a list
E002995 compact="no" is not working in xhtml
E002942 Trademarks should use Unicode symbols & only be output under the right set of parms
E002988 image in title needs to use ALT attr
E003079 Better control over table rules
Added in Prereqs for topic/body
Added div around screen for better NS formatting
Added bidi support
Added simple revision support (single @rev value for now) - template name="revtext" - checks for @rev & does apply-templates
Added simple flagging support (single property values for now)
Added SL, SLI - simple lists
E002978 proptype & propvalue entries may need to be added to ensure property headings align properly
E002721 Relative column widths for simpletable & ref-properties
Added multi-value @rev processing
Added multi-value property processing [33]
E003250 fall back to English with message 008
E003270 revisions without a file should not cause flag-file reading errors
E003174 Convert ID attr processing from using HTML A-names to using IDs (leave a-names for early NS users)
E003012 next/prev, prereq, and ancestor links being omitted
E003089 title in XHTML doesn't contain alternate text
E003332 Add PATH2PROJ variable to allow users to have c.gif, delta.gif, css in 1 directory
E003343 XSL errors from dit2htm when formatting parml
E003358 need path2proj appended to copied to WORKDIR position for revs flags
E003373 Allow LQ to reference a dita file
E003357 figgroup title problem
E003453 fix section flagging
E003471 Fix image @placement and @align
E003522 flagging images need the path2proj directory pre-pended
E003553 Remove empty colgroup & col tags from tables - affects interactive table process
E003672 ID getting set too early in NOTE
E003729 trademarks should only be marked in English & AP countries
E003694 Trademark TM should not be superscripted
E003751 rev attr on xxxbody tag outputs no rev or flag
P016893 Problem with index terms in titles
P016895 menucascade, other markup ignored in shortdesc previews
E003812 Match table widths for lists in tables - P016943
P016890 section titles have same heading level as nested topics
E003820 dit2htm.xsl code cleanup (reg1fixed)
E003815 Add 2 meta or more values using HDF
P017128 Correct XHTML tags and add classes to phrases
E003877 Check colsep & rowsep on tgroup before using table (currently only table is used)
P017304 DITA: dt tags not transforming correctly when a ph with a conref is within them.
E003878 Add newlines in front of certain elements & fix table specializations
P017341 lines transformed incorrectly
P017342/E003878 Add newlines in front of certain elements
E003637 "draft comment area found" message should not be issued when outputting in draft mode
E003973 css link begins with a ./ when the csspath contains a URL
E004006 Footnote, table caption & figure caption counters need specialization; Update image attr processing
R008200 Add revision class to div/span around revs
P017643 Dlentry tag not showing revbars
E004234 Flagging not working for DLENTRY
P016954 Flags should not be recognized on phrase-level elements
P017747 prophead discrepancy
E004198 Footnotes with IDs not linking in DITA to XHTML
E004244 @xml:lang not evaluated correctly when getting a string
E004279 HTML language attributes not always set
P017797 DITA to XHTML should produce semantic classes, not presentation-oriented classes
E004287 dit2htm doesn't recognize Belarusian and Ukrainian be-by (or be), uk-ua (or uk)

 *-->
<!-- ===================================================================== -->

<!-- [1] =========== ENTITIES FOR USE IN GENERATED OUTPUT (must produce correctly in HTML) =========== -->
<!DOCTYPE xsl:stylesheet [

  <!ENTITY gt            "&gt;">
  <!ENTITY lt            "&lt;">
  <!ENTITY rbl           " ">
  <!ENTITY nbsp          "&#xA0;">    <!-- &#160; -->
  <!ENTITY quot          "&#34;">
  <!ENTITY copyr         "&#169;">
]>



<!-- ===================================================================== -->



<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">



<!-- [2] =========== OTHER STYLESHEET INCLUDES/IMPORTS =========== -->

<xsl:include href="GetMeta.xsl"/>
<xsl:include href="syntaxdiagram.xsl"/>
<xsl:include href="rel-links.xsl"/>
<xsl:include href="output-message.xsl"/>


<!-- [3] =========== OUTPUT METHOD =========== -->

<!-- XHTML output with XML syntax -->
<xsl:output method="xml"
            encoding="utf-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>


<!-- [4] =========== "GLOBAL" DECLARATIONS (see 35) =========== -->

<!-- Define a newline character -->
<xsl:variable name="newline"><xsl:text>
</xsl:text></xsl:variable>

<!-- Define the error message prefix identifier -->
<xsl:variable name="msgprefix">IDXS</xsl:variable>

<!-- Filler for A-name anchors  - was &nbsp;-->
<xsl:variable name="afill"></xsl:variable>


<!-- [5] =========== DEFAULT VALUES FOR EXTERNALLY MODIFIABLE PARAMETERS =========== -->

<!-- /CSS = default CSS filename parameter ('')-->
<xsl:param name="CSS"/>
<xsl:param name="ibmdita-css" select="'ibmdita.css'"/> <!-- left to right languages -->
<xsl:param name="bidi-ibmdita-css" select="'ibmditar.css'"/> <!-- bidirectional languages -->

<!-- /CSSPATH = default CSS path parameter (null)-->
<xsl:param name="CSSPATH"/>

<!-- /HDF = the file name containing XHTML to be placed in the HEAD area
     (file name and extension only - no path). -->
<xsl:param name="HDF"/>

<!-- /HDR = the file name containing XHTML to be placed in the BODY running-heading area
     (file name and extension only - no path). -->
<xsl:param name="HDR"/>

<!-- /FTR = the file name containing XHTML to be placed in the BODY running-footing area
     (file name and extension only - no path). -->
<xsl:param name="FTR"/>

<!-- /ARTLBL = default "output artwork filenames" processing parameter ('no')-->
<xsl:param name="ARTLBL" select="'no'"/><!-- "no" and "yes" are valid values; non-'yes' is ignored -->

<!-- /DRAFT = default "hide draft & cleanup content" processing parameter ('no' = hide them)-->
<xsl:param name="DRAFT" select="'no'"/><!-- "no" and "yes" are valid values; non-'yes' is ignored -->

<!-- /INDEXSHOW = default "hide index entries" processing parameter ('no' = hide them)-->
<xsl:param name="INDEXSHOW" select="'no'"/><!-- "no" and "yes" are valid values; non-'yes' is ignored -->

<!-- for now, disable breadcrumbs pending link group descision -->
<xsl:param name="BREADCRUMBS" select="'no'"/> <!-- "no" and "yes" are valid values; non-'yes' is ignored -->

<!-- /YEAR = the year for the copyright -->
<xsl:param name="YEAR" select="'2003'"/>

<!-- /OUTEXT = default "output extension" processing parameter ('html')-->
<xsl:param name="OUTEXT" select="'html'"/><!-- "htm" and "html" are valid values -->

<!-- /WORKDIR = the working directory that contains the document being transformed.
     Needed as a directory prefix for the @conref "document()" function calls.
     default is '../doc/')-->
<xsl:param name="WORKDIR" select="'./'"/>

<!-- /PATH2PROJ = the path back to the project. Used for c.gif, delta.gif, css to allow user's to have
     these files in 1 location. -->
<xsl:param name="PATH2PROJ"/>

<!-- /FILENAME = the file name (file name and extension only - no path) of the document being transformed.
     Needed to help with debugging.
     default is 'myfile.xml')-->
<xsl:param name="FILENAME"/>

<!-- /FILTERFILE = the file name containing filter/flagging/revision information
     (file name and extension only - no path).  - testfile: revflag.dita -->
<xsl:param name="FILTERFILE"/>

<!-- /DBG = Debug mode - enables XSL debugging xsl-messages.
     Needed to help with debugging.
     default is 'no')-->
<xsl:param name="DBG" select="'no'"/> <!-- "no" and "yes" are valid values; non-'yes' is ignored -->


<!-- ===================================================================== -->
<!-- ==== START OF DITA COMPLIANT TRANSFORMS                          ==== -->
<!-- ===================================================================== -->



<!-- [6] =========== ITEMS FOR TRANSLATION/GLOBALIZATION (see 33) =========== -->
<!-- TBD: move localizable rules/defs to external, language-controlled imports -->


<!-- [7] =========== NULL PROCESSORS (for things whose content will be used by reference or excluded) =========== -->

<!-- section title for now is pulled due to need for resolution of possible multiple title methods -->
<xsl:template match="*[contains(@class,' topic/section ')]/*[contains(@class,' topic/title ')]" priority="100"/>
<xsl:template match="*[contains(@class,' topic/example ')]/*[contains(@class,' topic/title ')]" priority="100"/>

<!-- fig and table titles can be relocated, therefore must be pulled; can't fall through -->
<!-- E002729 Table Title not supporting markup for XHTML transform -->
 <xsl:template match="*[contains(@class,' topic/table ')]/*[contains(@class,' topic/title ')]" priority="100"/>
 <xsl:template match="*[contains(@class,' topic/table ')]/*[contains(@class,' topic/desc ')]" priority="100"/>
 <xsl:template match="*[contains(@class,' topic/fig ')]/*[contains(@class,' topic/title ')]" priority="100"/>
 <xsl:template match="*[contains(@class,' topic/fig ')]/*[contains(@class,' topic/desc ')]" priority="100"/>
 <xsl:template match="*[contains(@class,' topic/figgroup ')]/*[contains(@class,' topic/title ')]" priority="100"/>
<!--xsl:template match="*[contains(@class,' topic/desc ')]"/-->

<!-- these elements are never processed in a conventional presentation. can be overridden. -->
<xsl:template match="*[contains(@class,' topic/no-topic-nesting ')]"/>


<!-- [8] =========== ROOT RULE (just fall through; no side effects for new delivery contexts =========== -->

<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>


<!-- [9] =========== NESTED TOPIC RULES =========== -->

<!-- This first template rule generates the outer-level shell for a delivery context.
     In an override stylesheet, the same call to "chapter-setup" must be issued to
     maintain the consistency of overall look'n'feel of the output HTML.
     Match on the first DITA element -or- the first root 'topic' element. -->
<xsl:template match="/dita | /*[contains(@class,' topic/topic ')]">
  <xsl:call-template name="chapter-setup"/>
</xsl:template>

<!-- first topic child of dita -->
<xsl:template match="/dita/*[contains(@class,' topic/topic ')]">
<div class="nested0">
 <xsl:call-template name="gen-topic"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>


<!-- child topics get a div wrapper and fall through -->
<!-- 2nd level -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]" priority="2">
<div class="nested1">
 <xsl:call-template name="gen-topic"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 3rd level -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]" priority="3">
<div class="nested2">
 <xsl:call-template name="gen-topic"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 4th level -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]"  priority="4">
<div class="nested3">
 <xsl:call-template name="gen-topic"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 5th level -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]"  priority="5">
<div class="nested4">
 <xsl:call-template name="gen-topic"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 6th level -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]" priority="6">
<div class="nested5">
 <xsl:call-template name="gen-topic"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template name="gen-topic">
  <xsl:if test="@outputclass">
   <xsl:attribute name="class"><xsl:value-of select="@outputclass"/></xsl:attribute>
  </xsl:if>
 <xsl:call-template name="setidaname"/>
 <xsl:call-template name="gen-toc-id"/>
 <xsl:call-template name="flagit"/>
 <xsl:call-template name="start-revflag"/>
 <xsl:apply-templates/>
 <xsl:call-template name="end-revflag"/>
</xsl:template>


<!-- NESTED TOPIC TITLES (sensitive to nesting depth, but are still processed for contained markup) -->
<!-- 1st level - topic/title -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="1">
  <h1 class="topictitle1">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/></h1><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 2nd level - topic/topic/title -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="2">
  <h2 class="topictitle2">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/></h2><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 3rd level - topic/topic/topic/title -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="3">
  <h3 class="topictitle3">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/></h3><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 4th level - topic/topic/topic/topic/title -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="4">
  <h4 class="topictitle4">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/></h4><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 5th level - topic/topic/topic/topic/topic/title -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="5">
  <h5 class="topictitle5">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/></h5><xsl:value-of select="$newline"/>
</xsl:template>

<!-- 6th level - topic/topic/topic/topic/topic/topic/title -->
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="6">
  <h6 class="topictitle6">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/></h6><xsl:value-of select="$newline"/>
</xsl:template>

<!-- Hide titlealts - they need to get pulled into the proper places -->
<xsl:template match="*[contains(@class,' topic/titlealts ')]"/>


<!-- [10] =========== BODY/SECTION (not sensitive to nesting depth) =========== -->

<xsl:template match="*[contains(@class,' topic/body ')]">
<div>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="start-revflag"/>
  <!-- here, you can generate a toc based on what's a child of body -->
  <!--xsl:call-template name="gen-sect-ptoc"/--><!-- Works; not always wanted, though; could add a param to enable it.-->

  <!-- Insert prev/next links. since they need to be scoped by who they're 'pooled' with, apply-templates in 'hierarchylink' mode to linkpools (or related-links itself) when they have children that have any of the following characteristics:
       - role=ancestor (used for breadcrumb)
       - role=next or role=previous (used for left-arrow and right-arrow before the breadcrumb)
       - importance=required AND no role, or role=sibling or role=friend or role=previous or role=cousin (to generate prerequisite links)
       - we can't just assume that links with importance=required are prerequisites, since a topic with eg role='next' might be required, while at the same time by definition not a prerequisite -->

  <!-- get the short descr para -->
  <xsl:apply-templates select="parent::*/shortdesc" mode="outofline"/>

<!-- Insert pre-req links - after shortdesc - unless there is a prereq section about -->
  <xsl:apply-templates select="following-sibling::*[contains(@class,' topic/related-links ')]" mode="prereqs"/>

  <xsl:apply-templates/>
  <xsl:call-template name="end-revflag"/>
</div><xsl:value-of select="$newline"/>
</xsl:template>

<!-- no fallthru for shortdesc - needs to be pulled for 1st para and for abstract metadata -->
<xsl:template match="*[contains(@class,' topic/shortdesc ')]"/>
<!-- called shortdesc processing - para at start of topic -->
<xsl:template match="*[contains(@class,' topic/shortdesc ')]" mode="outofline">
<p>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates/>
</p><xsl:value-of select="$newline"/>
</xsl:template>

<!-- section processor - div with no generated title -->
<xsl:template match="*[contains(@class,' topic/section ')]">
<div class="section">
 <xsl:call-template name="setclass"/>
 <xsl:call-template name="gen-toc-id"/>
 <xsl:call-template name="setidaname"/>
 <xsl:call-template name="flagit"/>
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
    <div class="{@rev}"><xsl:apply-templates select="."  mode="section-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
    <xsl:apply-templates select="."  mode="section-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</div><xsl:value-of select="$newline"/>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/section ')]" mode="section-fmt">
  <xsl:call-template name="start-revflag"/>
  <xsl:call-template name="sect-heading"/>
  <xsl:apply-templates/>
  <xsl:call-template name="end-revflag"/>
  <xsl:if test="$link-top-section='yes'"> <!-- optional return to top - not used -->
    <p align="left"><a href="#TOP">
      <!--xsl:value-of select="$deftxt-linktop"/-->
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Return to Top'"/>
      </xsl:call-template>
    </a></p>
  </xsl:if>
</xsl:template>

<!-- example processor - div with no generated title -->
<xsl:template match="*[contains(@class,' topic/example ')]">
<div class="example">
 <xsl:call-template name="setclass"/>
 <xsl:call-template name="setidaname"/>
 <xsl:call-template name="gen-toc-id"/>
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
    <div class="{@rev}"><xsl:apply-templates select="."  mode="example-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
    <xsl:apply-templates select="."  mode="example-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</div><xsl:value-of select="$newline"/>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/example ')]" mode="example-fmt">
  <xsl:call-template name="start-revflag"/>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="sect-heading">
    <xsl:with-param name="deftitle">
<!-- no generated title
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Example'"/>
      </xsl:call-template> -->
    </xsl:with-param>
  </xsl:call-template>
  <xsl:apply-templates/>
  <xsl:call-template name="end-revflag"/>
  <xsl:if test="$link-top-section='yes'"> <!-- optional return to top - not used -->
    <p align="left"><a href="#TOP">
      <!--xsl:value-of select="$deftxt-linktop"/-->
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Return to Top'"/>
      </xsl:call-template>
    </a></p>
  </xsl:if>
</xsl:template>


<!-- ===================================================================== -->

<!-- [11] =========== BASIC BODY ELEMENTS =========== -->

<!-- paragraphs -->
<!-- TBD: special formatting for first paragraph in a section? -->
<!-- (default presentation has vertical gap between heading and first content) -->
<xsl:template match="*[contains(@class,' topic/p ')]">

 <!-- To ensure XHTML validity, need to determine whether the DITA kids are block elements.
      If so, use div_class="p" instead of p -->
 <xsl:choose>
  <xsl:when test="descendant::*[contains(@class,' topic/pre ')] or
       descendant::*[contains(@class,' topic/screen ')] or
       descendant::*[contains(@class,' topic/ul ')] or
       descendant::*[contains(@class,' topic/sl ')] or
       descendant::*[contains(@class,' topic/ol ')] or
       descendant::*[contains(@class,' topic/lq ')] or
       descendant::*[contains(@class,' topic/dl ')] or
       descendant::*[contains(@class,' topic/note ')] or
       descendant::*[contains(@class,' topic/lines ')] or
       descendant::*[contains(@class,' topic/fig ')] or
       descendant::*[contains(@class,' topic/table ')] or
       descendant::*[contains(@class,' topic/simpletable ')]">
     <div class="p"><xsl:call-template name="setclass"/><xsl:call-template name="setidaname"/><xsl:call-template name="flagit"/><xsl:call-template name="revblock"/></div></xsl:when>
  <xsl:otherwise><p><xsl:call-template name="setclass"/><xsl:call-template name="setidaname"/><xsl:call-template name="flagit"/><xsl:call-template name="revblock"/></p></xsl:otherwise>
 </xsl:choose><xsl:value-of select="$newline"/>
</xsl:template>

<!-- note - match the idd-xhtml model -->
<xsl:template match="*[contains(@class,' topic/note ')]">
 <xsl:call-template name="spec-title"/>
  <xsl:choose>
    <xsl:when test="@type='note'">
     <xsl:call-template name="note"/>
    </xsl:when>
    <xsl:when test="@type='tip'">
     <div class="tip">
      <xsl:call-template name="setidaname"/>
      <span class="tiptitle">
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Tip'"/>
       </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
      </span>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='fastpath'">
     <div class="fastpath">
      <xsl:call-template name="setidaname"/>
      <span class="fastpathtitle">
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Fastpath'"/>
       </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
      </span>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='important'">
     <div class="important">
      <xsl:call-template name="setidaname"/>
      <span class="importanttitle">
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Important'"/>
       </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
      </span>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='remember'">
     <div class="remember">
      <xsl:call-template name="setidaname"/>
      <span class="remembertitle">
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Remember'"/>
       </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
      </span>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='restriction'">
     <div class="restriction">
      <xsl:call-template name="setidaname"/>
      <span class="restrictiontitle">
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Restriction'"/>
       </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
      </span>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='attention'">
     <div class="attention">
      <xsl:call-template name="setidaname"/>
      <span class="attentiontitle">
       <xsl:call-template name="flagit"/>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Attention'"/>
       </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
      </span>
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='caution'">
     <div class="cautiontitle">
      <xsl:call-template name="setidaname"/>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="getString">
       <xsl:with-param name="stringName" select="'Caution'"/>
      </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text>
     </div>
     <div class="caution">
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='danger'">
     <div class="dangertitle">
      <xsl:call-template name="setidaname"/>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="getString">
       <xsl:with-param name="stringName" select="'Danger'"/>
      </xsl:call-template>
     </div>
     <div class="danger">
      <xsl:call-template name="revblock"/>
     </div>
    </xsl:when>
    <xsl:when test="@type='other'">
     <xsl:choose>
      <xsl:when test="@othertype"> <!-- is there a type title? Use that -->
       <div class="note">
       <xsl:call-template name="setidaname"/>
        <span class="notetitle">
         <!-- TBD: this attr is a key that should look up external, translateable text.
              For now, just output the othertype attr value. -->
         <xsl:value-of select="@othertype"/>
         <xsl:call-template name="getString">
          <xsl:with-param name="stringName" select="'ColonSymbol'"/>
         </xsl:call-template><xsl:text> </xsl:text>
        </span>
        <xsl:call-template name="flagit"/>
        <xsl:call-template name="revblock"/>
       </div>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="note"/> <!-- otherwise, give them the standard note -->
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="note"/>
    </xsl:otherwise>
  </xsl:choose>
 <xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template name="note">
 <div class="note">
  <xsl:call-template name="setidaname"/>
  <span class="notetitle">
   <xsl:call-template name="getString">
    <xsl:with-param name="stringName" select="'Note'"/>
   </xsl:call-template>
   <xsl:call-template name="getString">
    <xsl:with-param name="stringName" select="'ColonSymbol'"/>
   </xsl:call-template><xsl:text> </xsl:text>
  </span>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="revblock"/>
 </div>
</xsl:template>

<!-- long quote (bibliographic association).
     @reftitle contains the citation for the excerpt.
     With a link if @href is used.  -->
<xsl:template match="*[contains(@class,' topic/lq ')]">
<blockquote>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagit"/>
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
    <div class="{@rev}"><xsl:apply-templates select="."  mode="lq-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
    <xsl:apply-templates select="."  mode="lq-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</blockquote><xsl:value-of select="$newline"/>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/lq ')]" mode="lq-fmt">
  <xsl:call-template name="start-revflag"/>
  <xsl:apply-templates/>
  <xsl:choose>
   <xsl:when test="@href"> <!-- Insert citation as link, use @href as-is -->
    <br/><div style="text-align:right"><a>
     <xsl:attribute name="href">
      <xsl:choose>
       <xsl:when test="contains(@href,'.dita')">
        <xsl:value-of select="substring-before(@href,'.dita')"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,'.dita')"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="@href"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:attribute>
     <xsl:choose>
      <xsl:when test="@type='external'">
       <xsl:attribute name="target">_blank</xsl:attribute>
      </xsl:when>
      <xsl:otherwise><!--nop - no target needed for internal or biblio types (OR-should internal force DITA xref-like processing? What is intent? @type is only internal/external/bibliographic) --></xsl:otherwise>
     </xsl:choose>
     <cite><xsl:choose>
      <xsl:when test="@reftitle"><xsl:value-of select="@reftitle"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
      </xsl:choose></cite></a></div>
   </xsl:when>
   <xsl:when test="@reftitle"> <!-- Insert citation text -->
     <br/><div style="text-align:right"><cite><xsl:value-of select="@reftitle"/></cite></div>
   </xsl:when>
   <xsl:otherwise><!--nop - do nothing--></xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="end-revflag"/>
</xsl:template>


<!-- [12] =========== SINGLE PART LISTS =========== -->

<!-- Unordered List -->
<!-- handle all levels thru browser processing -->
<xsl:template match="*[contains(@class,' topic/ul ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="ul-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="ul-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/ul ')]" mode="ul-fmt">
 <xsl:call-template name="flagit"/>
 <xsl:call-template name="start-revflag"/>
 <xsl:call-template name="setaname"/>
 <ul>
   <xsl:call-template name="setclass"/>
   <xsl:apply-templates select="@compact"/>
   <xsl:call-template name="setid"/>
   <xsl:apply-templates/>
 </ul>
 <xsl:call-template name="end-revflag"/>
 <xsl:value-of select="$newline"/>
</xsl:template>

<!-- Simple List -->
<!-- handle all levels thru browser processing -->
<xsl:template match="*[contains(@class,' topic/sl ')]">
<xsl:call-template name="flagit"/>
  <xsl:choose> <!-- draft rev mode, add div w/ rev attr value -->
   <xsl:when test="@rev and not($FILTERFILE='') and ($DRAFT='yes')">
    <xsl:variable name="revtest"> <!-- Flag the revision? 1=yes; 0=no -->
     <xsl:call-template name="find-active-rev-flag">
      <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$revtest=1">
      <div class="{@rev}"><xsl:apply-templates select="."  mode="sl-fmt" /></div>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="."  mode="sl-fmt" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="."  mode="sl-fmt" />
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/sl ')]" mode="sl-fmt">
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ul class="simple">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ul>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- Ordered List - 1st level - Handle levels 1 to 9 thru OL-TYPE attribution -->
<xsl:template match="*[contains(@class,' topic/ol ')]">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 2nd level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="2">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol type="a">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 3rd level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="3">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol type="i">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 4th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="4">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 5th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="5">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<ol type="a">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setidaname"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 6th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="6">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol type="i">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 7th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="7">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 8th level - oye! -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="8">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol type="a">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- OL - 9th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="9">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<ol type="i">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</ol>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- list item -->
<xsl:template match="*[contains(@class,' topic/li ')]">
<li>
 <!-- handle non-compact list items -->
 <xsl:if test="parent::*/@compact='no'">
  <xsl:attribute name="class">liexpand</xsl:attribute>
 </xsl:if>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="revblock"/>
</li><xsl:value-of select="$newline"/>
</xsl:template>
<!-- simple list item -->
<xsl:template match="*[contains(@class,' topic/sli ')]">
<li>
 <!-- handle non-compact list items -->
 <xsl:if test="parent::*/@compact='no'">
  <xsl:attribute name="class">sliexpand</xsl:attribute>
 </xsl:if>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="revblock"/>
</li><xsl:value-of select="$newline"/>
</xsl:template>

<!-- special case of getting the number of a list item referenced by xref -->
<xsl:template match="*[contains(@class,' topic/li ')]" mode="xref">
  <xsl:number/>
</xsl:template>


<!-- list item section is like li/lq but without presentation (indent) -->
<xsl:template match="*[contains(@class,' topic/itemgroup ')]">
<!-- insert a space before all but the first itemgroups in a LI -->
<xsl:variable name="itemgroupcount"><xsl:number count="*[contains(@class,' topic/itemgroup ')]"/></xsl:variable>
<!-- <span> - span & class removed because of xslt validation -->
<!--  <xsl:call-template name="setclass"/> -->
  <xsl:if test="$itemgroupcount&gt;'1'">
    <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/>
<!-- </span> -->
</xsl:template>

<!-- [13] =========== DEFINITION LIST =========== -->

<!-- DL -->
<xsl:template match="*[contains(@class,' topic/dl ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="dl-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="dl-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/dl ')]"  mode="dl-fmt">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="setaname"/>
<dl>
 <!-- handle DL compacting - default=yes -->
  <xsl:if test="@compact='no'">
   <xsl:attribute name="class">dlexpand</xsl:attribute>
  </xsl:if>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:call-template name="setid"/>
  <xsl:apply-templates/>
</dl>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- DL entry -->
<xsl:template match="*[contains(@class,' topic/dlentry ')]">
  <xsl:apply-templates/>
</xsl:template>

<!-- DL term -->
<xsl:template match="*[contains(@class,' topic/dt ')]">
<!-- insert a blank line before only the first DT in a DLENTRY; count which DT this is -->
<xsl:variable name="dtcount"><xsl:number count="*[contains(@class,' topic/dt ')]"/></xsl:variable>
<xsl:choose>
 <xsl:when test="$dtcount=1">
  <dt class="dlterm">
   <!-- handle non-compact list items -->
   <xsl:if test="../../@compact='no'">
    <xsl:attribute name="class">dltermexpand</xsl:attribute>
   </xsl:if>
   <xsl:call-template name="setclass"/>
   <xsl:call-template name="setidaname"/>
   <!-- handle ID on a DLENTRY -->
    <xsl:if test="parent::*/@id">
     <xsl:call-template name="parent-id"/>
    </xsl:if>
   <!-- handle non-compact DLs dl/dlentry/dt-->
    <xsl:call-template name="flagit-parent"/>          <!-- flag on parent/DLENTRY> -->
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag-parent"/>   <!-- rev on parent/DLENTRY? -->
    <xsl:call-template name="revtext"/>
    <xsl:call-template name="end-revflag-parent"/>
  </dt>
 </xsl:when>
 <xsl:otherwise><!-- DTs 2 thru N -->
  <dt class="dlterm">
    <xsl:call-template name="setclass"/>
    <xsl:call-template name="setidaname"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag-parent"/>
    <xsl:call-template name="revtext"/>
    <xsl:call-template name="end-revflag-parent"/>
  </dt>
 </xsl:otherwise>
</xsl:choose>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- DL description -->
<xsl:template match="*[contains(@class,' topic/dd ')]">
<!-- insert a blank line before all but the first DD in a DLENTRY; count which DD this is -->
<xsl:variable name="ddcount"><xsl:number count="*[contains(@class,' topic/dd ')]"/></xsl:variable>
<xsl:choose>
 <xsl:when test="$ddcount=1">
  <dd>
   <xsl:call-template name="setclass"/>
   <xsl:call-template name="setidaname"/>
   <xsl:call-template name="flagit"/>
   <xsl:call-template name="start-revflag-parent"/>    <!-- rev on parent/DLENTRY? -->
   <xsl:call-template name="revblock"/>
   <xsl:call-template name="end-revflag-parent"/>
  </dd>
 </xsl:when>
 <xsl:otherwise><!-- para space before 2 thru N -->
  <dd class="ddexpand">
   <xsl:call-template name="setclass"/>
   <xsl:call-template name="setidaname"/>
   <xsl:call-template name="flagit"/>
   <xsl:call-template name="start-revflag-parent"/>
   <xsl:call-template name="revblock"/>
   <xsl:call-template name="end-revflag-parent"/>
  </dd>
 </xsl:otherwise>
</xsl:choose>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- DL heading -->
<xsl:template match="*[contains(@class, ' topic/dlhead ')]">
 <xsl:apply-templates/>
</xsl:template>

<!-- DL heading, term -->
<xsl:template match="*[contains(@class,' topic/dthd ')]">
<dt>
 <xsl:call-template name="setclass"/>
 <xsl:call-template name="setidaname"/>
 <xsl:call-template name="flagit"/>
 <xsl:call-template name="start-revflag-parent"/>
 <b><xsl:call-template name="revtext"/></b>
 <xsl:call-template name="end-revflag-parent"/>
</dt><xsl:value-of select="$newline"/>
</xsl:template>

<!-- DL heading, description -->
<xsl:template match="*[contains(@class,' topic/ddhd ')]">
<dd>
 <xsl:call-template name="setclass"/>
 <xsl:call-template name="setidaname"/>
 <xsl:call-template name="flagit"/>
 <xsl:call-template name="start-revflag-parent"/>
 <b><xsl:call-template name="revblock"/></b>
 <xsl:call-template name="end-revflag-parent"/>
</dd><xsl:value-of select="$newline"/>
</xsl:template>


<!-- [14] =========== PHRASES =========== -->

<!-- phrase presentational style - have to use a low priority otherwise topic/ph always wins -->

<xsl:template match="*[contains(@class,' topic/ph ')]" priority="1">
 <span>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<!-- keyword presentational style - have to use priority else topic/keyword always wins -->

<xsl:template match="*[contains(@class,' topic/keyword ')]" priority="1">
 <span class="keyword">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<!-- trademarks  -->
<!-- prepare a key for each trademark tag -->
<xsl:key name="tm"  match="*[contains(@class,' topic/tm ')]" use="."/>

<!-- process the TM tag -->
<xsl:template match="*[contains(@class,' topic/tm ')]" priority="1">

  <xsl:apply-templates/> <!-- output the TM content -->

  <!-- Determine the tmclass value; IBM legal only wants some classes processed -->
  <xsl:variable name="Ltmclass">
    <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
      <xsl:with-param name="inputval" select="@tmclass"/>
    </xsl:call-template>
  </xsl:variable>
  <!-- If this is a good class, continue... -->
  <xsl:if test="$Ltmclass='ibm' or $Ltmclass='ibmsub' or $Ltmclass='special'">
    <!-- Test for TM area's language -->
    <xsl:variable name="tmtest">
      <xsl:call-template name="tm-area"/>
    </xsl:variable>

    <!-- If this language should get trademark markers, continue... -->
    <xsl:if test="$tmtest='tm'">
      <xsl:variable name="tmvalue"><xsl:value-of select="@trademark"/></xsl:variable>

      <!-- Determine if this is in a title, and should be marked -->
      <xsl:variable name="usetitle">
        <xsl:if test="ancestor::*[contains(@class,' topic/title ')]/parent::*[contains(@class,' topic/topic ')]">
          <xsl:choose>
            <!-- Not the first one in a title -->
            <xsl:when test="generate-id(.)!=generate-id(key('tm',.)[1])">skip</xsl:when>
            <!-- First one in the topic, BUT it appears in a shortdesc or body -->
            <xsl:when test="//*[contains(@class,' topic/shortdesc ') or contains(@class,' topic/body ')]//*[contains(@class,' topic/tm ')][@trademark=$tmvalue]">skip</xsl:when>
            <xsl:otherwise>use</xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:variable>

      <!-- Determine if this is in a body, and should be marked -->
      <xsl:variable name="usebody">
        <xsl:choose>
          <!-- If in a title or prolog, skip -->
          <xsl:when test="ancestor::*[contains(@class,' topic/title ') or contains(@class,' topic/prolog ')]/parent::*[contains(@class,' topic/topic ')]">skip</xsl:when>
          <!-- If first in the document, use it -->
          <xsl:when test="generate-id(.)=generate-id(key('tm',.)[1])">use</xsl:when>
          <!-- If there is another before this that is in the body or shortdesc, skip -->
          <xsl:when test="preceding::*[contains(@class,' topic/tm ')][@trademark=$tmvalue][ancestor::*[contains(@class,' topic/body ') or contains(@class,' topic/shortdesc ')]]">skip</xsl:when>
          <!-- Otherwise, any before this must be in a title or ignored section -->
          <xsl:otherwise>use</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <!-- If it should be used in a title or used in the body, output your favorite TM marker based on the attributes -->
      <xsl:if test="$usetitle='use' or $usebody='use'">
        <xsl:choose>  <!-- ignore @tmtype=service or anything else -->
          <xsl:when test="@tmtype='tm'">&#x2122;</xsl:when>
          <xsl:when test="@tmtype='reg'"><sup>&#xAE;</sup></xsl:when>
          <xsl:otherwise/>
        </xsl:choose>
      </xsl:if>
    </xsl:if>
 </xsl:if>
</xsl:template>

<!-- Test for in TM area: returns "tm" when parent's @xml:lang needs a trademark language;
     Otherwise, leave blank.
     Use the TM for US English and the AP languages (Japanese, Korean, and both Chinese).
     Ignore the TM for all other languages. -->
<xsl:template name="tm-area">
 <xsl:variable name="parentlangUpper">  <!-- the parent's xml:lang value (use en-us if none found) -->
  <xsl:choose>
   <xsl:when test="ancestor-or-self::*/@xml:lang">
     <xsl:value-of select="ancestor-or-self::*/@xml:lang"/>
   </xsl:when>
   <xsl:otherwise>en-us</xsl:otherwise>
  </xsl:choose>
 </xsl:variable>
 <xsl:variable name="parentlang">
  <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
   <xsl:with-param name="inputval" select="$parentlangUpper"/>
  </xsl:call-template>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$parentlang='en-us' or $parentlang='en'">tm</xsl:when>
  <xsl:when test="$parentlang='ja-jp' or $parentlang='ja'">tm</xsl:when>
  <xsl:when test="$parentlang='ko-kr' or $parentlang='ko'">tm</xsl:when>
  <xsl:when test="$parentlang='zh-cn' or $parentlang='zh'">tm</xsl:when>
  <xsl:when test="$parentlang='zh-tw' or $parentlang='zh'">tm</xsl:when>
  <xsl:otherwise/>
 </xsl:choose>
</xsl:template>

<!-- hi-d.ent Phrase domain: b | i | u | tt | sup | sub -->

<xsl:template match="*[contains(@class,' hi-d/b ')]" priority="2">
 <b>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></b>
</xsl:template>

<xsl:template match="*[contains(@class,' hi-d/i ')]" priority="2">
 <i>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></i>
</xsl:template>

<xsl:template match="*[contains(@class,' hi-d/u ')]" priority="2">
 <u>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></u>
</xsl:template>

<xsl:template match="*[contains(@class,' hi-d/tt ')]" priority="2">
 <tt>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></tt>
</xsl:template>

<xsl:template match="*[contains(@class,' hi-d/sup ')]" priority="2">
 <sup>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></sup>
</xsl:template>

<xsl:template match="*[contains(@class,' hi-d/sub ')]" priority="2">
 <sub>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></sub>
</xsl:template>

<!-- software-domain.ent domain: filepath | msgph | userinput | systemoutput | cmdname | msgnum | varname -->

<xsl:template match="*[contains(@class,' sw-d/filepath ')]" priority="2">
 <span class="filepath">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' sw-d/msgph ')]" priority="2">
 <tt class="msgph">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></tt>
</xsl:template>

<xsl:template match="*[contains(@class,' sw-d/userinput ')]" priority="2">
 <kbd class="userinput">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></kbd>
</xsl:template>

<xsl:template match="*[contains(@class,' sw-d/systemoutput ')]" priority="2">
 <tt class="sysout">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></tt>
</xsl:template>

<xsl:template match="*[contains(@class,' sw-d/cmdname ')]" priority="2">
 <span class="cmdname">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' sw-d/msgnum ')]" priority="2">
 <span class="msgnum">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' sw-d/varname ')]" priority="2">
 <var class="varname">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></var>
</xsl:template>

<!-- programming-domain.ent domain: codeph | var | kwd | synph | oper | delim | sep | repsep |
                                    option | parmname | apiname-->

<xsl:template match="*[contains(@class,' pr-d/codeph ')]" priority="2">
 <samp class="codeph">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></samp>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/kwd ')]" priority="2">
 <span class="kwd">
  <xsl:if test="(@importance='default')">
   <xsl:attribute name="class">defkwd</xsl:attribute>
  </xsl:if>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/var ')]" priority="2">
 <span class="var">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/synph ')]" priority="2">
 <span class="synph">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/oper ')]" priority="2">
 <span class="oper">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/delim ')]" priority="2">
 <span class="delim">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/sep ')]" priority="2">
 <span class="sep">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/repsep ')]" priority="2">
 <span class="repsep">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/option ')]" priority="2">
 <span class="option">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/parmname ')]" priority="2">
 <span class="parmname">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' pr-d/apiname ')]" priority="2">
 <span class="apiname">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<!-- ui-domain.ent domain: uicontrol | wintitle | menucascade | shortcut -->

<xsl:template match="*[contains(@class,' ui-d/uicontrol ')]" priority="2">
<!-- insert an arrow with leading/trailing spaces before all but the first uicontrol in a menucascade -->
<xsl:if test="ancestor::*[contains(@class,' ui-d/menucascade ')]">
 <xsl:variable name="uicontrolcount"><xsl:number count="*[contains(@class,' ui-d/uicontrol ')]"/></xsl:variable>
  <xsl:if test="$uicontrolcount&gt;'1'">
    <xsl:text> > </xsl:text>
  </xsl:if>
</xsl:if>
 <span class="uicontrol">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' ui-d/wintitle ')]" priority="2">
 <span class="wintitle">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' ui-d/menucascade ')]" priority="2">
 <span class="menucascade">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>

<xsl:template match="*[contains(@class,' ui-d/shortcut ')]" priority="2">
 <span class="shortcut">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/></span>
</xsl:template>


<!-- phrase "semantic" classes -->
<!-- citations -->
<xsl:template match="*[contains(@class,' topic/cite ')]">
<cite>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <!-- TBD: add some associative linking to literal title text, if no bibdesc -->
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/>
</cite>
</xsl:template>

<!-- quotes - only do 1 level, no flip-flopping -->
<xsl:template match="*[contains(@class,' topic/q ')]">
<span class="q">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="getString">
   <xsl:with-param name="stringName" select="'OpenQuote'"/>
  </xsl:call-template>
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/>
  <xsl:call-template name="getString">
   <xsl:with-param name="stringName" select="'CloseQuote'"/>
  </xsl:call-template>
</span>
</xsl:template>

<!-- terms -->
<xsl:template match="*[contains(@class,' topic/term ')]">
<dfn class="term">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <!-- TBD: For when glosaries exist - Build an assumed associative link: -->
  <!-- [<a href="#term_{.}" class="term">]-->
  <xsl:call-template name="flagcheck"/>
  <xsl:call-template name="revtext"/>
  <!--[</a>]-->
</dfn>
</xsl:template>


<!-- [15] =========== BOOLEAN-STATE DATA TYPES =========== -->
<!-- Use color to indicate these types for now -->
<!-- output the tag & it's state -->
<xsl:template match="*[contains(@class,' topic/boolean ')]">
 <span style="color:green">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:value-of select="name()"/><xsl:text>: </xsl:text><xsl:value-of select="@state"/>
 </span>
</xsl:template>

<!-- output the tag, it's name & value -->
<xsl:template match="*[contains(@class,' topic/state ')]">
<span style="color:red">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:value-of select="name()"/><xsl:text>: </xsl:text><xsl:value-of select="@name"/><xsl:text>=</xsl:text><xsl:value-of select="@value"/>
</span>
</xsl:template>


<!-- [17] =========== RECORD END RESPECTING DATA =========== -->
<!-- PRE -->
<xsl:template match="*[contains(@class,' topic/pre ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="pre-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="pre-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/pre ')]" mode="pre-fmt">
<xsl:if test="contains(@frame,'top')"><hr /></xsl:if>
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="spec-title-nospace"/>
<pre>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setscale"/>
  <xsl:call-template name="setidaname"/>
  <xsl:apply-templates/>
</pre>
<xsl:call-template name="end-revflag"/>
<xsl:if test="contains(@frame,'bot')"><hr /></xsl:if><xsl:value-of select="$newline"/>
</xsl:template>

<!-- Screen -->
<xsl:template match="*[contains(@class,' ui-d/screen ')]" priority="2">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="screen-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="screen-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' ui-d/screen ')]" mode="screen-fmt">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="spec-title-nospace"/>
<pre class="screen">
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setscale"/>
  <xsl:call-template name="setidaname"/>
  <xsl:apply-templates/>
</pre>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<!-- lines - body font -->
<xsl:template match="*[contains(@class,' topic/lines ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="lines-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="lines-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/lines ')]" mode="lines-fmt">
<xsl:if test="contains(@frame,'top')"><hr /></xsl:if>
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
<xsl:call-template name="spec-title-nospace"/>
 <p>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setscale"/>
  <xsl:call-template name="setidaname"/>
  <xsl:apply-templates/>
 </p>
<xsl:call-template name="end-revflag"/>
<xsl:if test="contains(@frame,'bot')"><hr /></xsl:if><xsl:value-of select="$newline"/>
</xsl:template>

<!-- test for text in a lines area -->
<!--[
<xsl:template match="*[contains(@class,' topic/lines ')]//text()">
 <xsl:call-template name="br-replace">
  <xsl:with-param name="brtext" select="."/>
 </xsl:call-template>
</xsl:template>
]-->
<!-- new way - swap '  ' with '&nbsp;&nbsp;' to preserve blanks -->
<xsl:template match="*[contains(@class,' topic/lines ')]//text()">
 <xsl:variable name="linetext"><xsl:value-of select="."/></xsl:variable>
<!-- LineText:[
<xsl:value-of select="$linetext"/>
]    -->
 <xsl:variable name="linetext2">
  <xsl:call-template name="sp-replace"><xsl:with-param name="sptext" select="$linetext"/></xsl:call-template>
 </xsl:variable>
<!-- LineText2:[
<xsl:value-of select="$linetext2"/>
]    -->
<!-- <xsl:variable name="linetext3">
  <xsl:call-template name="br-replace">
   <xsl:with-param name="brtext" select="$linetext2"/>
  </xsl:call-template>
 </xsl:variable>
LineText3:[
<xsl:value-of select="$linetext3"/>
]   -->
 <xsl:call-template name="br-replace">
  <xsl:with-param name="brtext" select="$linetext2"/>
 </xsl:call-template>
</xsl:template>


<!-- [18] =========== FIGURE =========== -->
<xsl:template match="*[contains(@class,' topic/fig ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="fig-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="fig-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/fig ')]" mode="fig-fmt">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
 <div>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setscale"/>
  <xsl:choose>
    <xsl:when test="@frame='all'">
      <xsl:attribute name="class">figborder</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='sides'">
      <xsl:attribute name="class">figsides</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='top'">
      <xsl:attribute name="class">figtop</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='bottom'">
      <xsl:attribute name="class">figbottom</xsl:attribute>
    </xsl:when>
    <xsl:when test="@frame='topbot'">
      <xsl:attribute name="class">figtopbot</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
      <xsl:attribute name="class">fignone</xsl:attribute>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="place-fig-lbl"/>
  <xsl:apply-templates/>
 </div>
<xsl:call-template name="end-revflag"/>
<xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/figgroup ')]" priority="1">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="figgroup-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="figgroup-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/figgroup ')]" mode="figgroup-fmt">
<xsl:call-template name="flagit"/>
<xsl:call-template name="start-revflag"/>
 <span>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:call-template name="place-figgrp-lbl"/>
  <xsl:apply-templates/>
 </span>
<xsl:call-template name="end-revflag"/>
</xsl:template>


<!-- [19] =========== IMAGE/OBJECT =========== -->

<xsl:template match="*[contains(@class,' topic/image ')]">
  <!-- build any pre break indicated by style -->
  <xsl:choose>
    <xsl:when test="parent::fig[contains(@frame,'top ')]">
      <!-- NOP if there is already a break implied by a parent property -->
    </xsl:when>
    <xsl:otherwise>
     <xsl:choose>
      <xsl:when test="(@placement='break')"><br/>
       <xsl:call-template name="flagit"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="flagcheck"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="start-revflag"/>
  <xsl:call-template name="setaname"/>
  <xsl:choose>
   <xsl:when test="@placement='break'"><!--Align only works for break-->
    <xsl:choose>
     <xsl:when test="@align='left'">
      <div class="imageleft">
       <xsl:call-template name="topic-image"/>
      </div>
     </xsl:when>
     <xsl:when test="@align='right'">
      <div class="imageright">
       <xsl:call-template name="topic-image"/>
      </div>
     </xsl:when>
     <xsl:when test="@align='center'">
      <div class="imagecenter">
       <xsl:call-template name="topic-image"/>
      </div>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="topic-image"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="topic-image"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="end-revflag"/>
  <!-- build any post break indicated by style -->
  <xsl:if test="not(@placement='inline')"><br/></xsl:if>
  <!-- image name for review -->
  <xsl:if test="$ARTLBL='yes'">
    [<xsl:value-of select="@href"/>]
  </xsl:if>
</xsl:template>

<xsl:template name="topic-image">
  <!-- now invoke the actual content and its alt text -->
  <xsl:element name="img">
    <xsl:call-template name="setclass"/>
    <xsl:call-template name="setid"/>
    <xsl:apply-templates select="@href|@height|@width|@longdescref"/>
    <xsl:choose>
      <xsl:when test="*[contains(@class,' topic/alt')]">
        <xsl:attribute name="alt"><xsl:value-of select="*[contains(@class,' topic/alt ')]"/></xsl:attribute>
      </xsl:when>
      <xsl:when test="@alt">
        <xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
      </xsl:when>
    </xsl:choose>
  </xsl:element>
</xsl:template>
<!-- Process image attributes -->
<xsl:template match="*[contains(@class,' topic/image ')]/@href" priority="1">
  <xsl:attribute name="src"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/image ')]/@height" priority="1">
  <xsl:attribute name="height"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/image ')]/@width" priority="1">
  <xsl:attribute name="width"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/image ')]/@longdescref" priority="1">
  <xsl:attribute name="longdesc">
    <xsl:choose>
      <xsl:when test="contains(.,'.dita')">  <!-- switch extension from .dita -->
        <xsl:value-of select="substring-before(.,'.dita')"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(.,'.dita')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:attribute>
  <!--<a href="{@longdescref}">D</a>--> <!-- "D"-link -->
</xsl:template>


<!-- object, desc, & param -->
<xsl:template match="*[contains(@class,' topic/object ')]">
 <xsl:element name="object">
  <xsl:if test="@id"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
  <xsl:if test="@declare"><xsl:attribute name="declare"><xsl:value-of select="@declare"/></xsl:attribute></xsl:if>
  <xsl:if test="@codebase"><xsl:attribute name="codebase"><xsl:value-of select="@codebase"/></xsl:attribute></xsl:if>
  <xsl:if test="@type"><xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute></xsl:if>
  <xsl:if test="@archive"><xsl:attribute name="archive"><xsl:value-of select="@archive"/></xsl:attribute></xsl:if>
  <xsl:if test="@height"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
  <xsl:if test="@usemap"><xsl:attribute name="usemap"><xsl:value-of select="@usemap"/></xsl:attribute></xsl:if>
  <xsl:if test="@tabindex"><xsl:attribute name="tabindex"><xsl:value-of select="@tabindex"/></xsl:attribute></xsl:if>
  <xsl:if test="@classid"><xsl:attribute name="classid"><xsl:value-of select="@classid"/></xsl:attribute></xsl:if>
  <xsl:if test="@data"><xsl:attribute name="data"><xsl:value-of select="@data"/></xsl:attribute></xsl:if>
  <xsl:if test="@codetype"><xsl:attribute name="codetype"><xsl:value-of select="@codetype"/></xsl:attribute></xsl:if>
  <xsl:if test="@standby"><xsl:attribute name="standby"><xsl:value-of select="@standby"/></xsl:attribute></xsl:if>
  <xsl:if test="@width"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
  <xsl:if test="@name"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
  <xsl:if test="@longdescref">
   <xsl:call-template name="output-message">
    <xsl:with-param name="msg">The LONGDESCREF attribute on tag "<xsl:value-of select="name(.)"/>" will be ignored. Accessibility needs to be handled another way.</xsl:with-param>
    <xsl:with-param name="msgnum">010</xsl:with-param>
    <xsl:with-param name="msgsev">I</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:apply-templates/>
 </xsl:element>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/param ')]">
 <xsl:element name="param">
  <xsl:if test="@name"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
  <xsl:if test="@id"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
  <xsl:if test="@value"><xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute></xsl:if>
 </xsl:element>
</xsl:template>

<!-- need to add test for object/desc to avoid conflicts -->
<xsl:template match="*[contains(@class,' topic/object ')]/*[contains(@class,' topic/desc ')]">
 <xsl:element name="span">
  <xsl:if test="@name"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
  <xsl:if test="@id"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
  <xsl:if test="@value"><xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute></xsl:if>
  <xsl:apply-templates/>
 </xsl:element>
</xsl:template>

<!-- TBD: process the param element as part of object (ie, pass through to HTML) -->


<!-- ===================================================================== -->

<!-- [20] =========== CALS (OASIS) TABLE =========== -->

<xsl:template match="*[contains(@class,' topic/table ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="table-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="table-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/table ')]" mode="table-fmt">
 <xsl:value-of select="$newline"/>
 <!-- special case for IE & NS for frame & no rules - needs to be a double table -->
 <xsl:variable name="colsep">    <!-- E003877 -->
   <xsl:choose>
     <xsl:when test="*[contains(@class,' topic/tgroup ')]/@colsep"><xsl:value-of select="*[contains(@class,' topic/tgroup ')]/@colsep"/></xsl:when>
     <xsl:when test="@colsep"><xsl:value-of select="@colsep"/></xsl:when>
   </xsl:choose>
 </xsl:variable>
 <xsl:variable name="rowsep">    <!-- E003877 -->
   <xsl:choose>
     <xsl:when test="*[contains(@class,' topic/tgroup ')]/@rowsep"><xsl:value-of select="*[contains(@class,' topic/tgroup ')]/@rowsep"/></xsl:when>
     <xsl:when test="@rowsep"><xsl:value-of select="@rowsep"/></xsl:when>
   </xsl:choose>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="@frame='all' and $colsep='0' and $rowsep='0'">
    <table cellpadding="4" cellspacing="0" border="1" class="tableborder"><tr><td><xsl:value-of select="$newline"/>
     <xsl:call-template name="dotable"/>
    </td></tr></table>
  </xsl:when>
  <xsl:when test="not(@frame) and $colsep='0' and $rowsep='0'">
    <table cellpadding="4" cellspacing="0" border="1" class="tableborder"><tr><td><xsl:value-of select="$newline"/>
     <xsl:call-template name="dotable"/>
    </td></tr></table>
  </xsl:when>
  <xsl:otherwise>
   <div class="tablenoborder">
   <xsl:call-template name="dotable"/>
   </div>
  </xsl:otherwise>
 </xsl:choose><xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template name="dotable">
 <xsl:call-template name="flagit"/>
 <xsl:call-template name="start-revflag"/>
 <xsl:call-template name="setaname"/>
 <table cellpadding="4" cellspacing="0" summary="">
  <xsl:variable name="colsep">    <!-- E003877 -->
    <xsl:choose>
      <xsl:when test="*[contains(@class,' topic/tgroup ')]/@colsep"><xsl:value-of select="*[contains(@class,' topic/tgroup ')]/@colsep"/></xsl:when>
      <xsl:when test="@colsep"><xsl:value-of select="@colsep"/></xsl:when>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="rowsep">    <!-- E003877 -->
    <xsl:choose>
      <xsl:when test="*[contains(@class,' topic/tgroup ')]/@rowsep"><xsl:value-of select="*[contains(@class,' topic/tgroup ')]/@rowsep"/></xsl:when>
      <xsl:when test="@rowsep"><xsl:value-of select="@rowsep"/></xsl:when>
    </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="setid"/>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setscale"/>
  <!-- When a table's width is set to page or column, force it's width to 100%. If it's in a list, use 90%.
       Otherwise, the table flows to the content -->
  <xsl:choose>
   <xsl:when test="@expanse='page' and (ancestor::*[contains(@class,' topic/li ')] or ancestor::*[contains(@class,' topic/dd ')] )">
    <xsl:attribute name="width">90%</xsl:attribute>
   </xsl:when>
   <xsl:when test="@expanse='column' and (ancestor::*[contains(@class,' topic/li ')] or ancestor::*[contains(@class,' topic/dd ')] )">
    <xsl:attribute name="width">90%</xsl:attribute>
   </xsl:when>
   <xsl:when test="@expanse='page'">
    <xsl:attribute name="width">100%</xsl:attribute>
   </xsl:when>
   <xsl:when test="@expanse='column'">
    <xsl:attribute name="width">100%</xsl:attribute>
   </xsl:when>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="@frame='all' and $colsep='0' and $rowsep='0'">
    <xsl:attribute name="border">0</xsl:attribute>
   </xsl:when>
   <xsl:when test="not(@frame) and $colsep='0' and $rowsep='0'">
    <xsl:attribute name="border">0</xsl:attribute>
   </xsl:when>
   <xsl:when test="@frame='sides'">
    <xsl:attribute name="frame">vsides</xsl:attribute>
    <xsl:attribute name="border">1</xsl:attribute>
   </xsl:when>
   <xsl:when test="@frame='top'">
    <xsl:attribute name="frame">above</xsl:attribute>
    <xsl:attribute name="border">1</xsl:attribute>
   </xsl:when>
   <xsl:when test="@frame='bottom'">
    <xsl:attribute name="frame">below</xsl:attribute>
    <xsl:attribute name="border">1</xsl:attribute>
   </xsl:when>
   <xsl:when test="@frame='topbot'">
    <xsl:attribute name="frame">hsides</xsl:attribute>
    <xsl:attribute name="border">1</xsl:attribute>
   </xsl:when>
   <xsl:when test="@frame='none'">
    <xsl:attribute name="frame">void</xsl:attribute>
    <xsl:attribute name="border">1</xsl:attribute>
   </xsl:when>
   <xsl:otherwise>
    <xsl:attribute name="frame">border</xsl:attribute>
    <xsl:attribute name="border">1</xsl:attribute>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="@frame='all' and $colsep='0' and $rowsep='0'">
    <xsl:attribute name="border">0</xsl:attribute>
   </xsl:when>
   <xsl:when test="not(@frame) and $colsep='0' and $rowsep='0'">
    <xsl:attribute name="border">0</xsl:attribute>
   </xsl:when>
   <xsl:when test="$colsep='0' and $rowsep='0'">
    <xsl:attribute name="rules">none</xsl:attribute>
    <xsl:attribute name="border">0</xsl:attribute>
   </xsl:when>
   <xsl:when test="$colsep='0'">
    <xsl:attribute name="rules">rows</xsl:attribute>
   </xsl:when>
   <xsl:when test="$rowsep='0'">
    <xsl:attribute name="rules">cols</xsl:attribute>
   </xsl:when>
   <xsl:otherwise>
    <xsl:attribute name="rules">all</xsl:attribute>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="place-tbl-lbl"/>
  <xsl:apply-templates/>
 </table><xsl:value-of select="$newline"/>
 <xsl:call-template name="end-revflag"/>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/tgroup ')]">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/colspec ')]"></xsl:template>

<xsl:template match="*[contains(@class,' topic/spanspec ')]"></xsl:template>

<xsl:template match="*[contains(@class,' topic/thead ')]">
  <thead>
  <xsl:call-template name="setclass"/>
    <xsl:choose>
     <xsl:when test="@align">
      <xsl:attribute name="align">
        <xsl:value-of select="@align"/>
      </xsl:attribute>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="th-align"/>
<!--       <xsl:attribute name="align">left</xsl:attribute> -->
     </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@char">
      <xsl:attribute name="char">
        <xsl:value-of select="@char"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@charoff">
      <xsl:attribute name="charoff">
        <xsl:value-of select="@charoff"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@valign">
      <xsl:attribute name="valign">
        <xsl:value-of select="@valign"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </thead><xsl:value-of select="$newline"/>
</xsl:template>

<!-- Table footer processing. Ignore fall-thru tfoot; process them from the table body -->
<xsl:template match="*[contains(@class,' topic/tfoot ')]"/>

<xsl:template match="*[contains(@class,' topic/tbody ')]">
  <tbody>
    <xsl:call-template name="setclass"/>
    <xsl:if test="@align">
      <xsl:attribute name="align">
        <xsl:value-of select="@align"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@char">
      <xsl:attribute name="char">
        <xsl:value-of select="@char"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@charoff">
      <xsl:attribute name="charoff">
        <xsl:value-of select="@charoff"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@valign">
      <xsl:attribute name="valign">
        <xsl:value-of select="@valign"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
    <!-- process table footer -->
    <xsl:apply-templates select="../*[contains(@class,' topic/tfoot ')]" mode="gen-tfoot" />
  </tbody><xsl:value-of select="$newline"/>
</xsl:template>

<!-- special mode for table footers -->
<xsl:template match="*[contains(@class,' topic/tfoot ')]" mode="gen-tfoot">
  <xsl:apply-templates/><xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/row ')]">
  <tr>
    <xsl:call-template name="setid"/>
    <xsl:call-template name="setclass"/>
    <xsl:if test="@align">
      <xsl:attribute name="align">
        <xsl:value-of select="@align"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@char">
      <xsl:attribute name="char">
        <xsl:value-of select="@char"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@charoff">
      <xsl:attribute name="charoff">
        <xsl:value-of select="@charoff"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@valign">
      <xsl:attribute name="valign">
        <xsl:value-of select="@valign"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </tr><xsl:value-of select="$newline"/>
</xsl:template>

<!-- do header entries -->
<xsl:template match="*[contains(@class,' topic/thead ')]/*[contains(@class,' topic/row ')]/*[contains(@class,' topic/entry ')]" priority="2">
 <th>
  <xsl:call-template name="doentry"/>
 </th><xsl:value-of select="$newline"/>
</xsl:template>

<!-- do body entries -->
<xsl:template match="*[contains(@class,' topic/entry ')]">
  <xsl:variable name="startpos">
    <xsl:if test="../../../../@rowheader='firstcol'"><xsl:call-template name="find-entry-start-position"/></xsl:if>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$startpos=1"><th><xsl:call-template name="doentry"/></th></xsl:when>
    <xsl:otherwise><td><xsl:call-template name="doentry"/></td></xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template name="doentry">
  <xsl:call-template name="setclass"/>
  <xsl:if test="@morerows">
    <xsl:attribute name="rowspan"> <!-- set the number of rows to span -->
      <xsl:value-of select="@morerows+1"/>
    </xsl:attribute>
  </xsl:if>
  <xsl:if test="@spanname">
    <xsl:attribute name="colspan"> <!-- get the number of columns to span from the corresponding spanspec -->
      <xsl:call-template name="find-spanspec-colspan"/>
    </xsl:attribute>
  </xsl:if>
  <xsl:if test="@namest and @nameend"> <!-- get the number of columns to span from the specified named column values -->
    <xsl:attribute name="colspan">
      <xsl:call-template name="find-colspan"/>
    </xsl:attribute>
  </xsl:if>
  <!-- If align is on the tgroup, use it (parent=row, then tbody|thead|tfoot, then tgroup) -->
  <xsl:if test="../../../@align">
    <xsl:attribute name="align">
      <xsl:value-of select="../../../@align"/>
    </xsl:attribute>
  </xsl:if>
  <!-- If align is specified on a colspec or spanspec, that takes priority over tgroup -->
  <xsl:if test="@colname">
    <xsl:variable name="this-colname"><xsl:value-of select="@colname"/></xsl:variable>
    <xsl:if test="../../../*[contains(@class,' topic/colspec ')][@colname=$this-colname][@align]">
      <xsl:attribute name="align">
        <xsl:value-of select="../../../*[contains(@class,' topic/colspec ')][@colname=$this-colname]/@align"/>
      </xsl:attribute>
    </xsl:if>
  </xsl:if>
  <xsl:if test="@spanname">
    <xsl:variable name="this-spanname"><xsl:value-of select="@spanname"/></xsl:variable>
    <xsl:if test="../../../*[contains(@class,' topic/spanspec ')][@spanname=$this-spanname][@align]">
      <xsl:attribute name="align">
        <xsl:value-of select="../../../*[contains(@class,' topic/spanspec ')][@spanname=$this-spanname]/@align"/>
      </xsl:attribute>
    </xsl:if>
  </xsl:if>
  <!-- If align is locally specified, that takes priority over all -->
  <xsl:if test="@align">
    <xsl:attribute name="align">
      <xsl:value-of select="@align"/>
    </xsl:attribute>
  </xsl:if>
  <xsl:if test="@char">
    <xsl:attribute name="char">
      <xsl:value-of select="@char"/>
    </xsl:attribute>
  </xsl:if>
  <xsl:if test="@charoff">
    <xsl:attribute name="charoff">
      <xsl:value-of select="@charoff"/>
    </xsl:attribute>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="@valign">
    <xsl:attribute name="valign">
      <xsl:value-of select="@valign"/>
    </xsl:attribute>
   </xsl:when>
   <xsl:when test="ancestor::*[contains(@class,' topic/row ')]/@valign">
    <xsl:attribute name="valign">
      <xsl:value-of select="ancestor::*[contains(@class,' topic/row ')]/@valign"/>
    </xsl:attribute>
   </xsl:when>
   <xsl:otherwise>
    <xsl:attribute name="valign">top</xsl:attribute>
   </xsl:otherwise>
  </xsl:choose>

  <!-- If @rowheader='firstcol' on table, and this entry is in the first column,
       output an ID and the firstcol class -->
  <xsl:if test="../../../../@rowheader='firstcol'">
    <xsl:variable name="startpos">
      <xsl:call-template name="find-entry-start-position"/>
    </xsl:variable>
    <xsl:if test="number($startpos)=1">
      <xsl:attribute name="class">firstcol</xsl:attribute>
      <xsl:attribute name="id">
        <xsl:value-of select="generate-id(.)"/>
      </xsl:attribute>
     </xsl:if>
  </xsl:if>

  <xsl:choose>
    <!-- When entry is in a thead, output the ID -->
    <xsl:when test="parent::*/parent::*[contains(@class,' topic/thead ')]">
      <xsl:attribute name="id">
        <xsl:value-of select="generate-id(.)"/>
      </xsl:attribute>
    </xsl:when>
    <!-- otherwise, add @headers if needed -->
    <xsl:otherwise>
      <xsl:call-template name="add-headers-attribute"/>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <!-- When entry is empty, output a blank -->
    <xsl:when test="not(*|text()|processing-instruction())">
      <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>  <!-- nbsp -->
    </xsl:when>
    <xsl:otherwise>
<!--     <xsl:call-template name="flagit-parent"/> --> <!-- no more row image flagging -->
      <xsl:variable name="revtest">
        <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
          <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
            <xsl:with-param name="allrevs" select="@rev"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:variable>
      <xsl:variable name="revtest-row">
        <xsl:if test="../@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
          <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
            <xsl:with-param name="allrevs" select="../@rev"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$revtest=1">   <!-- Entry Rev is active - add the span -->
          <span class="{@rev}">
          <xsl:call-template name="start-revflag-parent"/>
          <xsl:call-template name="start-revflag"/>              <!-- E003944 add @rev to entry -->
          <xsl:apply-templates/>
          <xsl:call-template name="end-revflag"/>
          <xsl:call-template name="end-revflag-parent"/>
          </span>
        </xsl:when>
        <xsl:when test="$revtest-row=1">   <!-- Row Rev is active - add the span -->
          <span class="{../@rev}">
          <xsl:call-template name="start-revflag-parent"/>
          <xsl:call-template name="start-revflag"/>
          <xsl:apply-templates/>
          <xsl:call-template name="end-revflag"/>
          <xsl:call-template name="end-revflag-parent"/>
          </span>
        </xsl:when>
        <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
          <xsl:call-template name="start-revflag-parent"/>
          <xsl:call-template name="start-revflag"/>
          <xsl:apply-templates/>
          <xsl:call-template name="end-revflag"/>
          <xsl:call-template name="end-revflag-parent"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Find the starting column of an entry in a row. -->
<xsl:template name="find-entry-start-position">
  <xsl:choose>

    <!-- if the column number is specified, use it -->
    <xsl:when test="@colnum">
      <xsl:value-of select="@colnum"/>
    </xsl:when>

    <!-- If there is a defined column name, check the colspans to determine position -->
    <xsl:when test="@colname">
      <!-- count the number of colspans before the one this entry references, plus one -->
      <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=current()/@colname]/preceding-sibling::*)+1)"/>
    </xsl:when>

    <!-- If the starting column is defined, check colspans to determine position -->
    <xsl:when test="@namest">
      <!--<xsl:value-of select="count(../../../*[contains(@class,' topic/colspec ')][@colname=./@namest]/preceding-sibling::*)"/>-->
      <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=current()/@namest]/preceding-sibling::*)+1)"/>
    </xsl:when>

    <!-- Need a test for spanspec -->
    <xsl:when test="@spanname">
      <xsl:variable name="startspan">  <!-- starting column for this span -->
        <xsl:value-of select="../../../*[contains(@class,' topic/spanspec ')][@spanname=current()/@spanname]/@namest"/>
      </xsl:variable>
      <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=$startspan]/preceding-sibling::*)+1)"/>
    </xsl:when>

    <!-- Otherwise, just use the count of cells in this row -->
    <xsl:otherwise>
      <xsl:variable name="prev-sib">            <!-- need to update for spanning cell? -->
        <xsl:value-of select="count(preceding-sibling::*)"/>
      </xsl:variable>
      <xsl:value-of select="$prev-sib+1"/>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<!-- Find the end column of a cell. If the cell does not span any columns,
     the end position is the same as the start position. -->
<xsl:template name="find-entry-end-position">
  <xsl:param name="startposition" select="0"/>
  <xsl:choose>
    <xsl:when test="@nameend">
      <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=current()/@nameend]/preceding-sibling::*)+1)"/>
    </xsl:when>
    <xsl:when test="@spanname">
      <xsl:variable name="endspan">  <!-- starting column for this span -->
        <xsl:value-of select="../../../*[contains(@class,' topic/spanspec ')][@spanname=current()/@spanname]/@nameend"/>
      </xsl:variable>
      <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=$endspan]/preceding-sibling::*)+1)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$startposition"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Check <thead> entries, and return IDs for those which match the desired column -->
<xsl:template match="*[contains(@class,' topic/thead ')]/*[contains(@class,' topic/row ')]/*[contains(@class,' topic/entry ')]" mode="findmatch">
  <xsl:param name="startmatch">1</xsl:param>  <!-- start column of the tbody cell -->
  <xsl:param name="endmatch">1</xsl:param>    <!-- end column of the tbody cell -->
  <xsl:variable name="entrystartpos">         <!-- start column of this thead cell -->
    <xsl:call-template name="find-entry-start-position"/>
  </xsl:variable>
  <xsl:variable name="entryendpos">           <!-- end column of this thead cell -->
    <xsl:call-template name="find-entry-end-position">
      <xsl:with-param name="startposition" select="$entrystartpos"/>
    </xsl:call-template>
  </xsl:variable>
  <!-- The test cell can be any of the following:
       * completely before the header range (ignore id)
       * completely after the header range (ignore id)
       * completely within the header range (save id)
       * partially before, partially within (save id)
       * partially within, partially after (save id)
       * completely surrounding the header range (save id) -->
  <xsl:choose>
    <!-- Ignore this header cell if it  starts after the tbody cell we are testing -->
    <xsl:when test="number($endmatch) &lt; number($entrystartpos)"/>
    <!-- Ignore this header cell if it ends before the tbody cell we are testing -->
    <xsl:when test="number($startmatch) > number($entryendpos)"/>
    <!-- Otherwise, this header lines up with the tbody cell, so use the ID -->
    <xsl:otherwise>
      <xsl:value-of select="generate-id(.)"/><xsl:text> </xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Check the first column for entries that line up with the test row.
     Any entries that line up need to have the header saved. This template is first
     called with the first entry of the first row in <tbody>. It is called from here
     on the next cell in column one.            -->
<!--<xsl:template match="*[contains(@class,' topic/tbody ')]/*[contains(@class,' topic/row ')]/*[contains(@class,' topic/entry ')]" priority="2" mode="check-first-column"> -->
<xsl:template match="*[contains(@class,' topic/entry ')]" mode="check-first-column">
  <xsl:param name="startMatchRow" select="1"/>   <!-- First row of the tbody cell we are matching -->
  <xsl:param name="endMatchRow" select="1"/>     <!-- Last row of the tbody cell we are matching -->
  <xsl:param name="startCurrentRow" select="1"/> <!-- First row of the column-1 cell we are testing -->
  <xsl:variable name="endCurrentRow">            <!-- Last row of the column-1 cell we are testing -->
    <xsl:choose>
      <!-- If @morerows, the cell ends at startCurrentRow + @morerows. Otherise, start=end. -->
      <xsl:when test="@morerows"><xsl:value-of select="number($startCurrentRow)+number(@morerows)"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$startCurrentRow"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <!-- When the current column-1 cell ends before the tbody cell we are matching -->
    <xsl:when test="number($endCurrentRow) &lt; number($startMatchRow)">
      <!-- Call this template again with the next entry in column one -->
      <xsl:if test="parent::*/parent::*/*[number($endCurrentRow)+1]">
        <xsl:apply-templates select="parent::*/parent::*/*[number($endCurrentRow)+1]/*[1]" mode="check-first-column">
          <xsl:with-param name="startMatchRow" select="$startMatchRow"/>
          <xsl:with-param name="endMatchRow" select="$endMatchRow"/>
          <xsl:with-param name="startCurrentRow" select="number($endCurrentRow)+1"/>
        </xsl:apply-templates>
      </xsl:if>
    </xsl:when>
    <!-- If this column-1 cell starts after the tbody cell we are matching, jump out of recursive loop -->
    <xsl:when test="number($startCurrentRow) &gt; number($endMatchRow)"/>
    <!-- Otherwise, the column-1 cell is aligned with the tbody cell, so save the ID and continue -->
    <xsl:otherwise>
      <xsl:value-of select="generate-id(.)"/><xsl:text> </xsl:text>
      <!-- If we are not at the end of the tbody cell, and more rows exist, continue testing column 1 -->
      <xsl:if test="number($endCurrentRow) &lt; number($endMatchRow) and
                    parent::*/parent::*/*[number($endCurrentRow)+1]">
        <xsl:apply-templates select="parent::*/parent::*/*[number($endCurrentRow)+1]/*[1]" mode="check-first-column">
          <xsl:with-param name="startMatchRow" select="$startMatchRow"/>
          <xsl:with-param name="endMatchRow" select="$endMatchRow"/>
          <xsl:with-param name="startCurrentRow" select="number($endCurrentRow)+1"/>
        </xsl:apply-templates>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Add @headers to cells in the body of a table. -->
<xsl:template name="add-headers-attribute">
  <!-- Determine the start column for the current cell -->
  <xsl:variable name="entrystartpos">
    <xsl:call-template name="find-entry-start-position"/>
  </xsl:variable>
  <!-- Determine the end column for the current cell -->
  <xsl:variable name="entryendpos">
    <xsl:call-template name="find-entry-end-position">
      <xsl:with-param name="startposition" select="$entrystartpos"/>
    </xsl:call-template>
  </xsl:variable>
  <!-- Find the IDs of headers that are aligned above this cell. This is done by applying
       templates on all headers, using mode=findmatch; matching IDs are returned. -->
  <xsl:variable name="hdrattr">
    <xsl:apply-templates select="../../../thead/row/*" mode="findmatch">
      <xsl:with-param name="startmatch" select="$entrystartpos"/>
      <xsl:with-param name="endmatch" select="$entryendpos"/>
    </xsl:apply-templates>
  </xsl:variable>
  <!-- Find the IDs of headers in the first column, which are aligned with this cell -->
  <xsl:variable name="rowheader">
    <!-- If this entry is not in the first column or in thead, and @rowheader=firstcol on table -->
    <xsl:if test="not(number($entrystartpos)=1) and
                  not(parent::*/parent::*[contains(@class,' topic/thead ')]) and
                  ../../../../@rowheader='firstcol'">
      <!-- Find the start row for this entry -->
      <xsl:variable name="startrow" select="number(count(parent::*/preceding-sibling::*)+1)"/>
      <!-- Find the end row for this entry -->
      <xsl:variable name="endrow">
        <xsl:if test="@morerows"><xsl:value-of select="number($startrow) + number(@morerows)"/></xsl:if>
        <xsl:if test="not(@morerows)"><xsl:value-of select="$startrow"/></xsl:if>
      </xsl:variable>
      <!-- Scan first-column entries for ones that align with this cell, starting with
           the first entry in the first row -->
      <xsl:apply-templates select="../../row[1]/entry[1]" mode="check-first-column">
        <xsl:with-param name="startMatchRow" select="$startrow"/>
        <xsl:with-param name="endMatchRow" select="$endrow"/>
      </xsl:apply-templates>
    </xsl:if>
  </xsl:variable>
   <xsl:if test="string-length($rowheader)>0 or string-length($hdrattr)>0">
    <xsl:attribute name="headers"><xsl:value-of select="$rowheader"/><xsl:value-of select="$hdrattr"/></xsl:attribute>
  </xsl:if>
</xsl:template>

<!-- Find the number of column spans between name-start and name-end attrs -->
<xsl:template name="find-colspan">
  <xsl:variable name="startpos">
    <xsl:call-template name="find-entry-start-position"/>
  </xsl:variable>
  <xsl:variable name="endpos">
    <xsl:call-template name="find-entry-end-position"/>
  </xsl:variable>
  <xsl:value-of select="$endpos - $startpos + 1"/>
<!--  <xsl:message>found colspan = <xsl:value-of select="$endpos - $startpos + 1"/></xsl:message> -->
</xsl:template>

<xsl:template name="find-spanspec-colspan">
  <xsl:variable name="spanname"><xsl:value-of select="@spanname"/></xsl:variable>
  <xsl:variable name="startcolname">
    <xsl:value-of select="../../../*[contains(@class,' topic/spanspec ')][@spanname=$spanname][1]/@namest"/>
  </xsl:variable>
  <xsl:variable name="endcolname">
    <xsl:value-of select="../../../*[contains(@class,' topic/spanspec ')][@spanname=$spanname][1]/@nameend"/>
  </xsl:variable>
  <xsl:variable name="startpos">
   <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=$startcolname]/preceding-sibling::*)+1)"/>
  </xsl:variable>
  <xsl:variable name="endpos">
   <xsl:value-of select="number(count(../../../*[contains(@class,' topic/colspec ')][@colname=$endcolname]/preceding-sibling::*)+1)"/>
  </xsl:variable>
  <xsl:value-of select="$endpos - $startpos + 1"/>
<!--[  <xsl:message>Start col name = <xsl:value-of select="$startcolname"/></xsl:message>
  <xsl:message>End col name = <xsl:value-of select="$endcolname"/></xsl:message>
  <xsl:message>Start col = <xsl:value-of select="$scol"/></xsl:message>
  <xsl:message>End   col = <xsl:value-of select="$ecol"/></xsl:message>
  <xsl:message>found spanspec colspan = <xsl:value-of select="$ecol - $scol + 1"/></xsl:message> ]-->
</xsl:template>

<!-- end of table section -->


<!-- ===================================================================== -->

<!-- [21] =========== SimpleTable - SEMANTIC TABLE =========== -->

<xsl:template match="*[contains(@class,' topic/simpletable ')]">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
 <xsl:choose>
   <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
     <div class="{@rev}"><xsl:apply-templates select="."  mode="simpletable-fmt" /></div>
   </xsl:when>
   <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
     <xsl:apply-templates select="."  mode="simpletable-fmt" />
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/simpletable ')]" mode="simpletable-fmt">
  <!-- Find the total number of relative units for the table. If @relcolwidth="1* 2* 2*",
       the variable is set to 5. -->
  <xsl:variable name="totalwidth">
    <xsl:if test="@relcolwidth">
      <xsl:call-template name="find-total-table-width"/>
    </xsl:if>
  </xsl:variable>
  <!-- Find how much of the table each relative unit represents. If @relcolwidth is 1* 2* 2*,
       there are 5 units. So, each unit takes up 100/5, or 20% of the table. Default to 0,
       which the entries will ignore. -->
  <xsl:variable name="width-multiplier">
    <xsl:choose>
      <xsl:when test="@relcolwidth">
        <xsl:value-of select="100 div $totalwidth"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="spec-title"/>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="start-revflag"/>
  <xsl:call-template name="setaname"/>
  <table cellpadding="4" cellspacing="0" summary="">
   <xsl:call-template name="setid"/>
    <xsl:choose>
     <xsl:when test="@frame='none'">
      <xsl:attribute name="border">0</xsl:attribute>
      <xsl:attribute name="class">simpletablenoborder</xsl:attribute>
     </xsl:when>
     <xsl:otherwise>
      <xsl:attribute name="border">1</xsl:attribute>
      <xsl:attribute name="class">simpletableborder</xsl:attribute>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="setclass"/>
    <xsl:call-template name="setscale"/>
    <xsl:apply-templates>     <!-- width-multiplier will be used in the first row to set widths. -->
      <xsl:with-param name="width-multiplier"><xsl:value-of select="$width-multiplier"/></xsl:with-param>
    </xsl:apply-templates>
  </table>
  <xsl:call-template name="end-revflag"/><xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/strow ')]">
  <xsl:param name="width-multiplier"/>
  <tr>
   <xsl:call-template name="setid"/>
    <xsl:call-template name="setclass"/>
    <xsl:choose>
      <!-- If there are any rows or headers before this, the width values have already been set. -->
      <xsl:when test="preceding-sibling::*">
        <xsl:apply-templates/>
      </xsl:when>
      <!-- Otherwise, this is the first row. Pass the percentage to all entries in this row. -->
      <xsl:otherwise>
        <xsl:apply-templates>
          <xsl:with-param name="width-multiplier"><xsl:value-of select="$width-multiplier"/></xsl:with-param>
        </xsl:apply-templates>
      </xsl:otherwise>
    </xsl:choose>
  </tr><xsl:value-of select="$newline"/>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/sthead ')]">
  <xsl:param name="width-multiplier"/>
  <tr>
    <xsl:call-template name="setclass"/>
    <!-- There is only one sthead, so use the entries in the header to set relative widths. -->
    <xsl:apply-templates>
      <xsl:with-param name="width-multiplier"><xsl:value-of select="$width-multiplier"/></xsl:with-param>
    </xsl:apply-templates>
  </tr><xsl:value-of select="$newline"/>
</xsl:template>

<!-- Output the ID for a simpletable entry, when it is specified. If no ID is specified,
     and this is a header row, generate an ID. The entry is considered a header entry
     when the it is inside <sthead>, or when it is in the column specified in the keycol
     attribute on <simpletable>
     NOTE: I reference simpletable with parent::*/parent::* in order to avoid problems
     with nested simpletables. -->
<xsl:template name="output-stentry-id">
  <!-- Find the position in this row -->
  <xsl:variable name="thiscolnum"><xsl:number level="single" count="*"/></xsl:variable>
  <xsl:choose>
    <xsl:when test="@id">    <!-- If ID is specified, always use it -->
      <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
    </xsl:when>
    <!-- If no ID is specified, and this is a header cell, generate an ID -->
    <xsl:when test="parent::*[contains(@class,' topic/sthead ')] or
                    (parent::*/parent::*/@keycol and number(parent::*/parent::*/@keycol)=number($thiscolnum))">
      <xsl:attribute name="id"><xsl:value-of select="generate-id(.)"/></xsl:attribute>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<!-- Output the headers attribute for screen readers. If specified, it should match both
     of the following:
     * the <stentry> with the same position in the header
     * the <stentry> that is in the key column (specified in @keycol on simpletable)
     The headers attribute is not generated for elements that are in the <sthead>, but
     it WILL be generated for elements in the keycol if a thead exists.
     NOTE: I reference simpletable with parent::*/parent::* in order to avoid problems
     with nested simpletables. -->
<xsl:template name="output-stentry-headers">
  <xsl:if test="not(parent::*[contains(@class,' topic/sthead ')])">
    <!-- Store the value of the keycol attribute on simpletable -->
    <xsl:variable name="keycolval">
      <xsl:choose>
        <xsl:when test="parent::*/parent::*/@keycol">
          <xsl:value-of select="parent::*/parent::*/@keycol"/>
        </xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!-- Store the position of this entry in the current row -->
    <xsl:variable name="thiscolnum"><xsl:number level="single" count="*"/></xsl:variable>
    <!-- If there is a header in this table, find the ID for the matching <stentry>. Each
         test in this variable is attempting to match the following simplified expression:
         syntaxdiagram/sthead/stentry, where stentry is in column $thiscolnum, with or without @id -->
    <xsl:variable name="head-match">
      <xsl:if test="parent::*/parent::*/*[contains(@class,' topic/sthead ')]/*[number($thiscolnum)]">
        <xsl:choose>
          <!-- If the matching cell has an ID, that should be used. -->
          <xsl:when test="parent::*/parent::*/*[contains(@class,' topic/sthead ')]/*[number($thiscolnum)][@id]">
            <xsl:value-of select="parent::*/parent::*/*[contains(@class,' topic/sthead ')]/*[number($thiscolnum)]/@id"/>
          </xsl:when>
          <!-- Otherwise, the generated ID for that cell should be used -->
          <xsl:otherwise>
            <xsl:value-of select="generate-id(parent::*/parent::*/*[contains(@class,' topic/sthead ')]/*[number($thiscolnum)])"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    <!-- If there is a keycol in this table, find the ID for the matching <stentry> -->
    <xsl:variable name="keycol-match">
      <!-- If there is a keycol, and it is NOT the current column -->
      <xsl:if test="number($keycolval)!=0 and number($keycolval)!=number($thiscolnum)">
        <xsl:choose>
          <!-- When the entry in the desired column has an ID, use it -->
          <xsl:when test="parent::*/*[number($keycolval)]/@id">
            <xsl:value-of select="parent::*/*[number($keycolval)]/@id"/>
          </xsl:when>
          <!-- Otherwise, use the generated ID for that entry -->
          <xsl:otherwise>
            <xsl:value-of select="generate-id(parent::*/*[number($keycolval)])"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>

    <!-- If there was a matching header or a matching keycol, create the headers attribute.
         If there is more than one value, they should be separated with spaces. -->
    <xsl:if test="string-length($head-match) > 0 or string-length($keycol-match) > 0">
      <xsl:attribute name="headers">
        <xsl:value-of select="$head-match"/>   <!-- Output any header ID -->
        <xsl:if test="string-length($head-match) > 0 and string-length($keycol-match) > 0">
          <xsl:text> </xsl:text>               <!-- If both exist, output a space between -->
        </xsl:if>
        <xsl:value-of select="$keycol-match"/>  <!-- Output any keycol ID -->
      </xsl:attribute>
    </xsl:if>
  </xsl:if>
</xsl:template>

<!-- sthead/stentry - bottom align the header text -->
<xsl:template match="*[contains(@class,' topic/sthead ')]/*[contains(@class,' topic/stentry ')]" priority="2">
  <xsl:param name="width-multiplier">0</xsl:param>
  <th valign="bottom">
    <xsl:call-template name="th-align"/>
    <!-- Determine which column this entry is in. -->
    <xsl:variable name="thiscolnum"><xsl:value-of select="number(count(preceding-sibling::*)+1)"/></xsl:variable>
    <!-- If width-multiplier=0, then either @relcolwidth was not specified, or this is not the first
         row, so do not create a width value. Otherwise, find out the relative width of this column. -->
    <xsl:variable name="widthpercent">
      <xsl:if test="$width-multiplier != 0">
        <xsl:call-template name="get-current-entry-percentage">
          <xsl:with-param name="multiplier"><xsl:value-of select="$width-multiplier"/></xsl:with-param>
          <xsl:with-param name="entry-num"><xsl:value-of select="$thiscolnum"/></xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <xsl:call-template name="output-stentry-id"/>
    <xsl:call-template name="setclass"/>
    <!-- If we calculated a width, create the width attribute. -->
    <xsl:if test="string-length($widthpercent)>0">
      <xsl:attribute name="width">
        <xsl:value-of select="$widthpercent"/><xsl:text>%</xsl:text>
      </xsl:attribute>
    </xsl:if>
       <xsl:choose>
        <xsl:when test="not(*|text()|processing-instruction()) and @specentry">
         <xsl:value-of select="@specentry"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:apply-templates/>
        </xsl:otherwise>
       </xsl:choose>
  </th><xsl:value-of select="$newline"/>
</xsl:template>

<!-- For simple table headers: <TH> Set align="right" when in a BIDI area -->
<xsl:template name="th-align">
 <xsl:variable name="biditest">
  <xsl:call-template name="bidi-area"/>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$biditest='bidi'">
   <xsl:attribute name="align">right</xsl:attribute>
  </xsl:when>
  <xsl:otherwise>
   <xsl:attribute name="align">left</xsl:attribute>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- stentry  -->
<!-- for specentry - if no text in cell, output specentry attr; otherwise output text -->
<!-- Bold the @keycol column. Get the column's number. When (Nth stentry = the @keycol value) then bold the stentry -->
<xsl:template match="*[contains(@class,' topic/stentry ')]" priority="1">
 <xsl:param name="width-multiplier">0</xsl:param>
  <td valign="top">
    <xsl:call-template name="output-stentry-id"/>
    <xsl:call-template name="output-stentry-headers"/>
    <xsl:call-template name="setclass"/>
    <xsl:variable name="localkeycol">
      <xsl:choose>
        <xsl:when test="ancestor::*[contains(@class,' topic/simpletable ')]/@keycol">
          <xsl:value-of select="ancestor::*[contains(@class,' topic/simpletable ')]/@keycol"/>
        </xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!-- Determine which column this entry is in. -->
    <xsl:variable name="thiscolnum"><xsl:value-of select="number(count(preceding-sibling::*)+1)"/></xsl:variable>
    <!-- If width-multiplier=0, then either @relcolwidth was not specified, or this is not the first
         row, so do not create a width value. Otherwise, find out the relative width of this column. -->
    <xsl:variable name="widthpercent">
      <xsl:if test="$width-multiplier != 0">
        <xsl:call-template name="get-current-entry-percentage">
          <xsl:with-param name="multiplier"><xsl:value-of select="$width-multiplier"/></xsl:with-param>
          <xsl:with-param name="entry-num"><xsl:value-of select="$thiscolnum"/></xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <!-- If we calculated a width, create the width attribute. -->
    <xsl:if test="string-length($widthpercent)>0">
      <xsl:attribute name="width">
        <xsl:value-of select="$widthpercent"/><xsl:text>%</xsl:text>
      </xsl:attribute>
    </xsl:if>
<!--    <xsl:value-of select="$localkeycol"/><xsl:value-of select="$thiscolnum"/>   -->
<!--    <xsl:call-template name="spec-title-cell"/> --><!-- specentry is not added - it is replacement -->
<!--    <xsl:call-template name="flagit-parent"/> --> <!-- no more row flagging -->
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag-parent"/>
    <xsl:call-template name="start-revflag"/>
    <xsl:variable name="revtest">
      <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
        <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
          <xsl:with-param name="allrevs" select="@rev"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="revtest-row">
      <xsl:if test="../@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
        <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
          <xsl:with-param name="allrevs" select="../@rev"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <!-- Does the column match? Is REV on for entry or row? -->
    <xsl:choose>
     <xsl:when test="$thiscolnum=$localkeycol and $revtest-row=1">
      <b><span class="{../@rev}">
<xsl:call-template name="stentry-templates"/>
      </span></b>
     </xsl:when>
     <xsl:when test="$thiscolnum=$localkeycol and $revtest=1">
      <b><span class="{@rev}">
<xsl:call-template name="stentry-templates"/>
      </span></b>
     </xsl:when>
     <xsl:when test="$thiscolnum=$localkeycol">
      <b>
<xsl:call-template name="stentry-templates"/>
      </b>
     </xsl:when>
     <xsl:when test="$revtest-row=1">
      <span class="{../@rev}">
<xsl:call-template name="stentry-templates"/>
      </span>
     </xsl:when>
     <xsl:when test="$revtest=1">
      <span class="{@rev}">
<xsl:call-template name="stentry-templates"/>
      </span>
     </xsl:when>
     <xsl:otherwise>
<xsl:call-template name="stentry-templates"/>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="end-revflag"/>
    <xsl:call-template name="end-revflag-parent"/>
  </td><xsl:value-of select="$newline"/>
</xsl:template>
<xsl:template name="stentry-templates">
 <xsl:choose>
  <xsl:when test="not(*|text()|processing-instruction()) and @specentry">
   <xsl:value-of select="@specentry"/>
  </xsl:when>
  <xsl:when test="not(*|text()|processing-instruction())">
    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>  <!-- nbsp -->
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates/>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>


<!-- Use @relcolwidth to find the total width of the table. That is, if the attribute is set
     to 1* 2* 2* 1*, then the table is 6 units wide. -->
<xsl:template name="find-total-table-width">
  <!-- Start with relcolwidth, and each recursive call will remove the first value -->
  <xsl:param name="relcolwidth"><xsl:value-of select="@relcolwidth"/></xsl:param>
  <!-- Determine the first value, which is the value before the first asterisk -->
  <xsl:variable name="firstval">
    <xsl:if test="contains($relcolwidth,'*')">
      <xsl:value-of select="substring-before($relcolwidth,'*')"/>
    </xsl:if>
  </xsl:variable>
  <!-- Begin processing if we were able to find a first value -->
  <xsl:if test="string-length($firstval)>0">
    <!-- Chop off the first value, and set morevals to the remainder -->
    <xsl:variable name="morevals"><xsl:value-of select="substring-after($relcolwidth,' ')"/></xsl:variable>
    <xsl:choose>
      <!-- If there are additional values, call this template on the remainder.
           Add the result of that call to the first value. -->
      <xsl:when test="string-length($morevals)>0">
        <xsl:variable name="nextval">   <!-- The total of the remaining values -->
          <xsl:call-template name="find-total-table-width">
            <xsl:with-param name="relcolwidth"><xsl:value-of select="$morevals"/></xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="number($firstval)+number($nextval)"/>
      </xsl:when>
      <!-- If there are no more values, return the first (and only) value -->
      <xsl:otherwise><xsl:value-of select="$firstval"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>

<!-- Find the width of the current cell. Multiplier is how much each unit of width is multiplied to total 100.
     Entry-num is the current entry. Current-col is what column we are at when scanning @relcolwidth.
     Relcolvalues is the unscanned part of @relcolwidth. -->
<xsl:template name="get-current-entry-percentage">
  <xsl:param name="multiplier">1</xsl:param>  <!-- Each relative unit is worth this many percentage points -->
  <xsl:param name="entry-num"/>               <!-- The entry number of the cell we are evaluating now -->
  <xsl:param name="current-col">1</xsl:param> <!-- Position within the recursive call to evaluate @relcolwidth -->
  <!-- relcolvalues begins with @relcolwidth. Each call to the template removes the first value. -->
  <xsl:param name="relcolvalues"><xsl:value-of select="parent::*/parent::*/@relcolwidth"/></xsl:param>

  <xsl:choose>
    <!-- If the recursion has moved up to the proper cell, multiply $multiplier by the number of
         relative units for this column. -->
    <xsl:when test="$entry-num = $current-col">
      <xsl:variable name="relcol"><xsl:value-of select="substring-before($relcolvalues,'*')"/></xsl:variable>
      <xsl:value-of select="$relcol * $multiplier"/>
    </xsl:when>
    <!-- Otherwise, call this template again, removing the first value form @relcolwidth. Also add one
         to $current-col. -->
    <xsl:otherwise>
      <xsl:call-template name="get-current-entry-percentage">
        <xsl:with-param name="multiplier"><xsl:value-of select="$multiplier"/></xsl:with-param>
        <xsl:with-param name="entry-num"><xsl:value-of select="$entry-num"/></xsl:with-param>
        <xsl:with-param name="current-col"><xsl:value-of select="$current-col + 1"/></xsl:with-param>
        <xsl:with-param name="relcolvalues"><xsl:value-of select="substring-after($relcolvalues,' ')"/></xsl:with-param>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- [22] =========== FOOTNOTE =========== -->
<xsl:template match="*[contains(@class,' topic/fn ')]">
  <xsl:param name="xref"/>
  <!-- when FN has an ID, it can only be referenced, otherwise, output an a-name & a counter -->
  <xsl:if test="not(@id) or $xref='yes'">
  <xsl:variable name="fnid"><xsl:number from="/" level="any"/></xsl:variable>
  <xsl:variable name="callout"><xsl:value-of select="@callout"/></xsl:variable>
  <xsl:variable name="convergedcallout">
    <xsl:choose>
      <xsl:when test="string-length($callout)>'0'"><xsl:value-of select="$callout"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$fnid"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
      <!--<xsl:variable name="fnbody"><xsl:apply-templates/></xsl:variable> -->
      <!-- <a name="fnsrc_{$fnid}" href="#fntarg_{$fnid}" OnClick='alert ("{$fnbody}")'> -->
   <a name="fnsrc_{$fnid}" href="#fntarg_{$fnid}">
    <sup><xsl:value-of select="$convergedcallout"/></sup>
   </a>
  </xsl:if>
</xsl:template>


<!-- [23] =========== REQUIRED CLEANUP and REVIEW COMMENT =========== -->

<xsl:template match="*[contains(@class,' topic/required-cleanup ')]">
 <xsl:if test="$DRAFT='yes'">
  <xsl:call-template name="output-message">
   <xsl:with-param name="msg">Required cleanup area found.</xsl:with-param>
   <xsl:with-param name="msgnum">001</xsl:with-param>
   <xsl:with-param name="msgsev">W</xsl:with-param>
  </xsl:call-template>
  <div style="background-color: #FFFF99; color:#CC3333; border: 1pt black solid;">
   <xsl:call-template name="setclass"/>
   <xsl:call-template name="setidaname"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag"/>
     <b><xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Required cleanup'"/>
      </xsl:call-template>
       <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text></b><xsl:if test="@remap">[<xsl:value-of select="@remap"/>] </xsl:if>
     <xsl:apply-templates/>
    <xsl:call-template name="end-revflag"/>
  </div><xsl:value-of select="$newline"/>
 </xsl:if>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/draft-comment ')]">
 <xsl:if test="$DRAFT='yes'">
  <xsl:call-template name="output-message">
   <xsl:with-param name="msg">Draft comment area found.</xsl:with-param>
   <xsl:with-param name="msgnum">048</xsl:with-param>
   <xsl:with-param name="msgsev">I</xsl:with-param>
  </xsl:call-template>
  <div style="background-color: #99FF99; border: 1pt black solid;">
    <xsl:call-template name="setclass"/>
    <xsl:call-template name="setidaname"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag"/>
     <b><xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Draft comment'"/>
      </xsl:call-template>
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'ColonSymbol'"/>
       </xsl:call-template><xsl:text> </xsl:text></b><xsl:if test="@author"><xsl:value-of select="@author"/><xsl:text> </xsl:text></xsl:if><xsl:if test="@disposition"><xsl:value-of select="@disposition"/><xsl:text> </xsl:text></xsl:if><xsl:if test="@time"><xsl:value-of select="@time"/></xsl:if><br/>
     <xsl:apply-templates/>
    <xsl:call-template name="end-revflag"/>
  </div><xsl:value-of select="$newline"/>
 </xsl:if>
</xsl:template>

<!--Dita comment passthru-->
<xsl:template match="processing-instruction()">
  <xsl:if test="name()='dita-comment'"><xsl:comment><xsl:value-of select="."/></xsl:comment></xsl:if>
</xsl:template>

<!-- [24] =========== INDEX =========== -->

<!-- TBD: this needs practical implementation.  currently the support merely
     echoes the content back, indicating any nesting.  Useful view for authoring!-->
<xsl:template match="*[contains(@class,' topic/indexterm ')]">
 <xsl:if test="$INDEXSHOW='yes'">
  <span style="margin: 1pt; background-color: #ffddff; border: 1pt black solid;">
     <xsl:call-template name="setclass"/>
     <xsl:apply-templates/>
  </span>
 </xsl:if>
</xsl:template>
<!-- Index terms which may be inside of ph elements should not appear in text-only mode -->
<xsl:template match="*[contains(@class,' topic/indexterm ')]" mode="text-only"/>


<xsl:template match="*[contains(@class,' topic/indextermref ')]"/>


<!-- ===================================================================== -->

<!-- [25] =========== PROLOG =========== -->
<!-- all handled in getmeta.xsl -->
<xsl:template match="*[contains(@class,' topic/prolog ')]"/>


<!-- ===================================================================== -->

<!-- [26] ================= COMMON ATTRIBUTE PROCESSORS ====================== -->

<!-- If the element has an ID, set it as an ID and anchor-->
<!-- Set ID and output A-name -->
<xsl:template name="setidaname">
 <xsl:if test="@id">
  <xsl:call-template name="setidattr">
   <xsl:with-param name="idvalue" select="@id"/>
  </xsl:call-template>
  <xsl:call-template name="setanametag">
   <xsl:with-param name="idvalue" select="@id"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Set ID only -->
<xsl:template name="setid">
 <xsl:if test="@id">
  <xsl:call-template name="setidattr">
   <xsl:with-param name="idvalue" select="@id"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Set A-name only -->
<xsl:template name="setaname">
 <xsl:if test="@id">
  <xsl:call-template name="setanametag">
   <xsl:with-param name="idvalue" select="@id"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Set the ID attr for IE -->
<xsl:template name="setidattr">
 <xsl:param name="idvalue"/>
 <xsl:attribute name="id">
  <!-- If we're in the body, prefix the ID with the topic's ID & two "_" -->
  <xsl:if test="ancestor::*[contains(@class,' topic/body ')]">
   <xsl:value-of select="ancestor::*[contains(@class,' topic/body ')]/parent::*/@id"/><xsl:text>__</xsl:text>
  </xsl:if>
  <xsl:value-of select="$idvalue"/>
 </xsl:attribute>
</xsl:template>

<!-- Set the A-NAME attr for NS -->
<xsl:template name="setanametag">
 <xsl:param name="idvalue"/>
 <a>
  <xsl:attribute name="name">
   <xsl:if test="ancestor::*[contains(@class,' topic/body ')]">
    <xsl:value-of select="ancestor::*[contains(@class,' topic/body ')]/parent::*/@id"/><xsl:text>__</xsl:text>
   </xsl:if>
   <xsl:value-of select="$idvalue"/>
  </xsl:attribute>
  <xsl:value-of select="$afill"/><xsl:comment><xsl:text> </xsl:text></xsl:comment> <!-- fix for home page reader -->
 </a>
</xsl:template>

<xsl:template name="parent-id"><!-- if the parent's element has an ID, copy it through as an anchor -->
 <a>
  <xsl:attribute name="name">
   <xsl:if test="ancestor::*[contains(@class,' topic/body ')]">
    <xsl:value-of select="ancestor::*[contains(@class,' topic/body ')]/parent::*/@id"/><xsl:text>__</xsl:text>
   </xsl:if>
   <xsl:value-of select="parent::*/@id"/>
  </xsl:attribute>
 <xsl:value-of select="$afill"/><xsl:comment><xsl:text> </xsl:text></xsl:comment> <!-- fix for home page reader -->
 </a>
</xsl:template>

<!-- Create & insert an ID for the generated table of contents -->
<xsl:template name="gen-toc-id">
<!--[<a name="{generate-id()}"><xsl:value-of select="$afill"/></a>]-->
</xsl:template>

<!-- Create the class attribute for an element when the DITA element has an
     outputclass attribute -->
<xsl:template name="setclass">
  <xsl:if test="@outputclass">
     <xsl:attribute name="class"><xsl:value-of select="@outputclass"/></xsl:attribute>
  </xsl:if>
</xsl:template>

<!-- if the element has a compact=yes attribute, assert it in XHTML form -->
<xsl:template match="@compact">
  <xsl:if test="@compact = 'yes'">
   <xsl:attribute name="compact">compact</xsl:attribute><!-- assumes that no compaction is default -->
  </xsl:if>
</xsl:template>

<!-- Process the scale attribute - disable for now E002923 -->
<xsl:template name="setscale">
  <xsl:if test="@scale">
<!--    <xsl:attribute name="style">font-size: <xsl:value-of select="@scale"/>%;</xsl:attribute> -->
  </xsl:if>
</xsl:template>



<!-- ===================================================================== -->
<!-- ========== GENERAL SUPPORT/DOC CONTENT MANAGEMENT          ========== -->
<!-- ===================================================================== -->

<!-- [27] =========== CATCH UNDEFINED ELEMENTS (for stylesheet maintainers) =========== -->

<!-- (this rule should NOT produce output in production setting) -->
<xsl:template match="*">
  <span style="background-color: yellow;">
    <span style="font-weight: bold">
      <xsl:text>[</xsl:text>
      <xsl:for-each select="ancestor-or-self::*">
       <xsl:text>/</xsl:text>
       <xsl:value-of select="name()" />
     </xsl:for-each>
     {"<xsl:value-of select="@class"/>"}<xsl:text>) </xsl:text>
    </span>
    <xsl:apply-templates/>
    <span style="font-weight: bold">
      <xsl:text> (</xsl:text><xsl:value-of select="name()"/><xsl:text>]</xsl:text>
    </span>
  </span>
</xsl:template>


<!-- [28] =========== CONREF (content fetched by id from conrefed element) =========== -->
<!-- conref processing is now done in the first stage & conref.xsl -->


<!-- [29] ========== JAVASCRIPT SUPPORT ========== -->

<xsl:template name="script-sample">
<script language="JavaScript">
<xsl:comment>
  // define JavaScript within here; use CDATA sections as appropriate
  self.focus();
  function popwin(popupitem)
  {
         var PopUpWin=window.open(popupitem,"PopUpWin","toolbar=no,directories=no,menubar=no,status=no,scrollbars=yes,resizable=yes,width=500,height=200");
         PopUpWin.focus();
  }
//</xsl:comment>
</script>
</xsl:template>



<!-- [30] ========= NAMED TEMPLATES (call by name, only) ========== -->
<!-- named templates that can be used anywhere -->

<!-- Process spectitle attribute - if one exists - needs to be called on tags that allow it -->
<xsl:template name="spec-title">
 <xsl:if test="@spectitle"><div style="margin-top: 1em;"><b><xsl:value-of select="@spectitle"/></b></div></xsl:if>
</xsl:template>
<xsl:template name="spec-title-nospace">
 <xsl:if test="@spectitle"><div style="margin-bottom: 0;"><b><xsl:value-of select="@spectitle"/></b></div></xsl:if>
</xsl:template>

<xsl:template name="spec-title-cell">  <!-- not used - was a cell 'title' -->
 <xsl:if test="@specentry"><xsl:value-of select="@specentry"/><xsl:text> </xsl:text></xsl:if>
</xsl:template>


<!-- IBM Copyright - English only output -->
<xsl:template name="ibmcopyright">
 <xsl:variable name="entest">
  <xsl:call-template name="English-test"/>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$entest='en-us'">
   <xsl:comment> All rights reserved. Licensed Materials Property of IBM </xsl:comment><xsl:value-of select="$newline"/>
   <xsl:comment> US Government Users Restricted Rights </xsl:comment><xsl:value-of select="$newline"/>
   <xsl:comment> Use, duplication or disclosure restricted by </xsl:comment><xsl:value-of select="$newline"/>
   <xsl:comment> GSA ADP Schedule Contract with IBM Corp. </xsl:comment><xsl:value-of select="$newline"/>
  </xsl:when>
  <xsl:otherwise/>
 </xsl:choose>
</xsl:template>

<!-- Break replace - used for LINES -->
<!-- this replaces newlines with the BR element. Forces breaks. -->
<xsl:template name="br-replace">
  <xsl:param name="brtext"/>
<!--<xsl:text>brtext[</xsl:text><xsl:value-of select="$brtext"/><xsl:text>]</xsl:text>-->
<!-- capture an actual newline within the xsl:text element -->
  <xsl:variable name="cr"><xsl:text>
</xsl:text></xsl:variable>
  <xsl:choose>
    <xsl:when test="contains($brtext,$cr)"> <!-- is there a CR within the text? -->
       <xsl:value-of select="substring-before($brtext,$cr)"/> <!-- yes - substring & add the BR & newline -->
<br/><xsl:value-of select="$cr"/>
       <xsl:call-template name="br-replace"> <!-- call again to get remaining CRs -->
         <xsl:with-param name="brtext" select="substring-after($brtext,$cr)"/>
       </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$brtext"/> <!-- No CRs, just output -->
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Space replace - used for LINES -->
<!-- add checks for repeating leading blanks & converts them to &nbsp;&nbsp; -->
<!-- this replaces newlines with the BR element. Forces breaks. -->
<xsl:template name="sp-replace">
  <xsl:param name="sptext"/>
<!-- <xsl:text>sptext[</xsl:text><xsl:value-of select="$sptext"/><xsl:text>]</xsl:text> -->
<!-- capture 2 spaces -->
  <xsl:choose>
    <xsl:when test="contains($sptext,'  ')"> <!-- are there dual spaces within the text? -->
       <xsl:value-of select="substring-before($sptext,'  ')"/> <!-- yes - substring & add the &nbsp -->
       <xsl:text disable-output-escaping="yes">&nbsp;&nbsp;</xsl:text>
       <xsl:call-template name="sp-replace"> <!-- call again to get remaining spaces -->
         <xsl:with-param name="sptext" select="substring-after($sptext,'  ')"/>
       </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$sptext"/> <!-- No spaces, just output -->
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- diagnostic: call this to generate a path-like view of an element's ancestry -->
<xsl:template name="breadcrumbs">
<xsl:variable name="full-path">
  <xsl:for-each select="ancestor-or-self::*">
    <xsl:value-of select="concat('/',name())"/>
  </xsl:for-each>
</xsl:variable>
<p><b><xsl:value-of select="$full-path"/></b></p>
</xsl:template>


<!-- the following named templates generate inline content for the delivery context -->

<!-- named templates for labels and titles related to topic structures -->

<!-- test processors for HTML title element -->
<xsl:template match="*" mode="text-only">
  <xsl:apply-templates select="text()|*" mode="text-only"/>
</xsl:template>
<!-- for artwork in a title, get the alt text -->
<xsl:template match="*[contains(@class,' topic/image ')]" mode="text-only">
  <xsl:choose>
    <xsl:when test="*[contains(@class,' topic/alt ')]"><xsl:apply-templates mode="text-only"/></xsl:when>
    <xsl:when test="@alt"><xsl:value-of select="@alt"/></xsl:when>
  </xsl:choose>
</xsl:template>
<!-- for boolean in a title, set the text -->
<xsl:template match="*[contains(@class,' topic/boolean ')]" mode="text-only">
  <xsl:value-of select="name()"/><xsl:text>: </xsl:text><xsl:value-of select="@state"/>
</xsl:template>
<!-- for state in a title, set the text -->
<xsl:template match="*[contains(@class,' topic/state ')]" mode="text-only">
  <xsl:value-of select="name()"/><xsl:text>: </xsl:text><xsl:value-of select="@name"/><xsl:text>=</xsl:text><xsl:value-of select="@value"/>
</xsl:template>
<!-- Footnote as text-only should just create the number -->
<xsl:template match="*[contains(@class,' topic/fn ')]" mode="text-only">
  <xsl:variable name="fnid"><xsl:number from="/" level="any"/></xsl:variable>
  <xsl:choose>
    <xsl:when test="@callout">(<xsl:value-of select="@callout"/>)</xsl:when>
    <xsl:otherwise>(<xsl:value-of select="$fnid"/>)</xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- P016895 -->
<xsl:template match="*[contains(@class, ' ui-d/menucascade ')]" mode="text-only">
  <xsl:apply-templates select="*" mode="text-only"/>
</xsl:template>

<xsl:template match="*[contains(@class, ' ui-d/uicontrol ')]" mode="text-only">
  <xsl:if test="parent::*[contains(@class,' ui-d/menucascade ')] and preceding-sibling::*[contains(@class, ' ui-d/uicontrol ')]">
    <xsl:text> > </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="*|text()" mode="text-only"/>
</xsl:template>

<!-- get a section's heading - for PTOC things. Use 1) title element 2) @spectitle attr -->
<xsl:template name="get-sect-heading">
   <xsl:choose>
    <xsl:when test="*[contains(@class,' topic/title ')]">
      <xsl:apply-templates select="*[contains(@class,' topic/title ')]"/>
    </xsl:when>
    <xsl:when test="@spectitle">
      <xsl:value-of select="@spectitle"/>
    </xsl:when>
    <xsl:otherwise/>
   </xsl:choose>
</xsl:template>

<!-- Process a section heading - H4 based on: 1) title element 2) @spectitle attr -->
<xsl:template name="sect-heading">
  <xsl:param name="deftitle"/> <!-- get param by reference -->
  <xsl:variable name="heading">
     <xsl:choose>
      <xsl:when test="*[contains(@class,' topic/title ')]">
        <xsl:apply-templates select="*[contains(@class,' topic/title ')][1]" mode="text-only"/>
        <xsl:if test="*[contains(@class,' topic/title ')][2]">
         <xsl:call-template name="output-message">
           <xsl:with-param name="msg">More than one title element in a section. Using the first one for the section's title.</xsl:with-param>
           <xsl:with-param name="msgnum">007</xsl:with-param>
           <xsl:with-param name="msgsev">W</xsl:with-param>
         </xsl:call-template>
      </xsl:if>
      </xsl:when>
      <xsl:when test="@spectitle">
        <xsl:value-of select="@spectitle"/>
      </xsl:when>
      <xsl:otherwise/>
     </xsl:choose>
  </xsl:variable>

  <!-- based on graceful defaults, build an appropriate section-level heading -->
  <xsl:choose>
    <xsl:when test="not($heading='')">
      <xsl:if test="normalize-space($heading)=''">
        <!-- hack: a title with whitespace ALWAYS overrides as null -->
        <xsl:comment>no heading</xsl:comment>
      </xsl:if>
      <h4 class="sectiontitle">
       <!-- if there's an output class on the section's title - add that class to the 'p' for the section heading -->
       <xsl:if test="*[contains(@class,' topic/title ')]/@outputclass">
        <xsl:attribute name="class"><xsl:value-of select="*[contains(@class,' topic/title ')]/@outputclass"/></xsl:attribute>
       </xsl:if>
       <xsl:call-template name="proc-ing"/>
       <xsl:choose>
           <xsl:when test="*[contains(@class,' topic/title ')]">
               <xsl:apply-templates select="*[contains(@class,' topic/title ')][1]" mode="output-section-title"/>
           </xsl:when>
           <xsl:otherwise><xsl:value-of select="@spectitle"/></xsl:otherwise>
       </xsl:choose>
      </h4>
    </xsl:when>
    <xsl:when test="$deftitle">
      <h4 class="sectiontitle"><xsl:value-of select="$deftitle"/></h4>
    </xsl:when>
    <xsl:otherwise><!--<br/>--><!-- no heading title, output section starting with a break --></xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- P017732: previously used text-only for section titles, which dropped images -->
<xsl:template match="*[contains(@class,' topic/title ')]" mode="output-section-title">
    <xsl:apply-templates/>
</xsl:template>

<!-- Convert the input value to lowercase & return it -->
<xsl:template name="convert-to-lower">
 <xsl:param name="inputval"/>
 <xsl:value-of select="translate($inputval,
                                  '-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
                                  '-abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz')"/>
</xsl:template>

<!-- Test for in US English: returns "en-us" when child's @xml:lang is English or not specified;
     Otherwise, leave blank -->
<xsl:template name="English-test">
 <xsl:variable name="childlangUpper">  <!-- the child's xml:lang value (use en-us if none found) -->
  <xsl:choose>
   <xsl:when test="descendant-or-self::*/@xml:lang">
     <xsl:value-of select="descendant-or-self::*/@xml:lang"/>
   </xsl:when>
   <xsl:otherwise>en-us</xsl:otherwise>
  </xsl:choose>
 </xsl:variable>
 <xsl:variable name="childlang">
  <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
   <xsl:with-param name="inputval" select="$childlangUpper"/>
  </xsl:call-template>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$childlang='en-us' or $childlang='en'">en-us</xsl:when>
  <xsl:otherwise/>
 </xsl:choose>
</xsl:template>

<!-- Test for in BIDI area: returns "bidi" when parent's @xml:lang is a bidi language;
     Otherwise, leave blank -->
<xsl:template name="bidi-area">
 <xsl:variable name="parentlangUpper">  <!-- the parent's xml:lang value (use en-us if none found) -->
  <xsl:choose>
   <xsl:when test="ancestor-or-self::*/@xml:lang">
     <xsl:value-of select="ancestor-or-self::*/@xml:lang"/>
   </xsl:when>
   <xsl:otherwise/>
  </xsl:choose>
 </xsl:variable>
 <xsl:variable name="parentlang">
  <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
   <xsl:with-param name="inputval" select="$parentlangUpper"/>
  </xsl:call-template>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$parentlang='ar-eg' or $parentlang='ar'">bidi</xsl:when>
  <xsl:when test="$parentlang='he' or $parentlang='he-il'">bidi</xsl:when>
  <xsl:otherwise/>
 </xsl:choose>
</xsl:template>

<!-- Test for URL: returns "url" when the content starts with a URL;
     Otherwise, leave blank -->
<xsl:template name="url-string">
 <xsl:param name="urltext"/>
<!-- <xsl:message><xsl:value-of select="$urltext"/></xsl:message> -->
 <xsl:choose>
  <xsl:when test="contains($urltext,'http://')">url</xsl:when>
  <xsl:when test="contains($urltext,'https://')">url</xsl:when>
  <xsl:otherwise/>
 </xsl:choose>
</xsl:template>

<!-- For header file processing, pull out the wrapping DIV if one is there -->
<xsl:template match="/div" mode="add-HDF">
  <xsl:apply-templates select="*|comment()|processing-instruction()|text()" mode="add-HDF"/>
</xsl:template>

<xsl:template match="*|@*|comment()|processing-instruction()|text()" mode="add-HDF">
  <xsl:copy>
    <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()" mode="add-HDF"/>
  </xsl:copy>
</xsl:template>

<!-- [31] ========== Section-like generated content =========== -->

<!-- render any contained footnotes as endnotes.  Links back to reference point -->
<!-- RDA: moved from for-each into a template with a mode. Easier to keep out
     specialized footnotes, if you do not want them in the end list. -->
<xsl:template name="gen-endnotes">
  <!-- Skip any footnotes that are in draft elements when draft = no -->
  <xsl:apply-templates select="//*[contains(@class,' topic/fn ')][not( (ancestor::*[contains(@class,' topic/draft-comment ')] or ancestor::*[contains(@class,' topic/required-cleanup ')]) and $DRAFT='no')]" mode="genEndnote"/>

</xsl:template>

<!-- Catch footnotes that should appear at the end of the topic, and output them. -->
<xsl:template match="*[contains(@class,' topic/fn ')]" mode="genEndnote">
  <div class="p">
    <xsl:variable name="fnid"><xsl:number from="/" level="any"/></xsl:variable>
    <xsl:variable name="callout"><xsl:value-of select="@callout"/></xsl:variable>
    <xsl:variable name="convergedcallout">
      <xsl:choose>
        <xsl:when test="string-length($callout)>'0'"><xsl:value-of select="$callout"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$fnid"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <a>
     <xsl:choose>
      <xsl:when test="@id">
       <xsl:call-template name="setid"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:attribute name="name"><xsl:text>fntarg_</xsl:text><xsl:value-of select="$fnid"/></xsl:attribute>
       <xsl:attribute name="href"><xsl:text>#fnsrc_</xsl:text><xsl:value-of select="$fnid"/></xsl:attribute>
      </xsl:otherwise>
     </xsl:choose>
     <sup><xsl:value-of select="$convergedcallout"/></sup>
    </a><xsl:text>  </xsl:text>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag"/>
    <xsl:apply-templates/>
    <xsl:call-template name="end-revflag"/>
  </div>
</xsl:template>

<!-- listing of topics from calling context only; can be expanded for nesting -->
<xsl:template name="gen-toc">
  <div>
  <h3 class="sectiontitle">
    <!--xsl:value-of select="$deftxt-toc"/-->
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Contents'"/>
      </xsl:call-template>
  </h3>
   <ul>
    <xsl:for-each select="//topic/title">
     <li>
<!-- this directive provides a "depth" indicator without doing recursive nesting -->
<xsl:value-of select="substring('------',1,count(ancestor::*))"/>
     <a>
       <xsl:attribute name="href">#<xsl:value-of select="generate-id()"/></xsl:attribute>
       <xsl:value-of select="."/>
     </a>
     <!--recursive call for subtopics here"/-->
     </li>
    </xsl:for-each>
   </ul>
  </div>
</xsl:template>


<!-- listing of immediate child topics; can be expanded for nesting -->
<!-- unused - comment out
<xsl:template name="gen-ptoc">
<xsl:if test="*[contains(@class,' topic/topic ')]">
  <div>
  <h3 class="sectiontitle">
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Local topics'"/>
      </xsl:call-template><xsl:text>: </xsl:text>
  </h3>
   <ol>
    <xsl:for-each select="*[contains(@class,' topic/topic ')]">
     <li><a>
       <xsl:attribute name="href">#<xsl:value-of select="generate-id()"/></xsl:attribute>
       <xsl:value-of select="title"/>
     </a>
     </li>
    </xsl:for-each>
   </ol>
  </div>
</xsl:if>
</xsl:template>
-->

<!-- unused - comment out
<xsl:template name="gen-sect-ptoc">
  <xsl:if test="section">
  <div>
  <h3>Sections in this topic:</h3>
    <ol>
    <xsl:for-each select="section">
     <li><xsl:call-template name="get-sect-heading"/></li>
    </xsl:for-each>
    </ol>
  <hr />
  </div>
  </xsl:if>
</xsl:template>
-->



<!-- ===================================================================== -->

<!-- [32] ========== Language support  ========== -->

<xsl:template name="getString">
  <xsl:param name="stringName"/>

  <xsl:variable name="ancestorlangUpper">  <!-- the current xml:lang value (en-us if none found) -->
    <xsl:choose>
      <xsl:when test="ancestor-or-self::*/@xml:lang">
        <xsl:value-of select="ancestor-or-self::*[@xml:lang][1]/@xml:lang"/>
      </xsl:when>
      <xsl:otherwise>en-us</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="ancestorlang">
   <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
    <xsl:with-param name="inputval" select="$ancestorlangUpper"/>
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="validlang"> <!-- ensure the language is valid; if not, use en-us -->
    <xsl:choose>                   <!-- 5-characters "xx-xx"; use as is -->
      <xsl:when test="string-length($ancestorlang)=5 and
                      (contains($ancestorlang,'en-us') or contains($ancestorlang,'ar-eg') or contains($ancestorlang,'nl-be') or
                       contains($ancestorlang,'fr-be') or contains($ancestorlang,'pt-br') or contains($ancestorlang,'bg-bg') or
                       contains($ancestorlang,'ca-es') or contains($ancestorlang,'en-ca') or contains($ancestorlang,'fr-ca') or
                       contains($ancestorlang,'hr-hr') or contains($ancestorlang,'cs-cz') or contains($ancestorlang,'da-dk') or
                       contains($ancestorlang,'nl-nl') or contains($ancestorlang,'en-us') or contains($ancestorlang,'et-ee') or
                       contains($ancestorlang,'fi-fi') or contains($ancestorlang,'fr-fr') or contains($ancestorlang,'de-de') or
                       contains($ancestorlang,'el-gr') or contains($ancestorlang,'he-il') or contains($ancestorlang,'hu-hu') or
                       contains($ancestorlang,'is-is') or contains($ancestorlang,'it-it') or contains($ancestorlang,'ja-jp') or
                       contains($ancestorlang,'ko-kr') or contains($ancestorlang,'lv-lv') or contains($ancestorlang,'lt-lt') or
                       contains($ancestorlang,'mk-mk') or contains($ancestorlang,'no-no') or contains($ancestorlang,'pl-pl') or
                       contains($ancestorlang,'pt-pt') or contains($ancestorlang,'ro-ro') or contains($ancestorlang,'ru-ru') or
                       contains($ancestorlang,'zh-cn') or contains($ancestorlang,'sr-sp') or contains($ancestorlang,'fr-ch') or
                       contains($ancestorlang,'de-ch') or contains($ancestorlang,'it-ch') or contains($ancestorlang,'sk-sk') or
                       contains($ancestorlang,'sl-si') or contains($ancestorlang,'es-es') or contains($ancestorlang,'sv-se') or
                       contains($ancestorlang,'zh-tw') or contains($ancestorlang,'th-th') or contains($ancestorlang,'tr-tr') or
                       contains($ancestorlang,'en-gb') or contains($ancestorlang,'be-by') or contains($ancestorlang,'uk-ua') )">
        <xsl:value-of select="$ancestorlang"/>
      </xsl:when>
           <!-- 2-characters "xx"; use "xx-xx"  -->
      <xsl:when test="string-length($ancestorlang)=2">
        <xsl:choose>
          <xsl:when test="contains($ancestorlang,'bg') or contains($ancestorlang,'hr') or contains($ancestorlang,'nl') or
                          contains($ancestorlang,'fi') or contains($ancestorlang,'fr') or contains($ancestorlang,'de') or
                          contains($ancestorlang,'hu') or contains($ancestorlang,'is') or contains($ancestorlang,'it') or
                          contains($ancestorlang,'lv') or contains($ancestorlang,'lt') or contains($ancestorlang,'mk') or
                          contains($ancestorlang,'no') or contains($ancestorlang,'pl') or contains($ancestorlang,'pt') or
                          contains($ancestorlang,'ro') or contains($ancestorlang,'ru') or contains($ancestorlang,'sk') or
                          contains($ancestorlang,'es') or contains($ancestorlang,'th') or contains($ancestorlang,'tr')">
            <xsl:value-of select="$ancestorlang"/><xsl:text>-</xsl:text><xsl:value-of select="$ancestorlang"/>
          </xsl:when>
             <!-- special 2-char cases for "xx-xx"  -->
          <xsl:when test="contains($ancestorlang,'bg')">bg-bg</xsl:when>
          <xsl:when test="contains($ancestorlang,'en')">en-us</xsl:when>
          <xsl:when test="contains($ancestorlang,'ar')">ar-eg</xsl:when>
          <xsl:when test="contains($ancestorlang,'ca')">ca-es</xsl:when>
          <xsl:when test="contains($ancestorlang,'cs')">cs-cz</xsl:when>
          <xsl:when test="contains($ancestorlang,'da')">da-dk</xsl:when>
          <xsl:when test="contains($ancestorlang,'et')">et-ee</xsl:when>
          <xsl:when test="contains($ancestorlang,'el')">el-gr</xsl:when>
          <xsl:when test="contains($ancestorlang,'he')">he-il</xsl:when>
          <xsl:when test="contains($ancestorlang,'ja')">ja-jp</xsl:when>
          <xsl:when test="contains($ancestorlang,'ko')">ko-kr</xsl:when>
          <xsl:when test="contains($ancestorlang,'zh')">zh-cn</xsl:when>
          <xsl:when test="contains($ancestorlang,'sr')">sr-sp</xsl:when>
          <xsl:when test="contains($ancestorlang,'sl')">sl-si</xsl:when>
          <xsl:when test="contains($ancestorlang,'sv')">sv-se</xsl:when>
          <xsl:when test="contains($ancestorlang,'be')">be-by</xsl:when>
          <xsl:when test="contains($ancestorlang,'uk')">uk-ua</xsl:when>
          <xsl:otherwise>en-us<xsl:call-template name="output-message">
          <!-- message about unrecognized 2 char language -->
            <xsl:with-param name="msg">Language '<xsl:value-of select="$ancestorlang"/>' unknown. Using English.</xsl:with-param>
            <xsl:with-param name="msgnum">011</xsl:with-param>
            <xsl:with-param name="msgsev">W</xsl:with-param>
          </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>en-us<xsl:call-template name="output-message">
         <!-- message about unrecognized language -->
          <xsl:with-param name="msg">Language '<xsl:value-of select="$ancestorlang"/>' unknown. Using English.</xsl:with-param>
          <xsl:with-param name="msgnum">011</xsl:with-param>
          <xsl:with-param name="msgsev">W</xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Determine the string file based on the language, and get the string -->
  <xsl:variable name="stringFileName">strings-<xsl:value-of select="$validlang"/>.xml</xsl:variable>
  <xsl:variable name="str" select="document($stringFileName)/strings/str[@name=$stringName]"/>
  <xsl:if test="$DBG='yes'">
   <xsl:call-template name="output-message">
    <xsl:with-param name="msg">Get-string trace: </xsl:with-param>
    <xsl:with-param name="msgnum">000</xsl:with-param>
    <xsl:with-param name="msgsev">I</xsl:with-param>
   </xsl:call-template>
   <xsl:message>Original language is <xsl:value-of select="$ancestorlangUpper"/></xsl:message>
   <xsl:message>Lowercase language is <xsl:value-of select="$ancestorlang"/></xsl:message>
   <xsl:message>Valid language is <xsl:value-of select="$validlang"/></xsl:message>
   <xsl:message>String file name is <xsl:value-of select="$stringFileName"/></xsl:message>
   <xsl:message>Searching for string <xsl:value-of select="$stringName"/></xsl:message>
   <xsl:message>Found string <xsl:value-of select="$str"/></xsl:message>
  </xsl:if>
  <xsl:choose>
    <xsl:when test="string-length($str)>0">
      <xsl:value-of select="$str"/>
    </xsl:when>
    <xsl:otherwise>
      <!-- try to get the English version -->
      <xsl:variable name="stringFileNameEN">strings-en-us.xml</xsl:variable>
      <xsl:variable name="strEN" select="document($stringFileNameEN)/strings/str[@name=$stringName]"/>
      <xsl:choose>
       <xsl:when test="string-length($strEN)>0">
        <xsl:value-of select="$strEN"/>
        <xsl:call-template name="output-message">
         <xsl:with-param name="msg">No string named '<xsl:value-of select="$stringName"/>' was found. Using English equivalent.</xsl:with-param>
         <xsl:with-param name="msgnum">008</xsl:with-param>
         <xsl:with-param name="msgsev">W</xsl:with-param>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="$stringName"/>
        <xsl:call-template name="output-message">
         <xsl:with-param name="msg">No string named '<xsl:value-of select="$stringName"/>' was found. Using original value.</xsl:with-param>
         <xsl:with-param name="msgnum">008</xsl:with-param>
         <xsl:with-param name="msgsev">W</xsl:with-param>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>



<!-- [33] ========== Flagging with flags & revisions ========== -->

<!-- Flags - based on audience, product, platform, and otherprops in the source
               AND prop elements in the val file:
             Flag the text with the artwork from the val file & insert the ALT text from the val file.
             For multiple attr values, output each flag in turn.
     -->
<xsl:template name="flagit">
 <!-- Test for the flagging attributes. If found, call 'mark-prop' with the values to use. Otherwise return -->
 <xsl:if test="@audience and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'audience'"/>
   <xsl:with-param name="flag-att-val" select="@audience"/>
  </xsl:call-template>
 </xsl:if>
 <xsl:if test="@platform and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'platform'"/>
   <xsl:with-param name="flag-att-val" select="@platform"/>
  </xsl:call-template>
 </xsl:if>
 <xsl:if test="@product and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'product'"/>
   <xsl:with-param name="flag-att-val" select="@product"/>
  </xsl:call-template>
 </xsl:if>
 <xsl:if test="@otherprops and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'otherprops'"/>
   <xsl:with-param name="flag-att-val" select="@otherprops"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- No flagging attrs allowed to process in phrases - output a message when in debug mode. -->
<xsl:template name="flagcheck">
 <xsl:if test="$DBG='yes' and not($FILTERFILE='')">
  <xsl:if test="@audience">
   <xsl:call-template name="output-message">
    <xsl:with-param name="msg">Flagging attribute found on audience attribute. Inline phrases cannot be flagged.</xsl:with-param>
    <xsl:with-param name="msgnum">058</xsl:with-param>
    <xsl:with-param name="msgsev">I</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="@platform">
   <xsl:call-template name="output-message">
    <xsl:with-param name="msg">Flagging attribute found on platform attribute. Inline phrases cannot be flagged.</xsl:with-param>
    <xsl:with-param name="msgnum">058</xsl:with-param>
    <xsl:with-param name="msgsev">I</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="@product">
   <xsl:call-template name="output-message">
    <xsl:with-param name="msg">Flagging attribute found on product attribute. Inline phrases cannot be flagged.</xsl:with-param>
    <xsl:with-param name="msgnum">058</xsl:with-param>
    <xsl:with-param name="msgsev">I</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="@otherprops">
   <xsl:call-template name="output-message">
    <xsl:with-param name="msg">Flagging attribute found on otherprops attribute. Inline phrases cannot be flagged.</xsl:with-param>
    <xsl:with-param name="msgnum">058</xsl:with-param>
    <xsl:with-param name="msgsev">I</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:if>
</xsl:template>

<xsl:template name="flagit-parent">
 <!-- Test for the flagging attributes on the parent.
   If found and if the filterfile name was passed in,
      call 'mark-prop' with the values to use. Otherwise return -->
 <xsl:if test="../@audience and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'audience'"/>
   <xsl:with-param name="flag-att-val" select="../@audience"/>
  </xsl:call-template>
 </xsl:if>
 <xsl:if test="../@platform and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'platform'"/>
   <xsl:with-param name="flag-att-val" select="../@platform"/>
  </xsl:call-template>
 </xsl:if>
 <xsl:if test="../@product and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'product'"/>
   <xsl:with-param name="flag-att-val" select="../@product"/>
  </xsl:call-template>
 </xsl:if>
 <xsl:if test="../@otherprops and not($FILTERFILE='')">
  <xsl:call-template name="mark-prop">
   <xsl:with-param name="flag-att" select="'otherprops'"/>
   <xsl:with-param name="flag-att-val" select="../@otherprops"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Use passed attr value to mark each active flag. -->
<xsl:template name="mark-prop">
 <xsl:param name="flag-att"/>     <!-- attribute name -->
 <xsl:param name="flag-att-val"/> <!-- content of attribute -->
<!--<xsl:value-of select="$flag-att"/>=<xsl:value-of select="$flag-att-val"/>-->

  <!-- Determine the first flag value, which is the value before the first space -->
  <xsl:variable name="firstflag">
   <xsl:choose>
    <xsl:when test="contains($flag-att-val,' ')">
     <xsl:value-of select="substring-before($flag-att-val,' ')"/>
    </xsl:when>
    <xsl:otherwise> <!-- no space, one value -->
     <xsl:value-of select="$flag-att-val"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Determine the other flag values, after the first space -->
  <xsl:variable name="moreflags">
   <xsl:choose>
    <xsl:when test="contains($flag-att-val,' ')">
     <xsl:value-of select="substring-after($flag-att-val,' ')"/>
    </xsl:when>
    <xsl:otherwise/> <!-- no space, one value -->
   </xsl:choose>
  </xsl:variable>

  <!-- Is the flag active? -->
  <xsl:choose> <!-- Ensure there's an image to get, otherwise don't insert anything -->
   <xsl:when test="document(concat($WORKDIR,$PATH2PROJ,$FILTERFILE))/val/prop[@att=$flag-att][@val=$firstflag][@action='flag'][@img]">
    <!-- yes, output the flag -->
    <img>
     <xsl:attribute name="src">
      <xsl:if test="string-length($PATH2PROJ) > 0"><xsl:value-of select="$PATH2PROJ"/></xsl:if>
      <xsl:value-of select="document(concat($WORKDIR,$PATH2PROJ,$FILTERFILE))/val/prop[@att=$flag-att][@val=$firstflag][@action='flag']/@img"/>
     </xsl:attribute>
     <xsl:attribute name="alt"> <!-- always insert an ALT - if it's blank, assume the user didn't want to fill it. -->
      <xsl:value-of select="document(concat($WORKDIR,$PATH2PROJ,$FILTERFILE))/val/prop[@att=$flag-att][@val=$firstflag][@action='flag']/@alt"/>
     </xsl:attribute>
    </img>
   </xsl:when>
   <xsl:otherwise/> <!-- that flag not active -->
  </xsl:choose>

  <!-- keep testing other values -->
  <xsl:choose>
   <xsl:when test="string-length($moreflags)>0">
    <!-- more values - call it again with remaining values -->
    <xsl:call-template name="mark-prop">
     <xsl:with-param name="flag-att"><xsl:value-of select="$flag-att"/></xsl:with-param>
     <xsl:with-param name="flag-att-val"><xsl:value-of select="$moreflags"/></xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise/> <!-- no more values -->
  </xsl:choose>

</xsl:template>


<!-- Revisions - based on rev attr in source and
                 if the filterfile name was passed in, and
                 based on the revprop in val file:
                 * color the text based on the 1st style found.
                 * flag the text with the delta gifs & alt text for the first flag found.
     -->
<!-- Test for rev attr, otherwise apply templates & quick return -->
<!-- Output starting flag only -->
<xsl:template name="start-revflag">
 <xsl:if test="@rev and not($FILTERFILE='')">
  <xsl:call-template name="start-mark-rev">
   <xsl:with-param name="revvalue" select="@rev"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Output ending flag only -->
<xsl:template name="end-revflag">
 <xsl:if test="@rev and not($FILTERFILE='')">
  <xsl:call-template name="end-mark-rev">
   <xsl:with-param name="revvalue" select="@rev"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- for table entries - if the parent (row) has a rev but the cell does not - output the rev -->
<xsl:template name="start-revflag-parent">
 <xsl:if test="../@rev and not(@rev) and not($FILTERFILE='')">
  <xsl:call-template name="start-mark-rev">
   <xsl:with-param name="revvalue" select="../@rev"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>
<xsl:template name="end-revflag-parent">
 <xsl:if test="../@rev and not(@rev) and not($FILTERFILE='')">
  <xsl:call-template name="end-mark-rev">
   <xsl:with-param name="revvalue" select="../@rev"/>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Output starting & ending flag for "blocked" text.
     Use instead of 'apply-templates' for block areas (P, Note, DD, etc) -->
<xsl:template name="revblock">
 <xsl:choose>
  <xsl:when test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- draft rev mode, add div w/ rev attr value -->
    <xsl:variable name="revtest"> <!-- Flag the revision? 1=yes; 0=no -->
     <xsl:call-template name="find-active-rev-flag">
      <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$revtest=1">
      <div class="{@rev}">
      <xsl:call-template name="start-mark-rev">
       <xsl:with-param name="revvalue" select="@rev"/>
      </xsl:call-template>
      <xsl:apply-templates/>
      <xsl:call-template name="end-mark-rev">
       <xsl:with-param name="revvalue" select="@rev"/>
      </xsl:call-template>
      </div>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="start-mark-rev">
       <xsl:with-param name="revvalue" select="@rev"/>
      </xsl:call-template>
      <xsl:apply-templates/>
      <xsl:call-template name="end-mark-rev">
       <xsl:with-param name="revvalue" select="@rev"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
  </xsl:when>
  <xsl:when test="@rev and not($FILTERFILE='')">    <!-- normal rev mode -->
   <xsl:call-template name="start-mark-rev">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
   <xsl:apply-templates/>
   <xsl:call-template name="end-mark-rev">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>  <!-- no rev mode -->
 </xsl:choose>
</xsl:template>

<!-- Output starting & ending flag & color for phrase text.
     Use instead of 'apply-templates' for phrase areas (PH, B, DT, etc) -->
<xsl:template name="revtext">
 <xsl:variable name="revtest">
   <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
     <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
       <xsl:with-param name="allrevs" select="@rev"/>
     </xsl:call-template>
   </xsl:if>
 </xsl:variable>
<xsl:choose>
  <xsl:when test="$revtest=1">   <!-- Rev is active - add the SPAN -->
   <span class="{@rev}">
   <xsl:call-template name="start-mark-rev">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
   <xsl:call-template name="revstyle">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
   <xsl:call-template name="end-mark-rev">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
   </span>
  </xsl:when>
  <xsl:when test="@rev and not($FILTERFILE='')">         <!-- normal rev mode -->
   <xsl:call-template name="start-mark-rev">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
   <xsl:call-template name="revstyle">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
   <xsl:call-template name="end-mark-rev">
    <xsl:with-param name="revvalue" select="@rev"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>  <!-- no rev mode -->
 </xsl:choose>
</xsl:template>

<!-- There's a rev attr - test for active rev values -->
<xsl:template name="start-mark-rev">
 <xsl:param name="revvalue"/>
 <!-- flag it? 1=yes; 0=no -->
 <xsl:variable name="revtest">
  <xsl:call-template name="find-active-rev-flag">
   <xsl:with-param name="allrevs" select="$revvalue"/>
  </xsl:call-template>
 </xsl:variable>
  <xsl:if test="$revtest=1">
   <xsl:call-template name="start-revision-flag"/>
  </xsl:if>
</xsl:template>

<!-- There's a rev attr - test for active rev values -->
<xsl:template name="end-mark-rev">
 <xsl:param name="revvalue"/>
 <!-- flag it? 1=yes; 0=no -->
 <xsl:variable name="revtest">
  <xsl:call-template name="find-active-rev-flag">
   <xsl:with-param name="allrevs" select="$revvalue"/>
  </xsl:call-template>
 </xsl:variable>
  <xsl:if test="$revtest=1">
   <xsl:call-template name="end-revision-flag"/>
  </xsl:if>
</xsl:template>

<!-- output the revision color & apply further templates-->
<xsl:template name="revstyle">
 <xsl:param name="revvalue"/>
 <xsl:variable name="revcolor">
  <xsl:call-template name="find-active-rev-style"> <!-- get 1st active rev color -->
   <xsl:with-param name="allrevs" select="$revvalue"/>
  </xsl:call-template>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="string-length($revcolor)>0"> <!-- if there's a value, there's an active color -->
   <font>
    <xsl:attribute name="color">
     <xsl:value-of select="$revcolor"/>
    </xsl:attribute>
    <xsl:apply-templates/>
   </font>
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates/> <!-- no active rev color - just apply templates -->
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- output the beginning revision graphic & ALT text -->
<!-- Reverse the artwork for BIDI languages -->
<xsl:template name="start-revision-flag">
 <xsl:variable name="biditest"> <!-- test for BIDI area -->
  <xsl:call-template name="bidi-area"/>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$biditest='bidi'">
   <xsl:call-template name="start-rev-art"> <!-- BIDI, use English end graphic for start of change-->
    <xsl:with-param name="deltaname" select="'deltaend.gif'"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:otherwise>
   <xsl:call-template name="start-rev-art"> <!-- Not BIDI, use English start graphic -->
    <xsl:with-param name="deltaname" select="'delta.gif'"/>
   </xsl:call-template>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- output the ending revision graphic & ALT text -->
<!-- Reverse the artwork for BIDI languages -->
<xsl:template name="end-revision-flag">
 <xsl:variable name="biditest">
  <xsl:call-template name="bidi-area"/>
 </xsl:variable>
 <xsl:choose>
  <xsl:when test="$biditest='bidi'">
   <xsl:call-template name="end-rev-art"> <!-- BIDI, use English start graphic for end of change-->
    <xsl:with-param name="deltaname" select="'delta.gif'"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:otherwise>
   <xsl:call-template name="end-rev-art"> <!-- Not BIDI, use English end graphic -->
    <xsl:with-param name="deltaname" select="'deltaend.gif'"/>
   </xsl:call-template>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- output the beginning revision graphic & ALT text -->
<xsl:template name="start-rev-art">
 <xsl:param name="deltaname"/>
  <img src="{$PATH2PROJ}{$deltaname}">
  <xsl:attribute name='alt'>
   <xsl:call-template name="getString">
    <xsl:with-param name="stringName" select="'Start of change'"/>
   </xsl:call-template>
  </xsl:attribute>
 </img>
</xsl:template>
<!-- output the ending revision graphic & ALT text -->
<xsl:template name="end-rev-art">
 <xsl:param name="deltaname"/>
 <img src="{$PATH2PROJ}{$deltaname}">
  <xsl:attribute name='alt'>
   <xsl:call-template name="getString">
    <xsl:with-param name="stringName" select="'End of change'"/>
   </xsl:call-template>
  </xsl:attribute>
 </img>
</xsl:template>

<!-- Use @rev to find the first active flagged revision.
     Return 1 for active.
     Return 0 for non-active. -->
<xsl:template name="find-active-rev-flag">
  <xsl:param name="allrevs"/>

  <!-- Determine the first rev value, which is the value before the first space -->
  <xsl:variable name="firstrev">
   <xsl:choose>
    <xsl:when test="contains($allrevs,' ')">
     <xsl:value-of select="substring-before($allrevs,' ')"/>
    </xsl:when>
    <xsl:otherwise> <!-- no space, one value -->
     <xsl:value-of select="$allrevs"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Determine the other rev value, after the first space -->
  <xsl:variable name="morerevs">
   <xsl:choose>
    <xsl:when test="contains($allrevs,' ')">
     <xsl:value-of select="substring-after($allrevs,' ')"/>
    </xsl:when>
    <xsl:otherwise/> <!-- no space, one value -->
   </xsl:choose>
  </xsl:variable>

  <xsl:choose>
  <!-- Is first rev active? -->
   <xsl:when test="document(concat($WORKDIR,$PATH2PROJ,$FILTERFILE))/val/revprop[@val=$firstrev][@action='flag']">
     <xsl:value-of select="1"/> <!-- yes -->
   </xsl:when>
   <xsl:otherwise>              <!-- nope -->

    <!-- keep testing other values -->
    <xsl:choose>
     <xsl:when test="string-length($morerevs)>0">
      <!-- more values - call it again with remaining values -->
      <xsl:call-template name="find-active-rev-flag">
       <xsl:with-param name="allrevs"><xsl:value-of select="$morerevs"/></xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise> <!-- no more values - none found -->
      <xsl:value-of select="0"/>
     </xsl:otherwise>
    </xsl:choose>

   </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<!-- Use @rev to find the first active styled revision.
     Return color setting when active.
     Return null for non-active. -->
<xsl:template name="find-active-rev-style">
  <xsl:param name="allrevs"/>

  <!-- Determine the first rev value, which is the value before the first space -->
  <xsl:variable name="firstrev">
   <xsl:choose>
    <xsl:when test="contains($allrevs,' ')">
     <xsl:value-of select="substring-before($allrevs,' ')"/>
    </xsl:when>
    <xsl:otherwise> <!-- no space, one value -->
     <xsl:value-of select="$allrevs"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Determine the other rev value, after the first space -->
  <xsl:variable name="morerevs">
   <xsl:choose>
    <xsl:when test="contains($allrevs,' ')">
     <xsl:value-of select="substring-after($allrevs,' ')"/>
    </xsl:when>
    <xsl:otherwise/> <!-- no space, one value -->
   </xsl:choose>
  </xsl:variable>

  <xsl:choose>
  <!-- Is first rev active? -->
   <xsl:when test="document(concat($WORKDIR,$PATH2PROJ,$FILTERFILE))/val/revprop[@val=$firstrev]/@style">
     <!-- yes -->
     <xsl:value-of select="document(concat($WORKDIR,$PATH2PROJ,$FILTERFILE))/val/revprop[@val=$firstrev]/@style"/>
   </xsl:when>
   <xsl:otherwise>              <!-- nope -->

    <!-- keep testing other values -->
    <xsl:choose>
     <xsl:when test="string-length($morerevs)>0">
      <!-- more values - call it again with remaining values -->
      <xsl:call-template name="find-active-rev-style">
       <xsl:with-param name="allrevs"><xsl:value-of select="$morerevs"/></xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise/> <!-- no more values - none found -->
    </xsl:choose>

   </xsl:otherwise>
  </xsl:choose>

</xsl:template>



<!-- ===================================================================== -->

<!-- [34] ========== Alternate named templates ========== -->

<!-- <xsl:template name="sidetoc">
<xsl:if test="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]">
 (!-  if there are nested topics...  -)
<xsl:text>
</xsl:text>
<xsl:comment> Begin Table of Contents </xsl:comment>
<p>
<xsl:text>
</xsl:text>
  <table width="150" align="right" border="1" frame="box" rules="none">
<xsl:text>
</xsl:text>
    <tr><td height="5" bgcolor="#0033CC" align="center"><b><font color="#FFFFFF">Contents:</font></b></td></tr>
<xsl:text>
</xsl:text>
      <xsl:for-each select="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]">
        <tr><td class="toc"><a href="#{generate-id()}"><xsl:value-of select="."/></a>
        (!- recursive call for subtopics here" -)
        </td></tr>
<xsl:text>
</xsl:text>
      </xsl:for-each>
  </table>
</p>
<xsl:text>
</xsl:text>
</xsl:if>
</xsl:template>
-->

<!-- section with special processing based on a presumed outputclass
<xsl:template match="*[contains(@class,' topic/section ')][@outputclass='sidebar']" priority="1">
<xsl:comment>A sample sidebar:</xsl:comment>
<xsl:comment> SIDEBAR (OPTIONAL) </xsl:comment>
  <table align="RIGHT" border="0" cellpadding="3" width="35%" class="sidebar">
    <tr>
      <td bgcolor="#CCCCCC"><a name="Sidebar: {title}"></a>
          TBD: apply ID and other pertinent attribute processing here
          TBD: apply standard section title and content processing as well
        <b><xsl:value-of select="*[contains(@class,' topic/title ')]"/></b>
        <br/>
        <xsl:apply-templates/>
      </td>
    </tr>
  </table>
<xsl:comment> END OF SIDEBAR </xsl:comment>
</xsl:template>
-->


<!-- ===================================================================== -->

<!-- [35] ========== SETTINGS ========== -->
<xsl:variable name="trace">no</xsl:variable> <!--set string to 'yes' to turn on trace -->

<!-- set up keys based on xref's "type" attribute: %info-types;|hd|fig|table|li|fn -->
<xsl:key name="topic" match="topic" use="@id"/> <!-- uses "title" -->
<xsl:key name="fig"   match="fig"   use="@id"/> <!-- uses "title" -->
<xsl:key name="table" match="table" use="@id"/> <!-- uses "title" -->
<xsl:key name="li"    match="li"    use="@id"/> <!-- uses "?" -->
<xsl:key name="fn"    match="fn"    use="@id"/> <!-- uses "callout?" -->


<!-- [36] ========== FORMATTER DECLARATIONS AND GLOBALS ========== -->

<!-- [37] ========== "FORMAT" GLOBAL DECLARATIONS ========== -->

<xsl:variable name="link-top-section">no</xsl:variable><!-- values: yes, no (or any not "yes") -->
<xsl:variable name="do-place-ing">no</xsl:variable><!-- values: yes, no (or any not "yes") -->


<!-- [38] ========== "FORMAT" MACROS  - Table title, figure title, InfoNavGraphic ========== -->
<!--
 | These macros support globally-defined formatting constants for
 | document content.  Some elements have attributes that permit local
 | control of formatting; such logic is part of the pertinent template rule.
 +-->

<xsl:template name="place-tbl-width">  <!-- was 540 now 100% -->
<xsl:variable name="twidth-fixed">100%</xsl:variable>
  <xsl:if test="$twidth-fixed != ''">
    <xsl:attribute name="width"><xsl:value-of select="$twidth-fixed"/></xsl:attribute>
  </xsl:if>
</xsl:template>

<!-- table caption -->
<xsl:template name="place-tbl-lbl">
<xsl:variable name="tbl-count">                  <!-- Number of table/title's before this one -->
 <xsl:number count="*/*[contains(@class,' topic/table ')]/*[contains(@class,' topic/title ')]" level="any"/>
</xsl:variable>
<xsl:variable name="tbl-count-actual">           <!-- Number of table/title's including this one -->
 <xsl:choose>   <!-- init table counter to 1 - if not set -->
   <xsl:when test="not($tbl-count&gt;0) and not($tbl-count=0) and not($tbl-count&lt;0)">1</xsl:when>
   <xsl:otherwise><xsl:value-of select="$tbl-count+1"/></xsl:otherwise>
 </xsl:choose>
</xsl:variable>          <!-- normally: "Table 1. " -->
  <xsl:param name="stringName"/>
  <xsl:variable name="ancestorlangUpper">  <!-- the current xml:lang value (en-us if none found) -->
    <xsl:choose>
      <xsl:when test="ancestor-or-self::*/@xml:lang">
       <xsl:value-of select="ancestor-or-self::*/@xml:lang"/>
      </xsl:when>
      <xsl:otherwise>en-us</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="ancestorlang">
   <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
    <xsl:with-param name="inputval" select="$ancestorlangUpper"/>
   </xsl:call-template>
  </xsl:variable>
  <xsl:choose>
    <!-- title -or- title & desc -->
    <xsl:when test="*[contains(@class,' topic/title ')]">
      <caption>
       <xsl:choose>     <!-- Hungarian: "1. Table " -->
        <xsl:when test="( (string-length($ancestorlang)=5 and contains($ancestorlang,'hu-hu')) or (string-length($ancestorlang)=2 and contains($ancestorlang,'hu')) )">
         <xsl:value-of select="$tbl-count-actual"/><xsl:text>. </xsl:text>
         <xsl:call-template name="getString">
          <xsl:with-param name="stringName" select="'Table'"/>
         </xsl:call-template><xsl:text> </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="getString">
          <xsl:with-param name="stringName" select="'Table'"/>
         </xsl:call-template><xsl:text> </xsl:text><xsl:value-of select="$tbl-count-actual"/><xsl:text>. </xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:apply-templates select="./*[contains(@class,' topic/title ')]" mode="tabletitle"/>
       <xsl:if test="*[contains(@class,' topic/desc ')]">
        <xsl:text>. </xsl:text><!-- <xsl:value-of select="*[contains(@class,' topic/desc ')]"/> -->
        <xsl:apply-templates select="./*[contains(@class,' topic/desc ')]" mode="tabledesc"/>
       </xsl:if>
      </caption>
    </xsl:when>
    <!-- desc -->
    <xsl:when test="*[contains(@class,' topic/desc ')]">
      <div><xsl:apply-templates select="./*[contains(@class,' topic/desc ')]" mode="tabledesc"/></div>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/table ')]/*[contains(@class,' topic/title ')]" mode="tabletitle">
  <xsl:apply-templates/>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/table ')]/*[contains(@class,' topic/desc ')]" mode="tabledesc">
  <xsl:apply-templates/>
</xsl:template>

<!-- Figure caption -->
<xsl:template name="place-fig-lbl">
<xsl:variable name="fig-count">                 <!-- Number of fig/title's before this one -->
 <xsl:number count="*/*[contains(@class,' topic/fig ')]/*[contains(@class,' topic/title ')]" level="any"/>
</xsl:variable>
<xsl:variable name="fig-count-actual">          <!-- Number of fig/title's including this one -->
 <xsl:choose>
   <xsl:when test="not($fig-count&gt;0) and not($fig-count=0) and not($fig-count&lt;0)">1</xsl:when>
   <xsl:otherwise><xsl:value-of select="$fig-count+1"/></xsl:otherwise>
 </xsl:choose>
</xsl:variable>
  <xsl:param name="stringName"/>
  <xsl:variable name="ancestorlangUpper">  <!-- the current xml:lang value (en-us if none found) -->
    <xsl:choose>
      <xsl:when test="ancestor-or-self::*/@xml:lang">
        <xsl:value-of select="ancestor-or-self::*/@xml:lang"/>
      </xsl:when>
      <xsl:otherwise>en-us</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="ancestorlang">       <!-- convert the value to lower case -->
    <xsl:value-of select="translate($ancestorlangUpper,
                                    '-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
                                    '-abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz')"/>
  </xsl:variable>
  <xsl:choose>
    <!-- title -or- title & desc -->
    <xsl:when test="*[contains(@class,' topic/title ')]">
      <span class="figcap">
       <xsl:choose>      <!-- Hungarian: "1. Figure " -->
        <xsl:when test="( (string-length($ancestorlang)=5 and contains($ancestorlang,'hu-hu')) or (string-length($ancestorlang)=2 and contains($ancestorlang,'hu')) )">
         <xsl:value-of select="$fig-count-actual"/><xsl:text>. </xsl:text>
         <xsl:call-template name="getString">
          <xsl:with-param name="stringName" select="'Figure'"/>
         </xsl:call-template><xsl:text> </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="getString">
          <xsl:with-param name="stringName" select="'Figure'"/>
         </xsl:call-template><xsl:text> </xsl:text><xsl:value-of select="$fig-count-actual"/><xsl:text>. </xsl:text>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:apply-templates select="./*[contains(@class,' topic/title ')]" mode="figtitle"/>
      </span>
      <xsl:if test="desc">
       <xsl:text>. </xsl:text><span class="figdesc"><xsl:apply-templates select="./*[contains(@class,' topic/desc ')]" mode="figdesc"/></span>
      </xsl:if>
    </xsl:when>
    <!-- desc -->
    <xsl:when test="*[contains(@class, ' topic/desc ')]">
     <span class="figdesc"><xsl:apply-templates select="./*[contains(@class,' topic/desc ')]" mode="figdesc"/></span>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/fig ')]/*[contains(@class,' topic/title ')]" mode="figtitle">
 <xsl:apply-templates/>
</xsl:template>
<xsl:template match="*[contains(@class,' topic/fig ')]/*[contains(@class,' topic/desc ')]" mode="figdesc">
 <xsl:apply-templates/>
</xsl:template>

<!-- Figure group caption -->
<xsl:template name="place-figgrp-lbl">
 <xsl:choose>
  <!-- title -->
  <xsl:when test="*[contains(@class,' topic/title ')]">
   <xsl:apply-templates select="./*[contains(@class,' topic/title ')]" mode="figgrptitle"/>
  </xsl:when>
  <xsl:otherwise/>
 </xsl:choose>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/figgroup ')]/*[contains(@class,' topic/title ')]" mode="figgrptitle">
 <xsl:apply-templates/>
</xsl:template>


<xsl:template name="proc-ing">
  <xsl:if test="$do-place-ing = 'yes'"> <!-- set in a global variable, as with label placement, etc. -->
    <img src="tip-ing.jpg"/> <!-- this should be an xsl:choose with the approved list and a selection method-->
    <!-- add any other required positioning controls, if needed, but must be valid in the location
         from which the call to this template was made -->
    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
  </xsl:if>
</xsl:template>


<!-- ===================================================================== -->

<!-- [39] ========== STUBS FOR USER PROVIDED OVERRIDE EXTENSIONS ========== -->

<xsl:template name="gen-user-head">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- it will be placed in the HEAD section of the XHTML. -->
</xsl:template>

<xsl:template name="gen-user-header">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- it will be placed in the running heading section of the XHTML. -->
</xsl:template>

<xsl:template name="gen-user-footer">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- it will be placed in the running footing section of the XHTML. -->
</xsl:template>

<xsl:template name="gen-user-sidetoc">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- Uncomment the line below to have a "freebie" table of contents on the top-right -->
  <!-- <xsl:call-template name="sidetoc"/> -->
</xsl:template>

<xsl:template name="gen-user-scripts">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- It will be placed before the ending HEAD tag -->
  <!-- see (or enable) the named template "script-sample" for an example -->
  <!--xsl:call-template name="script-sample"/-->
</xsl:template>

<xsl:template name="gen-user-styles">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- It will be placed before the ending HEAD tag -->
</xsl:template>

<xsl:template name="gen-user-external-link">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- It will be placed after an external LINK or XREF -->
</xsl:template>


<xsl:template name="gen-user-panel-title-pfx">
  <!-- to customize: copy this to your override transform, add the content you want. -->
  <!-- It will be placed immediately after TITLE tag, in the title -->
</xsl:template>

<!-- ===================================================================== -->

<!-- [41] ========== DEFAULT PAGE LAYOUT ========== -->

<xsl:template name="chapter-setup">
<html>

<!-- test for a bidi language code on 1st 'topic' tag
     also need to look at 1st topic following dita -->
 <xsl:variable name="childlangUpper">  <!-- the kid's xml:lang value (use en-us if none found) -->
  <xsl:choose>
   <xsl:when test="descendant-or-self::*/@xml:lang">
     <xsl:value-of select="descendant-or-self::*/@xml:lang"/>
   </xsl:when>
   <xsl:otherwise>en-us</xsl:otherwise>
  </xsl:choose>
 </xsl:variable>
 <xsl:variable name="childlang">
  <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
   <xsl:with-param name="inputval" select="$childlangUpper"/>
  </xsl:call-template>
 </xsl:variable>
 <xsl:attribute name="lang"><xsl:value-of select="$childlang"/></xsl:attribute>
 <xsl:attribute name="xml:lang"><xsl:value-of select="$childlang"/></xsl:attribute>
 <xsl:if test="$childlang='ar-eg' or $childlang='ar' or $childlang='he' or $childlang='he-il'">
  <xsl:attribute name="dir">rtl</xsl:attribute>
 </xsl:if>

<xsl:value-of select="$newline"/>
<head><xsl:value-of select="$newline"/>
  <!-- initial meta information -->
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/><xsl:value-of select="$newline"/>
<!--  <meta http-equiv="generator" content="IBM Darwin Information Typing Architecture dit2htm transform" /><xsl:value-of select="$newline"/> -->

<!-- If there is no copyright in the document, make the standard IBM one -->
<xsl:if test="not(//*[contains(@class,' topic/copyright ')])">
  <meta name="copyright">
   <xsl:attribute name="content">
   <xsl:text>(C) </xsl:text>
   <xsl:call-template name="getString">
    <xsl:with-param name="stringName" select="'Copyright IBM'"/>
   </xsl:call-template>
   <xsl:text> </xsl:text><xsl:value-of select="$YEAR"/>
   </xsl:attribute>
  </meta>
  <xsl:value-of select="$newline"/>
  <meta name="DC.rights.owner">
   <xsl:attribute name="content">
   <xsl:text>(C) </xsl:text>
   <xsl:call-template name="getString">
    <xsl:with-param name="stringName" select="'Copyright IBM'"/>
   </xsl:call-template>
   <xsl:text> </xsl:text><xsl:value-of select="$YEAR"/>
   </xsl:attribute>
  </meta>
  <xsl:value-of select="$newline"/>
</xsl:if>

  <meta name="security" content="public" /><xsl:value-of select="$newline"/>
  <meta name="Robots" content="index,follow" /><xsl:value-of select="$newline"/>
  <xsl:text disable-output-escaping="yes">&lt;meta http-equiv="PICS-Label" content='(PICS-1.1 "http://www.icra.org/ratingsv02.html" l gen true r (cz 1 lz 1 nz 1 oz 1 vz 1) "http://www.rsac.org/ratingsv01.html" l gen true r (n 0 s 0 v 0 l 0) "http://www.classify.org/safesurf/" l gen true r (SS~~000 1))' /></xsl:text>
  <xsl:value-of select="$newline"/>

  <xsl:call-template name="getMeta"/>

  <!-- IBM Copyright text -->
  <xsl:call-template name="ibmcopyright"/>

 <xsl:variable name="urltest"> <!-- test for URL -->
  <xsl:call-template name="url-string">
   <xsl:with-param name="urltext" select="$CSSPATH"/>
  </xsl:call-template>
 </xsl:variable>
<!--<xsl:message>CSSPATH=<xsl:value-of select="$CSSPATH"/></xsl:message>-->
<!--<xsl:message>URLTEST=<xsl:value-of select="$urltest"/></xsl:message>-->

  <!-- IBM DITA style sheet always output - but based on bidi language -->
 <xsl:choose>
  <xsl:when test="($childlang='ar-eg' or $childlang='ar' or $childlang='he' or $childlang='he-il') and ($urltest='url')">
   <link rel="stylesheet" type="text/css" href="{$CSSPATH}{$bidi-ibmdita-css}" />
  </xsl:when>
  <xsl:when test="($childlang='ar-eg' or $childlang='ar' or $childlang='he' or $childlang='he-il') and ($urltest='')">
   <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$bidi-ibmdita-css}" />
  </xsl:when>
  <xsl:when test="not($childlang='ar-eg' or $childlang='ar' or $childlang='he' or $childlang='he-il') and ($urltest='url')">
   <link rel="stylesheet" type="text/css" href="{$CSSPATH}{$ibmdita-css}" />
  </xsl:when>
  <xsl:otherwise>
   <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$ibmdita-css}" />
  </xsl:otherwise>
 </xsl:choose>
  <xsl:value-of select="$newline"/>
  <!-- Add user's style sheet if requested to -->
  <xsl:if test="string-length($CSS)>0">
   <xsl:choose>
    <xsl:when test="$urltest='url'">
     <link rel="stylesheet" type="text/css" href="{$CSSPATH}{$CSS}" />
    </xsl:when>
    <xsl:otherwise>
     <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$CSS}" />
    </xsl:otherwise>
   </xsl:choose><xsl:value-of select="$newline"/>
  </xsl:if>

  <!-- Title processing - special handling for short descriptions -->
    <title>
      <xsl:call-template name="gen-user-panel-title-pfx"/> <!-- hook for a user-XSL title prefix -->
      <!-- use the searchtitle unless there's no value - else use title -->
      <xsl:variable name="schtitle"><xsl:value-of select="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/titlealts ')]/*[contains(@class,' topic/searchtitle ')]"/></xsl:variable>
      <xsl:variable name="ditaschtitle"><xsl:value-of select="/dita/*[contains(@class,' topic/topic ')][1]/*[contains(@class,' topic/titlealts ')]/*[contains(@class,' topic/searchtitle ')]"/></xsl:variable>
      <xsl:variable name="maintitle"><xsl:apply-templates select="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" mode="text-only"/></xsl:variable>
      <xsl:variable name="ditamaintitle"><xsl:apply-templates select="/dita/*[contains(@class,' topic/topic ')][1]/*[contains(@class,' topic/title ')]" mode="text-only"/></xsl:variable>
      <xsl:choose>
       <xsl:when test="string-length($schtitle)>'0'"><xsl:value-of select="$schtitle"/></xsl:when>
       <xsl:when test="string-length($ditaschtitle)>'0'"><xsl:value-of select="$ditaschtitle"/></xsl:when>
       <xsl:when test="string-length($maintitle)>'0'"><xsl:value-of select="$maintitle"/></xsl:when>
       <xsl:when test="string-length($ditamaintitle)>'0'"><xsl:value-of select="$ditamaintitle"/></xsl:when>
       <xsl:otherwise><xsl:text>***</xsl:text>
       <xsl:call-template name="output-message">
         <xsl:with-param name="msg">Topic contains no title; using "***".</xsl:with-param>
         <xsl:with-param name="msgnum">009</xsl:with-param>
         <xsl:with-param name="msgsev">W</xsl:with-param>
       </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
    </title><xsl:value-of select="$newline"/>

    <!--do pull processing for resource ID via xsl:choose-->
    <!-- include user's XSL HEAD processing here -->
    <xsl:call-template name="gen-user-head" />
    <!-- include user's XSL javascripts here -->
    <xsl:call-template name="gen-user-scripts" />
    <!-- include user's XSL style element and content here -->
    <xsl:call-template name="gen-user-styles" />

  <!-- Add user's head XHTML code snippet if requested to -->
  <xsl:if test="string-length($HDF)>0">
   <xsl:apply-templates select="document(concat($WORKDIR,$HDF))" mode="add-HDF"/>
  </xsl:if>
  </head><xsl:value-of select="$newline"/>

  <body>
  <xsl:call-template name="setclass"/>
  <xsl:call-template name="setidaname"/>
  <xsl:value-of select="$newline"/>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="start-revflag"/>

<!-- Insert previous/next/ancestor breadcrumbs links at the top of the xhtml. -->
  <xsl:apply-templates select="*[contains(@class,' topic/related-links ')]" mode="breadcrumb"/>

  <!-- include user's XSL running header here -->
  <xsl:call-template name="gen-user-header"/>
  <!-- Add user's running heading XHTML code snippet if requested to -->
  <xsl:if test="string-length($HDR)>0">
   <xsl:copy-of select="document(concat($WORKDIR,$HDR))"/>
  </xsl:if>
  <xsl:value-of select="$newline"/>
  <!-- Include a user's XSL call here to generate a toc based on what's a child of topic -->
  <xsl:call-template name="gen-user-sidetoc"/>

    <xsl:apply-templates/> <!-- this will include all things within topic; therefore, -->
    <!-- title content will appear here by fall-through -->
    <!-- followed by prolog (but no fall-through is permitted for it) -->
    <!-- followed by body content, again by fall-through in document order -->
    <!-- followed by related links -->
    <!-- followed by child topics by fall-through -->

  <!-- include footnote-endnotes -->
  <xsl:call-template name="gen-endnotes"/>

  <!-- include user's XSL running footer here -->
  <xsl:call-template name="gen-user-footer"/>
  <!-- Add user's running footing XHTML code snippet if requested to -->
  <xsl:if test="string-length($FTR)>0">
   <xsl:copy-of select="document(concat($WORKDIR,$FTR))"/>
  </xsl:if>
  <xsl:value-of select="$newline"/>
 <xsl:call-template name="end-revflag"/>

  </body><xsl:value-of select="$newline"/>
</html>
</xsl:template>

</xsl:stylesheet>
