<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                version='1.0'>

<!-- =================== start of diagnostics  ====================== -->


<xsl:template name="output-message">
  <xsl:param name="msg" select="***"/>
  <xsl:param name="msgnum" select="000"/>
  <xsl:param name="msgsev" select="I"/>
  <xsl:variable name="localclass"><xsl:value-of select="@class"/></xsl:variable>
  <xsl:variable name="debugloc">
   <!-- DocID = test.dita, Element = searchtitle:1 -->
   <xsl:text>DocID = </xsl:text><xsl:value-of select="generate-id(/)"/><xsl:text>, </xsl:text>
   <xsl:text>Element = </xsl:text><xsl:value-of select="name()"/>:<xsl:value-of select="count(preceding::*[@class=$localclass])+count(ancestor-or-self::*[@class=$localclass])"/>
  </xsl:variable>
  <xsl:message><xsl:text>------------------------------------------------------------------
DITA</xsl:text><xsl:value-of select="$msgnum"/>
    <xsl:choose>
      <xsl:when test="$msgsev='I'">I Informational: </xsl:when>
      <xsl:when test="$msgsev='W'">W Warning: </xsl:when>
      <xsl:when test="$msgsev='E'">E Error: </xsl:when>

      <xsl:when test="$msgsev='F'">F Fatal: </xsl:when>
      <xsl:otherwise>I Informational: </xsl:otherwise>
    </xsl:choose>
    <xsl:text> (</xsl:text><xsl:value-of select="$debugloc"/><xsl:text>)
</xsl:text><xsl:value-of select="$msg"/><xsl:text>
</xsl:text>
  </xsl:message>
</xsl:template>

<!-- =================== end of diagnostics  ====================== -->
 
</xsl:stylesheet>
