<?xml version="1.0" encoding="UTF-8" ?>
<!--  IBMoverrides.xsl
 | Composite DITA topics to HTML with IBM specific tweaks
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 | 07012002 DRD Created an IBM-specific override "style"
 *-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- stylesheet imports -->

<xsl:import href="topic2html.xsl"/>
<xsl:import href="xslhtml/domains2html.xsl"/>
<xsl:import href="task2html.xsl"/>
<xsl:import href="ref2html.xsl"/>


<!-- XHTML output with XML syntax -->
<xsl:output method="xml"
            encoding="utf-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>

<xsl:variable name="newline">
</xsl:variable>

<xsl:template match="/" priority="3">
  <xsl:comment>Composite DITA to XHTML application by IBM Corp., 2001, 2002</xsl:comment><xsl:value-of select="$newline"/>
  <xsl:message>DITA File = <xsl:value-of select="$FILENAME"/>, DocID = <xsl:value-of select="generate-id(/)"/></xsl:message>
  <xsl:apply-templates/>
</xsl:template>


<!-- Proper copyright and metadata for IBM deliverables -->
<xsl:template name="gen-user-metadata">
  <xsl:comment> (C) Copyright IBM Corporation, 2002 </xsl:comment><xsl:value-of select="$newline"/>
  <xsl:comment> All rights reserved. Licensed Materials Property of IBM </xsl:comment><xsl:value-of select="$newline"/>
  <xsl:comment> Note to US Government users: Documentation related to restricted rights </xsl:comment><xsl:value-of select="$newline"/>
  <xsl:comment> Use, duplication or disclosure is subject to restrictions set forth in GSA ADP Schedule with IBM Corp. </xsl:comment><xsl:value-of select="$newline"/>
  <xsl:comment>This page may contain other proprietary notices and copyright information, the terms of which must be observed and followed. </xsl:comment><xsl:value-of select="$newline"/>
  <meta name="dc.date" scheme="iso8601" content="2002-05-02" /><xsl:value-of select="$newline"/>
  <meta name="copyright" content="(C) Copyright IBM Corp. 2002" /><xsl:value-of select="$newline"/>
  <meta name="security" content="public" /><xsl:value-of select="$newline"/>
  <meta name="dc.language" scheme="rfc1766" content="en-us" /><xsl:value-of select="$newline"/>
  <meta name="Robots" content="index,follow"/><xsl:value-of select="$newline"/>
  <meta http-equiv="PICS-Label" content='(PICS-1.1 "http://www.icra.org/ratingsv02.html" l gen true r (cz 1 lz 1 nz 1 oz 1 vz 1) "http://www.rsac.org/ratingsv01.html" l gen true r (n 0 s 0 v 0 l 0) "http://www.classify.org/safesurf/" l gen true r (SS~~000 1))' /><xsl:value-of select="$newline"/>
</xsl:template>

<!-- Preferred rotation through nested ordered list styles -->

<!-- 1st level - Handle levels 1 to 9 thru OL-TYPE attribution -->
<xsl:template match="*[contains(@class,' topic/ol ')]" priority="1">
<ol>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 2nd level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="2">
<ol type="a">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 3rd level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="3">
<ol type="i">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 4th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="4">
<ol>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 5th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="5">
<ol type="a">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 6th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="6">
<ol type="i">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 7th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="7">
<ol>
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 8th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="8">
<ol type="a">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>

<!-- 9th level -->
<xsl:template match="*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]/*/*[contains(@class,' topic/ol ')]" priority="9">
<ol type="i">
  <xsl:call-template name="setclass"/>
  <xsl:apply-templates select="@compact"/>
  <xsl:apply-templates select="@id"/>
  <xsl:apply-templates/>
</ol>
</xsl:template>



</xsl:stylesheet>
