<?xml version="1.0" encoding="UTF-8" ?>
<!--  task:xsl
 | Specific override stylesheet for tasks (demo)
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 |   2003 May 31 DRD: added choicetable support (revised from ifcond support)
 *-->


<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- elements task and taskbody will fall through to topic processors -->


<!-- == TASK UNIQUE SUBSTRUCTURES == -->

<xsl:template match="*[contains(@class,' task/prereq ')]">
  <div>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="*[contains(@class,' task/context ')]">
  <div>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="sect-heading">
      <xsl:with-param name="deftitle">
      </xsl:with-param>
    </xsl:call-template>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="*[contains(@class,' task/result ')]">
  <div>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="sect-heading">
      <xsl:with-param name="deftitle">
      </xsl:with-param>
    </xsl:call-template>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="*[contains(@class,' task/postreq ')]">
  <div>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="sect-heading">
      <xsl:with-param name="deftitle">
      </xsl:with-param>
    </xsl:call-template>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="*[contains(@class,' task/steps ')]">
  <ol>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </ol>
</xsl:template>

<xsl:template match="*[contains(@class,' task/step ')]">
  <li>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:choose>
    <xsl:when test="@importance='optional'">
      <strong>
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Optional'"/>
      </xsl:call-template><xsl:text>: </xsl:text>
      </strong>
    </xsl:when>
    <xsl:when test="@importance='required'">
      <strong>
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Required'"/>
      </xsl:call-template><xsl:text>: </xsl:text>
      </strong>
    </xsl:when>
    </xsl:choose>
    <xsl:apply-templates/>
  </li>
</xsl:template>

<xsl:template match="*[contains(@class,' task/substeps ')]">
  <ol type="a">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </ol>
</xsl:template>

<xsl:template match="*[contains(@class,' task/substep ')]">
  <li>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:if test="@importance='optional'">
      <strong>
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Optional'"/>
      </xsl:call-template><xsl:text>: </xsl:text>
      </strong>
    </xsl:if>
    <xsl:if test="@importance='required'">
      <strong>
      <xsl:call-template name="getString">
        <xsl:with-param name="stringName" select="'Required'"/>
      </xsl:call-template><xsl:text>: </xsl:text>
      </strong>
    </xsl:if>
    <xsl:apply-templates/>
  </li>
</xsl:template>

<xsl:template match="*[contains(@class,' task/stepxmp ')]">
  <xsl:text> </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="*[contains(@class,' task/info ')]">
  <xsl:text> </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="*[contains(@class,' task/tutorialinfo ')]">
  <xsl:text> </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="*[contains(@class,' task/choices ')]" priority="5">
  <xsl:choose>
    <xsl:when test="./*[contains(@class,' task/choice ')]">
      <ul>
        <xsl:call-template name="setclass"/>
        <xsl:apply-templates select="@id"/>
        <xsl:apply-templates/>
      </ul>
    </xsl:when>
    <xsl:otherwise>
      <table border="1" frame="hsides" rules="rows">
        <xsl:apply-templates select="@id"/>
        <thead>
          <tr><td><b>Option</b></td><td><b>Description</b></td></tr>
        </thead>
        <tbody>
          <xsl:apply-templates/>
        </tbody>
      </table>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="*[contains(@class,' task/choice ')]">
  <li>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </li>
</xsl:template>


<!-- Element ifcond replaced by choicetable structure -->

<xsl:template match="*[contains(@class,' task/chrow ')]">
  <tr valign="top">
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </tr>
</xsl:template>

<xsl:template match="*[contains(@class,' task/choption ')]">
  <td>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </td>
</xsl:template>

<xsl:template match="*[contains(@class,' task/chdesc ')]">
  <td>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </td>
</xsl:template>

</xsl:stylesheet>
