<?xml version="1.0"?>

<!-- 
     Conversion from DITA map or maplist to .NET Help project.
     Input = one DITA map file, or a maplist pointing to multiple maps
     Output = one HxF project file for use with .NET
     
     NOT YET WORKING: does not scan the files to find images, or other referenced files.
     When that is done, it will have to reconcile paths: 
       "abc.dita" may or may not be the same as "../ref/abc.dita"
     
     Options:
        /OUTEXT  = XHTML output extension (default is 'html')
        /WORKDIR = The working directory that contains the document being transformed.
                   Needed as a directory prefix for the @href "document()" function calls. 
                   Default is './'

     Updates:
       3.8.2: Allow for paths in maplist, improve removal of duplicate files from the list
-->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                xmlns:saxon="http://icl.com/saxon"
                extension-element-prefixes="saxon">

<!-- Include error message template -->
<xsl:include href="output-message.xsl"/>

<!-- This program uses a temp file. If we declare the doctype here, it
     goes in to the temp file as well. So, output it directly below. -->
<xsl:output method="xml"
            encoding="utf-8"
/>

<!-- Set the prefix for error message numbers -->
<xsl:variable name="msgprefix">IDXS</xsl:variable>
<xsl:variable name="newline"><xsl:text>
</xsl:text></xsl:variable>

<!-- *************************** Command line parameters *********************** -->
<xsl:param name="OUTEXT" select="'html'"/>
<xsl:param name="WORKDIR" select="'./'"/>
<xsl:param name="CSS"/>
<xsl:param name="CSSPATH"/>

<!-- This file contains extra project information, such as a list of
     images. It is produced by the Omnimark pre-processor. -->
<xsl:param name="PROJECTINFO">mapinfo.tmp</xsl:param>

<xsl:variable name="BASENAME">
  <xsl:value-of select="document(concat($WORKDIR,$PROJECTINFO))/*/basename"/>
</xsl:variable>

<xsl:template match="/" priority="2">
  <xsl:if test="contains(system-property('xsl:vendor'), 'SAXON')">
    <xsl:variable name="INIT-TEMPFILE">atemp.txt</xsl:variable>
    <xsl:variable name="TEMPFILE">btemp.txt</xsl:variable>
    <xsl:variable name="WORKING-TEMPFILE">
      <xsl:value-of select="$WORKDIR"/>
      <xsl:value-of select="$TEMPFILE"/>
    </xsl:variable>
    <saxon:output href="{$INIT-TEMPFILE}">
      <filelist>
        <xsl:apply-templates/>
        <!-- Need to get images from temp file and include them, while removing duplicates -->
        <xsl:apply-templates select="document(concat($WORKDIR,$PROJECTINFO))/*/image" mode="images"/>
      </filelist>
    </saxon:output>
    <!-- Fix any abc/../def items in the path -->
    <saxon:output href="{$TEMPFILE}">
      <filelist>
        <xsl:for-each select="document(concat($WORKDIR,$INIT-TEMPFILE))//file">
          <xsl:sort select="@href"/>
          <file>
            <xsl:attribute name="href"><xsl:call-template name="removeExtraRelpath"/></xsl:attribute>
          </file>
        </xsl:for-each>
      </filelist>
    </saxon:output>
    <!-- Output the doctype as text -->
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE HelpFileList SYSTEM "ms-help://hx/resources/HelpFileList.DTD">
</xsl:text>
    <HelpFileList DTDVersion="1.0">
      <xsl:value-of select="$newline"/>
      <!-- Need to put in TOC file, index, F1 help, etc -->
      <File Url="{$BASENAME}.HxT"/>
      <xsl:if test="document(concat($WORKDIR,$PROJECTINFO))/*/includeIndex">
        <xsl:value-of select="$newline"/>
        <File Url="{$BASENAME}.HxK"/>
        <!-- Not sure yet if F1 help is really needed -->
        <!--<xsl:value-of select="$newline"/>
        <File Url="{$BASENAME}.F1.HxK"/>-->
      </xsl:if>
      <xsl:for-each select="document($WORKING-TEMPFILE)//file">
        <xsl:sort select="@href"/>
        <xsl:variable name="thishref" select="@href"/>
        <!--<xsl:if test="@href!=preceding-sibling::*[1]/@href or not(preceding-sibling::*)">-->
        <xsl:if test="not(preceding-sibling::*[@href=$thishref])">
          <xsl:value-of select="$newline"/>
          <File Url="{@href}"/>
        </xsl:if>
      </xsl:for-each>
      <xsl:value-of select="$newline"/>
      <!-- Include any user-specified CSS file -->
      <xsl:if test="string-length($CSS)>0">
        <xsl:value-of select="$newline"/>
        <File Url="{$CSSPATH}{$CSS}"/>
      </xsl:if>
      <!-- Include the default stylesheet(s) -->
      <xsl:apply-templates select="document(concat($WORKDIR,$PROJECTINFO))/*/css" mode="css"/>
    </HelpFileList>
  </xsl:if>
</xsl:template>

<xsl:template match="image" mode="images">
  <xsl:value-of select="$newline"/>
  <file href="{.}"/>
</xsl:template>

<xsl:template match="/maplist">
  <xsl:apply-templates select="*/map"/>
</xsl:template>

<xsl:template match="/maplist/*/map">
  <xsl:variable name="MapWithPath"><xsl:value-of select="$WORKDIR"/><xsl:value-of select="@file"/></xsl:variable>
  <xsl:apply-templates select="document($MapWithPath)/*[contains(@class, ' map/map ')]">
    <xsl:with-param name="pathFromMaplist"><xsl:call-template name="getRelativePath"/></xsl:with-param>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="/*[contains(@class, ' map/map ')]">
  <xsl:param name="pathFromMaplist"/>
  <xsl:apply-templates select=".//*[contains(@class, ' map/topicref ')]">
    <xsl:with-param name="pathFromMaplist" select="$pathFromMaplist"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="*[contains(@class, ' map/topicref ')]">
  <xsl:param name="pathFromMaplist"/>
  <xsl:if test="@href and (not(@scope='external') or @format='dita' or @format='DITA')">
    <xsl:value-of select="$newline"/>
    <file>
      <xsl:attribute name="href">
        <xsl:choose>
          <xsl:when test="contains(@copy-to,'.dita')">
            <xsl:if test="not(@scope='external')"><xsl:value-of select="$pathFromMaplist"/></xsl:if>
            <xsl:value-of select="substring-before(@copy-to,'.dita')"/>.<xsl:value-of select="$OUTEXT"/>
          </xsl:when>
          <xsl:when test="contains(@copy-to,'.DITA')">
            <xsl:if test="not(@scope='external')"><xsl:value-of select="$pathFromMaplist"/></xsl:if>
            <xsl:value-of select="substring-before(@copy-to,'.DITA')"/>.<xsl:value-of select="$OUTEXT"/>
          </xsl:when>
          <xsl:when test="contains(@href,'.dita')">
            <xsl:if test="not(@scope='external')"><xsl:value-of select="$pathFromMaplist"/></xsl:if>
            <xsl:value-of select="substring-before(@href,'.dita')"/>.<xsl:value-of select="$OUTEXT"/>
          </xsl:when>
          <xsl:when test="contains(@href,'.DITA')">
            <xsl:if test="not(@scope='external')"><xsl:value-of select="$pathFromMaplist"/></xsl:if>
            <xsl:value-of select="substring-before(@href,'.DITA')"/>.<xsl:value-of select="$OUTEXT"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:if test="not(@scope='external')"><xsl:value-of select="$pathFromMaplist"/></xsl:if>
            <xsl:value-of select="@href"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
    </file>
  </xsl:if>
  <!-- Process the file itself? Or, use the files that came from hrefscan for images, etc? -->
</xsl:template>

<!-- Add CSS files from the mapinfo file into the HxF file. -->
<xsl:template match="css" mode="css">
  <xsl:value-of select="$newline"/>
  <File Url="{$CSSPATH}{.}"/>
</xsl:template>

<!-- Template to get the relative path from a maplist to a map -->
<xsl:template name="getRelativePath">
  <xsl:param name="remainingPath" select="@file"/>
  <xsl:choose>
    <xsl:when test="contains($remainingPath,'/')">
      <xsl:value-of select="substring-before($remainingPath,'/')"/><xsl:text>/</xsl:text>
      <xsl:call-template name="getRelativePath">
        <xsl:with-param name="remainingPath" select="substring-after($remainingPath,'/')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="contains($remainingPath,'\')">
      <xsl:value-of select="substring-before($remainingPath,'\')"/><xsl:text>/</xsl:text>
      <xsl:call-template name="getRelativePath">
        <xsl:with-param name="remainingPath" select="substring-after($remainingPath,'\')"/>
      </xsl:call-template>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<!-- Remove extra relpaths (as in abc/../def) -->
<xsl:template name="removeExtraRelpath">
  <xsl:param name="remainingPath"><xsl:value-of select="@href"/></xsl:param>
  <xsl:choose>
    <xsl:when test="not(contains($remainingPath,'../'))"><xsl:value-of select="$remainingPath"/></xsl:when>
    <xsl:when test="not(starts-with($remainingPath,'../')) and
                    starts-with(substring-after($remainingPath,'/'),'../')">
      <xsl:call-template name="removeExtraRelpath">
        <xsl:with-param name="remainingPath" select="substring-after($remainingPath,'../')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="contains($remainingPath,'/')">
      <xsl:value-of select="substring-before($remainingPath,'/')"/>/<xsl:text/>
      <xsl:call-template name="removeExtraRelpath">
        <xsl:with-param name="remainingPath" select="substring-after($remainingPath,'/')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise><xsl:value-of select="$remainingPath"/></xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
