<?xml version="1.0" encoding="UTF-8"?>
<!--  generalize.xsl 
 | Convert specialied DITA topics into revertable, "generalized" form
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 | 2002/05/09 - modified the stylesheet for new class attribute separation token
 *-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
     <xsl:output method="xml" indent="no"/>

     <xsl:template match="*[@class]">
          <xsl:variable name="generalize" select="substring-before(substring-after(@class,'/'),' ')" />
                <xsl:element name="{$generalize}">
                     <xsl:copy-of select="@*"/>
                    <xsl:apply-templates/>
                </xsl:element>
     </xsl:template>

     <xsl:template match="*|@*|comment()|processing-instruction()|text()">
       <xsl:copy>
         <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"/>
       </xsl:copy>
     </xsl:template>
</xsl:stylesheet>
