<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE xsl:stylesheet [

  <!ENTITY gt            "&gt;">
  <!ENTITY lt            "&lt;">
  <!ENTITY rbl           " ">
  <!ENTITY nbsp          "&#xA0;">    <!-- &#160; -->
  <!ENTITY quot          "&#34;">
  <!ENTITY copyr         "&#169;">
]>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:MSHelp="http://msdn.microsoft.com/mshelp"
                xmlns:saxon="http://icl.com/saxon"
                extension-element-prefixes="saxon"
                >

<!-- dotnet.xsl   Override to produce .NET output
 | Convert DITA topic to HTML; "single topic to single web page"-level view
 |
 | Copyright IBM Corporation
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
E002790 Encoding is wrong in XHTML output
E002749 Don't need the DITA Generator comments at the top of the file
E002740 Switch to using Saxon's xhtml output setting. Better handling of single & empty tags. (br, meta, <b/>)
     -->

<!-- stylesheet imports -->
<!-- the main dita to xhtml converter -->
<xsl:import href="dit2htm.xsl"/>

<!-- the dita to xhtml converter for task documents -->
<xsl:import href="taskdisplay.xsl"/>

<!-- the dita to xhtml converter for reference documents -->
<xsl:import href="refdisplay.xsl"/>

<!-- Output XHTML with XML syntax, use UFT-8 encoding="UTF-8", transitional XHTML.
     Prevent indenting to conserve space on output. -->
<!-- <xsl:output method="xml" -->
<xsl:output method="saxon:xhtml"
            encoding="UTF-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>

<!-- Temporary file, generated by an earlier program, that contains info on the map -->
<xsl:param name="MAPINFOFILE">mapinfo.tmp</xsl:param>

<xsl:template match="/dita | /*[contains(@class,' topic/topic ')]" priority="3">
  <xsl:call-template name="dotnet-setup"/>
</xsl:template>

<xsl:template name="dotnet-setup">
<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp">

<!-- test for a bidi language code on 1st 'topic' tag
     also need to look at 1st topic following dita -->
  <xsl:variable name="childlangUpper">  <!-- the kid's xml:lang value (use en-us if none found) -->
   <xsl:choose>
    <xsl:when test="descendant-or-self::*/@xml:lang">
      <xsl:value-of select="descendant-or-self::*/@xml:lang"/>
    </xsl:when>
    <xsl:otherwise>en-us</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="childlang">
   <xsl:call-template name="convert-to-lower"> <!-- ensure lowercase for comparisons -->
    <xsl:with-param name="inputval" select="$childlangUpper"/>
   </xsl:call-template>
  </xsl:variable>
  <xsl:choose>
   <xsl:when test="$childlang='ar-eg' or $childlang='ar'">
    <xsl:attribute name="lang">ar-eg</xsl:attribute>
    <xsl:attribute name="xml:lang">ar-eg</xsl:attribute>
    <xsl:attribute name="dir">rtl</xsl:attribute>
   </xsl:when>
   <xsl:when test="$childlang='he' or $childlang='he-il'">
    <xsl:attribute name="lang">he-il</xsl:attribute>
    <xsl:attribute name="xml:lang">he-il</xsl:attribute>
    <xsl:attribute name="dir">rtl</xsl:attribute>
   </xsl:when>
   <xsl:otherwise/>
  </xsl:choose>

  <xsl:value-of select="$newline"/>
  <head>
    <xsl:value-of select="$newline"/>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <xsl:value-of select="$newline"/>

    <!-- If there is no copyright in the document, make the standard IBM one -->
    <xsl:if test="not(//*[contains(@class,' topic/copyright ')])">
      <meta name="copyright">
       <xsl:attribute name="content">
         <xsl:text>(C) </xsl:text>
         <xsl:call-template name="getString">
           <xsl:with-param name="stringName" select="'Copyright IBM'"/>
         </xsl:call-template>
         <xsl:text> </xsl:text>
         <xsl:value-of select="$YEAR"/>
       </xsl:attribute>
      </meta>
      <xsl:value-of select="$newline"/>
    </xsl:if>

    <meta name="security" content="public" /><xsl:value-of select="$newline"/>
    <meta name="Robots" content="index,follow" /><xsl:value-of select="$newline"/>
    <xsl:text disable-output-escaping="yes">&lt;meta http-equiv="PICS-Label" content='(PICS-1.1 "http://www.icra.org/ratingsv02.html" l gen true r (cz 1 lz 1 nz 1 oz 1 vz 1) "http://www.rsac.org/ratingsv01.html" l gen true r (n 0 s 0 v 0 l 0) "http://www.classify.org/safesurf/" l gen true r (SS~~000 1))' /></xsl:text>
    <xsl:value-of select="$newline"/>

    <xsl:call-template name="getMeta"/>

    <!-- IBM Copyright text -->
    <xsl:call-template name="ibmcopyright"/>
  
    <!-- Generate XML Island -->
    <xml><xsl:value-of select="$newline"/>
      <xsl:apply-templates select="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/prolog ')]/*[contains(@class,' topic/metadata ')]/*[contains(@class,' topic/othermeta ')][contains(@otherprops,'MSHelp:')]" mode="xml-island"/>
      <xsl:apply-templates select="/dita/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/prolog ')]/*[contains(@class,' topic/metadata ')]/*[contains(@class,' topic/othermeta ')][contains(@otherprops,'MSHelp:')]" mode="xml-island"/>
      <xsl:if test="string-length($HDF)>0">
        <xsl:apply-templates select="document(concat($WORKDIR,$HDF))//xml" mode="add-HDF-xml"/>
      </xsl:if>
    </xml><xsl:value-of select="$newline"/>

    <!-- IBM DITA style sheet always output - but based on bidi language -->
    <xsl:choose>
      <xsl:when test="$childlang='ar-eg' or $childlang='ar' or $childlang='he' or $childlang='he-il'">
        <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$bidi-ibmdita-css}" />
      </xsl:when>
      <xsl:otherwise>
        <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$ibmdita-css}" />
      </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$newline"/>
    
    <!-- Add user's style sheet if requested to -->
    <xsl:if test="string-length($CSS)>0">
      <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$CSS}" /><xsl:value-of select="$newline"/>
    </xsl:if>

    <!-- Title processing - special handling for short descriptions -->
    <title>
      <!-- use the searchtitle unless there's no value - else use title -->
      <xsl:variable name="schtitle"><xsl:value-of select="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/titlealts ')]/*[contains(@class,' topic/searchtitle ')]"/></xsl:variable>
      <xsl:variable name="ditaschtitle"><xsl:value-of select="/dita/*[contains(@class,' topic/topic ')][1]/*[contains(@class,' topic/titlealts ')]/*[contains(@class,' topic/searchtitle ')]"/></xsl:variable>
      <xsl:variable name="maintitle"><xsl:apply-templates select="/*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" mode="text-only"/></xsl:variable>
      <xsl:variable name="ditamaintitle"><xsl:apply-templates select="/dita/*[contains(@class,' topic/topic ')][1]/*[contains(@class,' topic/title ')]" mode="text-only"/></xsl:variable>
      <xsl:choose>
       <xsl:when test="string-length($schtitle)>'0'"><xsl:value-of select="$schtitle"/></xsl:when>
       <xsl:when test="string-length($ditaschtitle)>'0'"><xsl:value-of select="$ditaschtitle"/></xsl:when>
       <xsl:when test="string-length($maintitle)>'0'"><xsl:value-of select="$maintitle"/></xsl:when>
       <xsl:when test="string-length($ditamaintitle)>'0'"><xsl:value-of select="$ditamaintitle"/></xsl:when>
       <xsl:otherwise><xsl:text>***</xsl:text>
       <xsl:call-template name="output-message">
         <xsl:with-param name="msg">Topic contains no title; using "***".</xsl:with-param>
         <xsl:with-param name="msgnum">009</xsl:with-param>
         <xsl:with-param name="msgsev">W</xsl:with-param>
       </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
    </title>
    <xsl:value-of select="$newline"/>

    <!-- Add user's head XHTML code snippet if requested to -->
    <xsl:if test="string-length($HDF)>0">
      <xsl:apply-templates select="document(concat($WORKDIR,$HDF))" mode="add-HDF"/>
    </xsl:if>
  </head>
  <xsl:value-of select="$newline"/>

  <body class="dotnet">
    <xsl:call-template name="setclass"/>
    <xsl:call-template name="setidaname"/>
    <xsl:value-of select="$newline"/>
    
    <!-- Generate the .NET banner -->
    <xsl:apply-templates select="*[contains(@class,' topic/title ')]" mode="gen-banner"/>
  
    <!-- Use class instead of id for nstext -->
    <div class="nstext">
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="start-revflag"/>
   
      <!-- Insert previous/next/ancestor breadcrumbs links at the top of the xhtml. -->
      <xsl:apply-templates select="*[contains(@class,' topic/related-links ')]" mode="breadcrumb"/>
   
      <!-- Add user's running heading XHTML code snippet if requested to -->
      <xsl:if test="string-length($HDR)>0">
        <xsl:copy-of select="document(concat($WORKDIR,$HDR))"/>
      </xsl:if>
      <xsl:value-of select="$newline"/>
   
      <xsl:apply-templates/> <!-- this will include all things within topic; therefore, -->
      <!-- title content will appear here by fall-through -->
      <!-- followed by prolog (but no fall-through is permitted for it) -->
      <!-- followed by body content, again by fall-through in document order -->
      <!-- followed by related links -->
      <!-- followed by child topics by fall-through -->
   
      <!--xsl:call-template name="gen-relsect"/-->
      <!-- include footnote-endnotes -->
      <xsl:call-template name="gen-endnotes"/>
   
      <!-- Add user's running footing XHTML code snippet if requested to -->
      <xsl:if test="string-length($FTR)>0">
        <xsl:copy-of select="document(concat($WORKDIR,$FTR))"/>
      </xsl:if>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="end-revflag"/>
    </div>
  </body>
  <xsl:value-of select="$newline"/>
</html>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" priority="1"/>
<xsl:template match="*[contains(@class,' topic/topic ')]/*[contains(@class,' topic/title ')]" mode="gen-banner" priority="1">
  <!--NONSCROLLING BANNER START-->
  <!-- Use class instead of ID for nsbanner, bannerrow1, hdr, and TitleRow -->
  <div class="nsbanner">
    <div class="bannerrow1">
      <table class="bannerparthead" cellspacing="0">
        <tr class="hdr">
          <td class="runninghead">
            <xsl:apply-templates select="document(concat($WORKDIR,$PATH2PROJ,$MAPINFOFILE))//helpset/title"/>
          </td>
          <td class="product">&nbsp;</td>
        </tr>
      </table>
    </div>
    <div class="TitleRow">
      <h1 class="dtH1"><xsl:apply-templates/></h1>
    </div>
  </div>
  <!--NONSCROLLING BANNER END-->
</xsl:template>

<!-- This is in a temporary file generated by the pre-processor. Must be used until
     there is a way to pass the map name into the XHTML conversion process. -->
<xsl:template match="helpset/title">
  <xsl:apply-templates/>
</xsl:template>


<!-- If there is an XML island in the HDF file, this copies its contents
     into the XML island generated above. -->
<xsl:template match="xml" mode="add-HDF-xml">
  <xsl:apply-templates select="*|comment()|processing-instruction()|text()" mode="add-HDF"/>
</xsl:template>

<xsl:template match="xml" mode="add-HDF"/>  <!-- XML island info is pulled in above -->

<xsl:template match="/div" mode="add-HDF">
  <xsl:apply-templates select="*|comment()|processing-instruction()|text()" mode="add-HDF"/>
</xsl:template>

<xsl:template match="*|@*|comment()|processing-instruction()|text()" mode="add-HDF">
  <xsl:copy>
    <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()" mode="add-HDF"/>
  </xsl:copy>
</xsl:template>

<!-- Process othermeta; ignore values that will go in XML island -->
<xsl:template match="*[contains(@class,' topic/othermeta ')]" mode="gen-metadata">
  <xsl:choose>
    <xsl:when test="@otherprops='MSHelp:Attr'"/>
    <xsl:when test="@otherprops='MSHelp:Keyword'"/>
    <xsl:when test="@otherprops='MSHelp:TOCTitle'"/>
    <xsl:when test="@otherprops='MSHelp:RLTitle'"/>
    <xsl:when test="@otherprops='MSHelp:Include'"/>
    <xsl:when test="@otherprops='MSHelp:NoSearch'"/>
    <xsl:when test="@otherprops='MSHelp:VTopic'"/>
    <xsl:when test="@otherprops='MSHelp:FTSIndex'"/>
    <xsl:otherwise>
      <meta>
        <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
        <xsl:attribute name="content"><xsl:value-of select="@content"/></xsl:attribute>
      </meta>
      <xsl:value-of select="$newline"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Process othermeta that will go in the XML island. -->
<xsl:template match="*[contains(@class,' topic/othermeta ')]" mode="xml-island">
  <xsl:choose>
    <xsl:when test="@otherprops='MSHelp:Attr'">
      <MSHelp:Attr Name="{@name}" Value="{@content}"/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:Keyword'">
      <MSHelp:Keyword Index="{@name}" Term="{@content}"/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:TOCTitle'">
      <MSHelp:TOCTitle Title="{@name}"/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:RLTitle'">
      <MSHelp:RLTitle Title="{@name}"/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:Include'">
      <MSHelp:Include File="{@name}"/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:NoSearch'">
      <MSHelp:NoSearch/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:VTopic'">
      <MSHelp:VTopic Name="{@name}"/><xsl:value-of select="$newline"/>
    </xsl:when>
    <xsl:when test="@otherprops='MSHelp:FTSIndex'">
      <MSHelp:FTSIndex Vtopic="{@name}"/><xsl:value-of select="$newline"/>
    </xsl:when>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>

