<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                version='1.0'>



<!-- =================== start of I18N generated text support ====================== -->


<!-- basis for string localization -->

<xsl:template name="xgetString">
  <xsl:param name="stringName"/>
  <xsl:value-of select="$stringName"/>
</xsl:template>

<!-- language support (from an algorithm described in XSL FAQ) -->
<!--
        given the info needed to produce a set of candidates ($str),
           pick the best of the bunch:
           1. $str[lang($Lang)][1]
           2. $str[lang($PrimaryLang)][1]
           3. $str[1]
           4. if not($str) then issue warning to STDERR
   - -->
<xsl:template name="getString">
  <xsl:param name="stringName"/>
  <xsl:param name="stringFile" select="$StringFile"/>
  <xsl:variable name="str" 
     select="$stringFile/strings/str[@name=$stringName]"/>
  <xsl:choose>
    <xsl:when test="$str[lang($Lang)]">
      <xsl:value-of select="$str[lang($Lang)][1]"/>
    </xsl:when>
    <xsl:when test="$str[lang($PrimaryLang)]">
      <xsl:value-of select="$str[lang($PrimaryLang)][1]"/>
    </xsl:when>
    <xsl:when test="$str">
      <xsl:value-of select="$str[1]"/>
    </xsl:when>
    <xsl:otherwise>
       [<xsl:value-of select="$stringName"/>]
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>


<!-- =================== end of I18N generated text support ====================== -->



</xsl:stylesheet>
