<?xml version="1.0" encoding="UTF-8" ?>
<!--  related-links.xsl
 | DITA link processor (xref, related-links)
 |
 | (C) Copyright IBM Corporation 2001, 2002, 2003. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
 +
 | updates:
 *-->
<!--??? need to add additional pass for inherited atts - move the text pull in there too - for now, only detecting hierarchical links with explicit roles-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml"
            encoding="utf-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>
<!--key formed of containing topic's id plus:
@href
@type
@role
@platform
@audience
@importance
@outputclass
@keyref
@format
@scope
@otherrole
@product
@otherprops
@rev
@class
linktext
shortdesc
-->
<!--??? to do - on every match statement, reorder to put simple conditions first-->
<!--??? to figure out - how handle non-http protocols - in file variable - as in mappull also-->

<xsl:key name="link" match="*[contains(@class, ' topic/link ')][not(ancestor::*[contains(@class, ' topic/linklist ')])]" use="concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*)"/>

<xsl:template match="*[contains(@class,' topic/related-links ') or contains(@class,' topic/linkpool ')]
	[child::*[@role='ancestor' or @role='next' or @role='previous' or (@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin'))]]" mode="hierarchylink">
	<!---output blank space if next/prev missing to preserve spacing-->
	<dl class="hierarchy"><dt class="breadcrumb">
	<xsl:choose>
		<xsl:when test="*[@href][@role='previous']">
			<xsl:apply-templates select="*[@href][@role='previous']">
				<xsl:with-param name="linktext">
					<xsl:call-template name="getString">
			                  <xsl:with-param name="stringName" select="'Previous topic'"/>
			               </xsl:call-template>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:when>
		<xsl:otherwise><xsl:text>  </xsl:text></xsl:otherwise>
	</xsl:choose>
	<xsl:if test="*[@href][@role='next'] and *[@href][@role='previous']">
	  <xsl:text> | </xsl:text>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="*[@href][@role='next']">
			<xsl:apply-templates select="*[@href][@role='next']">
				<xsl:with-param name="linktext">
					<xsl:call-template name="getString">
			                  <xsl:with-param name="stringName" select="'Next topic'"/>
			               </xsl:call-template>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:when>
		<xsl:otherwise><xsl:text>  </xsl:text></xsl:otherwise>
	</xsl:choose>
	<xsl:if test="(*[@href][@role='next'] or *[@href][@role='previous']) and *[@href][@role='ancestor']">
	  <xsl:text> | </xsl:text>
	</xsl:if>
	<xsl:if test="*[@href][@role='ancestor']">
	<xsl:for-each select="*[@href][@role='ancestor']">
			<xsl:apply-templates select="."/> &gt; 
	</xsl:for-each>
	</xsl:if>
	</dt>
	<xsl:if test="*[@href][@importance='required'][not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin']">
	
	<dt class="prereq">
             <xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Prerequisites'"/>
               </xsl:call-template>
		 </dt>
	    <xsl:for-each select="*[@href][@importance='required'][not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin']">
			<dd><xsl:apply-templates select="."/></dd>
	    </xsl:for-each>
	</xsl:if>
	</dl>
</xsl:template>


<xsl:template match="*[contains(@class,' topic/related-links ')]">
   <div>
    <xsl:call-template name="setclass"/>

     <!--children-->
     <xsl:if test="descendant::*[contains(@class, ' topic/link ')][not(ancestor-or-self::linklist)][(ancestor-or-self::*/@role)[last()]='child' or (ancestor-or-self::*/@role)[last()]='descendant']">
     <blockquote>
          <xsl:apply-templates select="descendant::*
		[generate-id(.)=generate-id(key('link',concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1])]
		[contains(@class, ' topic/link ')]
		[not(ancestor-or-self::linklist)]
		[(ancestor-or-self::*/@role)[last()]='child' or (ancestor-or-self::*/@role)[last()]='descendant']"/>
     </blockquote>
     </xsl:if>

     <!--repeat the next links (already created in hierarchylinks, but now spelled out in full)-->
     <xsl:if test="descendant::*[contains(@class, ' topic/link ')]
		[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
		[not((ancestor-or-self::*/@role)[last()]='child')]
		[not((ancestor-or-self::*/@role)[last()]='descendant')]
		[(ancestor-or-self::*/@role)[last()]='next']">
          <p>
	   <xsl:for-each select="descendant::*[contains(@class, ' topic/link ')]
		[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
		[not((ancestor-or-self::*/@role)[last()]='child')]
		[not((ancestor-or-self::*/@role)[last()]='descendant')]
		[(ancestor-or-self::*/@role)[last()]='next']">
		<b>
		<xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Next topic'"/>
               </xsl:call-template>
		<xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'ColonSymbol'"/>
               </xsl:call-template>
		</b><xsl:text> </xsl:text>
<xsl:text> </xsl:text>
		<xsl:apply-templates select="."/>
	   </xsl:for-each>
          </p>
     </xsl:if>



     <!--related concepts-->
     <xsl:if test="descendant::*[contains(@class, ' topic/link ')]
		[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
		[not((ancestor-or-self::*/@role)[last()]='child')]
		[not((ancestor-or-self::*/@role)[last()]='descendant')]
		[not(@role='ancestor' or @role='next' or @role='previous')]
		[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
		[(ancestor-or-self::*/@type)[last()]='concept']">
          <p>
          <b>
             <xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Related concepts'"/>
               </xsl:call-template>
          </b><br clear="all"/>
	  <xsl:call-template name="sort-links-by-role"><xsl:with-param name="type">concept</xsl:with-param></xsl:call-template>
          </p>
     </xsl:if>

     <!--related tasks-->
     <xsl:if test="descendant::*
		[contains(@class, ' topic/link ')]
		[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])][not((ancestor-or-self::*/@role)[last()]='child')][not((ancestor-or-self::*/@role)[last()]='descendant')]
		[not(@role='ancestor' or @role='next' or @role='previous')]
		[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
		[(ancestor-or-self::*/@type)[last()]='task']">
          <p>
          <b>
             <xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Related tasks'"/>
               </xsl:call-template>
          </b><br clear="all"/>
	  <xsl:call-template name="sort-links-by-role"><xsl:with-param name="type">task</xsl:with-param></xsl:call-template>
          </p>
     </xsl:if>


     <!--related reference-->
     <xsl:if test="descendant::*
		[contains(@class, ' topic/link ')]
		[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
		[not((ancestor-or-self::*/@role)[last()]='child')][not((ancestor-or-self::*/@role)[last()]='descendant')]
		[not(@role='ancestor' or @role='next' or @role='previous')]
		[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
		[(ancestor-or-self::*/@type)[last()]='reference']">
          <p>
          <b>
             <xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Related reference'"/>
               </xsl:call-template>
          </b><br clear="all"/> 
	  <xsl:call-template name="sort-links-by-role"><xsl:with-param name="type">reference</xsl:with-param></xsl:call-template>
          </p>
     </xsl:if>

     <!--other info- - not currently sorting by role, since already mixing any number of types in here-->
     <xsl:if test="descendant::*
[contains(@class, ' topic/link ')]
[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
[generate-id(.)=generate-id(key('link',concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1])]
[not((ancestor-or-self::*/@role)[last()]='child')]
[not((ancestor-or-self::*/@role)[last()]='descendant')]
[not((ancestor-or-self::*/@type)[last()]='concept')]
[not((ancestor-or-self::*/@type)[last()]='task')]
[not((ancestor-or-self::*/@type)[last()]='reference')]
[not(@role='ancestor' or @role='next' or @role='previous')]
[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
">
          <p>
          <b>
             <xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Related information'"/>
               </xsl:call-template>
          </b><br clear="all"/>
   	  <xsl:apply-templates select="descendant::*
[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
[generate-id(.)=generate-id(key('link',concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1])]
[contains(@class, ' topic/link ')]
[not((ancestor-or-self::*/@role)[last()]='child')]
[not((ancestor-or-self::*/@role)[last()]='descendant')]
[not((ancestor-or-self::*/@type)[last()]='concept')]
[not((ancestor-or-self::*/@type)[last()]='task')]
[not((ancestor-or-self::*/@type)[last()]='reference')]
[not(@role='ancestor' or @role='next' or @role='previous')]
[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
"/>
          </p>
     </xsl:if>


     <!--linklists-->
     <xsl:apply-templates select="*[contains(@class,' topic/linklist ')]"/>
   </div>
</xsl:template>




<xsl:template name="sort-links-by-role">
   <xsl:param name="type">topic</xsl:param>
	<xsl:call-template name="create-links"><xsl:with-param name="role">parent</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="create-links"><xsl:with-param name="role">sibling</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="create-links"><xsl:with-param name="role">cousin</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="create-links"><xsl:with-param name="role">friend</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="create-links"><xsl:with-param name="role">other</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="create-links"><xsl:with-param name="role">none</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
</xsl:template>

	

<xsl:template name="create-links">
	<xsl:param name="type">topic</xsl:param>
	<xsl:param name="role">friend</xsl:param>

       <xsl:choose>
		<xsl:when test="$role='none'">
     		<xsl:apply-templates select="descendant::*
			[generate-id(.)=generate-id(key('link',concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1])]
			[contains(@class, ' topic/link ')]
			[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
			[not(ancestor-or-self::*/@role)]
			[(ancestor-or-self::*/@type)[last()]=$type]
			[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin'))]"
		/>
		</xsl:when>
		<xsl:otherwise>			
		     	<xsl:apply-templates select="descendant::*
			[not(ancestor-or-self::*[contains(@class,' topic/linklist ')])]
			[generate-id(.)=generate-id(key('link',concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1])]
			[contains(@class, ' topic/link ')]
			[(ancestor-or-self::*/@role)[last()]=$role]
			[(ancestor-or-self::*/@type)[last()]=$type]
			[not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin'))]"
		/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="*[contains(@class,' topic/link ')]"><!--???to do: split this into two templates, one for children, one not-->
  <xsl:param name="linktext">#none#</xsl:param>
  <xsl:variable name="file">
  <xsl:choose>
     <xsl:when test="starts-with(@href,'http://') and contains(@href,'#')"><xsl:value-of select="substring-before(@href,'#')"/></xsl:when>
     <xsl:when test="starts-with(@href,'http://')"><xsl:value-of select="@href"/></xsl:when>
     <xsl:when test="contains(@href,'#')"><xsl:value-of select="$WORKDIR"/><xsl:value-of select="substring-before(@href,'#')"/></xsl:when>
     <xsl:otherwise><xsl:value-of select="$WORKDIR"/><xsl:value-of select="@href"/></xsl:otherwise>
  </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicid">
     <xsl:choose>
          <xsl:when test="contains(@href,'#')"><xsl:value-of select="substring-after(@href,'#')"/></xsl:when>
          <xsl:otherwise>#none#</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicpos">
  <xsl:choose>
     <xsl:when test="starts-with(@href,'#')">samefile</xsl:when>
     <xsl:when test="contains(@href,'#')">otherfile</xsl:when>
     <xsl:otherwise>firstinfile</xsl:otherwise>
  </xsl:choose>
  </xsl:variable>

  <xsl:variable name="format">
     <xsl:choose>
          <xsl:when test="(ancestor-or-self::*/@format)"><xsl:value-of select="(ancestor-or-self::*/@format)[last()]"/></xsl:when>
          <xsl:otherwise>#none#</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <xsl:variable name="scope">
     <xsl:choose>
          <xsl:when test="(ancestor-or-self::*/@scope)"><xsl:value-of select="(ancestor-or-self::*/@scope)[last()]"/></xsl:when>
          <xsl:otherwise>#none#</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>



  <xsl:variable name="topictype">
     <xsl:choose>
          <xsl:when test="(ancestor-or-self::*/@type)"><xsl:value-of select="(ancestor-or-self::*/@type)[last()]"/></xsl:when>
          <xsl:otherwise>topic</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <xsl:variable name="classval"><xsl:text> </xsl:text><xsl:value-of select="$topictype"/>/<xsl:value-of select="$topictype"/><xsl:text> </xsl:text></xsl:variable>


  <xsl:choose>
     <xsl:when test="(ancestor-or-self::*/@role)[last()]='child' or (ancestor-or-self::*/@role)[last()]='descendant'">

          <div>
             <xsl:call-template name="setclass"/>
              <b><a>
               <xsl:attribute name="href">
                    <xsl:choose>
                         <xsl:when test="$topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/><xsl:call-template name="output-message">
                       <xsl:with-param name="msg">Unknown file extension on <xsl:value-of select="@href"/>. If this is a link to a non-DITA resource,
set the format attribute to the type of the resource. If it's a link to a DITA resource,
the file extension must be .<xsl:value-of select="$SRCEXT"/> .</xsl:with-param>
                       <xsl:with-param name="msgnum">030</xsl:with-param>
                       <xsl:with-param name="msgsev">E</xsl:with-param>
                     </xsl:call-template>
                         </xsl:otherwise>
                    </xsl:choose>
               </xsl:attribute>
               <xsl:if test="$scope='external' or $topictype='external' or (($format='PDF' or $format='pdf') and not($scope='local'))">
                <xsl:attribute name="target">_blank</xsl:attribute>
               </xsl:if>
          <xsl:call-template name="get-link-text">
          <xsl:with-param name="file"><xsl:value-of select="$file"/></xsl:with-param>
          <xsl:with-param name="topicid"><xsl:value-of select="$topicid"/></xsl:with-param>
          <xsl:with-param name="topictype"><xsl:value-of select="$topictype"/></xsl:with-param>
          <xsl:with-param name="topicpos"><xsl:value-of select="$topicpos"/></xsl:with-param>
          <xsl:with-param name="classval"><xsl:value-of select="$classval"/></xsl:with-param>
	  <xsl:with-param name="scope"><xsl:value-of select="$scope"/></xsl:with-param>
 	  <xsl:with-param name="format"><xsl:value-of select="$format"/></xsl:with-param>
          </xsl:call-template></a></b>

          <xsl:if test="$scope='external' or $topictype='external' or (($format='PDF' or $format='pdf') and not($scope='local' or $scope='peer'))">
           <!-- include user's XSL external link indicator -->
           <xsl:call-template name="gen-user-external-link"/>
          </xsl:if>
          <br clear="all"/>
          <xsl:call-template name="get-link-shortdesc">
          <xsl:with-param name="file"><xsl:value-of select="$file"/></xsl:with-param>
          <xsl:with-param name="topicid"><xsl:value-of select="$topicid"/></xsl:with-param>
          <xsl:with-param name="topictype"><xsl:value-of select="$topictype"/></xsl:with-param>
          <xsl:with-param name="topicpos"><xsl:value-of select="$topicpos"/></xsl:with-param>
          <xsl:with-param name="classval"><xsl:value-of select="$classval"/></xsl:with-param>
	  <xsl:with-param name="scope"><xsl:value-of select="$scope"/></xsl:with-param>
 	  <xsl:with-param name="format"><xsl:value-of select="$format"/></xsl:with-param>
          </xsl:call-template></div><br clear="all"/>

     </xsl:when>
     <xsl:otherwise>
          <a>
             <xsl:call-template name="setclass"/>
               <xsl:attribute name="href">
                    <xsl:choose>
                         <xsl:when test="$topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/><xsl:call-template name="output-message">
                       <xsl:with-param name="msg">Unknown file extension for <xsl:value-of select="@href"/>. If this is a link to a non-DITA resource,
set the format attribute to the type of the resource. If it's a link to a DITA resource,
the file extension must be .<xsl:value-of select="$SRCEXT"/> .</xsl:with-param>
                       <xsl:with-param name="msgnum">031</xsl:with-param>
                       <xsl:with-param name="msgsev">E</xsl:with-param>
                     </xsl:call-template>
                          </xsl:otherwise>
                    </xsl:choose>
               </xsl:attribute>
               <xsl:if test="$scope='external' or $topictype='external' or (($format='PDF' or $format='pdf') and not($scope='local'))">
                <xsl:attribute name="target">_blank</xsl:attribute>
               </xsl:if>
	<xsl:choose>
	 <xsl:when test="$linktext='#none#'">
          <xsl:attribute name="title"><!--??? should not add when empty-->
              <xsl:call-template name="get-link-shortdesc">
               <xsl:with-param name="file"><xsl:value-of select="$file"/></xsl:with-param>
               <xsl:with-param name="topicid"><xsl:value-of select="$topicid"/></xsl:with-param>
               <xsl:with-param name="topictype"><xsl:value-of select="$topictype"/></xsl:with-param>
               <xsl:with-param name="topicpos"><xsl:value-of select="$topicpos"/></xsl:with-param>
               <xsl:with-param name="classval"><xsl:value-of select="$classval"/></xsl:with-param>
	       <xsl:with-param name="scope"><xsl:value-of select="$scope"/></xsl:with-param>

 	       <xsl:with-param name="format"><xsl:value-of select="$format"/></xsl:with-param>
              </xsl:call-template>
          </xsl:attribute>
          <xsl:call-template name="get-link-text">
               <xsl:with-param name="file"><xsl:value-of select="$file"/></xsl:with-param>
               <xsl:with-param name="topicid"><xsl:value-of select="$topicid"/></xsl:with-param>
               <xsl:with-param name="topictype"><xsl:value-of select="$topictype"/></xsl:with-param>
               <xsl:with-param name="topicpos"><xsl:value-of select="$topicpos"/></xsl:with-param>
               <xsl:with-param name="classval"><xsl:value-of select="$classval"/></xsl:with-param>
  	       <xsl:with-param name="scope"><xsl:value-of select="$scope"/></xsl:with-param>
 	       <xsl:with-param name="format"><xsl:value-of select="$format"/></xsl:with-param>
          </xsl:call-template>
	 </xsl:when>
	 <xsl:otherwise>
		<!--using program-provided link text, like the arrows for next and prev, and moving actual link-text into alt text-->

          <xsl:attribute name="title"><!--??? should not add when empty-->
              <xsl:call-template name="get-link-text">
               <xsl:with-param name="file"><xsl:value-of select="$file"/></xsl:with-param>
               <xsl:with-param name="topicid"><xsl:value-of select="$topicid"/></xsl:with-param>
               <xsl:with-param name="topictype"><xsl:value-of select="$topictype"/></xsl:with-param>
               <xsl:with-param name="topicpos"><xsl:value-of select="$topicpos"/></xsl:with-param>
               <xsl:with-param name="classval"><xsl:value-of select="$classval"/></xsl:with-param>
	       <xsl:with-param name="scope"><xsl:value-of select="$scope"/></xsl:with-param>
 	       <xsl:with-param name="format"><xsl:value-of select="$format"/></xsl:with-param>
              </xsl:call-template>
          </xsl:attribute>
	  <xsl:value-of select="$linktext"/>
	 </xsl:otherwise>
	</xsl:choose>
	  </a>

          <xsl:if test="$scope='external' or $topictype='external' or (($format='PDF' or $format='pdf') and not($scope='local' or $scope='peer'))">
           <!-- include user's XSL external link indicator -->
           <xsl:call-template name="gen-user-external-link"/>
          </xsl:if>
	  <xsl:if test="$linktext='#none#' and not((ancestor-or-self::*/@role)[last()]='ancestor')">
	          <br clear="all"/>
	  </xsl:if>
     </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="get-link-text">
     <xsl:param name="file">file</xsl:param>
     <xsl:param name="topicid">topicid</xsl:param>
     <xsl:param name="topictype">topictype</xsl:param>
     <xsl:param name="topicpos">topicposition</xsl:param>
     <xsl:param name="classval">class value</xsl:param>
     <xsl:param name="format">#none#</xsl:param>
     <xsl:param name="scope">#none#</xsl:param>
     <xsl:variable name="root" select="/"/>
     <xsl:choose>
          <xsl:when test="*[contains(@class,' topic/linktext ')]"><xsl:value-of select="*[contains(@class,' topic/linktext ')]"/></xsl:when>
          <xsl:when test="$scope='external' or $scope='peer' or $topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)">
                    <xsl:choose>
                         <xsl:when test="$topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
	</xsl:when>
          <xsl:when test="$topicpos='samefile'">
            <xsl:choose>

               <xsl:when test="//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/title ')]">
               <xsl:value-of select="normalize-space(//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/title ')])"/>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="$topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target: <xsl:value-of select="$topicid"/> (topic in same file).
Make sure the link type (<xsl:value-of select="$topictype"/>)matches the target, and that the topic id is correct.</xsl:with-param>
             <xsl:with-param name="msgnum">032</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$topicpos='firstinfile'">
            <xsl:choose>
               <xsl:when test="document($file,$root)//*[contains(@class, $classval)][1]/*[contains(@class, ' topic/title ')]">
               <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, $classval)][1]/*[contains(@class, ' topic/title ')])"/>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="$topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target: <xsl:value-of select="$file"/> (first topic in target file).
Make sure the link type (<xsl:value-of select="$topictype"/>) matches the target. If the target is not accessible at
build time, define the link text in the link.</xsl:with-param>
             <xsl:with-param name="msgnum">033</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
            <xsl:choose>
               <xsl:when test="document($file,$root)//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/title ')]">
               <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/title ')])"/>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="$topictype='external' or not($format='#none#' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target topic "<xsl:value-of select="$topicid"/>" in target file <xsl:value-of select="$file"/> .
Make sure the link type (<xsl:value-of select="$topictype"/>) matches the target, and that the topic id is correct.
If the target is not accessible at build time, define the link text in the link.</xsl:with-param>
             <xsl:with-param name="msgnum">034</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
           <xsl:call-template name="output-message">  <!--this error msg should never appear, since all three vals for topicpos are tested, but including for completeness-->
             <xsl:with-param name="msg">Problem with link text retrieval. Check that the href attribute is correctly formed.</xsl:with-param>
             <xsl:with-param name="msgnum">035</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
       </xsl:otherwise>
     </xsl:choose>
</xsl:template>

<xsl:template name="get-link-shortdesc">
     <xsl:param name="file">file</xsl:param>
     <xsl:param name="topicid">file</xsl:param>
     <xsl:param name="topictype">file</xsl:param>
     <xsl:param name="topicpos">topicposition</xsl:param>
     <xsl:param name="classval">class value</xsl:param>
     <xsl:param name="format">#none#</xsl:param>
     <xsl:param name="scope">#none#</xsl:param>

     <xsl:variable name="root" select="/"/>
     <xsl:choose>
          <xsl:when test="*[contains(@class,' topic/desc ')]"><xsl:value-of select="*[contains(@class,' topic/desc ')]"/></xsl:when>
          <xsl:when test="$scope='external' or $scope='peer' or $topictype='external' or not($format='none' or translate($format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)"/><!--do nothing - no way to get desc from inaccessible or non-dita source-->
          <xsl:when test="$topicpos='samefile'">
          <xsl:choose>
               <xsl:when test="//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/shortdesc ')]">
                         <xsl:value-of select="normalize-space(//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/shortdesc ')])"/>
               </xsl:when>
               <xsl:otherwise><!--short desc not required - no error-->
               </xsl:otherwise>
          </xsl:choose>
          </xsl:when>
                <xsl:when test="$topicpos='firstinfile'">
          <xsl:choose>
               <xsl:when test="document($file,$root)//*[contains(@class, $classval)][1]/*[contains(@class, ' topic/shortdesc ')]">
                         <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, $classval)][1]/*[contains(@class, ' topic/shortdesc ')])"/>
               </xsl:when>
               <xsl:otherwise><!--short desc not required - no error-->
               </xsl:otherwise>
          </xsl:choose>
           </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
          <xsl:choose>
               <xsl:when test="document($file,$root)//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/shortdesc ')]">
                         <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/shortdesc ')])"/>
               </xsl:when>
               <xsl:otherwise><!--short desc not required - no error-->
               </xsl:otherwise>
          </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
           <xsl:call-template name="output-message">   <!--this error msg should never appear, since all three vals for topicpos are tested, but including for completeness-->
             <xsl:with-param name="msg">Problem with link description retrieval. Check that the href attribute is correctly formed.</xsl:with-param>
             <xsl:with-param name="msgnum">039</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
       </xsl:otherwise>
     </xsl:choose>
</xsl:template>


<xsl:template match="*[contains(@class,' topic/xref ')]">
  <xsl:variable name="root" select="/"/>
  <xsl:variable name="file">
  <xsl:choose>
     <xsl:when test="contains(@href,'#')"><xsl:value-of select="$WORKDIR"/><xsl:value-of select="substring-before(@href,'#')"/></xsl:when>
     <xsl:otherwise><xsl:value-of select="$WORKDIR"/><xsl:value-of select="@href"/></xsl:otherwise>
  </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicid">
  <xsl:choose>
     <xsl:when test="contains(@href,'#') and contains(substring-after(@href,'#'),'/')"><xsl:value-of select="substring-before(substring-after(@href,'#'),'/')"/></xsl:when>
     <xsl:when test="contains(@href,'#')"><xsl:value-of select="substring-after(@href,'#')"/></xsl:when>
     <xsl:otherwise>none</xsl:otherwise>
  </xsl:choose>
  </xsl:variable>

  <xsl:variable name="elemid">
    <xsl:choose>
     <xsl:when test="contains(@href,'#') and contains(substring-after(@href,'#'),'/')"><xsl:value-of select="substring-after(substring-after(@href,'#'),'/')"/></xsl:when>
     <xsl:otherwise>none</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicpos">
  <xsl:choose>
     <xsl:when test="starts-with(@href,'#')">samefile</xsl:when>
     <xsl:when test="contains(@href,'#')">otherfile</xsl:when>
     <xsl:otherwise>firstinfile</xsl:otherwise>
  </xsl:choose>
  </xsl:variable>

  <xsl:variable name="targettype"><!--check on target???-->
     <xsl:choose>
          <xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
          <xsl:otherwise>topic</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  
  <xsl:variable name="classval">
     <xsl:choose>
          <xsl:when test="@type='fig' or @type='figgroup' or @type='table' or @type='section' or @type='li' or @type='fn'"><xsl:text> </xsl:text>topic/<xsl:value-of select="$targettype"/><xsl:text> </xsl:text></xsl:when>
          <xsl:otherwise><xsl:text> </xsl:text><xsl:value-of select="$targettype"/>/<xsl:value-of select="$targettype"/><xsl:text> </xsl:text></xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <a>
    <xsl:call-template name="setclass"/>
     <xsl:attribute name="href">
          <xsl:choose>
	       <xsl:when test="(@format and not(translate(@format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)) or $targettype='external'"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
               <xsl:when test="starts-with(@href,'#')">#<xsl:value-of select="$topicid"/><xsl:if test="contains(substring-after(@href,'#'),'/')">__<xsl:value-of select="$elemid"/></xsl:if>
               </xsl:when>
               <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                    <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:if test="contains(@href,'#')">#<xsl:value-of select="$topicid"/></xsl:if><xsl:if test="contains(substring-after(@href,'#'),'/')">__<xsl:value-of select="$elemid"/></xsl:if>
               </xsl:when>
               <xsl:otherwise><xsl:value-of select="@href"/><xsl:call-template name="output-message">
                  <xsl:with-param name="msg">Unknown file extension for <xsl:value-of select="@href"/>. If this is a link to a non-DITA resource,
set the format attribute to the type of the resource. If it's a link to a DITA resource,
the file extension must be .<xsl:value-of select="$SRCEXT"/> .</xsl:with-param>
                  <xsl:with-param name="msgnum">040</xsl:with-param>
                  <xsl:with-param name="msgsev">E</xsl:with-param>
                </xsl:call-template>
                </xsl:otherwise>
          </xsl:choose>
     </xsl:attribute>
     <xsl:if test="@scope='external' or $targettype='external' or ((@format='PDF' or @format='pdf') and not(@scope='local' or @scope='peer'))">
      <xsl:attribute name="target">_blank</xsl:attribute>
     </xsl:if>
  <xsl:choose>
     <!-- Issue E002765 Image inside xref not giving correct output -->
      <xsl:when test="*"><xsl:apply-templates/></xsl:when>
      <xsl:when test="text()"><xsl:value-of select="."/></xsl:when>
      <xsl:when test="(@format and not(translate(@format,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=$SRCEXT)) or $targettype='external'"><xsl:value-of select="@href"/></xsl:when> <!-- adding local -->
      <xsl:when test="$targettype='fig' or $targettype='figgroup' or $targettype='table' or $targettype='section'">
       <xsl:choose>
          <xsl:when test="$topicpos='samefile' and //*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]/*[contains(@class,' topic/title ')]">
               <xsl:value-of select="normalize-space(//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]/*[contains(@class,' topic/title ')])"/>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile' and document($file,$root)//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]/*[contains(@class,' topic/title ')]">
               <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]/*[contains(@class,' topic/title ')])"/>
          </xsl:when>
          <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target. Make sure the link type matches the target,
the ids for topic and element are correct, and that the target has a title.
If the target is not accessible at build time, or does not have a title,
give the link text as content of the xref element.</xsl:with-param>
             <xsl:with-param name="msgnum">041</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
       </xsl:otherwise>
       </xsl:choose>
     </xsl:when>
     <xsl:when test="$targettype='li'">
       <xsl:choose>
          <xsl:when test="$topicpos='samefile' and //*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]">
               <xsl:apply-templates mode="xref" select="//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]"/>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile' and document($file,$root)//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]">
               <xsl:apply-templates mode="xref" select="document($file,$root)//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]"/>
          </xsl:when>
          <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to find the target to determine the list item number. Make sure the link type
matches the target, and that the ids for topic and element are correct.</xsl:with-param>
             <xsl:with-param name="msgnum">042</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
         </xsl:otherwise>
       </xsl:choose>
     </xsl:when>
     <xsl:when test="$targettype='fn'">
	<xsl:choose>
          <xsl:when test="$topicpos='samefile' and //*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]">
               <xsl:apply-templates select="//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]">
			<xsl:with-param name="xref">yes</xsl:with-param>
		</xsl:apply-templates>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile' and document($file,$root)//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]">
               <xsl:apply-templates select="document($file,$root)//*[contains(@class, ' topic/topic ')][@id=$topicid]/*[contains(@class,' topic/body ')]//*[contains(@class, $classval)][@id=$elemid]">
			<xsl:with-param name="xref">yes</xsl:with-param>
		</xsl:apply-templates>
          </xsl:when>
          <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to find the target to determine the footnote number. Make sure the link type
matches the target, and that the ids for topic and element are correct.</xsl:with-param>
             <xsl:with-param name="msgnum">042</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
       </xsl:otherwise>
	</xsl:choose>

     </xsl:when>
     <xsl:otherwise><!--topic-->
       <xsl:choose>
          <xsl:when test="$topicpos='samefile'">
            <xsl:choose>
               <xsl:when test="//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class,' topic/title ')]">
               <xsl:value-of select="normalize-space(//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class,' topic/title ')])"/>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target (topic in same file). Make sure the link type
matches the target, and that the id for the topic is correct.</xsl:with-param>
             <xsl:with-param name="msgnum">044</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
             <xsl:when test="$topicpos='firstinfile'">
            <xsl:choose>
               <xsl:when test="document($file,$root)//*[contains(@class, $classval)][1]/*[contains(@class, ' topic/title ')]">
               <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, $classval)][1]/*[contains(@class, ' topic/title ')])"/>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target (first topic in target file). Make sure the link type
matches the target, which is the first topic in the referenced file,
and that the referenced file is accessible. If the target is not accessible
at build time, give the link text as content of the xref element.</xsl:with-param>
             <xsl:with-param name="msgnum">045</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
            <xsl:choose>
               <xsl:when test="document($file,$root)//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/title ')]">
               <xsl:value-of select="normalize-space(document($file,$root)//*[contains(@class, $classval)][@id=$topicid]/*[contains(@class, ' topic/title ')])"/>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target (topic in target file). Make sure the link type
matches the target, that the id for the topic is correct, and that the file is
accessible. If the target is not accessible at build time, give the link text
as content of the xref element.</xsl:with-param>
             <xsl:with-param name="msgnum">046</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
                    <xsl:choose>
                         <xsl:when test="starts-with(@href,'#')"><xsl:value-of select="@href"/></xsl:when>
                         <xsl:when test="contains(@href,concat('.', $SRCEXT))">
                              <xsl:value-of select="substring-before(@href,concat('.', $SRCEXT))"/>.<xsl:value-of select="$OUTEXT"/><xsl:value-of select="substring-after(@href,concat('.', $SRCEXT))"/>
                         </xsl:when>
                         <xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
                    </xsl:choose> 
           <xsl:call-template name="output-message">
             <xsl:with-param name="msg">Unable to retrieve link text from target. Make sure the href is correctly formed and
can be used to reach the target. If the target is not a DITA resource,
make sure type="external" is set. If the target is not accessible at
build time, give the link text as content of the xref element.</xsl:with-param>
             <xsl:with-param name="msgnum">047</xsl:with-param>
             <xsl:with-param name="msgsev">E</xsl:with-param>
           </xsl:call-template>
       </xsl:otherwise>
       </xsl:choose>
     </xsl:otherwise>
  </xsl:choose>
  </a>
          <xsl:if test="@scope='external' or $targettype='external' or ((@format='PDF' or @format='pdf') and not(@scope='local' or @scope='peer'))">
   <!-- include user's XSL external link indicator -->
   <xsl:call-template name="gen-user-external-link"/>
  </xsl:if>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/linklist ')]">
   <xsl:choose>
     <xsl:when test="parent::*[contains(@class,' topic/related-links ')] and not(child::*[contains(@class,' topic/link ')][(ancestor-or-self::*/@role)[last()]='child' or (ancestor-or-self::*/@role)[last()]='descendant'])">
          <p>
            <xsl:call-template name="setclass"/>
	    <xsl:apply-templates select="*[contains(@class, ' topic/title ')]"/>
	    <xsl:apply-templates select="*[contains(@class,' topic/desc ')]"/>
	    <xsl:apply-templates select="*[contains(@class,' topic/linklist ')]|*[contains(@class,' topic/link ')]"/>
	    <xsl:apply-templates select="*[contains(@class,' topic/linkinfo ')]"/>
          </p>
     </xsl:when>
     <xsl:otherwise>
          <blockquote>
               <xsl:call-template name="setclass"/>
		  <xsl:apply-templates select="*[contains(@class, ' topic/title ')]"/>
		  <xsl:apply-templates select="*[contains(@class,' topic/desc ')]"/>
		  <xsl:apply-templates select="*[contains(@class,' topic/linklist ')]|*[contains(@class,' topic/link ')]"/>
		  <xsl:apply-templates select="*[contains(@class,' topic/linkinfo ')]"/>
          </blockquote>
     </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="*[contains(@class,' topic/linkinfo ')]">
  <xsl:apply-templates/><br clear="all"/>
</xsl:template>

<xsl:template match="*[contains(@class, ' topic/linklist ')]/*[contains(@class, ' topic/title ')]">
  <b><xsl:apply-templates/></b><br clear="all"/>
</xsl:template>

<xsl:template match="*[contains(@class, ' topic/linklist ')]/*[contains(@class, ' topic/desc ')]">
  <xsl:apply-templates/><br clear="all"/>
</xsl:template>

</xsl:stylesheet>

