<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Composite DITA topics to HTML
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- stylesheet imports -->
<xsl:import href="xslhtml/map2TOC.xsl"/>

<xsl:output
    method="text"
    encoding="UTF-8"
/>

<xsl:template match="*[contains(@class,' map/map ')]" mode="toctop">
  <xsl:text>[OPTIONS]
Compiled file=
Contents file=
Default Window=default
Full-text search=Yes
Display compile progress=No
Default topic=


[FILES]
</xsl:text>
  <xsl:apply-templates select="*[contains(@class,' map/topicref ')]"/>
</xsl:template>

<xsl:template match="*[contains(@class,' map/topicref ')]" mode="tocentry">
  <xsl:param name="infile"/>
  <xsl:param name="outroot"/>
  <xsl:param name="outfile"/>
  <xsl:param name="nodeID"/>
  <xsl:param name="isFirst"/>
  <xsl:param name="subtopicNodes"/>
  <xsl:param name="title"/>
  <xsl:if test="$isFirst">
    <xsl:if test="$outfile and $outfile!=''">
      <xsl:value-of select="$outfile"/>
      <xsl:text>
</xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$subtopicNodes"/>
  </xsl:if>
</xsl:template>

<!-- suppress default processing because title not used in project file -->
<xsl:template match="*[contains(@class,' map/topicref ')]" mode="title">
  <xsl:param name="isFirst"/>
  <xsl:param name="infile"/>
  <xsl:param name="nodeID"/>
  <xsl:param name="outfile"/>
</xsl:template>

</xsl:stylesheet>
