<?xml version="1.0" encoding="UTF-8" ?>
<!--  
 | Composite DITA topics to HTML
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 *-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- stylesheet imports -->
<xsl:import href="xslhtml/map2TOC.xsl"/>

<xsl:output
    method="xml"
    omit-xml-declaration="no"
    encoding="utf-8"
    indent="yes"
/>

<xsl:template match="*[contains(@class,' map/map ')]" mode="toctop">
  <toc label="{@title}">
    <xsl:apply-templates select="*[contains(@class,' map/topicref ')]"/>
  </toc>
</xsl:template>

<xsl:template match="*[contains(@class,' map/topicref ')]" mode="tocentry">
  <xsl:param name="infile"/>
  <xsl:param name="outroot"/>
  <xsl:param name="outfile"/>
  <xsl:param name="nodeID"/>
  <xsl:param name="isFirst"/>
  <xsl:param name="subtopicNodes"/>
  <xsl:param name="title"/>
  <topic label="{$title}">
    <xsl:if test="$outfile and $outfile!=''">
      <xsl:attribute name="href">
        <xsl:value-of select="$outfile"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates select="$subtopicNodes"/>
  </topic>
</xsl:template>

</xsl:stylesheet>
