<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://icl.com/saxon"
                extension-element-prefixes="saxon"
                >

<!-- idit2htm.xsl   main stylesheet
 | Convert DITA topic to HTML; "single topic to single web page"-level view
 |
 | Copyright IBM Corporation
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers.
E002790 Encoding is wrong in XHTML output
E002749 Don't need the DITA Generator comments at the top of the file
E002740 Switch to using Saxon's xhtml output setting. Better handling of single & empty tags. (br, meta, <b/>)
     -->

<!-- stylesheet imports -->
<!-- the main dita to xhtml converter -->
<xsl:import href="dit2htm.xsl"/>

<!-- the dita to xhtml converter for task documents -->
<xsl:import href="taskdisplay.xsl"/>

<!-- the dita to xhtml converter for reference documents -->
<xsl:import href="refdisplay.xsl"/>

<!-- user technologies domain -->
<xsl:import href="ut-d.xsl"/>

<!-- the dita to xhtml converter for element reference documents - not used now -->
<!--<xsl:import href="elementrefdisp.xsl"/>-->

<!-- Output XHTML with XML syntax, use UFT-8 encoding="UTF-8", transitional XHTML.
     Prevent indenting to conserve space on output. -->
<!-- <xsl:output method="xml" -->
<xsl:output method="saxon:xhtml"
            encoding="UTF-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>

<!-- root rule -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
