<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                version='1.0'>


<!-- =================== in-process conref support ==================== -->




<!--  CONREF (content fetched by id from conrefed element)  -->

<xsl:template match="*[@conref]" priority="10">
  <!--get element local name, parent topic's domains, and then file name, topic id, element id from conref value-->
  <xsl:variable name="element">
    <xsl:value-of select="local-name(.)"/>
  </xsl:variable>
  <xsl:variable name="domains">
    <!--xsl:value-of select="ancestor::*[contains(@class, ' topic/body ')]/parent::*/@domains"/-->
    <xsl:value-of select="ancestor-or-self::*[contains(@class, ' topic/topic ')][1]/@domains"/>
  </xsl:variable>
  <xsl:variable name="file">
    <xsl:choose>
       <xsl:when test="contains(@conref,'#')"><xsl:value-of select="$WORKDIR"/><xsl:value-of select="substring-before(@conref,'#')"/></xsl:when>
       <xsl:otherwise><xsl:value-of select="$WORKDIR"/><xsl:value-of select="@conref"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicid">
    <xsl:choose>
       <xsl:when test="contains(@conref,'#') and contains(substring-after(@conref,'#'),'/')"><xsl:value-of select="substring-before(substring-after(@conref,'#'),'/')"/></xsl:when>
       <xsl:when test="contains(@conref,'#')"><xsl:value-of select="substring-after(@conref,'#')"/></xsl:when>
       <xsl:otherwise>none</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="elemid">
    <xsl:choose>
     <xsl:when test="contains(@conref,'#') and contains(substring-after(@conref,'#'),'/')"><xsl:value-of select="substring-after(substring-after(@conref,'#'),'/')"/></xsl:when>
     <xsl:otherwise>none</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="topicpos">
    <xsl:choose>
       <xsl:when test="starts-with(@conref,'#')">samefile</xsl:when>
       <xsl:when test="contains(@conref,'#')">otherfile</xsl:when>
       <xsl:otherwise>firstinfile</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!--xsl:variable name="DBG">no</xsl:variable-->
  <xsl:if test="$DBG='yes'">
    <xsl:call-template name="output-message">
      <xsl:with-param name="msg">Conref trace: </xsl:with-param>
      <xsl:with-param name="msgnum">006</xsl:with-param>
      <xsl:with-param name="msgsev">I</xsl:with-param>
    </xsl:call-template>
    <xsl:message> Element: <xsl:value-of select="name()"/>:<xsl:value-of select="$element"/></xsl:message>
    <xsl:message> Domains: <xsl:value-of select="$domains"/></xsl:message>
    <xsl:message> Working dir: <xsl:value-of select="$WORKDIR"/></xsl:message>
    <xsl:message> File: <xsl:value-of select="$file"/></xsl:message>
    <xsl:message> Topicid: <xsl:value-of select="$topicid"/></xsl:message>
    <xsl:message> Elemid: <xsl:value-of select="$elemid"/></xsl:message>
    <xsl:message> Topic location: <xsl:value-of select="$topicpos"/></xsl:message>
  </xsl:if>

  <xsl:choose>
     <xsl:when test="contains(substring-after(@conref,'#'),'/')"><!--targetting an element inside a topic-->
       <xsl:choose>
          <xsl:when test="$topicpos='samefile'">
            <xsl:apply-templates select="//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains]/*[contains(@class, ' topic/body ')]//*[local-name()=$element][@id=$elemid]"/>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
            <xsl:apply-templates select="document($file,/)//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains]/*[contains(@class, ' topic/body ')]//*[local-name()=$element][@id=$elemid]"/>
          </xsl:when>
          <xsl:otherwise/><!-- error msg -->
       </xsl:choose>
     </xsl:when>
     <xsl:otherwise><!--assume targetting a topic-->
       <xsl:choose>
          <xsl:when test="$topicpos='samefile'">
            <xsl:apply-templates select="//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains][local-name()=$element]"/>
          </xsl:when>
          <xsl:when test="$topicpos='otherfile'">
            <xsl:apply-templates select="document($file,/)//*[contains(@class, ' topic/topic ')][@id=$topicid][@domains=$domains][local-name()=$element]"/>
          </xsl:when>
          <xsl:when test="$topicpos='firstinfile'">
            <xsl:apply-templates select="document($file,/)//*[contains(@class, ' topic/topic ')][1][@domains=$domains][local-name()=$element]"/>
          </xsl:when>
          <xsl:otherwise/><!-- error msg -->
       </xsl:choose>
     </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- =================== end of conref support ====================== -->



</xsl:stylesheet>
