<?xml version="1.0" encoding="UTF-8" ?>
<!--  domains.xsl
 | DITA domains support for the demo set; extend as needed
 |
 | (C) Copyright IBM Corporation 2001, 2004. All Rights Reserved.
 | This file is part of the DITA package on IBM's developerWorks site.
 | See license.txt for disclaimers and permissions.
 +
 | updates:
 |  Added ui-d screen (new element)
 *-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- the specific processing for syntax diagram markup is now in this
     external file, which enables selection of variant output forms -->

<xsl:include href="syntax-braces.xsl"/>
<!--xsl:include href="syntax-svg.xsl"/-->


<!-- Start of UI domain -->

<xsl:template match="*[contains(@class,' ui-d/uicontrol ')]">
  <!-- insert an arrow before all but the first uicontrol in a menucascade -->
  <xsl:if test="ancestor::*[contains(@class,' ui-d/menucascade ')]">
    <xsl:variable name="uicontrolcount"><xsl:number count="*[contains(@class,' ui-d/uicontrol ')]"/></xsl:variable>
    <xsl:if test="$uicontrolcount&gt;'1'">
      <xsl:text> --> </xsl:text>
    </xsl:if>
  </xsl:if>
  <b>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:apply-templates/>
  </b>
</xsl:template>


<xsl:template match="*[contains(@class,' ui-d/wintitle ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:apply-templates/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' ui-d/menucascade ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:apply-templates/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' ui-d/shortcut ')]">
  <u>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:apply-templates/>
  </u>
</xsl:template>


<xsl:template match="*[contains(@class,' ui-d/screen ')]">
  <xsl:if test="contains(@frame,'top')"><hr /></xsl:if>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="gen-att-label"/>
  <pre>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:if test="@scale">
      <xsl:attribute name="style">font-size: <xsl:value-of select="@scale"/>%;</xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </pre>
  <xsl:if test="contains(@frame,'bot')"><hr /></xsl:if>
</xsl:template>


<!-- start of highlighting domain -->

<xsl:template match="*[contains(@class,' hi-d/b ')]">
  <b>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </b>
</xsl:template>


<xsl:template match="*[contains(@class,' hi-d/i ')]">
  <i>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </i>
</xsl:template>


<xsl:template match="*[contains(@class,' hi-d/u ')]">
  <u>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </u>
</xsl:template>


<xsl:template match="*[contains(@class,' hi-d/tt ')]">
  <tt>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </tt>
</xsl:template>


<xsl:template match="*[contains(@class,' hi-d/sup ')]">
  <sup>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:apply-templates/>
  </sup>
</xsl:template>


<xsl:template match="*[contains(@class,' hi-d/sub ')]">
  <sub>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:apply-templates/>
  </sub>
</xsl:template>


<!-- start of programming domain -->

<xsl:template match="*[contains(@class,' pr-d/codeph ')]">
  <code>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </code>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/codeblock ')]">
  <xsl:if test="contains(@frame,'top')"><hr /></xsl:if>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="gen-att-label"/>
  <pre>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:if test="@scale">
      <xsl:attribute name="style">font-size: <xsl:value-of select="@scale"/>%;</xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </pre>
  <xsl:if test="contains(@frame,'bot')"><hr /></xsl:if>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/option ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/var ')]">
  <var>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </var>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/parmname ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/synph ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/oper ')]">
  <kbd>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </kbd>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/delim ')]">
  <kbd>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </kbd>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/sep ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>



<xsl:template match="*[contains(@class,' pr-d/apiname ')]">
  <kbd>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </kbd>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/parml ')]">
  <xsl:call-template name="gen-att-label"/>
  <dl>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@compact"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </dl>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/plentry ')]">
  <xsl:apply-templates/>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/pt ')]">
  <dt>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <!-- create a potentially linkable target for associative link possibilities -->
    <!--a name="pl_{.}"><xsl:apply-templates/></a-->
    <b><xsl:call-template name="apply-for-phrases"/></b>
  </dt>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/pd ')]">
  <dd>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:apply-templates/>
  </dd>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/repsep ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' pr-d/kwd ')]">
  <kbd>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </kbd>
</xsl:template>







<!-- start of software domain elements -->

<xsl:template match="*[contains(@class,' sw-d/msgph ')]">
  <code>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </code>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/msgblock ')]">
  <xsl:if test="contains(@frame,'top')"><hr /></xsl:if>
  <xsl:call-template name="flagit"/>
  <xsl:call-template name="gen-att-label"/>
  <pre>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:if test="@scale">
      <xsl:attribute name="style">font-size: <xsl:value-of select="@scale"/>%;</xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </pre>
  <xsl:if test="contains(@frame,'bot')"><hr /></xsl:if>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/msgnum ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/cmdname ')]">
  <span>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </span>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/varname ')]">
  <var>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </var>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/filepath ')]">
  <tt>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </tt>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/userinput ')]">
  <kbd>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </kbd>
</xsl:template>


<xsl:template match="*[contains(@class,' sw-d/systemoutput ')]">
  <code>
    <xsl:call-template name="setclass"/>
    <xsl:apply-templates select="@id"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="apply-for-phrases"/>
  </code>
</xsl:template>


<!-- Start of UT domain -->

<xsl:template match="*[contains(@class,' ut-d/imagemap ')]">
  <img id="{generate-id()}">
   <xsl:attribute name="src"><xsl:value-of select="*[contains(@class,' ut-d/image ')]/@href"/></xsl:attribute>
   <xsl:attribute name="alt"><xsl:value-of select="*[contains(@class,' ut-d/image ')]/@alt"/></xsl:attribute>
   </img>
  <map usemap="{generate-id()}">
    <xsl:apply-templates select="area"/>
  </map>
</xsl:template>

<!--xsl:template match="*[contains(@class,' ut-d/area ')]">
  <area>
    <xsl:attribute name="href"><xsl:value-of select="*[contains(@class,' ut-d/xref ')]/@href"/></xsl:attribute>
    <xsl:attribute name="shape"><xsl:value-of select="*[contains(@class,' ut-d/shape ')]"/></xsl:attribute>
    <xsl:attribute name="coords"><xsl:value-of select="*[contains(@class,' ut-d/coords ')]"/></xsl:attribute>
  </area>
</xsl:template-->


</xsl:stylesheet>

