CREATE TABLE CITIES
   (
      CITY_ID          INTEGER NOT NULL constraint cities_pk primary key,
      CITY_NAME        VARCHAR(24) NOT NULL,
      COUNTRY          VARCHAR(26) NOT NULL,
      AIRPORT          VARCHAR(26),
      LANGUAGE         VARCHAR(16),
      COUNTRY_ISO_CODE CHAR(2) 
   );

insert into CITIES VALUES (1,'Amsterdam','Netherlands','AMS','Dutch','NL');
insert into CITIES VALUES (2,'Athens','Greece','ATH','Greek','GR');
insert into CITIES VALUES (3,'Auckland','New Zealand','AKL','English','NZ');
insert into CITIES VALUES (4,'Beirut','Lebanon','BEY','Arabic','LB');
insert into CITIES VALUES (5,'Bogota','Colombia','BOG','Spanish','CO');
insert into CITIES VALUES (6,'Bombay','India','BOM','Hindi','IN');
insert into CITIES VALUES (7,'Budapest','Hungary','BUD','Hungarian','HU');
insert into CITIES VALUES (8,'Buenos Aires','Argentina','BUE','Spanish','AR');
insert into CITIES VALUES (9,'Cairo','Egypt','CAI','Arabic','EG');
insert into CITIES VALUES (10,'Calcutta','India','CCU','Bengali','IN');
insert into CITIES VALUES (11,'Cape Town','South Africa','CPT','English','ZA');
insert into CITIES VALUES (12,'Caracas','Venezuela','CCS','Spanish','VE');
insert into CITIES VALUES (13,'Casablanca','Morocco','CAS','Arabic','MA');
insert into CITIES VALUES (14,'Copenhagen','Denmark','CPH','Danish','DK');
insert into CITIES VALUES (15,'Dublin','Ireland','DUB','English','IE');
insert into CITIES VALUES (16,'Geneva','Switzerland','GVA','French','CH');
insert into CITIES VALUES (17,'Hong Kong','China','HKG','Chinese','CN');
insert into CITIES VALUES (18,'Istanbul','Turkey','IST','Turkish','TR');
insert into CITIES VALUES (19,'Jakarta','Indonesia','JKT','Indonesian','ID');
insert into CITIES VALUES (20,'Kabul','Afghanistan','KBL','Pashto','AF');
insert into CITIES VALUES (21,'Karachi','Pakistan','KHI','Punjabi','PK');
insert into CITIES VALUES (22,'Lagos','Nigeria','LOS','English','NG');
insert into CITIES VALUES (23,'Lima','Peru','LIM','Spanish','PE');
insert into CITIES VALUES (24,'Lisbon','Portugal','LIS','Portuguese','PT');
insert into CITIES VALUES (25,'London','United Kingdom','LHR','English','GB');
insert into CITIES VALUES (26,'Madrid','Spain','MAD','Spanish','ES');
insert into CITIES VALUES (27,'Manila','Philippines','MNL','Tagalog','PH');
insert into CITIES VALUES (28,'Melbourne','Australia','MEL','English','AU');
insert into CITIES VALUES (29,'Mexico City','Mexico','MEX','Spanish','MX');
insert into CITIES VALUES (30,'Montreal','Canada','YUL','French','CA');
insert into CITIES VALUES (31,'Moscow','Russia','SVO','Russian','RU');
insert into CITIES VALUES (32,'Nairobi','Kenya','NBO','English','KE');
insert into CITIES VALUES (33,'Osaka','Japan','OSA','Japanese','JP');
insert into CITIES VALUES (34,'Oslo','Norway','OSL','Norwegian','NO');
insert into CITIES VALUES (35,'Paris','France','CDG','French','FR');
insert into CITIES VALUES (36,'Prague','Czech Republic','PRG','Czech','CZ');
insert into CITIES VALUES (37,'Reykjavik','Iceland','REY','Icelandic','IS');
insert into CITIES VALUES (38,'Rio de Janeiro','Brazil','GIG','Portuguese','BR');
insert into CITIES VALUES (39,'Rome','Italy','FCO','Italian','IT');
insert into CITIES VALUES (40,'Santiago','Chile','SCL','Spanish','CL');
insert into CITIES VALUES (41,'Sao Paulo','Brazil','GRU','Portuguese','BR');
insert into CITIES VALUES (42,'Seoul','Korea, Republic of','SEL','Korean','KR');
insert into CITIES VALUES (43,'Shanghai','China','SHA','Chinese','CN');
insert into CITIES VALUES (44,'Singapore','Singapore','SIN','Malay','SG');
insert into CITIES VALUES (45,'Stockholm','Sweden','ARN','Swedish','SE');
insert into CITIES VALUES (46,'Sydney','Australia','SYD','English','AU');
insert into CITIES VALUES (47,'San Jose','United States','SJC','English','US');
insert into CITIES VALUES (48,'Tehran','Iran','THR','Farsi','IR');
insert into CITIES VALUES (49,'Tokyo','Japan','NRT','Japanese','JP');
insert into CITIES VALUES (50,'Toronto','Canada','YYZ','English','CA');
insert into CITIES VALUES (51,'Warsaw','Poland','WAW','Polish','PL');
insert into CITIES VALUES (52,'Albany','United States','ALB','English','US');
insert into CITIES VALUES (53,'Albuquerque','United States','ABQ','English','US');
insert into CITIES VALUES (54,'Atlanta','United States','ATL','English','US');
insert into CITIES VALUES (55,'Boise','United States','BOI','English','US');
insert into CITIES VALUES (56,'Boston','United States','BOS','English','US');
insert into CITIES VALUES (57,'Charleston','United States','CHS','English','US');
insert into CITIES VALUES (58,'Chicago','United States','MDW','English','US');
insert into CITIES VALUES (59,'Cleveland','United States','CLE','English','US');
insert into CITIES VALUES (60,'Dallas','United States','DFW','English','US');
insert into CITIES VALUES (61,'Denver','United States','DEN','English','US');
insert into CITIES VALUES (62,'Des Moines','United States','DSM','English','US');
insert into CITIES VALUES (63,'Fairbanks','United States','FAI','English','US');
insert into CITIES VALUES (64,'Helena','United States','HLN','English','US');
insert into CITIES VALUES (65,'Honolulu','United States','HNL','English','US');
insert into CITIES VALUES (66,'Houston','United States','HOU','English','US');
insert into CITIES VALUES (67,'Juneau','United States','JNU','English','US');
insert into CITIES VALUES (68,'Kansas City','United States','MCI','English','US');
insert into CITIES VALUES (69,'Los Angeles','United States','LAX','English','US');
insert into CITIES VALUES (70,'Memphis','United States','MEM','English','US');
insert into CITIES VALUES (71,'Miami','United States','MIA','English','US');
insert into CITIES VALUES (72,'Milwaukee','United States','MKE','English','US');
insert into CITIES VALUES (73,'Minneapolis','United States','MSP','English','US');
insert into CITIES VALUES (74,'Nashville','United States','BNA','English','US');
insert into CITIES VALUES (75,'New Orleans','United States','MSY','English','US');
insert into CITIES VALUES (76,'New York','United States','JFK','English','US');
insert into CITIES VALUES (77,'Oklahoma City','United States','OKC','English','US');
insert into CITIES VALUES (78,'Philadelphia','United States','PHL','English','US');
insert into CITIES VALUES (79,'Phoenix','United States','PHX','English','US');
insert into CITIES VALUES (80,'Saint Louis','United States','STL','English','US');
insert into CITIES VALUES (81,'Salt Lake City','United States','SLC','English','US');
insert into CITIES VALUES (82,'San Antonio','United States','SAT','English','US');
insert into CITIES VALUES (83,'San Diego','United States','SAN','English','US');
insert into CITIES VALUES (84,'San Francisco','United States','SFO','English','US');
insert into CITIES VALUES (85,'San Juan','United States','SJU','Spanish','US');
insert into CITIES VALUES (86,'Seattle','United States','SEA','English','US');
insert into CITIES VALUES (87,'Washington, DC','United States','IAD','English','US');

CREATE INDEX city_airport_idx on CITIES (AIRPORT);

CREATE TABLE FLIGHTS
   (
      FLIGHT_ID      CHAR(6) NOT NULL,
      SEGMENT_NUMBER INTEGER NOT NULL,
      ORIG_AIRPORT   CHAR(3),
      DEPART_TIME    TIME,
      DEST_AIRPORT   CHAR(3),
      ARRIVE_TIME    TIME,
      MEAL           CHAR(1) CONSTRAINT MEAL_CONSTRAINT 
                        CHECK (meal IN ('B', 'L', 'D', 'S')),
      FLYING_TIME    DOUBLE PRECISION,
      MILES          INTEGER,
      AIRCRAFT       VARCHAR(6),
      DEPART_DATE	 DATE,
      CONSTRAINT FLIGHTS_PK Primary Key (FLIGHT_ID)
   );

insert into FLIGHTS values ('AA1111',1,'ABQ','09:00:00','LAX','09:19:00','S',1.328,664,'B747', null); 
insert into FLIGHTS values ('AA1112',1,'LAX','09:00:00','ABQ','11:19:00','S',1.328,664,'B747', null); 
insert into FLIGHTS values ('AA1113',1,'ABQ','09:00:00','PHX','09:39:00','S',0.658,329,'B747', null); 
insert into FLIGHTS values ('AA1114',1,'PHX','09:00:00','ABQ','09:39:00','S',0.658,329,'B747', null); 
insert into FLIGHTS values ('AA1115',1,'ABQ','09:00:00','OKC','11:02:00','B',1.034,517,'B747', null); 
insert into FLIGHTS values ('AA1116',1,'OKC','09:00:00','ABQ','09:02:00','B',1.034,517,'B747', null); 
insert into FLIGHTS values ('AA1117',1,'AKL','09:00:00','HNL','18:48:00','L',8.804,4402,'B747', null); 
insert into FLIGHTS values ('AA1118',1,'HNL','13:30:00','AKL','21:18:00','D',8.804,4402,'DC10', null); 
insert into FLIGHTS values ('AA1119',1,'AKL','09:00:00','NRT','15:59:00','L',10.996,5498,'B747', null); 
insert into FLIGHTS values ('AA1120',1,'NRT','09:00:00','AKL','23:59:00','L',10.996,5498,'B747', null); 
insert into FLIGHTS values ('AA1121',1,'AKL','09:00:00','SYD','09:40:00','B',2.682,1341,'B747', null); 
insert into FLIGHTS values ('AA1122',1,'SYD','09:00:00','AKL','13:40:00','L',2.682,1341,'B747', null); 
insert into FLIGHTS values ('AA1123',1,'ALB','09:00:00','JFK','09:16:00','S',0.27,135,'DC10', null); 
insert into FLIGHTS values ('AA1124',1,'JFK','09:00:00','ALB','09:16:00','S',0.27,135,'DC10', null); 
insert into FLIGHTS values ('AA1125',1,'ALB','07:00:00','BOS','07:16:00','S',0.278,139,'B747', null); 
insert into FLIGHTS values ('AA1126',1,'BOS','14:00:00','ALB','14:16:00','S',0.278,139,'B747', null); 
insert into FLIGHTS values ('AA1127',1,'ALB','09:00:00','IAD','09:32:00','S',0.548,274,'B747', null); 
insert into FLIGHTS values ('AA1128',1,'IAD','09:00:00','ALB','09:32:00','S',0.548,274,'B747', null); 
insert into FLIGHTS values ('US1517',1,'AMS','09:00:00','JFK','10:17:00','B',7.296,3648,'B747', null); 

insert into FLIGHTS values ('AA1131',1,'AMS','09:00:00','ATH','12:41:00','L',2.688,1344,'B747', null); 
insert into FLIGHTS values ('AA1132',1,'ATH','09:00:00','AMS','10:41:00','B',2.688,1344,'B747', null); 
insert into FLIGHTS values ('AA1133',1,'AMS','09:00:00','CDG','09:31:00','S',0.532,266,'B747', null); 
insert into FLIGHTS values ('AA1134',1,'CDG','09:00:00','AMS','09:31:00','S',0.532,266,'B747', null); 
insert into FLIGHTS values ('AA1135',1,'ARN','09:00:00','BOS','11:07:00','L',8.126,4063,'B747', null); 
insert into FLIGHTS values ('AA1136',1,'BOS','22:00:00','ARN','12:07:00','L',8.126,4063,'B747', null); 
insert into FLIGHTS values ('AA1137',1,'ARN','09:00:00','SVO','12:51:00','B',1.858,929,'A320', null); 

insert into FLIGHTS values ('AA1139',1,'ARN','09:00:00','CPH','09:59:00','S',0.988,494,'B747', null); 
insert into FLIGHTS values ('AA1140',1,'CPH','09:00:00','ARN','09:59:00','S',0.988,494,'B747', null); 
insert into FLIGHTS values ('AA1141',1,'ATH','09:00:00','LHR','09:58:00','B',2.974,1487,'B747', null); 
insert into FLIGHTS values ('AA1142',1,'LHR','09:00:00','ATH','13:58:00','L',2.974,1487,'B747', null); 
insert into FLIGHTS values ('AA1143',1,'ATH','09:00:00','CAI','10:23:00','B',1.394,697,'B747', null); 
insert into FLIGHTS values ('AA1144',1,'CAI','09:00:00','ATH','10:23:00','B',1.394,697,'B747', null); 
insert into FLIGHTS values ('AA1145',1,'ATH','09:00:00','CDG','10:36:00','B',2.608,1304,'B747', null); 
insert into FLIGHTS values ('AA1146',1,'CDG','09:00:00','ATH','12:36:00','L',2.608,1304,'B747', null); 
insert into FLIGHTS values ('AA1147',1,'ATL','09:00:00','LAX','09:52:00','B',3.87,1935,'B747', null); 
insert into FLIGHTS values ('AA1148',1,'LAX','09:00:00','ATL','15:52:00','L',3.87,1935,'B747', null); 
insert into FLIGHTS values ('AA1149',1,'ATL','09:00:00','DFW','09:26:00','B',1.442,721,'B747', null); 
insert into FLIGHTS values ('AA1150',1,'DFW','09:00:00','ATL','11:26:00','B',1.442,721,'B747', null); 
insert into FLIGHTS values ('AA1151',1,'ATL','09:00:00','SEA','10:21:00','B',4.36,2180,'B747', null); 
insert into FLIGHTS values ('AA1152',1,'SEA','12:00:00','ATL','19:21:00','L',4.36,2180,'B747', null); 
insert into FLIGHTS values ('AA1153',1,'BEY','09:00:00','CAI','09:43:00','S',0.726,363,'B747', null); 
insert into FLIGHTS values ('AA1154',1,'CAI','11:00:00','BEY','11:43:00','S',0.726,363,'B747', null); 
insert into FLIGHTS values ('AA1270',1,'BEY','09:00:00','MAD','12:22:00','L',4.376,2188,'B747', null); 

insert into FLIGHTS values ('AA1157',1,'BEY','09:00:00','BOM','17:31:00','L',5.026,2513,'B747', null); 
insert into FLIGHTS values ('AA1158',1,'BOM','09:00:00','BEY','10:31:00','L',5.026,2513,'B747', null); 
insert into FLIGHTS values ('AA1159',1,'BNA','09:00:00','MIA','11:37:00','B',1.63,815,'B747', null); 
insert into FLIGHTS values ('AA1160',1,'MIA','09:00:00','BNA','09:37:00','B',1.63,815,'B747', null); 
insert into FLIGHTS values ('AA1161',1,'BNA','09:00:00','JFK','11:31:00','L',1.518,759,'B747', null); 
insert into FLIGHTS values ('AA1162',1,'JFK','09:00:00','BNA','09:31:00','L',1.518,759,'B747', null); 
insert into FLIGHTS values ('AA1163',1,'BNA','09:00:00','CHS','10:54:00','B',0.91,455,'B747', null); 
insert into FLIGHTS values ('AA1164',1,'GIG','09:00:00','BNA','15:57:00','L',9.964,4982,'B747', null); 
insert into FLIGHTS values ('US1591',1,'BOG','09:00:00','MIA','12:02:00','L',3.04,1520,'DC10', null); 

insert into FLIGHTS values ('AA1167',1,'BOG','09:00:00','LIM','11:20:00','B',2.338,1169,'B747', null); 
insert into FLIGHTS values ('AA1168',1,'LIM','08:00:00','BOG','10:20:00','B',2.338,1169,'B747', null); 
insert into FLIGHTS values ('AA1169',1,'BOG','09:00:00','GIG','16:38:00','L',5.648,2824,'B747', null); 
insert into FLIGHTS values ('AA1170',1,'GIG','09:00:00','BOG','12:38:00','L',5.648,2824,'B747', null); 
insert into FLIGHTS values ('AA1171',1,'BOI','09:00:00','SEA','08:48:00','S',0.808,404,'B747', null); 
insert into FLIGHTS values ('AA1172',1,'SEA','09:00:00','BOI','10:48:00','S',0.808,404,'B747', null); 
insert into FLIGHTS values ('AA1173',1,'BOI','09:00:00','DSM','12:18:00','L',2.31,1155,'A320', null); 
insert into FLIGHTS values ('AA1174',1,'DSM','09:00:00','BOI','10:18:00','B',2.31,1155,'A320', null); 
insert into FLIGHTS values ('AA1175',1,'BOI','09:00:00','HLN','09:34:00','S',0.58,290,'B747', null); 
insert into FLIGHTS values ('AA1176',1,'HLN','09:00:00','BOI','09:34:00','S',0.58,290,'B747', null); 
insert into FLIGHTS values ('AA1177',1,'BOM','09:00:00','CCU','11:03:00','B',2.066,1033,'B747', null); 
insert into FLIGHTS values ('AA1178',1,'CCU','09:00:00','BOM','11:03:00','B',2.066,1033,'B747', null); 
insert into FLIGHTS values ('AA1179',1,'BOM','09:00:00','KHI','09:36:00','B',1.102,551,'B747', null); 
insert into FLIGHTS values ('AA1180',1,'KHI','09:00:00','BOM','10:36:00','B',1.102,551,'B747', null); 
insert into FLIGHTS values ('AA1181',1,'BOM','09:00:00','HKG','16:51:00','L',5.354,2677,'B747', null); 

insert into FLIGHTS values ('AA1183',1,'BOS','09:00:00','SFO','11:23:00','L',5.39,2695,'B747', null); 
insert into FLIGHTS values ('AA1184',1,'SFO','09:00:00','BOS','17:23:00','L',5.39,2695,'B747', null); 
insert into FLIGHTS values ('AA1185',1,'BOS','09:00:00','MIA','11:31:00','B',2.518,1259,'B747', null); 

insert into FLIGHTS values ('AA1187',1,'BOS','09:00:00','IAD','09:29:00','S',0.49,245,'B747', null); 
insert into FLIGHTS values ('AA1188',1,'IAD','09:00:00','BOS','09:29:00','S',0.49,245,'B747', null); 
insert into FLIGHTS values ('AA1189',1,'BUD','09:00:00','GVA','10:13:00','B',1.232,616,'B747', null); 
insert into FLIGHTS values ('AA1190',1,'GVA','09:00:00','BUD','10:13:00','B',1.232,616,'B747', null); 
insert into FLIGHTS values ('AA1191',1,'BUD','09:00:00','SVO','12:56:00','L',1.946,973,'B747', null); 
insert into FLIGHTS values ('AA1192',1,'SVO','09:00:00','BUD','08:56:00','B',1.946,973,'B747', null); 
insert into FLIGHTS values ('AA1193',1,'BUD','09:00:00','FCO','10:00:00','B',1.008,504,'B747', null); 
insert into FLIGHTS values ('AA1194',1,'FCO','09:00:00','BUD','10:00:00','B',1.008,504,'B747', null); 
insert into FLIGHTS values ('AA1195',1,'CAI','09:00:00','CAS','11:33:00','B',4.562,2281,'B747', null); 
insert into FLIGHTS values ('AA1196',1,'MIA','09:00:00','CAI','04:59:00','D',12.984,6492,'B747', null); 
insert into FLIGHTS values ('AA1197',1,'CAI','09:00:00','IST','10:32:00','B',1.538,769,'B747', null); 
insert into FLIGHTS values ('AA1198',1,'IST','09:00:00','CAI','10:32:00','B',1.538,769,'B747', null); 
insert into FLIGHTS values ('AA1199',1,'CAI','09:00:00','KBL','16:27:00','L',4.454,2227,'B747', null); 
insert into FLIGHTS values ('AA1200',1,'GIG','09:00:00','CAI','02:18:00','D',12.308,6154,'B747', null); 
insert into FLIGHTS values ('AA1201',1,'CAS','09:00:00','KHI','22:54:00','L',8.9,4450,'B747', null); 
insert into FLIGHTS values ('AA1202',1,'KHI','09:00:00','CAS','12:54:00','L',8.9,4450,'B747', null); 
insert into FLIGHTS values ('AA1203',1,'CAS','09:00:00','LOS','14:00:00','L',4.006,2003,'B747', null); 
insert into FLIGHTS values ('AA1204',1,'LOS','09:00:00','CAS','12:00:00','L',4.006,2003,'B747', null); 
insert into FLIGHTS values ('AA1205',1,'CAS','09:00:00','MAD','11:02:00','B',1.036,518,'B747', null); 
insert into FLIGHTS values ('AA1206',1,'MAD','09:00:00','CAS','09:02:00','B',1.036,518,'B747', null); 
insert into FLIGHTS values ('AA1207',1,'CCS','09:00:00','SCL','16:05:00','L',6.098,3049,'B747', null); 
insert into FLIGHTS values ('AA1208',1,'SCL','09:00:00','CCS','14:05:00','L',6.098,3049,'B747', null); 
insert into FLIGHTS values ('AA1209',1,'CCS','09:00:00','MEX','11:28:00','L',4.47,2235,'B747', null); 
insert into FLIGHTS values ('AA1210',1,'MEX','09:00:00','CCS','15:28:00','L',4.47,2235,'B747', null); 
insert into FLIGHTS values ('AA1211',1,'CCS','09:00:00','BUE','17:20:00','L',6.336,3168,'B747', null); 
insert into FLIGHTS values ('AA1212',1,'BUE','09:00:00','CCS','13:20:00','L',6.336,3168,'B747', null); 
insert into FLIGHTS values ('AA1213',1,'CCU','09:00:00','HKG','14:47:00','L',3.294,1647,'B747', null); 
insert into FLIGHTS values ('AA1214',2,'HKG','10:30:00','CCU','11:17:00','L',3.294,1647,'B747', null); 
insert into FLIGHTS values ('AA1215',1,'CCU','09:00:00','NRT','18:53:00','L',6.396,3198,'B747', null); 
insert into FLIGHTS values ('AA1216',1,'NRT','09:00:00','CCU','11:53:00','L',6.396,3198,'B747', null); 
insert into FLIGHTS values ('AA1217',1,'CCU','09:00:00','SIN','15:06:00','L',3.6,1800,'B747', null); 
insert into FLIGHTS values ('AA1218',1,'SIN','09:00:00','CCU','10:06:00','L',3.6,1800,'B747', null); 
insert into FLIGHTS values ('AA1219',1,'CDG','09:00:00','LHR','08:25:00','S',0.422,211,'B747', null); 
insert into FLIGHTS values ('AA1220',1,'LHR','09:00:00','CDG','10:25:00','S',0.422,211,'B747', null); 
insert into FLIGHTS values ('AA1221',1,'CDG','18:00:00','JFK','19:15:00','D',7.258,3629,'B747', null); 
insert into FLIGHTS values ('AA1222',1,'JFK','09:00:00','CDG','22:15:00','L',7.258,3629,'B747', null); 

insert into FLIGHTS values ('AA1224',1,'SVO','09:00:00','CDG','10:05:00','B',3.09,1545,'B747', null); 
insert into FLIGHTS values ('AA1225',1,'CHS','09:00:00','ATL','09:31:00','S',0.532,266,'B747', null); 
insert into FLIGHTS values ('AA1226',1,'ATL','09:00:00','CHS','09:31:00','S',0.532,266,'B747', null); 
insert into FLIGHTS values ('AA1227',1,'CHS','11:00:00','MCI','11:51:00','S',1.856,928,'B747', null); 
insert into FLIGHTS values ('AA1228',1,'MCI','09:00:00','CHS','11:51:00','L',1.856,928,'B747', null); 
insert into FLIGHTS values ('AA1229',1,'CHS','09:00:00','MSY','09:15:00','L',1.256,628,'B747', null); 
insert into FLIGHTS values ('AA1230',1,'MSY','09:00:00','CHS','11:15:00','L',1.256,628,'B747', null); 
insert into FLIGHTS values ('AA1231',1,'CLE','09:00:00','LAX','10:05:00','L',4.092,2046,'B747', null); 
insert into FLIGHTS values ('AA1232',1,'LAX','09:00:00','CLE','16:05:00','L',4.092,2046,'B747', null); 
insert into FLIGHTS values ('AA1233',1,'CLE','09:00:00','DFW','10:03:00','L',2.052,1026,'B747', null); 
insert into FLIGHTS values ('AA1234',1,'DFW','09:00:00','CLE','12:03:00','L',2.052,1026,'B747', null); 
insert into FLIGHTS values ('AA1235',1,'CLE','09:00:00','MDW','08:37:00','S',0.618,309,'B747', null); 
insert into FLIGHTS values ('AA1236',1,'MDW','09:00:00','CLE','10:37:00','S',0.618,309,'B747', null); 
insert into FLIGHTS values ('AA1237',1,'CPH','09:00:00','FCO','10:54:00','L',1.904,952,'B747', null); 
insert into FLIGHTS values ('AA1238',1,'FCO','09:00:00','CPH','10:54:00','L',1.904,952,'B747', null); 
insert into FLIGHTS values ('AA1239',1,'CPH','09:00:00','REY','10:37:00','L',2.622,1311,'B747', null); 
insert into FLIGHTS values ('AA1240',1,'REY','09:00:00','CPH','12:37:00','L',2.622,1311,'B747', null); 
insert into FLIGHTS values ('AA1241',1,'CPH','09:00:00','CDG','10:16:00','L',1.276,638,'B747', null); 
insert into FLIGHTS values ('AA1242',1,'CDG','09:00:00','CPH','10:16:00','L',1.276,638,'B747', null); 
insert into FLIGHTS values ('AA1243',1,'CPT','09:00:00','LOS','13:55:00','L',5.92,2960,'B747', null); 
insert into FLIGHTS values ('AA1244',1,'LOS','09:00:00','CPT','15:55:00','L',5.92,2960,'B747', null); 
insert into FLIGHTS values ('AA1245',1,'CPT','09:00:00','NBO','15:06:00','L',5.102,2551,'DC10', null); 
insert into FLIGHTS values ('AA1246',1,'NBO','09:00:00','CPT','13:06:00','L',5.102,2551,'DC10', null); 
insert into FLIGHTS values ('AA1247',1,'CPT','09:00:00','LHR','19:01:00','L',12.026,6013,'B747', null); 
insert into FLIGHTS values ('AA1248',1,'LHR','09:00:00','CPT','23:01:00','L',12.026,6013,'B747', null); 

insert into FLIGHTS values ('AA1250',1,'SEA','09:00:00','DEN','12:02:00','L',2.04,1020,'B747', null); 

insert into FLIGHTS values ('AA1252',1,'BOI','09:00:00','DEN','10:16:00','L',1.276,638,'B747', null); 
insert into FLIGHTS values ('AA1253',1,'DEN','09:00:00','JFK','14:15:00','L',3.258,1629,'B747', null); 
insert into FLIGHTS values ('AA1254',1,'JFK','09:00:00','DEN','10:15:00','L',3.258,1629,'B747', null); 
insert into FLIGHTS values ('AA1255',1,'DFW','09:00:00','SAT','09:30:00','S',0.506,253,'B747', null); 
insert into FLIGHTS values ('AA1256',1,'SAT','09:00:00','DFW','09:30:00','S',0.506,253,'B747', null); 
insert into FLIGHTS values ('AA1257',1,'DFW','09:00:00','ATL','11:26:00','L',1.442,721,'B747', null); 

insert into FLIGHTS values ('AA1259',1,'DFW','09:00:00','MIA','12:13:00','L',2.218,1109,'B747', null); 
insert into FLIGHTS values ('AA1260',1,'MIA','09:00:00','DFW','10:13:00','L',2.218,1109,'B747', null); 
insert into FLIGHTS values ('AA1261',1,'DSM','09:00:00','MDW','09:36:00','S',0.612,306,'B747', null); 
insert into FLIGHTS values ('AA1262',1,'MDW','09:00:00','DSM','09:36:00','S',0.612,306,'B747', null); 
insert into FLIGHTS values ('AA1263',1,'DSM','09:00:00','SLC','09:53:00','L',1.9,950,'B747', null); 
insert into FLIGHTS values ('AA1264',1,'SLC','09:00:00','DSM','11:53:00','L',1.9,950,'B747', null); 
insert into FLIGHTS values ('AA1265',1,'DSM','09:00:00','OKC','09:56:00','L',0.94,470,'B747', null); 
insert into FLIGHTS values ('AA1266',1,'OKC','09:00:00','DSM','09:56:00','L',0.94,470,'B747', null); 
insert into FLIGHTS values ('AA1267',1,'DUB','09:00:00','LHR','09:34:00','S',0.574,287,'B747', null); 
insert into FLIGHTS values ('AA1268',1,'LHR','09:00:00','DUB','09:34:00','S',0.574,287,'B747', null); 
insert into FLIGHTS values ('AA1269',1,'DUB','09:00:00','MAD','11:48:00','L',1.804,902,'B747', null); 
 
insert into FLIGHTS values ('AA1271',1,'DUB','09:00:00','CDG','10:57:00','L',0.966,483,'B747', null); 
insert into FLIGHTS values ('AA1272',1,'CDG','09:00:00','DUB','08:57:00','L',0.966,483,'B747', null); 
insert into FLIGHTS values ('AA1273',1,'BUE','09:00:00','SCL','09:24:00','L',1.408,704,'B747', null); 
insert into FLIGHTS values ('AA1274',1,'SCL','09:00:00','BUE','11:24:00','L',1.408,704,'B747', null); 
insert into FLIGHTS values ('AA1275',1,'BUE','09:00:00','GRU','10:05:00','L',2.09,1045,'B747', null); 
insert into FLIGHTS values ('AA1276',1,'GRU','09:00:00','BUE','12:05:00','L',2.09,1045,'B747', null); 
insert into FLIGHTS values ('US1509',1,'BUE','23:00:00','MIA','04:49:00','L',8.826,4413,'B747', null); 
 
insert into FLIGHTS values ('AA1279',1,'FAI','09:00:00','JNU','10:15:00','L',1.254,627,'B747', null); 
insert into FLIGHTS values ('AA1280',1,'JNU','09:00:00','FAI','10:15:00','L',1.254,627,'B747', null); 
insert into FLIGHTS values ('AA1281',1,'FAI','09:00:00','SEA','13:02:00','L',3.038,1519,'B747', null); 
insert into FLIGHTS values ('AA1282',1,'SEA','09:00:00','FAI','11:02:00','L',3.038,1519,'B747', null); 
insert into FLIGHTS values ('US1443',1,'FAI','09:00:00','NRT','10:01:00','L',7.026,3513,'B747', null); 

insert into FLIGHTS values ('AA1285',1,'FCO','09:00:00','CDG','10:22:00','L',1.376,688,'B747', null); 
insert into FLIGHTS values ('AA1286',1,'CDG','09:00:00','FCO','10:22:00','L',1.376,688,'B747', null); 
insert into FLIGHTS values ('AA1287',1,'FCO','09:00:00','CAI','12:39:00','L',2.654,1327,'B747', null); 
insert into FLIGHTS values ('AA1288',1,'CAI','09:00:00','FCO','10:39:00','L',2.654,1327,'B747', null); 
insert into FLIGHTS values ('AA1289',1,'FCO','13:00:00','JFK','15:34:00','L',8.57,4285,'B747', null); 
insert into FLIGHTS values ('AA1290',1,'JFK','23:00:00','FCO','13:34:00','L',8.57,4285,'B747', null); 
insert into FLIGHTS values ('AA1291',1,'GIG','13:00:00','MIA','19:22:00','L',8.37,4185,'B747', null); 
insert into FLIGHTS values ('AA1292',1,'MIA','13:00:00','GIG','23:22:00','L',8.37,4185,'B747', null); 
insert into FLIGHTS values ('AA1293',1,'GIG','09:00:00','LIM','11:41:00','L',4.694,2347,'B747', null); 
insert into FLIGHTS values ('AA1294',1,'LIM','15:00:00','GIG','21:41:00','L',4.694,2347,'B747', null); 
insert into FLIGHTS values ('AA1295',1,'GIG','09:00:00','BUE','12:26:00','L',2.44,1220,'B747', null); 
insert into FLIGHTS values ('AA1296',1,'BUE','09:00:00','GIG','10:26:00','L',2.44,1220,'B747', null); 
insert into FLIGHTS values ('US1249',1,'GRU','09:00:00','CCS','13:26:00','L',5.448,2724,'B747', null); 
insert into FLIGHTS values ('US1250',1,'CCS','09:00:00','GRU','15:26:00','L',5.448,2724,'B747', null); 
insert into FLIGHTS values ('US1251',1,'GRU','09:00:00','JFK','16:33:00','L',9.556,4778,'B747', null); 
insert into FLIGHTS values ('US1252',1,'JFK','09:00:00','GRU','20:33:00','L',9.556,4778,'B747', null); 
insert into FLIGHTS values ('US1253',1,'GRU','09:00:00','LAX','16:19:00','L',12.322,6161,'B747', null); 
insert into FLIGHTS values ('US1254',1,'LAX','09:00:00','GRU','02:19:00','L',12.322,6161,'B747', null); 
insert into FLIGHTS values ('AA1053',1,'GRU','09:00:00','LIM','11:17:00','L',4.298,2149,'B747', null); 
insert into FLIGHTS values ('AA1054',1,'LIM','14:00:00','GRU','20:17:00','L',4.298,2149,'B747', null); 
insert into FLIGHTS values ('US1255',1,'GVA','09:00:00','CPH','10:25:00','L',1.422,711,'B747', null); 
insert into FLIGHTS values ('US1256',1,'CPH','09:00:00','GVA','10:25:00','L',1.422,711,'B747', null); 
insert into FLIGHTS values ('US1257',1,'GVA','09:00:00','LIS','09:52:00','L',1.868,934,'B747', null); 
insert into FLIGHTS values ('US1258',1,'LIS','09:00:00','GVA','11:52:00','L',1.868,934,'B747', null); 
insert into FLIGHTS values ('US1259',1,'GVA','09:00:00','OSL','10:56:00','L',1.934,967,'B747', null); 
insert into FLIGHTS values ('US1260',1,'OSL','09:00:00','GVA','10:56:00','L',1.934,967,'B747', null); 
 
insert into FLIGHTS values ('AA1182',1,'SHA','09:00:00','HKG','10:30:00','L',1.514,757,'B747', null); 
 
insert into FLIGHTS values ('US1264',1,'SIN','09:00:00','HKG','12:12:00','L',3.214,1607,'B747', null); 
 
insert into FLIGHTS values ('US1266',1,'SEL','09:00:00','HKG','10:36:00','L',2.612,1306,'B747', null); 
insert into FLIGHTS values ('US1267',1,'HLN','09:00:00','SEA','08:58:00','L',0.978,489,'B747', null); 
insert into FLIGHTS values ('US1268',1,'SEA','09:00:00','HLN','10:58:00','L',0.978,489,'B747', null); 
insert into FLIGHTS values ('US1269',1,'HLN','09:00:00','BOI','09:34:00','S',0.58,290,'B747', null); 
insert into FLIGHTS values ('US1270',1,'BOI','09:00:00','HLN','09:34:00','S',0.58,290,'B747', null); 
insert into FLIGHTS values ('US1271',1,'HLN','09:00:00','DEN','10:11:00','L',1.184,592,'B747', null); 
insert into FLIGHTS values ('US1272',1,'DEN','09:00:00','HLN','10:11:00','L',1.184,592,'B747', null); 

insert into FLIGHTS values ('US1274',1,'NRT','09:00:00','HNL','21:42:00','L',7.708,3854,'B747', null); 

insert into FLIGHTS values ('US1276',1,'SFO','09:00:00','HNL','11:47:00','L',4.794,2397,'B747', null); 
insert into FLIGHTS values ('US1277',1,'HNL','13:00:00','SYD','20:09:00','L',10.16,5080,'B747', null); 
insert into FLIGHTS values ('US1278',1,'SYD','09:00:00','HNL','22:09:00','L',10.16,5080,'B747', null); 
insert into FLIGHTS values ('AA1251',1,'HOU','09:00:00','DEN','09:45:00','L',1.756,878,'B747', null); 

insert into FLIGHTS values ('US1281',1,'HOU','09:00:00','SAT','09:22:00','S',0.378,189,'B747', null); 
insert into FLIGHTS values ('US1282',1,'SAT','09:00:00','HOU','09:22:00','S',0.378,189,'B747', null); 
insert into FLIGHTS values ('US1283',1,'HOU','09:00:00','IAD','12:56:00','L',2.936,1468,'B747', null); 
insert into FLIGHTS values ('US1284',1,'IAD','09:00:00','HOU','10:56:00','L',2.936,1468,'B747', null); 
insert into FLIGHTS values ('US1285',1,'IAD','09:00:00','BOS','09:29:00','S',0.49,245,'B747', null); 
insert into FLIGHTS values ('US1286',1,'BOS','09:00:00','IAD','09:29:00','S',0.49,245,'B747', null); 
insert into FLIGHTS values ('US1287',1,'IAD','09:00:00','MSP','09:49:00','L',1.83,915,'B747', null); 
insert into FLIGHTS values ('US1288',1,'MSP','09:00:00','IAD','11:49:00','L',1.83,915,'B747', null); 
insert into FLIGHTS values ('US1289',1,'IAD','09:00:00','MIA','11:02:00','L',2.048,1024,'B747', null); 
insert into FLIGHTS values ('US1290',1,'MIA','09:00:00','IAD','11:02:00','L',2.048,1024,'B747', null); 
insert into FLIGHTS values ('US1291',1,'IST','09:00:00','THR','13:02:00','L',2.538,1269,'B747', null); 
insert into FLIGHTS values ('US1292',1,'THR','09:00:00','IST','10:02:00','L',2.538,1269,'B747', null); 
insert into FLIGHTS values ('US1293',1,'IST','09:00:00','FCO','09:42:00','L',1.71,855,'B747', null); 
insert into FLIGHTS values ('US1294',1,'FCO','09:00:00','IST','11:42:00','L',1.71,855,'B747', null); 
insert into FLIGHTS values ('US1295',1,'IST','09:00:00','ATH','09:41:00','S',0.698,349,'B747', null); 
insert into FLIGHTS values ('US1296',1,'ATH','09:00:00','IST','09:41:00','S',0.698,349,'B747', null); 
 
insert into FLIGHTS values ('US1382',1,'CDG','09:00:00','JFK','10:15:00','L',7.258,3629,'B747', null); 
 
insert into FLIGHTS values ('US1300',1,'LAX','09:00:00','JFK','16:53:00','L',4.896,2448,'B747', null); 
insert into FLIGHTS values ('US1301',1,'JFK','09:00:00','GRU','20:33:00','L',9.556,4778,'B747', null); 
insert into FLIGHTS values ('US1302',1,'GRU','09:00:00','JFK','16:33:00','L',9.556,4778,'B747', null); 
insert into FLIGHTS values ('US1303',1,'JKT','09:00:00','HKG','14:03:00','L',4.054,2027,'B747', null); 
insert into FLIGHTS values ('US1304',1,'HKG','09:00:00','JKT','12:03:00','L',4.054,2027,'B747', null); 

insert into FLIGHTS values ('US1307',1,'SYD','09:00:00','JKT','11:50:00','L',6.844,3422,'B747', null); 
 
insert into FLIGHTS values ('US1308',1,'TPE','09:00:00','JKT','12:44:00','L',4.748,2374,'B747', null); 
insert into FLIGHTS values ('US1309',1,'JNU','09:00:00','SEA','11:46:00','L',1.782,891,'B747', null); 
insert into FLIGHTS values ('US1310',1,'SEA','09:00:00','JNU','09:46:00','L',1.782,891,'B747', null); 
insert into FLIGHTS values ('US1311',1,'JNU','09:00:00','SFO','13:02:00','L',3.034,1517,'B747', null); 
insert into FLIGHTS values ('US1312',1,'SFO','09:00:00','JNU','11:02:00','L',3.034,1517,'B747', null); 
insert into FLIGHTS values ('US1313',1,'JNU','09:00:00','HNL','13:37:00','L',5.626,2813,'B747', null); 
insert into FLIGHTS values ('US1314',1,'HNL','09:00:00','JNU','15:37:00','L',5.626,2813,'B747', null); 
insert into FLIGHTS values ('US1315',1,'KBL','09:00:00','KHI','10:21:00','L',1.358,679,'B747', null); 
insert into FLIGHTS values ('US1316',1,'KHI','09:00:00','KBL','10:21:00','L',1.358,679,'B747', null); 
insert into FLIGHTS values ('US1317',1,'KBL','09:00:00','IST','10:26:00','L',4.448,2224,'B747', null); 
insert into FLIGHTS values ('US1318',1,'IST','09:00:00','KBL','16:26:00','L',4.448,2224,'B747', null); 
 
insert into FLIGHTS values ('AA1138',1,'SVO','09:00:00','KBL','15:11:00','L',4.192,2096,'A320', null); 
insert into FLIGHTS values ('US1321',1,'KHI','09:00:00','IST','10:54:00','L',4.9,2450,'B747', null); 
insert into FLIGHTS values ('US1322',1,'IST','09:00:00','KHI','16:54:00','L',4.9,2450,'B747', null); 
insert into FLIGHTS values ('US1323',1,'KHI','09:00:00','IST','10:54:00','L',4.9,2450,'B747', null); 
insert into FLIGHTS values ('US1324',1,'IST','09:00:00','KHI','16:54:00','L',4.9,2450,'B747', null); 
insert into FLIGHTS values ('US1325',1,'KHI','09:00:00','THR','09:53:00','L',2.384,1192,'B747', null); 
insert into FLIGHTS values ('US1326',1,'THR','09:00:00','KHI','12:53:00','L',2.384,1192,'B747', null); 
insert into FLIGHTS values ('US1327',1,'LAX','09:00:00','HNL','12:07:00','L',5.124,2562,'B747', null); 
insert into FLIGHTS values ('US1328',1,'HNL','09:00:00','LAX','16:07:00','L',5.124,2562,'B747', null); 
insert into FLIGHTS values ('US1329',1,'LAX','09:00:00','GRU','02:19:00','L',12.322,6161,'B747', null); 
insert into FLIGHTS values ('US1330',1,'GRU','09:00:00','LAX','16:19:00','L',12.322,6161,'B747', null); 
insert into FLIGHTS values ('US1331',1,'LAX','09:00:00','NRT','12:57:00','L',10.956,5478,'B747', null); 
insert into FLIGHTS values ('US1332',1,'NRT','09:00:00','LAX','02:57:00','L',10.956,5478,'B747', null); 
insert into FLIGHTS values ('US1333',1,'LHR','09:00:00','WAW','11:47:00','L',1.798,899,'B747', null); 
insert into FLIGHTS values ('US1334',1,'WAW','09:00:00','LHR','09:47:00','L',1.798,899,'B747', null); 
insert into FLIGHTS values ('US1335',1,'LHR','09:00:00','YYZ','11:06:00','L',7.106,3553,'B747', null); 
insert into FLIGHTS values ('US1336',1,'YYZ','09:00:00','LHR','21:06:00','L',7.106,3553,'B747', null); 
insert into FLIGHTS values ('US1337',1,'LHR','09:00:00','NBO','20:28:00','L',8.48,4240,'B747', null); 
insert into FLIGHTS values ('US1338',1,'NBO','09:00:00','LHR','14:28:00','L',8.48,4240,'B747', null); 

insert into FLIGHTS values ('US1340',1,'MIA','09:00:00','LIM','14:15:00','L',5.25,2625,'B747', null); 
 
insert into FLIGHTS values ('US1339',1,'MIA','18:00:00','LIM','23:15:00','L',5.25,2625,'B747', null); 
 
insert into FLIGHTS values ('US1342',1,'BUE','09:00:00','LIM','09:53:00','L',3.896,1948,'B747', null); 

insert into FLIGHTS values ('US1344',1,'BOG','09:00:00','LIM','11:20:00','L',2.338,1169,'B747', null); 
insert into FLIGHTS values ('US1345',1,'LIS','09:00:00','CDG','11:48:00','L',1.806,903,'B747', null); 
insert into FLIGHTS values ('US1346',1,'CDG','09:00:00','LIS','09:48:00','L',1.806,903,'B747', null); 
insert into FLIGHTS values ('US1347',1,'LIS','09:00:00','CAS','09:43:00','S',0.73,365,'B747', null); 
insert into FLIGHTS values ('US1348',1,'CAS','09:00:00','LIS','09:43:00','S',0.73,365,'B747', null); 
insert into FLIGHTS values ('US1349',1,'LIS','09:00:00','JFK','10:44:00','L',6.744,3372,'B747', null); 
 
insert into FLIGHTS values ('AA1223',1,'LOS','09:00:00','CDG','14:52:00','L',5.868,2934,'B747', null); 

insert into FLIGHTS values ('US1353',1,'LOS','09:00:00','MAD','13:46:00','L',4.776,2388,'B747', null); 
insert into FLIGHTS values ('US1354',1,'MAD','09:00:00','LOS','13:46:00','L',4.776,2388,'B747', null); 
insert into FLIGHTS values ('US1355',1,'LOS','09:00:00','ATH','15:03:00','L',5.054,2527,'B747', null); 
insert into FLIGHTS values ('US1356',1,'ATH','09:00:00','LOS','13:03:00','L',5.054,2527,'B747', null); 

insert into FLIGHTS values ('US1358',1,'CDG','09:00:00','MAD','10:18:00','L',1.31,655,'B747', null); 
 
insert into FLIGHTS values ('US1357',1,'CAS','09:00:00','MAD','11:02:00','L',1.036,518,'B747', null); 
insert into FLIGHTS values ('US1361',1,'MAD','09:00:00','JFK','10:10:00','L',7.178,3589,'B747', null); 
insert into FLIGHTS values ('US1362',1,'JFK','09:00:00','MAD','22:10:00','L',7.178,3589,'B747', null); 
insert into FLIGHTS values ('US1363',1,'MCI','09:00:00','LAX','09:42:00','L',2.71,1355,'B747', null); 
insert into FLIGHTS values ('US1364',1,'LAX','09:00:00','MCI','13:42:00','L',2.71,1355,'B747', null); 
insert into FLIGHTS values ('US1365',1,'MCI','09:00:00','DFW','09:54:00','L',0.908,454,'B747', null); 
insert into FLIGHTS values ('US1366',1,'DFW','09:00:00','MCI','09:54:00','L',0.908,454,'B747', null); 
insert into FLIGHTS values ('US1367',1,'MCI','09:00:00','JFK','12:11:00','L',2.19,1095,'B747', null); 
insert into FLIGHTS values ('US1368',1,'JFK','09:00:00','MCI','10:11:00','L',2.19,1095,'B747', null); 

insert into FLIGHTS values ('US1380',1,'LAX','09:00:00','MDW','14:28:00','L',3.482,1741,'B747', null); 

insert into FLIGHTS values ('US1474',1,'JFK','11:00:00','MDW','11:25:00','L',1.428,714,'B747', null); 
insert into FLIGHTS values ('US1383',1,'MDW','12:15:00','ATL','14:25:00','L',1.174,587,'B747', null); 
insert into FLIGHTS values ('US1384',1,'ATL','11:30:00','MDW','11:40:00','L',1.174,587,'B747', null); 
insert into FLIGHTS values ('US1385',1,'MEL','09:00:00','SYD','09:52:00','L',0.882,441,'B747', null); 
insert into FLIGHTS values ('US1386',1,'SYD','09:00:00','MEL','09:52:00','L',0.882,441,'B747', null); 
insert into FLIGHTS values ('US1387',1,'MEL','09:00:00','SIN','13:32:00','L',7.536,3768,'B747', null); 
insert into FLIGHTS values ('US1389',1,'MEL','09:00:00','HNL','23:02:00','L',11.044,5522,'B747', null); 
insert into FLIGHTS values ('US1390',1,'HNL','12:45:00','MEL','20:47:00','L',11.044,5522,'B747', null); 
insert into FLIGHTS values ('US1391',1,'MEM','09:00:00','MIA','11:44:00','L',1.742,871,'B747', null); 
insert into FLIGHTS values ('US1392',1,'MIA','09:00:00','MEM','09:44:00','L',1.742,871,'B747', null); 
insert into FLIGHTS values ('US1393',1,'MEM','09:00:00','JFK','11:54:00','L',1.908,954,'B747', null); 
insert into FLIGHTS values ('US1394',1,'JFK','09:00:00','MEM','09:54:00','L',1.908,954,'B747', null); 
insert into FLIGHTS values ('US1395',1,'MEM','09:00:00','LAX','10:12:00','L',3.202,1601,'B747', null); 
insert into FLIGHTS values ('US1396',1,'LAX','09:00:00','MEM','14:12:00','L',3.202,1601,'B747', null); 
insert into FLIGHTS values ('US1397',1,'MEX','09:00:00','SFO','10:46:00','L',3.78,1890,'B747', null); 
insert into FLIGHTS values ('US1398',1,'SFO','09:00:00','MEX','14:46:00','L',3.78,1890,'B747', null); 
insert into FLIGHTS values ('US1399',1,'MEX','15:00:00','LAX','16:06:00','S',3.1,1550,'B747', null); 
insert into FLIGHTS values ('US1400',1,'LAX','09:00:00','MEX','14:06:00','L',3.1,1550,'B747', null); 
insert into FLIGHTS values ('US1401',1,'MEX','09:00:00','BOG','13:57:00','L',3.95,1975,'B747', null); 
insert into FLIGHTS values ('US1402',1,'BOG','09:00:00','MEX','11:57:00','L',3.95,1975,'B747', null); 
insert into FLIGHTS values ('US1403',1,'MIA','18:00:00','GRU','04:10:00','L',8.172,4086,'B747', null); 
insert into FLIGHTS values ('US1404',1,'GRU','23:00:00','MIA','05:10:00','L',8.172,4086,'B747', null); 
insert into FLIGHTS values ('US1405',1,'MIA','17:30:00','LAX','19:10:00','D',4.67,2335,'B747', null); 
insert into FLIGHTS values ('US1406',1,'LAX','08:00:00','MIA','15:40:00','L',4.67,2335,'B747', null); 
insert into FLIGHTS values ('US1407',1,'MIA','09:00:00','JFK','11:11:00','L',2.184,1092,'B747', null); 
insert into FLIGHTS values ('US1408',1,'JFK','09:00:00','MIA','11:11:00','L',2.184,1092,'B747', null); 
insert into FLIGHTS values ('US1409',1,'MKE','09:00:00','JFK','11:27:00','L',1.466,733,'B747', null); 
insert into FLIGHTS values ('US1410',1,'JFK','09:00:00','MKE','09:27:00','L',1.466,733,'B747', null); 
insert into FLIGHTS values ('US1411',1,'MKE','09:00:00','MDW','09:09:00','S',0.166,83,'B747', null); 
insert into FLIGHTS values ('US1412',1,'MDW','09:00:00','MKE','09:09:00','S',0.166,83,'B747', null); 
insert into FLIGHTS values ('US1413',1,'MKE','09:00:00','JFK','11:27:00','L',1.466,733,'B747', null); 
insert into FLIGHTS values ('US1414',1,'JFK','09:00:00','MKE','09:27:00','L',1.466,733,'B747', null); 
insert into FLIGHTS values ('US1415',1,'MNL','09:00:00','SYD','19:47:00','L',7.794,3897,'B747', null); 
insert into FLIGHTS values ('US1416',1,'SYD','09:00:00','MNL','13:47:00','L',7.794,3897,'B747', null); 
insert into FLIGHTS values ('US1417',1,'MNL','09:00:00','TPE','10:26:00','L',1.448,724,'B747', null); 
insert into FLIGHTS values ('US1418',1,'TPE','09:00:00','MNL','10:26:00','L',1.448,724,'B747', null); 
insert into FLIGHTS values ('US1419',1,'MNL','09:00:00','SIN','11:58:00','L',2.978,1489,'B747', null); 
insert into FLIGHTS values ('AA1419',1,'MNL','12:00:00','HKG','13:23:00','L',1.388,694,'B747', null); 

insert into FLIGHTS values ('AA1421',1,'MNL','07:00:00','HNL','23:36:00','B',10.604,5302,'B747', null); 
insert into FLIGHTS values ('AA1249',1,'MSP','09:00:00','DEN','09:52:00','L',1.882,941,'B747', null); 
insert into FLIGHTS values ('US1423',1,'MSP','09:00:00','MDW','09:25:00','S',0.43,215,'B747', null); 
insert into FLIGHTS values ('US1424',1,'MDW','09:00:00','MSP','09:25:00','S',0.43,215,'B747', null); 
insert into FLIGHTS values ('AA1423',1,'MDW','08:00:00','MIA','11:22:00','L',2.376,1188,'B747', null); 
insert into FLIGHTS values ('AA1424',1,'MIA','17:00:00','MDW','18:22:00','L',2.376,1188,'B747', null); 
insert into FLIGHTS values ('US1427',1,'MSY','09:00:00','SFO','10:50:00','L',3.846,1923,'B747', null); 
insert into FLIGHTS values ('US1428',1,'SFO','09:00:00','MSY','14:50:00','L',3.846,1923,'B747', null); 
insert into FLIGHTS values ('US1429',1,'MSY','09:00:00','ATL','10:50:00','L',0.848,424,'B747', null); 
insert into FLIGHTS values ('US1430',1,'ATL','09:00:00','MSY','08:50:00','L',0.848,424,'B747', null); 
insert into FLIGHTS values ('US1431',1,'MSY','09:00:00','JFK','12:20:00','L',2.336,1168,'B747', null); 
insert into FLIGHTS values ('US1432',1,'JFK','09:00:00','MSY','10:20:00','L',2.336,1168,'B747', null); 
insert into FLIGHTS values ('US1433',1,'NBO','09:00:00','FCO','13:42:00','L',6.702,3351,'B747', null); 
insert into FLIGHTS values ('US1434',1,'FCO','09:00:00','NBO','17:42:00','L',6.702,3351,'B747', null); 
insert into FLIGHTS values ('US1435',1,'NBO','06:00:00','MAD','11:41:00','L',7.694,3847,'B747', null); 
insert into FLIGHTS values ('US1436',1,'MAD','13:10:00','NBO','22:51:00','L',7.694,3847,'B747', null); 
insert into FLIGHTS values ('US1437',1,'NBO','09:00:00','CAS','13:31:00','L',7.518,3759,'B747', null); 
insert into FLIGHTS values ('US1438',1,'CAS','09:00:00','NBO','19:31:00','L',7.518,3759,'B747', null); 
insert into FLIGHTS values ('US1439',1,'NRT','09:00:00','SYD','20:44:00','L',9.736,4868,'B747', null); 
insert into FLIGHTS values ('US1440',1,'SYD','09:00:00','NRT','16:44:00','L',9.736,4868,'B747', null); 
insert into FLIGHTS values ('US1441',1,'NRT','09:00:00','LAX','02:57:00','L',10.956,5478,'B747', null); 
insert into FLIGHTS values ('US1442',1,'LAX','09:00:00','NRT','12:57:00','L',10.956,5478,'B747', null); 
insert into FLIGHTS values ('US1444',1,'HKG','09:00:00','NRT','13:35:00','L',3.596,1798,'B747', null); 
insert into FLIGHTS values ('US1445',1,'OKC','09:00:00','SLC','09:43:00','L',1.722,861,'B747', null); 
insert into FLIGHTS values ('US1446',1,'SLC','09:00:00','OKC','11:43:00','L',1.722,861,'B747', null); 
insert into FLIGHTS values ('US1447',1,'OKC','09:00:00','JFK','12:38:00','L',2.648,1324,'B747', null); 
insert into FLIGHTS values ('US1448',1,'JFK','09:00:00','OKC','10:38:00','L',2.648,1324,'B747', null); 
insert into FLIGHTS values ('US1449',1,'OKC','09:00:00','LAX','09:21:00','L',2.36,1180,'B747', null); 
insert into FLIGHTS values ('US1450',1,'LAX','09:00:00','OKC','13:21:00','L',2.36,1180,'B747', null); 
insert into FLIGHTS values ('US1451',1,'OSA','09:00:00','NRT','09:30:00','S',0.502,251,'B747', null); 
insert into FLIGHTS values ('US1452',1,'NRT','09:00:00','OSA','09:30:00','S',0.502,251,'B747', null); 
insert into FLIGHTS values ('US1453',1,'OSA','09:00:00','TPE','10:08:00','L',2.138,1069,'B747', null); 
insert into FLIGHTS values ('US1454',1,'TPE','09:00:00','OSA','12:08:00','L',2.138,1069,'B747', null); 
insert into FLIGHTS values ('US1455',1,'OSA','09:00:00','SVO','12:07:00','L',9.13,4565,'B747', null); 
insert into FLIGHTS values ('US1456',1,'SVO','09:00:00','OSA','00:07:00','L',9.13,4565,'B747', null); 
insert into FLIGHTS values ('US1457',1,'OSL','09:00:00','PRG','10:23:00','L',1.39,695,'B747', null); 
insert into FLIGHTS values ('US1458',1,'PRG','11:00:00','OSL','12:23:00','L',1.39,695,'B747', null); 
insert into FLIGHTS values ('US1459',1,'OSL','09:00:00','ARN','10:34:00','L',1.574,787,'B747', null); 
insert into FLIGHTS values ('US1460',1,'ARN','09:00:00','OSL','10:34:00','L',1.574,787,'B747', null); 
insert into FLIGHTS values ('US1461',1,'OSL','09:00:00','WAW','10:19:00','L',1.318,659,'B747', null); 
insert into FLIGHTS values ('US1462',1,'WAW','09:00:00','OSL','10:19:00','L',1.318,659,'B747', null); 
insert into FLIGHTS values ('AA1462',1,'OSL','07:15:00','CDG','08:55:00','B',1.668,834,'B747', null); 
insert into FLIGHTS values ('AA1463',1,'CDG','11:00:00','OSL','12:40:00','L',1.668,834,'B747', null); 
insert into FLIGHTS values ('US1463',1,'PHL','09:00:00','IAD','09:21:00','S',0.364,182,'B747', null); 
insert into FLIGHTS values ('US1464',1,'IAD','09:00:00','PHL','09:21:00','S',0.364,182,'B747', null); 
insert into FLIGHTS values ('US1465',1,'PHL','09:00:00','MIA','11:02:00','L',2.044,1022,'B747', null); 
insert into FLIGHTS values ('US1466',1,'MIA','09:00:00','PHL','11:02:00','L',2.044,1022,'B747', null); 
insert into FLIGHTS values ('AA1258',1,'PHL','09:00:00','ATL','10:19:00','L',1.33,665,'B747', null); 
insert into FLIGHTS values ('US1469',1,'PHX','09:00:00','LAX','08:42:00','S',0.714,357,'B747', null); 
insert into FLIGHTS values ('US1470',1,'LAX','09:00:00','PHX','10:42:00','S',0.714,357,'B747', null); 
insert into FLIGHTS values ('US1471',1,'PHX','09:00:00','SEA','10:13:00','L',2.23,1115,'B747', null); 
insert into FLIGHTS values ('US1472',1,'SEA','09:00:00','PHX','12:13:00','L',2.23,1115,'B747', null); 
insert into FLIGHTS values ('US1473',1,'PHX','09:00:00','MDW','12:53:00','L',2.898,1449,'B747', null); 


insert into FLIGHTS values ('US1475',1,'PRG','09:00:00','CDG','10:06:00','L',1.102,551,'B747', null); 
insert into FLIGHTS values ('US1476',1,'CDG','09:00:00','PRG','10:06:00','L',1.102,551,'B747', null); 
insert into FLIGHTS values ('US1477',1,'PRG','09:00:00','FCO','10:08:00','L',1.146,573,'B747', null); 
insert into FLIGHTS values ('US1478',1,'FCO','09:00:00','PRG','10:08:00','L',1.146,573,'B747', null); 
insert into FLIGHTS values ('US1479',1,'PRG','09:00:00','REY','11:16:00','B',3.282,1641,'A320', null); 
insert into FLIGHTS values ('US1480',1,'REY','09:00:00','PRG','13:16:00','L',3.282,1641,'A320', null); 
insert into FLIGHTS values ('US1481',1,'REY','09:00:00','SVO','16:06:00','L',4.112,2056,'B747', null); 

insert into FLIGHTS values ('US1483',1,'REY','09:00:00','CDG','12:46:00','L',2.776,1388,'B747', null); 
insert into FLIGHTS values ('US1484',1,'CDG','09:00:00','REY','10:46:00','L',2.776,1388,'B747', null); 
insert into FLIGHTS values ('US1485',1,'REY','09:00:00','DUB','10:51:00','L',1.862,931,'B747', null); 
insert into FLIGHTS values ('US1486',1,'DUB','09:00:00','REY','10:51:00','L',1.862,931,'B747', null); 
insert into FLIGHTS values ('US1487',1,'SAN','09:00:00','SFO','09:55:00','L',0.918,459,'B747', null); 
insert into FLIGHTS values ('US1488',1,'SFO','09:00:00','SAN','09:55:00','L',0.918,459,'B747', null); 
insert into FLIGHTS values ('US1489',1,'SAN','09:00:00','DFW','13:21:00','L',2.36,1180,'B747', null); 
insert into FLIGHTS values ('US1490',1,'DFW','09:00:00','SAN','09:21:00','L',2.36,1180,'B747', null); 
insert into FLIGHTS values ('US1491',1,'SAN','09:00:00','MEX','13:53:00','L',2.888,1444,'B747', null); 

insert into FLIGHTS values ('US1492',1,'MEX','09:00:00','SAN','09:53:00','L',2.888,1444,'B747', null); 
insert into FLIGHTS values ('US1493',1,'SAT','09:00:00','ATL','11:45:00','L',1.766,883,'B747', null); 
insert into FLIGHTS values ('US1494',1,'ATL','09:00:00','SAT','09:45:00','L',1.766,883,'B747', null); 
insert into FLIGHTS values ('US1495',1,'SAT','09:00:00','LAX','09:24:00','L',2.404,1202,'B747', null); 
insert into FLIGHTS values ('US1496',1,'LAX','09:00:00','SAT','13:24:00','L',2.404,1202,'B747', null); 
insert into FLIGHTS values ('US1497',1,'SAT','09:00:00','MIA','12:17:00','L',2.292,1146,'B747', null); 
insert into FLIGHTS values ('US1498',1,'MIA','09:00:00','SAT','10:17:00','L',2.292,1146,'B747', null); 
insert into FLIGHTS values ('US1499',1,'SCL','09:00:00','GRU','12:13:00','L',3.218,1609,'B747', null); 
insert into FLIGHTS values ('US1500',1,'GRU','09:00:00','SCL','12:13:00','L',3.218,1609,'B747', null); 
insert into FLIGHTS values ('US1501',1,'SCL','09:00:00','LIM','10:04:00','L',3.068,1534,'B747', null); 
 
insert into FLIGHTS values ('US1503',1,'SCL','09:00:00','BUE','11:24:00','L',1.408,704,'B747', null); 
insert into FLIGHTS values ('US1504',1,'BUE','09:00:00','SCL','09:24:00','L',1.408,704,'B747', null); 
insert into FLIGHTS values ('US1505',1,'SEA','09:00:00','SFO','10:21:00','L',1.356,678,'B747', null); 
insert into FLIGHTS values ('AA1505',1,'SFO','09:00:00','SEA','10:21:00','L',1.356,678,'B747', null); 
insert into FLIGHTS values ('US1506',1,'SEA','09:00:00','JFK','16:48:00','L',4.81,2405,'B747', null); 
insert into FLIGHTS values ('US1507',1,'JFK','09:00:00','SEA','10:48:00','L',4.81,2405,'B747', null); 
insert into FLIGHTS values ('US1508',1,'SEA','09:00:00','MIA','17:27:00','L',5.462,2731,'B747', null); 

insert into FLIGHTS values ('US1510',1,'SEL','09:00:00','NRT','10:26:00','L',1.438,719,'B747', null); 
insert into FLIGHTS values ('US1511',1,'NRT','09:00:00','SEL','10:26:00','L',1.438,719,'B747', null); 
insert into FLIGHTS values ('US1388',1,'SEL','09:00:00','SIN','13:49:00','L',5.818,2909,'B747', null); 

insert into FLIGHTS values ('US1514',1,'SEL','09:00:00','SHA','09:05:00','L',1.098,549,'B747', null); 
insert into FLIGHTS values ('US1515',1,'SHA','09:00:00','SEL','11:05:00','L',1.098,549,'B747', null); 
insert into FLIGHTS values ('US1516',1,'SFO','12:00:00','JFK','20:08:00','L',5.136,2568,'B747', null); 

insert into FLIGHTS values ('US1518',1,'SFO','09:00:00','MIA','17:10:00','L',5.18,2590,'B747', null); 
 
insert into FLIGHTS values ('US1519',1,'SCL','09:00:00','MIA','15:17:00','D',8.288,4144,'B747', null); 

insert into FLIGHTS values ('US1529',1,'SFO','09:00:00','HNL','11:47:00','L',4.794,2397,'B747', null); 
insert into FLIGHTS values ('US1521',1,'HNL','09:00:00','SFO','15:47:00','L',4.794,2397,'B747', null); 
insert into FLIGHTS values ('US1522',1,'SHA','09:00:00','SIN','13:43:00','L',4.72,2360,'B747', null); 
insert into FLIGHTS values ('US1523',1,'SIN','09:00:00','SHA','13:43:00','L',4.72,2360,'B747', null); 
insert into FLIGHTS values ('US1524',1,'SHA','09:00:00','HKG','10:30:00','L',1.514,757,'B747', null); 
insert into FLIGHTS values ('US1525',1,'HKG','09:00:00','SHA','10:30:00','L',1.514,757,'B747', null); 
insert into FLIGHTS values ('US1526',1,'SHA','09:00:00','SVO','12:29:00','L',8.486,4243,'B747', null); 
insert into FLIGHTS values ('US1527',1,'SVO','09:00:00','SHA','22:29:00','L',8.486,4243,'B747', null); 
insert into FLIGHTS values ('AA1528',1,'SIN','09:00:00','SYD','19:50:00','L',7.834,3917,'B747', null); 
insert into FLIGHTS values ('AA1529',1,'SYD','09:00:00','SIN','13:50:00','L',7.834,3917,'B747', null); 

insert into FLIGHTS values ('US1420',1,'JKT','09:00:00','SIN','11:06:00','L',1.108,554,'B747', null); 
insert into FLIGHTS values ('AA1532',1,'SIN','09:00:00','HKG','12:12:00','L',3.214,1607,'B747', null); 
insert into FLIGHTS values ('AA1533',1,'HKG','09:00:00','SIN','12:12:00','L',3.214,1607,'B747', null); 
insert into FLIGHTS values ('AA1186',1,'SJU','09:00:00','MIA','10:04:00','L',2.07,1035,'B747', null); 

insert into FLIGHTS values ('US1536',1,'SJU','09:00:00','CCS','10:06:00','L',1.106,553,'B747', null); 
insert into FLIGHTS values ('US1537',1,'CCS','09:00:00','SJU','10:06:00','L',1.106,553,'B747', null); 
insert into FLIGHTS values ('US1538',1,'SJU','09:00:00','MEL','20:17:00','L',20.288,10144,'B747', null); 
insert into FLIGHTS values ('US1539',1,'MEL','09:00:00','SJU','14:17:00','L',20.288,10144,'B747', null); 
insert into FLIGHTS values ('US1540',1,'SLC','09:00:00','DEN','09:44:00','S',0.74,370,'B747', null); 
insert into FLIGHTS values ('US1541',1,'DEN','09:00:00','SLC','09:44:00','S',0.74,370,'B747', null); 
insert into FLIGHTS values ('US1542',1,'SLC','09:00:00','SFO','09:11:00','L',1.198,599,'B747', null); 
insert into FLIGHTS values ('US1543',1,'SFO','09:00:00','SLC','11:11:00','L',1.198,599,'B747', null); 
insert into FLIGHTS values ('US1544',1,'SLC','09:00:00','MDW','12:30:00','L',2.51,1255,'B747', null); 
insert into FLIGHTS values ('US1545',1,'MDW','09:00:00','SLC','10:30:00','L',2.51,1255,'B747', null); 
insert into FLIGHTS values ('US1546',1,'STL','09:00:00','MDW','09:31:00','S',0.518,259,'B747', null); 
insert into FLIGHTS values ('US1547',1,'MDW','09:00:00','STL','09:31:00','S',0.518,259,'B747', null); 
insert into FLIGHTS values ('US1548',1,'STL','09:00:00','JFK','11:44:00','L',1.746,873,'B747', null); 
insert into FLIGHTS values ('US1549',1,'JFK','09:00:00','STL','09:44:00','L',1.746,873,'B747', null); 
insert into FLIGHTS values ('US1550',1,'STL','09:00:00','LAX','10:10:00','L',3.174,1587,'B747', null); 
insert into FLIGHTS values ('US1551',1,'LAX','09:00:00','STL','14:10:00','L',3.174,1587,'B747', null); 
insert into FLIGHTS values ('US1552',1,'SVO','14:00:00','CDG','15:05:00','L',3.09,1545,'B747', null); 
insert into FLIGHTS values ('US1553',1,'CDG','14:00:00','SVO','19:05:00','L',3.09,1545,'B747', null); 
insert into FLIGHTS values ('US1554',1,'SVO','09:00:00','NRT','00:18:00','L',9.308,4654,'B747', null); 
insert into FLIGHTS values ('US1555',1,'NRT','09:00:00','SVO','12:18:00','L',9.308,4654,'B747', null); 
 
insert into FLIGHTS values ('US1482',1,'BOM','09:00:00','SVO','12:45:00','L',6.266,3133,'B747', null); 
insert into FLIGHTS values ('US1558',1,'SYD','09:00:00','AKL','13:40:00','L',2.682,1341,'B747', null); 
insert into FLIGHTS values ('US1559',1,'AKL','09:00:00','SYD','09:40:00','L',2.682,1341,'B747', null); 
insert into FLIGHTS values ('US1560',1,'SYD','15:00:00','HNL','04:09:00','L',10.16,5080,'B747', null); 
insert into FLIGHTS values ('US1561',1,'HNL','13:00:00','SYD','20:09:00','L',10.16,5080,'B747', null); 
insert into FLIGHTS values ('US1562',1,'SYD','09:00:00','HKG','15:09:00','L',9.166,4583,'B747', null); 
insert into FLIGHTS values ('US1563',1,'HKG','09:00:00','SYD','21:09:00','L',9.166,4583,'B747', null); 
insert into FLIGHTS values ('US1564',1,'THR','09:00:00','KBL','12:30:00','L',2.014,1007,'B747', null); 
insert into FLIGHTS values ('US1565',1,'KBL','09:00:00','THR','09:30:00','L',2.014,1007,'B747', null); 
insert into FLIGHTS values ('US1566',1,'THR','09:00:00','KHI','12:53:00','L',2.384,1192,'B747', null); 
insert into FLIGHTS values ('US1567',1,'KHI','09:00:00','THR','09:53:00','L',2.384,1192,'B747', null); 
insert into FLIGHTS values ('US1568',1,'THR','09:00:00','CAI','09:57:00','L',2.464,1232,'B747', null); 
insert into FLIGHTS values ('US1569',1,'CAI','09:00:00','THR','12:57:00','L',2.464,1232,'B747', null); 
insert into FLIGHTS values ('US1572',1,'TPE','09:00:00','SYD','21:02:00','L',9.036,4518,'B747', null); 
insert into FLIGHTS values ('US1573',1,'SYD','09:00:00','TPE','15:02:00','L',9.036,4518,'B747', null); 
insert into FLIGHTS values ('US1574',1,'TPE','09:00:00','OSA','12:08:00','L',2.138,1069,'B747', null); 
insert into FLIGHTS values ('US1575',1,'OSA','09:00:00','TPE','10:08:00','L',2.138,1069,'B747', null); 
insert into FLIGHTS values ('US1576',1,'WAW','09:00:00','PRG','09:38:00','S',0.64,320,'B747', null); 
insert into FLIGHTS values ('US1577',1,'PRG','09:00:00','WAW','09:38:00','S',0.64,320,'B747', null); 
insert into FLIGHTS values ('US1578',1,'WAW','09:00:00','SVO','12:25:00','L',1.428,714,'B747', null); 
insert into FLIGHTS values ('US1579',1,'SVO','09:00:00','WAW','08:25:00','L',1.428,714,'B747', null); 
insert into FLIGHTS values ('US1580',1,'WAW','09:00:00','ARN','09:28:00','S',0.478,239,'B747', null); 
insert into FLIGHTS values ('US1581',1,'ARN','09:00:00','WAW','09:28:00','S',0.478,239,'B747', null); 
insert into FLIGHTS values ('US1379',1,'YUL','09:00:00','MDW','09:29:00','L',1.494,747,'B747', null); 
insert into FLIGHTS values ('US1584',1,'YUL','09:00:00','JFK','09:39:00','S',0.664,332,'B747', null); 
insert into FLIGHTS values ('US1585',1,'JFK','09:00:00','YUL','09:39:00','S',0.664,332,'B747', null); 
insert into FLIGHTS values ('US1586',1,'YUL','09:00:00','SFO','11:04:00','L',5.076,2538,'B747', null); 
insert into FLIGHTS values ('US1587',1,'SFO','09:00:00','YUL','17:04:00','L',5.076,2538,'B747', null); 
insert into FLIGHTS values ('US1588',1,'YYZ','09:00:00','SEA','10:08:00','L',4.134,2067,'B747', null); 
insert into FLIGHTS values ('US1589',1,'SEA','09:00:00','YYZ','16:08:00','L',4.134,2067,'B747', null); 
insert into FLIGHTS values ('US1590',1,'YYZ','09:00:00','MIA','11:28:00','L',2.474,1237,'B747', null); 
 
insert into FLIGHTS values ('US1592',1,'YYZ','09:00:00','LHR','21:06:00','L',7.106,3553,'DC10', null); 
insert into FLIGHTS values ('US1593',1,'LHR','09:00:00','YYZ','11:06:00','L',7.106,3553,'B747', null); 
insert into FLIGHTS values ('AA1600',1,'SFO','07:00:00','LAX','07:41:00','S',0.694,347,'B767', null); 
insert into FLIGHTS values ('AA1601',1,'LAX','07:00:00','SFO','07:41:00','S',0.694,347,'B767', null); 
insert into FLIGHTS values ('AA1602',1,'SFO','14:00:00','LAX','14:41:00','S',0.694,347,'B767', null); 
insert into FLIGHTS values ('AA1603',1,'LAX','14:00:00','SFO','14:41:00','S',0.622,347,'B767', null); 
insert into FLIGHTS values ('US1600',1,'YYZ','09:00:00','YUL','09:37:00','S',0.694,311,'DC10', null); 

insert into FLIGHTS values ('US1601',1,'SCL','05:00:00','YUL','17:55:00','L',10.926,5463,'DC10', null); 



CREATE INDEX DESTINDEX ON FLIGHTS (DEST_AIRPORT) ;
CREATE INDEX ORIGINDEX ON FLIGHTS (ORIG_AIRPORT) ;

CREATE TABLE USERS 
   (

      firstname varchar(40) not null,
      lastname varchar (40) not null,
      username varchar(20) not null constraint username_pk primary key, 
      password varchar(20) not null,
      password_verify varchar(20),
      email varchar(30) not null
   );
   
INSERT INTO USERS (firstname, lastname, username, password, email) 
values 
('apache', 'user', 'apacheu', 'apacheu', 'apacheu@mycompany.com');


CREATE TABLE USER_CREDIT_CARD
(
  id int not null generated always as identity constraint user_cc_pk primary key,

  username varchar(20) not null,
  lastname varchar(40),
  credit_card_type varchar(15) not null,
  credit_card_number varchar(20) not null,
  credit_card_display varchar(25) not null
  );
  
ALTER TABLE USER_CREDIT_CARD ADD CONSTRAINT USERNAME_FK
Foreign Key (username) REFERENCES USERS (username);

insert into USER_CREDIT_CARD (username, credit_card_type, credit_card_number, credit_card_display)
  values
  ('apacheu', 'Visa', '4735555555555555', 'xxxx-xxxx-xxxx-x555');



CREATE TABLE FLIGHTHISTORY
   (
      id int not null generated always as identity constraint user_fh_pk primary key,
      USERNAME       VARCHAR(20) NOT NULL,
      FLIGHT_ID      CHAR(6) NOT NULL,
      ORIG_AIRPORT   CHAR(3) NOT NULL,
      DEST_AIRPORT   CHAR(3) NOT NULL,
      MILES     	 INTEGER,
      AIRCRAFT       VARCHAR(6),
      DEPARTURE_DATE VARCHAR(25),
	  credit_card_type varchar(15) not null,
      credit_card_display varchar(25) not null
   );
   
 ALTER TABLE FLIGHTHISTORY ADD CONSTRAINT USERNAME_FH_FK
Foreign Key (username) REFERENCES USERS (username);
