/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.derby.demo.beans.view;

import java.sql.Time;
import java.util.Date;

public class FlightsBean {

	private String flightId;

	private int segmentNumber;

	private String startAirport;

	private Time departTime;

	private String endAirport;

	private Time arriveTime;

	private double flyingTime;

	private String miles;

	private String aircraft;

	private String meal;

	private Date departureDate;

	public FlightsBean() {
		flightId = "";
		segmentNumber = 0;
		startAirport = "";
		endAirport = "";
		meal = "";
		departTime = new Time(0L);
		arriveTime = new Time(0L);
		flyingTime = 0.0;
		miles = "";
		aircraft = "";
		departureDate = null;
	}

	public FlightsBean(String flight_id, int segNumber, String origAirport,
			Time depart_time, String destAirport, Time arrive_time, String food,
			double flying_time, String mile, String jet) {
		flightId = flight_id;
		segmentNumber = segNumber;
		startAirport = origAirport;
		departTime = depart_time;
		endAirport = destAirport;
		arriveTime = arrive_time;
		meal = food;
		flyingTime = flying_time;
		miles = mile;
		aircraft = jet;
	}

	public FlightsBean(String flight_id, int segNumber, String origAirport,
			Time depart_time, String destAirport, Time arrive_time, String food,
			double flying_time, String mile, String jet, Date departure) {
		flightId = flight_id;
		segmentNumber = segNumber;
		startAirport = origAirport;
		departTime = depart_time;
		endAirport = destAirport;
		arriveTime = arrive_time;
		meal = food;
		flyingTime = flying_time;
		miles = mile;
		aircraft = jet;
		departureDate = departure;
	}

	/**
	 * @return Returns the meal.
	 */
	public String getMeal() {
		return meal;
	}

	/**
	 * @param meal
	 *          The meal to set.
	 */
	public void setMeal(String meal) {
		this.meal = meal;
	}

	/**
	 * @return Returns the endAirport.
	 */
	public String getEndAirport() {
		return endAirport;
	}

	/**
	 * @param endAirport
	 *          The endAirport to set.
	 */
	public void setEndAirport(String endAirport) {
		this.endAirport = endAirport;
	}

	/**
	 * @return Returns the segmentNumber.
	 */
	public int getSegmentNumber() {
		return segmentNumber;
	}

	/**
	 * @param segmentNumber
	 *          The segmentNumber to set.
	 */
	public void setSegmentNumber(int segmentNumber) {
		this.segmentNumber = segmentNumber;
	}

	/**
	 * @return Returns the startAirport.
	 */
	public String getStartAirport() {
		return startAirport;
	}

	/**
	 * @param startAirport
	 *          The startAirport to set.
	 */
	public void setStartAirport(String startAirport) {
		this.startAirport = startAirport;
	}

	/**
	 * @return Returns the aircraft.
	 */
	public String getAircraft() {
		return aircraft;
	}

	/**
	 * @param aircraft
	 *          The aircraft to set.
	 */
	public void setAircraft(String aircraft) {
		this.aircraft = aircraft;
	}

	/**
	 * @return Returns the arriveTime.
	 */
	public String getArriveTime() {
		return arriveTime.toString();
	}

	/**
	 * @param arriveTime
	 *          The arriveTime to set.
	 */
	public void setArriveTime(Time arriveTime) {
		this.arriveTime = arriveTime;
	}

	/**
	 * @return Returns the departTime.
	 */
	public String getDepartTime() {
		return departTime.toString();
	}

	/**
	 * @param departTime
	 *          The departTime to set.
	 */
	public void setDepartTime(Time departTime) {
		this.departTime = departTime;
	}

	/**
	 * @return Returns the flightId.
	 */
	public String getFlightId() {
		return flightId;
	}

	/**
	 * @param flightId
	 *          The flightId to set.
	 */
	public void setFlightId(String flightId) {
		this.flightId = flightId;
	}

	/**
	 * @return Returns the flyingTime.
	 */
	public double getFlyingTime() {
		return flyingTime;
	}

	/**
	 * @param flyingTime
	 *          The flyingTime to set.
	 */
	public void setFlyingTime(double flyingTime) {
		this.flyingTime = flyingTime;
	}

	/**
	 * @return Returns the miles.
	 */
	public String getMiles() {
		return miles;
	}

	/**
	 * @param miles
	 *          The miles to set.
	 */
	public void setMiles(String miles) {
		this.miles = miles;
	}

	public String selectedFlight() {
		return "get_selected_flight";
	}

	public Date getDepartureDate() {

		return departureDate;
	}

	public void setDepartureDate(Date departureDate) {
		this.departureDate = departureDate;
	}
}
