/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.derby.demo.beans.model;

public class UserBean
{

	private String firstName;

	private String lastName;

	private String userName;

	private String password;

	private String passwordVerify;

	private String email;

	public UserBean() {
		// identity column can not be null for jpox persistence
		userName = "";
	}

	public UserBean(String uName, String pssword) {

		userName = uName;
		password = pssword;
	}

	public UserBean(String fName, String lName, String uName, String pssword,
			String mail) {
		email = mail;
		firstName = fName;
		lastName = lName;
		userName = uName;
		password = pssword;
	}

	public UserBean(String fName, String lName, String uName, String pssword,
			String verify, String mail) {
		email = mail;
		firstName = fName;
		lastName = lName;
		userName = uName;
		password = pssword;
		passwordVerify = verify;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getPasswordVerify() {
		return passwordVerify;
	}

	public void setPasswordVerify(String passwordVerify) {
		this.passwordVerify = passwordVerify;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

}
