package org.apache.derby.plugin.lab;

import java.io.*;
import java.sql.*;
import java.util.*;

public class Jays
{

    public static void main(String[] args) throws Exception
    {
        String embeddedDriver = "org.apache.derby.jdbc.EmbeddedDriver";
        String derbyClientDriver = "org.apache.derby.jdbc.ClientDriver";

        Class.forName(derbyClientDriver);
        //Class.forName(embeddedDriver);

        String embeddedURL = "jdbc:derby:jayDB;user=APP;password=APP;";
        String derbyClientURL = "jdbc:derby://localhost:1527/jayDB;user=APP;password=APP;";

        Connection conn = DriverManager.getConnection(derbyClientURL);
        // Connection conn = DriverManager.getConnection(embeddedURL);

        readCommands(conn);
        conn.close();
    }

    public static void readCommands(Connection conn) throws Exception
    {
        boolean end = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Statement stmt = conn.createStatement();

        while (!end)
        {
            System.out.println("\n Usage: ");
            System.out.println(" names <genus_name>,");
            System.out.println(" attributes <common_name>,");
            System.out.println(" wingspan <min_wingspan> <max_wingspan>,");
            System.out.println(" quit");
            System.out.print("\n>> ");
            String cmd = in.readLine();

            if (cmd.equals("quit"))
            {
                end = true;
            }
            else if (cmd.startsWith("names"))
            {
                showNames(stmt, cmd);
            }
            else if (cmd.startsWith("attributes"))
            {
                showAttributes(stmt, cmd);
            }

            else if (cmd.startsWith("wingspan"))
            {
                wingSpan(stmt, cmd);
            }
        }

        stmt.close();
    }

    protected static void showNames(Statement stmt, String cmd)
            throws Exception
    {
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken(); // skip first token
        String genus = st.nextToken();

        String query = "call selectNames('" + genus + "')";
        ResultSet resultSet = null;

        if (stmt.execute(query))
        {
            resultSet = stmt.getResultSet();

            while (resultSet.next())
            {
                System.out.print("Common name: " + resultSet.getString(1)
                        + ", ");
                System.out.println("Latin name: " + resultSet.getString(2));
            }
            resultSet.close();
        }

    }

    protected static void showAttributes(Statement stmt, String cmd)
            throws Exception
    {
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken(); // skip first token
        StringBuffer sb = new StringBuffer(40);
        int quote = 0;
        String inputString;
        while (st.hasMoreTokens())
        {
            inputString = st.nextToken();
            // check for quotes, e.g, Clark's Nutcracker
            quote = inputString.indexOf("'");

            if (quote != -1)
            {
                sb.append(inputString.substring(0, quote + 1));
                sb.append("'");
                sb.append(inputString
                        .substring(quote + 1, inputString.length()));
            }
            else
            {
                sb.append(inputString);
            }
            sb.append(" ");
        }

        String query = "call selectAttributes('" + sb.toString() + "')";
        ResultSet resultSet = null;

        /* The reason stmt.execute(query) is called in all of these methods
         * is because the embedded driver throws an exception if 
         * resultSet = stmt.executeQuery(query) is called first.  
         * I don't know if this is a bug or a feature.
         */
        
        if (stmt.execute(query))
        {
            resultSet = stmt.getResultSet();
            while (resultSet.next())
            {
                System.out.print("\nCommon name: " + resultSet.getString(1)
                        + ", ");
                System.out.print("Wingspan in: " + resultSet.getBigDecimal(2)
                        + ", ");
                System.out.print("Length in: " + resultSet.getDouble(3) + ", ");
                System.out.print("Weight oz: " + resultSet.getDouble(4) + ", ");
                System.out.println("Range: " + resultSet.getString(5).trim()
                        + ", ");
                System.out.println("Voice: " + resultSet.getString(6).trim());
            }
            resultSet.close();
        }

    }

    protected static void wingSpan(Statement stmt, String cmd) throws Exception
    {
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken(); // skip first token
        double minWingSpan = Double.parseDouble(st.nextToken());
        double maxWingSpan = Double.parseDouble(st.nextToken());

        String query = "call wingSpan(" + minWingSpan + ", " + maxWingSpan
                + ")";

        ResultSet resultSet = null;

        if (stmt.execute(query))
        {
            resultSet = stmt.getResultSet();

            while (resultSet.next())
            {
                System.out.print("\nGenus: " + resultSet.getString(1) + ", ");
                System.out.println("Latin name: " + resultSet.getString(2));
                System.out.print("Common name: " + resultSet.getString(3)
                        + ", ");
                System.out.print("Wingspan in: " + resultSet.getBigDecimal(4)
                        + ", ");
                System.out.print("Length in: " + resultSet.getDouble(5) + ", ");
                System.out.print("Weight oz: " + resultSet.getDouble(6) + ", ");
                System.out.println("Range: " + resultSet.getString(7).trim()
                        + ", ");
                System.out.println("Voice: " + resultSet.getString(8).trim());

            }
            resultSet.close();
        }
    }
}
