/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.GenericQualifier;

abstract class NoPutResultSetImpl
extends BasicNoPutResultSetImpl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public final int resultSetNumber;
    protected String indent;
    protected String subIndent;
    protected int sourceDepth;
    private boolean needsRowLocation;
    protected ExecRow clonedExecRow;
    GeneratedMethod checkGM;
    long heapConglomerate;
    protected TargetResultSet targetResultSet;
    protected int[] checkNullCols;
    protected int cncLen;

    public ResultDescription getResultDescription() {
        return this.activation.getResultDescription();
    }

    public String getCursorName() {
        String string = this.activation.getCursorName();
        if (string == null && this.isForUpdate()) {
            this.activation.setCursorName(this.activation.getLanguageConnectionContext().getUniqueCursorName());
            string = this.activation.getCursorName();
        }
        return string;
    }

    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.isTopResultSet) {
            int n = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.subqueryTrackingArray[n2] != null && !this.subqueryTrackingArray[n2].isClosed()) {
                    this.subqueryTrackingArray[n2].close();
                }
                ++n2;
            }
        }
        if (this.activation.getResultSet() == this) {
            this.activation.clearResultSet();
        }
        this.isOpen = false;
    }

    public void setTargetResultSet(TargetResultSet targetResultSet) {
        this.targetResultSet = targetResultSet;
    }

    public void setNeedsRowLocation(boolean bl) {
        this.needsRowLocation = bl;
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.getNextRowCore();
        if (execRow != null) {
            this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            return execRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.needsRowLocation;
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
        this.targetResultSet.changedRow(this.clonedExecRow, rowLocation);
    }

    protected void clearOrderableCache(Qualifier[][] qualifierArray) throws StandardException {
        if (qualifierArray != null) {
            int n = 0;
            while (n < qualifierArray.length) {
                int n2 = 0;
                while (n2 < qualifierArray[n].length) {
                    Qualifier qualifier = qualifierArray[n][n2];
                    qualifier.clearOrderableCache();
                    if (((GenericQualifier)qualifier).variantType != 0) {
                        qualifier.getOrderable();
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    protected void setCheckConstraints(GeneratedMethod generatedMethod) {
        this.checkGM = generatedMethod;
    }

    protected void setHeapConglomerate(long l) {
        this.heapConglomerate = l;
    }

    public final void setCurrentRow(ExecRow execRow) {
        this.activation.setCurrentRow(execRow, this.resultSetNumber);
    }

    public final void clearCurrentRow() {
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    public boolean isForUpdate() {
        return false;
    }

    protected boolean skipScan(ExecIndexRow execIndexRow, ExecIndexRow execIndexRow2) throws StandardException {
        int n = execIndexRow == null ? 0 : execIndexRow.nColumns();
        int n2 = execIndexRow2 == null ? 0 : execIndexRow2.nColumns();
        boolean bl = false;
        int n3 = n2;
        if (n > n2) {
            bl = true;
            n3 = n;
        }
        if (n3 == 0) {
            return false;
        }
        if (this.checkNullCols == null || this.checkNullCols.length < n3) {
            this.checkNullCols = new int[n3];
        }
        this.cncLen = 0;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n) {
            if (!execIndexRow.areNullsOrdered(n4)) {
                if (bl) {
                    this.checkNullCols[this.cncLen++] = n4 + 1;
                }
                if (execIndexRow.getColumn(n4 + 1).isNull()) {
                    bl2 = true;
                    if (!bl) break;
                }
            }
            ++n4;
        }
        if (bl && bl2) {
            return true;
        }
        n4 = 0;
        while (n4 < n2) {
            if (!execIndexRow2.areNullsOrdered(n4)) {
                if (!bl) {
                    this.checkNullCols[this.cncLen++] = n4 + 1;
                }
                if (!bl2 && execIndexRow2.getColumn(n4 + 1).isNull()) {
                    bl2 = true;
                    if (bl) break;
                }
            }
            ++n4;
        }
        return bl2;
    }

    protected boolean skipRow(ExecRow execRow) throws StandardException {
        int n = 0;
        while (n < this.cncLen) {
            if (execRow.getColumn(this.checkNullCols[n]).isNull()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String printQualifiers(Qualifier[][] qualifierArray) {
        String string = "";
        String string2 = "";
        if (qualifierArray == null) {
            return string + MessageService.getTextMessage("42Z37.U");
        }
        int n = 0;
        while (n < qualifierArray.length) {
            int n2 = 0;
            while (n2 < qualifierArray[n].length) {
                Qualifier qualifier = qualifierArray[n][n2];
                string2 = string + string2 + MessageService.getTextMessage("42Z48.U", String.valueOf(n), String.valueOf(n2)) + ": " + qualifier.getColumnId() + "\n";
                int n3 = qualifier.getOperator();
                String string3 = null;
                switch (n3) {
                    case 2: {
                        string3 = "=";
                        break;
                    }
                    case 3: {
                        string3 = "<=";
                        break;
                    }
                    case 1: {
                        string3 = "<";
                        break;
                    }
                    default: {
                        string3 = "unknown value (" + n3 + ")";
                        break;
                    }
                }
                string2 = string2 + string + MessageService.getTextMessage("42Z43.U") + ": " + string3 + "\n" + string + MessageService.getTextMessage("42Z44.U") + ": " + qualifier.getOrderedNulls() + "\n" + string + MessageService.getTextMessage("42Z45.U") + ": " + qualifier.getUnknownRV() + "\n" + string + MessageService.getTextMessage("42Z46.U") + ": " + qualifier.negateCompareResult() + "\n";
                ++n2;
            }
            ++n;
        }
        return string2;
    }

    public abstract long getTimeSpent(int var1);

    NoPutResultSetImpl(Activation activation, int n, double d, double d2) {
        super(null, activation, d, d2);
        this.resultSetNumber = n;
    }
}

