/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;

public class GroupedAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    public int rowsInput;
    public int rowsReturned;
    private ColumnOrdering[] order;
    private ExecIndexRow sortTemplateRow;
    public boolean hasDistinctAggregate;
    public boolean isInSortedOrder;
    private int maxRowSize;
    private ScanController scanController;
    private ExecIndexRow sourceExecIndexRow;
    private ExecIndexRow sortResultRow;
    private ExecIndexRow currSortedRow;
    private boolean nextCalled;
    private long distinctAggSortId;
    private boolean dropDistinctAggSort;
    private long genericSortId;
    private boolean dropGenericSort;
    private TransactionController tc;
    public Properties sortProperties = new Properties();
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$store$access$ColumnOrdering;

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.sortResultRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow.getClone());
        this.sourceExecIndexRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow.getClone());
        this.source.openCore();
        if (this.isInSortedOrder) {
            this.currSortedRow = this.getNextRowFromRS();
            if (this.currSortedRow != null) {
                this.currSortedRow = (ExecIndexRow)this.currSortedRow.getClone();
                this.initializeVectorAggregation(this.currSortedRow);
            }
        } else {
            this.scanController = this.loadSorter();
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecIndexRow execIndexRow;
        SortController sortController;
        long l;
        GenericAggregator[] genericAggregatorArray;
        int n = (int)this.optimizerEstimatedRowCount;
        boolean bl = this.isInSortedOrder;
        this.tc = this.getTransactionController();
        ColumnOrdering[] columnOrderingArray = this.order;
        if (this.aggInfoList.hasDistinct()) {
            ExecRow execRow;
            this.hasDistinctAggregate = true;
            genericAggregatorArray = this.getSortAggregators(this.aggInfoList, true, this.activation.getLanguageConnectionContext(), this.source);
            AggregateSortObserver aggregateSortObserver = new AggregateSortObserver(true, genericAggregatorArray, this.aggregates, this.sortTemplateRow);
            l = this.tc.createSort(null, this.sortTemplateRow.getRowArray(), this.order, aggregateSortObserver, false, n, this.maxRowSize);
            sortController = this.tc.openSort(l);
            this.distinctAggSortId = l;
            this.dropDistinctAggSort = true;
            while ((execRow = this.source.getNextRowCore()) != null) {
                sortController.insert(execRow.getRowArray());
                ++this.rowsInput;
            }
            this.source.close();
            this.sortProperties = sortController.getSortInfo().getAllSortInfo(this.sortProperties);
            sortController.close();
            this.scanController = this.tc.openSortScan(l, this.activation.getResultSetHoldability());
            bl = true;
            n = this.rowsInput;
            if (this.order.length == 1) {
                return this.scanController;
            }
            ColumnOrdering[] columnOrderingArray2 = new ColumnOrdering[this.order.length - 1];
            System.arraycopy(this.order, 0, columnOrderingArray2, 0, this.order.length - 1);
            columnOrderingArray = columnOrderingArray2;
        }
        genericAggregatorArray = new AggregateSortObserver(true, this.aggregates, this.aggregates, this.sortTemplateRow);
        l = this.tc.createSort(null, this.sortTemplateRow.getRowArray(), columnOrderingArray, (SortObserver)genericAggregatorArray, bl, n, this.maxRowSize);
        sortController = this.tc.openSort(l);
        this.genericSortId = l;
        this.dropGenericSort = true;
        while ((execIndexRow = this.getNextRowFromRS()) != null) {
            sortController.insert(execIndexRow.getRowArray());
        }
        this.source.close();
        this.sortProperties = sortController.getSortInfo().getAllSortInfo(this.sortProperties);
        sortController.close();
        return this.tc.openSortScan(l, this.activation.getResultSetHoldability());
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isInSortedOrder) {
            if (this.currSortedRow == null) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return null;
            }
            ExecIndexRow execIndexRow = this.getNextRowFromRS();
            while (execIndexRow != null) {
                if (!this.sameGroupingValues(this.currSortedRow, execIndexRow)) {
                    ExecIndexRow execIndexRow2 = this.currSortedRow;
                    this.currSortedRow = (ExecIndexRow)execIndexRow.getClone();
                    this.initializeVectorAggregation(this.currSortedRow);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    ++this.rowsReturned;
                    return this.finishAggregation(execIndexRow2);
                }
                this.initializeVectorAggregation(execIndexRow);
                this.mergeVectorAggregates(execIndexRow, this.currSortedRow);
                execIndexRow = this.getNextRowFromRS();
            }
            ExecIndexRow execIndexRow3 = this.currSortedRow;
            this.currSortedRow = null;
            this.nextTime += this.getElapsedMillis(this.beginTime);
            return this.finishAggregation(execIndexRow3);
        }
        ExecIndexRow execIndexRow = null;
        execIndexRow = this.getNextRowFromRS();
        if (execIndexRow != null) {
            this.setCurrentRow(execIndexRow);
        }
        if (execIndexRow != null) {
            execIndexRow = this.finishAggregation(execIndexRow);
            this.currentRow = execIndexRow;
        }
        if (execIndexRow != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execIndexRow;
    }

    private boolean sameGroupingValues(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n = 0;
        while (n < this.order.length) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(this.order[n].getColumnId() + 1);
            if (!dataValueDescriptor2.compare(2, dataValueDescriptor = execRow2.getColumn(this.order[n].getColumnId() + 1), true, true)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.currentRow = null;
            this.sortResultRow = null;
            this.sourceExecIndexRow = null;
            this.closeSource();
            if (this.dropDistinctAggSort) {
                this.tc.dropSort(this.distinctAggSortId);
                this.dropDistinctAggSort = false;
            }
            if (this.dropGenericSort) {
                this.tc.dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.originalSource.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rowLocation = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rowLocation);
        return rowLocation;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    private ExecIndexRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecIndexRow getRowFromResultSet() throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecRow execRow = this.source.getNextRowCore();
        if (execRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(execRow);
            execIndexRow = this.sourceExecIndexRow;
        }
        return execIndexRow;
    }

    private ExecIndexRow getRowFromSorter() throws StandardException {
        ExecIndexRow execIndexRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            execIndexRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(execIndexRow.getRowArray());
        }
        return execIndexRow;
    }

    public void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    private void initializeVectorAggregation(ExecRow execRow) throws StandardException {
        int n = this.aggregates.length;
        int n2 = 0;
        while (n2 < n) {
            GenericAggregator genericAggregator = this.aggregates[n2];
            genericAggregator.initialize(execRow);
            genericAggregator.accumulate(execRow, execRow);
            ++n2;
        }
    }

    private void mergeVectorAggregates(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n = 0;
        while (n < this.aggregates.length) {
            GenericAggregator genericAggregator = this.aggregates[n];
            genericAggregator.merge(execRow, execRow2);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GroupedAggregateResultSet(NoPutResultSet noPutResultSet, boolean bl, int n, int n2, Activation activation, GeneratedMethod generatedMethod, int n3, int n4, double d, double d2, GeneratedMethod generatedMethod2) throws StandardException {
        super(noPutResultSet, n, activation, generatedMethod, n4, d, d2, generatedMethod2);
        this.isInSortedOrder = bl;
        this.sortTemplateRow = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        this.order = (ColumnOrdering[])((FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n2)).getArray(class$Lorg$apache$derby$iapi$store$access$ColumnOrdering != null ? class$Lorg$apache$derby$iapi$store$access$ColumnOrdering : (class$Lorg$apache$derby$iapi$store$access$ColumnOrdering = GroupedAggregateResultSet.class$("org.apache.derby.iapi.store.access.ColumnOrdering")));
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }
}

