/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.jdbc.EmbedSQLWarning;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class GenericAggregateResultSet
extends NoPutResultSetImpl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    protected GenericAggregator[] aggregates;
    protected GeneratedMethod rowAllocator;
    protected AggregatorInfoList aggInfoList;
    public NoPutResultSet source;
    protected GeneratedMethod closeCleanup;
    protected NoPutResultSet originalSource;

    protected final GenericAggregator[] getSortAggregators(AggregatorInfoList aggregatorInfoList, boolean bl, LanguageConnectionContext languageConnectionContext, NoPutResultSet noPutResultSet) throws StandardException {
        Vector<GenericAggregator> vector = new Vector<GenericAggregator>();
        ClassFactory classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
        int n = aggregatorInfoList.size();
        int n2 = 0;
        while (n2 < n) {
            AggregatorInfo aggregatorInfo = (AggregatorInfo)aggregatorInfoList.elementAt(n2);
            if (!bl || !aggregatorInfo.isDistinct()) {
                vector.addElement(new GenericAggregator(aggregatorInfo, classFactory));
            }
            ++n2;
        }
        Object[] objectArray = new GenericAggregator[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected final ExecIndexRow finishAggregation(ExecIndexRow execIndexRow) throws StandardException {
        int n = this.aggregates.length;
        if (execIndexRow == null) {
            execIndexRow = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        }
        this.setCurrentRow(execIndexRow);
        this.currentRow = execIndexRow;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            GenericAggregator genericAggregator = this.aggregates[n2];
            if (genericAggregator.finish(execIndexRow)) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01003"));
        }
        return execIndexRow;
    }

    public void finish() throws StandardException {
        this.source.finish();
        super.finish();
    }

    public abstract long getTimeSpent(int var1);

    GenericAggregateResultSet(NoPutResultSet noPutResultSet, int n, Activation activation, GeneratedMethod generatedMethod, int n2, double d, double d2, GeneratedMethod generatedMethod2) throws StandardException {
        super(activation, n2, d, d2);
        this.source = noPutResultSet;
        this.originalSource = noPutResultSet;
        this.closeCleanup = generatedMethod2;
        this.rowAllocator = generatedMethod;
        this.aggInfoList = (AggregatorInfoList)activation.getPreparedStatement().getSavedObject(n);
        this.aggregates = this.getSortAggregators(this.aggInfoList, false, activation.getLanguageConnectionContext(), noPutResultSet);
    }
}

