/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class CLOBTypeCompiler
extends BaseTypeCompiler {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";

    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        return false;
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isStringTypeId();
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return typeId.isStringTypeId();
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "java.sql.Clob";
            }
            case 448: {
                return "java.sql.Clob";
            }
        }
        return null;
    }

    public String getMatchingNationalCharTypeName() {
        return "NCLOB";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    protected String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "getNullClob";
            }
            case 448: {
                return "getNullNClob";
            }
        }
        return null;
    }

    protected String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "getClobDataValue";
            }
            case 448: {
                return "getNClobDataValue";
            }
        }
        return null;
    }
}

