/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.impl.jdbc.EmbedConnection20;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.jdbc.EmbedXAConnection;

final class XAStatementControl
implements BrokeredStatementControl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";
    private final EmbedXAConnection xaConnection;
    private final BrokeredConnection applicationConnection;
    BrokeredStatement applicationStatement;
    private EmbedConnection20 realConnection;
    private Statement realStatement;
    private PreparedStatement realPreparedStatement;
    private CallableStatement realCallableStatement;

    public Statement getRealStatement() throws SQLException {
        block4: {
            if (this.applicationConnection != this.xaConnection.currentConnectionHandle) break block4;
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            Statement statement = this.applicationStatement.createDuplicateStatement(this.xaConnection.realConnection, this.realStatement);
            ((EmbedStatement)this.realStatement).transferBatch((EmbedStatement)statement);
            try {
                this.realStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realStatement = statement;
            this.realConnection = this.xaConnection.realConnection;
        }
        return this.realStatement;
    }

    public PreparedStatement getRealPreparedStatement() throws SQLException {
        block4: {
            if (this.applicationConnection != this.xaConnection.currentConnectionHandle) break block4;
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realPreparedStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            PreparedStatement preparedStatement = ((BrokeredPreparedStatement)this.applicationStatement).createDuplicateStatement((Connection)this.xaConnection.realConnection, this.realPreparedStatement);
            ((EmbedPreparedStatement)this.realPreparedStatement).transferParameters((EmbedPreparedStatement)preparedStatement);
            try {
                this.realPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realPreparedStatement = preparedStatement;
            this.realConnection = this.xaConnection.realConnection;
        }
        return this.realPreparedStatement;
    }

    public CallableStatement getRealCallableStatement() throws SQLException {
        block4: {
            if (this.applicationConnection != this.xaConnection.currentConnectionHandle) break block4;
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realCallableStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            CallableStatement callableStatement = ((BrokeredCallableStatement)this.applicationStatement).createDuplicateStatement((Connection)this.xaConnection.realConnection, this.realCallableStatement);
            ((EmbedStatement)((Object)this.realCallableStatement)).transferBatch((EmbedStatement)((Object)callableStatement));
            try {
                this.realCallableStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realCallableStatement = callableStatement;
            this.realConnection = this.xaConnection.realConnection;
        }
        return this.realCallableStatement;
    }

    public ResultSet wrapResultSet(ResultSet resultSet) {
        return resultSet;
    }

    public void checkHoldCursors(int n) throws SQLException {
        this.xaConnection.checkHoldCursors(n);
    }

    private XAStatementControl(EmbedXAConnection embedXAConnection) {
        this.xaConnection = embedXAConnection;
        this.realConnection = embedXAConnection.realConnection;
        this.applicationConnection = embedXAConnection.currentConnectionHandle;
    }

    XAStatementControl(EmbedXAConnection embedXAConnection, Statement statement) throws SQLException {
        this(embedXAConnection);
        this.realStatement = statement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this);
    }

    XAStatementControl(EmbedXAConnection embedXAConnection, PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        this(embedXAConnection);
        this.realPreparedStatement = preparedStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this, string, object);
    }

    XAStatementControl(EmbedXAConnection embedXAConnection, CallableStatement callableStatement, String string) throws SQLException {
        this(embedXAConnection);
        this.realCallableStatement = callableStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this, string);
    }
}

