/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.CachedPage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.NoSpaceOnPage;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.PageVersion;
import org.apache.derby.impl.store.raw.data.RawField;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.RememberBytesInputStream;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;

public class StoredPage
extends CachedPage {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public static final int FORMAT_NUMBER = 117;
    protected static final int PAGE_HEADER_OFFSET = 4;
    protected static final int PAGE_HEADER_SIZE = 56;
    protected static final int RECORD_SPACE_OFFSET = 60;
    protected static final int PAGE_VERSION_OFFSET = 6;
    protected static final int SMALL_SLOT_SIZE = 2;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int CHECKSUM_SIZE = 8;
    protected static final int OVERFLOW_POINTER_SIZE = 12;
    protected static final int OVERFLOW_PTR_FIELD_SIZE = 14;
    protected static final int COLUMN_NONE = 0;
    protected static final int COLUMN_FIRST = 1;
    protected static final int COLUMN_LONG = 2;
    ByteHolder bh = null;
    protected int maxFieldSize;
    private boolean isOverflowPage;
    private int slotsInUse;
    private int nextId;
    private int generation;
    private int prevGeneration;
    private long bipLocation;
    private int deletedRowCount;
    private boolean headerOutOfDate;
    private CRC32 checksum;
    protected int minimumRecordSize;
    private int userRowSize;
    private int slotFieldSize;
    private int slotEntrySize;
    private int slotTableOffsetToFirstEntry;
    private int slotTableOffsetToFirstRecordLengthField;
    private int slotTableOffsetToFirstReservedSpaceField;
    protected int totalSpace;
    protected int freeSpace = Integer.MIN_VALUE;
    private int firstFreeByte = Integer.MIN_VALUE;
    protected int spareSpace;
    private StoredRecordHeader overflowRecordHeader;
    protected ArrayInputStream rawDataIn;
    protected ArrayOutputStream rawDataOut;
    protected FormatIdOutputStream logicalDataOut;

    public int getTypeFormatId() {
        return 117;
    }

    private StoredRecordHeader getOverFlowRecordHeader() throws StandardException {
        return this.overflowRecordHeader != null ? this.overflowRecordHeader : (this.overflowRecordHeader = new StoredRecordHeader());
    }

    protected void initialize() {
        super.initialize();
        if (this.rawDataIn == null) {
            this.rawDataIn = new ArrayInputStream();
            this.checksum = new CRC32();
        }
        if (this.pageData != null) {
            this.rawDataIn.setData(this.pageData);
        }
    }

    private void createOutStreams() {
        this.rawDataOut = new ArrayOutputStream();
        this.rawDataOut.setData(this.pageData);
        this.logicalDataOut = new FormatIdOutputStream(this.rawDataOut);
    }

    private void setOutputStream(OutputStream outputStream) {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        this.logicalDataOut.setOutput(outputStream);
    }

    private void resetOutputStream() {
        this.logicalDataOut.setOutput(this.rawDataOut);
    }

    protected void usePageBuffer(byte[] byArray) {
        this.pageData = byArray;
        int n = this.pageData.length;
        if (this.rawDataIn != null) {
            this.rawDataIn.setData(this.pageData);
        }
        this.initSpace();
        this.slotFieldSize = n >= 65536 ? 4 : 2;
        this.slotEntrySize = 3 * this.slotFieldSize;
        this.slotTableOffsetToFirstEntry = n - 8 - this.slotEntrySize;
        this.slotTableOffsetToFirstRecordLengthField = this.slotTableOffsetToFirstEntry + this.slotFieldSize;
        this.slotTableOffsetToFirstReservedSpaceField = this.slotTableOffsetToFirstEntry + 2 * this.slotFieldSize;
        if (this.rawDataOut != null) {
            this.rawDataOut.setData(this.pageData);
        }
    }

    protected void createPage(PageKey pageKey, int[] nArray) throws StandardException {
        int n = nArray[2];
        this.spareSpace = nArray[3];
        this.minimumRecordSize = nArray[4];
        this.setPageArray(n);
        this.cleanPage();
        this.setPageVersion(0L);
        this.nextId = 6;
        this.generation = 0;
        this.prevGeneration = 0;
        this.bipLocation = 0L;
        this.createOutStreams();
    }

    protected void initFromData(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        if (fileContainer != null) {
            this.spareSpace = fileContainer.getSpareSpace();
            this.minimumRecordSize = fileContainer.getMinimumRecordSize();
        }
        try {
            this.readPageHeader();
            this.initSlotTable();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
        }
        try {
            this.validateChecksum(pageKey);
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("XSDG2.D")) {
                int n = this.getPageSize();
                byte[] byArray = this.pageData;
                this.pageData = null;
                this.setPageArray(n);
                try {
                    fileContainer.readPage(pageKey.getPageNumber(), this.pageData);
                }
                catch (IOException iOException) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
                }
                try {
                    this.validateChecksum(pageKey);
                }
                catch (StandardException standardException2) {
                    throw this.dataFactory.markCorrupt(standardException);
                }
                String string = StoredPage.pagedataToHexDump(byArray);
                String string2 = StoredPage.pagedataToHexDump(byArray);
                throw StandardException.newException("XSDFD.S", standardException, (Object)pageKey, (Object)string, (Object)string2);
            }
            throw standardException;
        }
    }

    protected void validateChecksum(PageKey pageKey) throws StandardException {
        long l;
        try {
            this.rawDataIn.setPosition(this.getPageSize() - 8);
            l = this.rawDataIn.readLong();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
        }
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        if (l != this.checksum.getValue()) {
            CRC32 cRC32 = new CRC32();
            cRC32.reset();
            cRC32.update(this.pageData, 0, this.getPageSize() - 8);
            if (l != cRC32.getValue()) {
                throw StandardException.newException("XSDG2.D", pageKey, (Object)new Long(this.checksum.getValue()), (Object)new Long(l), (Object)StoredPage.pagedataToHexDump(this.pageData));
            }
            this.checksum = cRC32;
        }
    }

    protected void updateChecksum() throws IOException {
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        this.rawDataOut.setPosition(this.getPageSize() - 8);
        this.logicalDataOut.writeLong(this.checksum.getValue());
    }

    protected void writePage(PageKey pageKey) throws StandardException {
        try {
            if (this.headerOutOfDate) {
                this.updatePageHeader();
            } else {
                this.updatePageVersion();
            }
            this.updateChecksum();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
        }
    }

    protected void writeFormatId(PageKey pageKey) throws StandardException {
        try {
            if (this.rawDataOut == null) {
                this.createOutStreams();
            }
            this.rawDataOut.setPosition(0);
            FormatIdUtil.writeFormatIdInteger(this.logicalDataOut, this.getTypeFormatId());
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
        }
    }

    protected void releaseExclusive() {
        super.releaseExclusive();
        this.pageCache.release(this);
    }

    public int getTotalSpace(int n) throws StandardException {
        try {
            this.rawDataIn.setPosition(this.getSlotOffset(n) + this.slotFieldSize);
            return this.slotFieldSize == 2 ? this.rawDataIn.readUnsignedShort() + this.rawDataIn.readUnsignedShort() : this.rawDataIn.readInt() + this.rawDataIn.readInt();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
    }

    public boolean spaceForInsert() throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        int n = this.totalSpace - this.freeSpace;
        int n2 = n / this.slotsInUse;
        return n2 <= this.freeSpace;
    }

    public boolean spaceForInsert(Object[] objectArray, FormatableBitSet formatableBitSet, int n) throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, 0, (byte)1, -1, -1, n);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return false;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
        return true;
    }

    private boolean spaceForInsert(Object[] objectArray, FormatableBitSet formatableBitSet, int n, int n2, int n3) throws StandardException {
        if (!this.spaceForInsert() || this.freeSpace < n) {
            return false;
        }
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, n2, (byte)1, -1, -1, n3);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return false;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
        return true;
    }

    public boolean unfilled() {
        return this.allowInsert() && this.freeSpace > this.getPageSize() / 2;
    }

    public boolean allowInsert() {
        if (this.slotsInUse == 0) {
            return true;
        }
        int n = this.freeSpace;
        if ((n -= this.slotEntrySize) < this.minimumRecordSize) {
            return false;
        }
        return n * 100 / this.totalSpace >= this.spareSpace;
    }

    public boolean spaceForCopy(int n, int[] nArray) {
        int n2 = this.slotEntrySize * n;
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] > 0) {
                n2 += nArray[n3] >= this.minimumRecordSize ? nArray[n3] : this.minimumRecordSize;
            }
            ++n3;
        }
        return this.freeSpace - n2 >= 0;
    }

    protected boolean restoreRecordFromSlot(int n, Object[] objectArray, FetchDescriptor fetchDescriptor, RecordHandle recordHandle, StoredRecordHeader storedRecordHeader, boolean bl) throws StandardException {
        try {
            int n2 = this.getRecordOffset(n) + storedRecordHeader.size();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n2);
            if (!storedRecordHeader.hasOverflow()) {
                if (bl && fetchDescriptor != null && fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                    if (!this.qualifyRecordFromSlot(objectArray, n2, fetchDescriptor, storedRecordHeader, recordHandle)) {
                        return false;
                    }
                    arrayInputStream.setPosition(n2);
                }
                if (fetchDescriptor != null) {
                    this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader, null, recordHandle);
                } else {
                    this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader, null, recordHandle);
                }
                return true;
            }
            if (fetchDescriptor != null) {
                if (fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                }
                this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader, null, recordHandle);
            } else {
                this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader, null, recordHandle);
            }
            while (storedRecordHeader != null) {
                StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                storedRecordHeader = storedPage.restoreLongRecordFromSlot(objectArray, fetchDescriptor, recordHandle, storedRecordHeader);
                storedPage.unlatch();
                storedPage = null;
            }
            return fetchDescriptor == null || fetchDescriptor.getQualifierList() == null || this.qualifyRecordFromRow(objectArray, fetchDescriptor.getQualifierList());
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
    }

    private StoredRecordHeader restoreLongRecordFromSlot(Object[] objectArray, FetchDescriptor fetchDescriptor, RecordHandle recordHandle, StoredRecordHeader storedRecordHeader) throws StandardException {
        int n = this.findRecordById(storedRecordHeader.getOverflowId(), 0);
        StoredRecordHeader storedRecordHeader2 = this.getHeaderAtSlot(n);
        try {
            int n2 = this.getRecordOffset(n) + storedRecordHeader2.size();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n2);
            if (fetchDescriptor != null) {
                if (fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                }
                this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader2, null, recordHandle);
            } else {
                this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader2, null, recordHandle);
            }
            return storedRecordHeader2.hasOverflow() ? storedRecordHeader2 : null;
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
    }

    public int newRecordId() {
        return this.nextId;
    }

    public int newRecordIdAndBump() {
        this.headerOutOfDate = true;
        return this.nextId++;
    }

    protected int newRecordId(int n) {
        return n + 1;
    }

    public boolean isOverflowPage() {
        return this.isOverflowPage;
    }

    public final int getPageSize() {
        return this.pageData.length;
    }

    protected final void clearSection(int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            this.pageData[n++] = 0;
        }
    }

    protected int getMaxFreeSpace() {
        return this.getPageSize() - 60 - 8;
    }

    protected int getCurrentFreeSpace() {
        return this.freeSpace;
    }

    private void readPageHeader() throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(4);
        this.isOverflowPage = arrayInputStream.readBoolean();
        this.setPageStatus(arrayInputStream.readByte());
        this.setPageVersion(arrayInputStream.readLong());
        this.slotsInUse = arrayInputStream.readUnsignedShort();
        this.nextId = arrayInputStream.readInt();
        this.generation = arrayInputStream.readInt();
        this.prevGeneration = arrayInputStream.readInt();
        this.bipLocation = arrayInputStream.readLong();
        this.deletedRowCount = arrayInputStream.readUnsignedShort() - 1;
        long l = arrayInputStream.readUnsignedShort();
        l = arrayInputStream.readInt();
        l = arrayInputStream.readLong();
        l = arrayInputStream.readLong();
    }

    private void updatePageHeader() throws IOException {
        this.rawDataOut.setPosition(4);
        this.logicalDataOut.writeBoolean(this.isOverflowPage);
        this.logicalDataOut.writeByte(this.getPageStatus());
        this.logicalDataOut.writeLong(this.getPageVersion());
        this.logicalDataOut.writeShort(this.slotsInUse);
        this.logicalDataOut.writeInt(this.nextId);
        this.logicalDataOut.writeInt(this.generation);
        this.logicalDataOut.writeInt(this.prevGeneration);
        this.logicalDataOut.writeLong(this.bipLocation);
        this.logicalDataOut.writeShort(this.deletedRowCount + 1);
        this.logicalDataOut.writeShort(0);
        this.logicalDataOut.writeInt(this.dataFactory.random());
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.headerOutOfDate = false;
    }

    private void updatePageVersion() throws IOException {
        this.rawDataOut.setPosition(6);
        this.logicalDataOut.writeLong(this.getPageVersion());
    }

    private int getSlotOffset(int n) {
        return this.slotTableOffsetToFirstEntry - n * this.slotEntrySize;
    }

    private int getRecordOffset(int n) {
        byte[] byArray = this.pageData;
        int n2 = this.slotTableOffsetToFirstEntry - n * this.slotEntrySize;
        return this.slotFieldSize == 2 ? (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF : (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private void setRecordOffset(int n, int n2) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(n));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n2);
        } else {
            this.logicalDataOut.writeInt(n2);
        }
    }

    protected int getRecordPortionLength(int n) throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(this.slotTableOffsetToFirstRecordLengthField - n * this.slotEntrySize);
        return this.slotFieldSize == 2 ? arrayInputStream.readUnsignedShort() : arrayInputStream.readInt();
    }

    public int getReservedCount(int n) throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(this.slotTableOffsetToFirstReservedSpaceField - n * this.slotEntrySize);
        return this.slotFieldSize == 2 ? arrayInputStream.readUnsignedShort() : arrayInputStream.readInt();
    }

    private void updateRecordPortionLength(int n, int n2, int n3) throws IOException {
        this.rawDataOut.setPosition(this.slotTableOffsetToFirstRecordLengthField - n * this.slotEntrySize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(this.getRecordPortionLength(n) + n2);
        } else {
            this.logicalDataOut.writeInt(this.getRecordPortionLength(n) + n2);
        }
        if (n3 != 0) {
            if (this.slotFieldSize == 2) {
                this.logicalDataOut.writeShort(this.getReservedCount(n) + n3);
            } else {
                this.logicalDataOut.writeInt(this.getReservedCount(n) + n3);
            }
        }
    }

    private void initSlotTable() throws StandardException {
        int n = this.slotsInUse;
        this.initializeHeaders(n);
        this.clearAllSpace();
        this.freeSpace -= n * this.slotEntrySize;
        int n2 = -1;
        int n3 = -1;
        try {
            int n4;
            int n5 = 0;
            while (n5 < n) {
                n4 = this.getRecordOffset(n5);
                if (n4 < 60 || n4 >= this.getPageSize() - 8) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
                }
                if (n4 > n3) {
                    n3 = n4;
                    n2 = n5;
                }
                ++n5;
            }
            this.bumpRecordCount(n);
            if (n2 != -1) {
                this.firstFreeByte = n3 + this.getTotalSpace(n2);
                this.freeSpace -= this.firstFreeByte - 60;
            }
            if (this.deletedRowCount == -1) {
                n5 = 0;
                n4 = this.slotsInUse;
                int n6 = 0;
                while (n6 < n4) {
                    if (this.isDeletedOnPage(n6)) {
                        ++n5;
                    }
                    ++n6;
                }
                this.deletedRowCount = n5;
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
    }

    private void setSlotEntry(int n, int n2, int n3, int n4) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(n));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n2);
            this.logicalDataOut.writeShort(n3);
            this.logicalDataOut.writeShort(n4);
        } else {
            this.logicalDataOut.writeInt(n2);
            this.logicalDataOut.writeInt(n3);
            this.logicalDataOut.writeInt(n4);
        }
    }

    private void addSlotEntry(int n, int n2, int n3, int n4) throws IOException {
        if (n < this.slotsInUse) {
            int n5 = this.getSlotOffset(this.slotsInUse - 1);
            int n6 = this.getSlotOffset(n) + this.slotEntrySize - n5;
            int n7 = this.getSlotOffset(this.slotsInUse);
            System.arraycopy(this.pageData, n5, this.pageData, n7, n6);
        } else {
            int n8 = this.getSlotOffset(n);
        }
        this.freeSpace -= this.slotEntrySize;
        ++this.slotsInUse;
        this.headerOutOfDate = true;
        this.setSlotEntry(n, n2, n3, n4);
    }

    private void removeSlotEntry(int n) throws IOException {
        int n2 = this.getSlotOffset(this.slotsInUse - 1);
        int n3 = this.getSlotOffset(this.slotsInUse - 2);
        if (n != this.slotsInUse - 1) {
            int n4 = this.getSlotOffset(n) - n2;
            System.arraycopy(this.pageData, n2, this.pageData, n3, n4);
        }
        this.clearSection(n2, this.slotEntrySize);
        this.freeSpace += this.slotEntrySize;
        --this.slotsInUse;
        this.headerOutOfDate = true;
    }

    public StoredRecordHeader recordHeaderOnDemand(int n) {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader(this.pageData, this.getRecordOffset(n));
        this.setHeaderAtSlot(n, storedRecordHeader);
        return storedRecordHeader;
    }

    public boolean entireRecordOnPage(int n) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (storedRecordHeader.hasOverflow()) {
            return false;
        }
        try {
            int n2 = this.getRecordOffset(n);
            int n3 = storedRecordHeader.getNumberFields();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n2 + storedRecordHeader.size());
            int n4 = 0;
            while (n4 < n3) {
                int n5 = StoredFieldHeader.readStatus(arrayInputStream);
                if (StoredFieldHeader.isOverflow(n5)) {
                    return false;
                }
                int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
                if (n6 != 0) {
                    arrayInputStream.setPosition(arrayInputStream.getPosition() + n6);
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
        return true;
    }

    protected void purgeOverflowAtSlot(int n, RecordHandle recordHandle, boolean bl) throws StandardException {
        if (n < 0 || n >= this.slotsInUse) {
            throw StandardException.newException("XSDA1.S");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[]{this.getHeaderAtSlot(n).getId()};
        this.owner.getActionSet().actionPurge(rawTransaction, this, n, 1, nArray, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeOneColumnChain(long l, int n) throws StandardException {
        StoredPage storedPage = null;
        boolean bl = false;
        try {
            while (l != -1L) {
                storedPage = this.getOverflowPage(l);
                bl = false;
                if (storedPage != null) {
                    int n2 = 0;
                    RecordHandle recordHandle = storedPage.getNextColumnPiece(n2);
                    if (storedPage.recordCount() == 1) {
                        bl = true;
                        this.owner.removePage(storedPage);
                    } else {
                        storedPage.unlatch();
                        storedPage = null;
                    }
                    if (recordHandle != null) {
                        l = recordHandle.getPageNumber();
                        n = recordHandle.getId();
                        continue;
                    }
                    l = -1L;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!bl && storedPage != null) {
                storedPage.unlatch();
                storedPage = null;
            }
            throw throwable;
        }
        Object var7_7 = null;
        if (!bl && storedPage != null) {
            storedPage.unlatch();
            return;
        }
    }

    private void purgeColumnChains(RawTransaction rawTransaction, int n, RecordHandle recordHandle) throws StandardException {
        try {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
            int n2 = storedRecordHeader.getNumberFields();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            int n3 = this.getRecordOffset(n) + storedRecordHeader.size();
            arrayInputStream.setPosition(n3);
            int n4 = 0;
            while (n4 < n2) {
                int n5 = StoredFieldHeader.readStatus(arrayInputStream);
                int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
                if (!StoredFieldHeader.isOverflow(n5)) {
                    if (n6 != 0) {
                        arrayInputStream.setPosition(arrayInputStream.getPosition() + n6);
                    }
                } else {
                    long l = CompressedNumber.readLong(arrayInputStream);
                    int n7 = CompressedNumber.readInt(arrayInputStream);
                    this.purgeOneColumnChain(l, n7);
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
    }

    protected void purgeRowPieces(RawTransaction rawTransaction, int n, RecordHandle recordHandle, boolean bl) throws StandardException {
        this.purgeColumnChains(rawTransaction, n, recordHandle);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        while (storedRecordHeader.hasOverflow()) {
            Object var8_7;
            StoredPage storedPage;
            block8: {
                storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                if (storedPage == null) break;
                try {
                    int n2 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
                    storedPage.purgeColumnChains(rawTransaction, n2, recordHandle);
                    storedRecordHeader = storedPage.getHeaderAtSlot(n2);
                    if (n2 == 0 && storedPage.recordCount() == 1) {
                        try {
                            this.owner.removePage(storedPage);
                            break block8;
                        }
                        finally {
                            Object var11_9 = null;
                            storedPage = null;
                        }
                    }
                    storedPage.purgeOverflowAtSlot(n2, recordHandle, bl);
                    storedPage.unlatch();
                    storedPage = null;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (storedPage != null) {
                        storedPage.unlatch();
                        storedPage = null;
                    }
                    throw throwable;
                }
            }
            var8_7 = null;
            if (storedPage == null) continue;
            storedPage.unlatch();
            storedPage = null;
        }
    }

    void removeOrphanedColumnChain(ReclaimSpace reclaimSpace, ContainerHandle containerHandle) throws StandardException {
        StoredPage storedPage = (StoredPage)containerHandle.getPageNoWait(reclaimSpace.getColumnPageId());
        if (storedPage == null) {
            return;
        }
        boolean bl = storedPage.equalTimeStamp(reclaimSpace.getPageTimeStamp());
        storedPage.unlatch();
        if (!bl) {
            return;
        }
        RecordHandle recordHandle = reclaimSpace.getHeadRowHandle();
        int n = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n >= 0) {
            StoredPage storedPage2 = this;
            try {
                try {
                    int n2 = reclaimSpace.getColumnId();
                    StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
                    while (storedRecordHeader.getNumberFields() + storedRecordHeader.getFirstField() <= n2) {
                        if (storedPage2 != this) {
                            storedPage2.unlatch();
                            storedPage2 = null;
                        }
                        if (!storedRecordHeader.hasOverflow()) break;
                        storedPage2 = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                        storedRecordHeader = storedPage2.getHeaderAtSlot(StoredPage.getOverflowSlot(storedPage2, storedRecordHeader));
                    }
                    if (storedRecordHeader.getNumberFields() + storedRecordHeader.getFirstField() > n2 && !storedPage2.isColumnOrphaned(storedRecordHeader, n2, reclaimSpace.getColumnPageId(), reclaimSpace.getColumnRecordId())) {
                        if (storedPage2 != this) {
                            storedPage2.unlatch();
                            storedPage2 = null;
                        }
                        Object var9_12 = null;
                        if (storedPage2 != this && storedPage2 != null) {
                            storedPage2.unlatch();
                        }
                        return;
                    }
                    Object var9_13 = null;
                    if (storedPage2 != this && storedPage2 != null) {
                        storedPage2.unlatch();
                    }
                }
                catch (IOException iOException) {
                    throw StandardException.newException("XSDA4.S", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                if (storedPage2 != this && storedPage2 != null) {
                    storedPage2.unlatch();
                }
                throw throwable;
            }
        }
        long l = reclaimSpace.getColumnPageId();
        int n3 = reclaimSpace.getColumnRecordId();
        this.purgeOneColumnChain(l, n3);
    }

    private boolean isColumnOrphaned(StoredRecordHeader storedRecordHeader, int n, long l, long l2) throws StandardException, IOException {
        int n2 = this.findRecordById(storedRecordHeader.getId(), 0);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        int n3 = this.getRecordOffset(n2);
        arrayInputStream.setPosition(n3 + storedRecordHeader.size());
        int n4 = storedRecordHeader.getFirstField();
        while (n4 < n) {
            this.skipField(arrayInputStream);
            ++n4;
        }
        n4 = StoredFieldHeader.readStatus(arrayInputStream);
        int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
        if (StoredFieldHeader.isOverflow(n4)) {
            long l3 = CompressedNumber.readLong(arrayInputStream);
            int n6 = CompressedNumber.readInt(arrayInputStream);
            if (l3 == l && (long)n6 == l2) {
                return false;
            }
        }
        return true;
    }

    private RecordHandle getNextColumnPiece(int n) throws StandardException {
        try {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
            int n2 = storedRecordHeader.getNumberFields();
            if (n2 != 2) {
                return null;
            }
            ArrayInputStream arrayInputStream = this.rawDataIn;
            int n3 = this.getRecordOffset(n) + storedRecordHeader.size();
            arrayInputStream.setPosition(n3);
            this.skipField(arrayInputStream);
            int n4 = StoredFieldHeader.readStatus(arrayInputStream);
            int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
            long l = CompressedNumber.readLong(arrayInputStream);
            int n6 = CompressedNumber.readInt(arrayInputStream);
            return this.owner.makeRecordHandle(l, n6);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
        }
    }

    private void initSpace() {
        this.totalSpace = this.getMaxFreeSpace();
        this.maxFieldSize = this.totalSpace - this.slotEntrySize - 16 - 12;
    }

    private void clearAllSpace() {
        this.freeSpace = this.totalSpace;
        this.firstFreeByte = this.getPageSize() - this.totalSpace - 8;
    }

    private void compressPage(int n, int n2) throws IOException {
        int n3 = n2 + 1 - n;
        if (n2 + 1 != this.firstFreeByte) {
            int n4 = this.firstFreeByte - n2 - 1;
            System.arraycopy(this.pageData, n2 + 1, this.pageData, n, n4);
            int n5 = 0;
            while (n5 < this.slotsInUse) {
                int n6 = this.getRecordOffset(n5);
                if (n6 >= n2 + 1) {
                    this.setRecordOffset(n5, n6 -= n3);
                }
                ++n5;
            }
        }
        this.freeSpace += n3;
        this.firstFreeByte -= n3;
        this.clearSection(this.firstFreeByte, n3);
    }

    protected void expandPage(int n, int n2) throws IOException {
        int n3 = this.firstFreeByte - n;
        if (n3 > 0) {
            System.arraycopy(this.pageData, n, this.pageData, n + n2, n3);
            int n4 = 0;
            while (n4 < this.slotsInUse) {
                int n5 = this.getRecordOffset(n4);
                if (n5 >= n) {
                    this.setRecordOffset(n4, n5 += n2);
                }
                ++n4;
            }
        }
        this.freeSpace -= n2;
        this.firstFreeByte += n2;
    }

    private void shrinkPage(int n, int n2) throws IOException {
        int n3 = this.firstFreeByte - n;
        if (n3 > 0) {
            System.arraycopy(this.pageData, n, this.pageData, n - n2, n3);
            int n4 = 0;
            while (n4 < this.slotsInUse) {
                int n5 = this.getRecordOffset(n4);
                if (n5 >= n) {
                    this.setRecordOffset(n4, n5 -= n2);
                }
                ++n4;
            }
        }
        this.freeSpace += n2;
        this.firstFreeByte -= n2;
    }

    public int getRecordLength(int n) throws IOException {
        return this.getRecordPortionLength(n);
    }

    protected boolean getIsOverflow(int n) throws IOException {
        return this.getHeaderAtSlot(n).hasOverflow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int logRow(int n, boolean bl, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n3, byte by, int n4, int n5, int n6) throws StandardException, IOException {
        block61: {
            int n7;
            block63: {
                int n8;
                block60: {
                    if (!bl && n4 != -1 && n5 == -1) {
                        return n4;
                    }
                    int n9 = this.freeSpace;
                    this.setOutputStream(dynamicByteArrayOutputStream);
                    int n10 = dynamicByteArrayOutputStream.getPosition();
                    this.userRowSize = 0;
                    boolean bl2 = false;
                    if (n4 != -1) {
                        n9 = n5;
                        n10 = dynamicByteArrayOutputStream.getBeginPosition();
                    } else {
                        if (!bl) {
                            n9 += this.getTotalSpace(n);
                        } else {
                            n9 -= this.slotEntrySize;
                            if (n3 == 0) {
                                bl2 = true;
                            }
                        }
                        if (n9 <= 0) {
                            throw new NoSpaceOnPage(this.isOverflowPage());
                        }
                    }
                    try {
                        int n11;
                        int n12;
                        int n13;
                        StoredRecordHeader storedRecordHeader;
                        if (objectArray == null) {
                            int n14 = this.logOverflowRecord(n, n9, dynamicByteArrayOutputStream);
                            Object var16_18 = null;
                            this.resetOutputStream();
                            return n14;
                        }
                        int n15 = 0;
                        if (bl) {
                            storedRecordHeader = new StoredRecordHeader();
                        } else {
                            storedRecordHeader = new StoredRecordHeader(this.getHeaderAtSlot(n));
                            n3 = storedRecordHeader.getFirstField();
                        }
                        if (formatableBitSet == null) {
                            n15 = objectArray.length - n3;
                        } else {
                            n13 = formatableBitSet.getLength() - 1;
                            while (n13 >= n3) {
                                if (formatableBitSet.isSet(n13)) {
                                    n15 = n13 + 1 - n3;
                                    break;
                                }
                                --n13;
                            }
                        }
                        n13 = -1;
                        if (bl) {
                            storedRecordHeader.setId(n2);
                            storedRecordHeader.setNumberFields(n15);
                        } else {
                            n13 = storedRecordHeader.getNumberFields();
                            if (n15 > n13) {
                                if (storedRecordHeader.hasOverflow()) {
                                    n15 = n13;
                                } else {
                                    storedRecordHeader.setNumberFields(n15);
                                }
                            } else if (n15 < n13) {
                                if (formatableBitSet == null) {
                                    storedRecordHeader.setNumberFields(n15);
                                } else {
                                    n15 = n13;
                                }
                            }
                        }
                        int n16 = n3 + n15;
                        if (n4 >= n16) {
                            n8 = -1;
                            break block60;
                        }
                        if ((by & 1) != 1) {
                            storedRecordHeader.setFirstField(n3);
                        }
                        int n17 = n4;
                        if (n4 == -1) {
                            n12 = storedRecordHeader.write(this.logicalDataOut);
                            if ((n9 -= n12) < 0) {
                                throw new NoSpaceOnPage(this.isOverflowPage());
                            }
                            n17 = n3;
                        }
                        n12 = 0;
                        int n18 = n11 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
                        if (formatableBitSet != null && !bl && formatableBitSet != null && n17 < n3 + n13) {
                            this.rawDataIn.setPosition(this.getFieldOffset(n, n17));
                            n12 = 1;
                        }
                        int n19 = n9;
                        int n20 = 0;
                        int n21 = dynamicByteArrayOutputStream.getPosition();
                        int n22 = n3;
                        if (n9 > 12) {
                            n21 = -1;
                        }
                        int n23 = 1;
                        int n24 = n17;
                        while (true) {
                            int n25;
                            int n26;
                            block62: {
                                Object object;
                                block64: {
                                    if (n24 >= n16) {
                                        dynamicByteArrayOutputStream.setBeginPosition(n10);
                                        n3 = -1;
                                        if (bl2 && n9 < this.minimumRecordSize - this.userRowSize) {
                                            throw new NoSpaceOnPage(this.isOverflowPage());
                                        }
                                        break block61;
                                    }
                                    object = null;
                                    boolean bl3 = false;
                                    if (formatableBitSet == null || n11 > n24 && formatableBitSet.isSet(n24)) {
                                        if (n24 < objectArray.length) {
                                            object = objectArray[n24];
                                        }
                                    } else if (!bl) {
                                        bl3 = true;
                                    }
                                    if (n9 > 12) {
                                        n21 = dynamicByteArrayOutputStream.getPosition();
                                        n22 = n24;
                                    }
                                    n19 = n9;
                                    if (!bl3) break block64;
                                    if (n24 < n3 + n13) {
                                        n26 = this.rawDataIn.getPosition();
                                        this.skipField(this.rawDataIn);
                                        n25 = this.rawDataIn.getPosition() - n26;
                                        if (n25 <= n9) {
                                            this.logColumn(null, 0, dynamicByteArrayOutputStream, Integer.MAX_VALUE, 0, n6);
                                            n9 -= n25;
                                        }
                                        break block62;
                                    } else {
                                        n9 = this.logColumn(null, 0, dynamicByteArrayOutputStream, n9, n23, n6);
                                    }
                                    break block62;
                                }
                                if (n12 != 0 && n24 < n3 + n13) {
                                    this.skipField(this.rawDataIn);
                                }
                                try {
                                    n9 = object == null ? this.logColumn(null, 0, dynamicByteArrayOutputStream, n9, n23, n6) : this.logColumn(objectArray, n24, dynamicByteArrayOutputStream, n9, n23, n6);
                                }
                                catch (LongColumnException longColumnException) {
                                    if ((by & 1) == 1) {
                                        if (!(longColumnException.getColumn() instanceof InputStream)) throw new NoSpaceOnPage(this.isOverflowPage());
                                        if (!(objectArray[n24] instanceof StreamStorable)) throw new NoSpaceOnPage(this.isOverflowPage());
                                        if (!(objectArray[n24] instanceof InputStream)) {
                                            if (((StreamStorable)objectArray[n24]).returnStream() == null) throw new NoSpaceOnPage(this.isOverflowPage());
                                        }
                                        ((StreamStorable)objectArray[n24]).setStream((InputStream)longColumnException.getColumn());
                                        throw new NoSpaceOnPage(this.isOverflowPage());
                                    }
                                    if ((n9 < 14 || n24 != n16 - 1) && (n9 < 28 || n24 >= n16 - 1)) break block62;
                                    dynamicByteArrayOutputStream.setBeginPosition(n10);
                                    longColumnException.setExceptionInfo(dynamicByteArrayOutputStream, n24, n9);
                                    throw longColumnException;
                                }
                            }
                            int n27 = n25 = n6 == 100 ? 0 : (int)(this.isLong(n20 += n19 - n9, n6) ? 1 : 0);
                            if (n19 == n9 || n25 != 0) {
                                if ((by & 1) == 1) {
                                    throw new NoSpaceOnPage(this.isOverflowPage());
                                }
                                if (n25 != 0) {
                                    dynamicByteArrayOutputStream.setPosition(dynamicByteArrayOutputStream.getPosition() - n20);
                                }
                                n26 = n24;
                            } else {
                                n26 = n16;
                            }
                            if ((n19 == n9 || (by & 0x10) == 16) && n9 <= 12) {
                                if (n24 == n3) throw new NoSpaceOnPage(this.isOverflowPage());
                                if (n21 < 0) {
                                    throw new NoSpaceOnPage(this.isOverflowPage());
                                }
                                dynamicByteArrayOutputStream.setPosition(n21);
                                n26 = n22;
                            }
                            if (n26 < n16) {
                                int n28;
                                int n29 = n26 - n3;
                                int n30 = storedRecordHeader.size();
                                storedRecordHeader.setNumberFields(n29);
                                int n31 = storedRecordHeader.size();
                                int n32 = dynamicByteArrayOutputStream.getPosition();
                                if (n30 > n31) {
                                    n28 = n30 - n31;
                                    dynamicByteArrayOutputStream.setBeginPosition(n10 + n28);
                                    dynamicByteArrayOutputStream.setPosition(n10 + n28);
                                } else if (n31 > n30) {
                                    dynamicByteArrayOutputStream.setPosition(n10);
                                } else {
                                    dynamicByteArrayOutputStream.setBeginPosition(n10);
                                    dynamicByteArrayOutputStream.setPosition(n10);
                                }
                                n28 = storedRecordHeader.write(this.logicalDataOut);
                                dynamicByteArrayOutputStream.setPosition(n32);
                                if (!bl && formatableBitSet != null) {
                                    this.handleIncompleteLogRow(n, n26, formatableBitSet, dynamicByteArrayOutputStream);
                                }
                                n7 = n26;
                                break block63;
                            }
                            n23 = 0;
                            ++n24;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_22 = null;
                        this.resetOutputStream();
                        throw throwable;
                    }
                }
                Object var16_19 = null;
                this.resetOutputStream();
                return n8;
            }
            Object var16_20 = null;
            this.resetOutputStream();
            return n7;
        }
        Object var16_21 = null;
        this.resetOutputStream();
        return n3;
    }

    private void handleIncompleteLogRow(int n, int n2, FormatableBitSet formatableBitSet, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        int n3 = storedRecordHeader.getFirstField() + storedRecordHeader.getNumberFields();
        boolean bl = false;
        int n4 = formatableBitSet.size();
        int n5 = n2;
        while (n5 < n3) {
            if (n4 <= n5 || !formatableBitSet.get(n5)) {
                bl = true;
                break;
            }
            ++n5;
        }
        if (!bl) {
            return;
        }
        Object[] objectArray = new Object[n3 - n2];
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n6 = n2;
        while (n6 < n3) {
            if (n4 <= n6 || !formatableBitSet.get(n6)) {
                try {
                    if (byteArrayOutputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                    } else {
                        byteArrayOutputStream.reset();
                    }
                    this.logField(n, n6, byteArrayOutputStream);
                    objectArray[n6 - n2] = new RawField(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)this.getPageId()));
                }
            }
            ++n6;
        }
        LongColumnException longColumnException = new LongColumnException();
        longColumnException.setExceptionInfo(dynamicByteArrayOutputStream, n2, -1);
        longColumnException.setColumn(objectArray);
        throw longColumnException;
    }

    public void restoreRecordFromStream(LimitObjectInput limitObjectInput, Object[] objectArray) throws StandardException, IOException {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader();
        storedRecordHeader.read(limitObjectInput);
        this.readRecordFromStream(objectArray, objectArray.length - 1, null, null, limitObjectInput, storedRecordHeader, null, null);
    }

    private boolean qualifyRecordFromRow(Object[] objectArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object;
        boolean bl = true;
        int n = 0;
        while (n < qualifierArray[0].length) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n];
            object = (DataValueDescriptor)objectArray[qualifier.getColumnId()];
            bl = object.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        n = 1;
        while (n < qualifierArray.length) {
            bl = false;
            int n2 = 0;
            while (n2 < qualifierArray[n].length) {
                object = qualifierArray[n][n2];
                int n3 = object.getColumnId();
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray[object.getColumnId()];
                bl = dataValueDescriptor.compare(object.getOperator(), object.getOrderable(), object.getOrderedNulls(), object.getUnknownRV());
                if (object.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
                ++n2;
            }
            if (!bl) break;
            ++n;
        }
        return bl;
    }

    private final void readOneColumnFromPage(Object[] objectArray, int n, int n2, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        ArrayInputStream arrayInputStream = this.rawDataIn;
        try {
            Object object = objectArray[n];
            if (n <= storedRecordHeader.getNumberFields() - 1) {
                int n3 = n;
                while (n3 > 0) {
                    n2 += StoredFieldHeader.readTotalFieldLength(this.pageData, n2);
                    --n3;
                }
                n3 = StoredFieldHeader.readStatus(this.pageData, n2);
                int n4 = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, n2 + 1, n3, this.slotFieldSize, arrayInputStream);
                if (!StoredFieldHeader.isNonexistent(n3)) {
                    boolean bl = StoredFieldHeader.isOverflow(n3);
                    OverflowInputStream overflowInputStream = null;
                    if (bl) {
                        long l = CompressedNumber.readLong(arrayInputStream);
                        int n5 = CompressedNumber.readInt(arrayInputStream);
                        MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                        overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l, n5, recordHandle);
                    }
                    if (object instanceof DataValueDescriptor) {
                        DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                        if (StoredFieldHeader.isNull(n3)) {
                            dataValueDescriptor.restoreToNull();
                        } else if (!bl) {
                            arrayInputStream.setLimit(n4);
                            errorObjectInput = arrayInputStream;
                            dataValueDescriptor.readExternalFromArray(arrayInputStream);
                            errorObjectInput = null;
                            int n6 = arrayInputStream.clearLimit();
                            if (n6 != 0) {
                                arrayInputStream.skipBytes(n6);
                            }
                        } else {
                            FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                            if (dataValueDescriptor instanceof StreamStorable) {
                                ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                            } else {
                                errorObjectInput = formatIdInputStream;
                                dataValueDescriptor.readExternal(formatIdInputStream);
                                errorObjectInput = null;
                            }
                        }
                    } else {
                        if (StoredFieldHeader.isNull(n3)) {
                            throw StandardException.newException("XSDA6.S", Integer.toString(n));
                        }
                        arrayInputStream.setLimit(n4);
                        errorObjectInput = arrayInputStream;
                        objectArray[n] = arrayInputStream.readObject();
                        errorObjectInput = null;
                        int n7 = arrayInputStream.clearLimit();
                        if (n7 != 0) {
                            arrayInputStream.skipBytes(n7);
                        }
                    }
                } else if (object instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)object).restoreToNull();
                } else {
                    objectArray[n] = null;
                }
            } else if (object instanceof DataValueDescriptor) {
                ((DataValueDescriptor)object).restoreToNull();
            } else {
                objectArray[n] = null;
            }
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, (Object)errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, (Object)errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, (Object)errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, (Object)errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            arrayInputStream.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, (Object)errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, (Object)errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    private final boolean qualifyRecordFromSlot(Object[] objectArray, int n, FetchDescriptor fetchDescriptor, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        boolean bl = true;
        Qualifier[][] qualifierArray = fetchDescriptor.getQualifierList();
        int[] nArray = fetchDescriptor.getMaterializedColumns();
        int n2 = 0;
        while (n2 < qualifierArray[0].length) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n2];
            int n3 = qualifier.getColumnId();
            if (nArray[n3] == 0) {
                this.readOneColumnFromPage(objectArray, n3, n, storedRecordHeader, recordHandle);
                nArray[n3] = n;
            }
            bl = ((DataValueDescriptor)objectArray[n3]).compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < qualifierArray.length) {
            bl = false;
            int n4 = 0;
            while (n4 < qualifierArray[n2].length) {
                Qualifier qualifier = qualifierArray[n2][n4];
                int n5 = qualifier.getColumnId();
                if (nArray[n5] == 0) {
                    this.readOneColumnFromPage(objectArray, n5, n, storedRecordHeader, recordHandle);
                    nArray[n5] = n;
                }
                bl = ((DataValueDescriptor)objectArray[n5]).compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
                if (qualifier.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
                ++n4;
            }
            if (!bl) break;
            ++n2;
        }
        return bl;
    }

    private final boolean readRecordFromStream(Object[] objectArray, int n, int[] nArray, int[] nArray2, LimitObjectInput limitObjectInput, StoredRecordHeader storedRecordHeader, ErrorObjectInput errorObjectInput, RecordHandle recordHandle) throws StandardException, IOException {
        try {
            int n2 = storedRecordHeader.getNumberFields();
            int n3 = storedRecordHeader.getFirstField();
            if (n3 > n) {
                return true;
            }
            int n4 = n2 + n3;
            int n5 = nArray == null ? 0 : nArray.length;
            int n6 = n3;
            while (n6 <= n) {
                if (nArray != null && (n5 <= n6 || nArray[n6] == 0) || nArray2 != null && nArray2[n6] != 0) {
                    if (n6 < n4) {
                        this.skipField(limitObjectInput);
                    }
                } else if (n6 >= n4) {
                    Object object = objectArray[n6];
                    if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                    } else {
                        objectArray[n6] = null;
                    }
                } else {
                    int n7 = StoredFieldHeader.readStatus(limitObjectInput);
                    int n8 = StoredFieldHeader.readFieldDataLength(limitObjectInput, n7, this.slotFieldSize);
                    Object object = objectArray[n6];
                    OverflowInputStream overflowInputStream = null;
                    if (StoredFieldHeader.isNonexistent(n7)) {
                        if (object instanceof DataValueDescriptor) {
                            ((DataValueDescriptor)object).restoreToNull();
                        } else {
                            objectArray[n6] = null;
                        }
                    } else {
                        int n9;
                        boolean bl = StoredFieldHeader.isOverflow(n7);
                        if (bl) {
                            long l = CompressedNumber.readLong((InputStream)((Object)limitObjectInput));
                            n9 = CompressedNumber.readInt((InputStream)((Object)limitObjectInput));
                            MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                            overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l, n9, recordHandle);
                        }
                        if (object instanceof DataValueDescriptor) {
                            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                            if (StoredFieldHeader.isNull(n7)) {
                                dataValueDescriptor.restoreToNull();
                            } else if (!bl) {
                                limitObjectInput.setLimit(n8);
                                errorObjectInput = limitObjectInput;
                                dataValueDescriptor.readExternal(limitObjectInput);
                                errorObjectInput = null;
                                int n10 = limitObjectInput.clearLimit();
                                if (n10 != 0) {
                                    limitObjectInput.skipBytes(n10);
                                }
                            } else {
                                FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                                n9 = 1;
                                if (!(dataValueDescriptor instanceof StreamStorable)) {
                                    n9 = 0;
                                }
                                if (n9 != 0) {
                                    ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                                } else {
                                    errorObjectInput = formatIdInputStream;
                                    dataValueDescriptor.readExternal(formatIdInputStream);
                                    errorObjectInput = null;
                                }
                            }
                        } else {
                            if (StoredFieldHeader.isNull(n7)) {
                                throw StandardException.newException("XSDA6.S", Integer.toString(n6));
                            }
                            limitObjectInput.setLimit(n8);
                            errorObjectInput = limitObjectInput;
                            objectArray[n6] = limitObjectInput.readObject();
                            errorObjectInput = null;
                            int n11 = limitObjectInput.clearLimit();
                            if (n11 != 0) {
                                limitObjectInput.skipBytes(n11);
                            }
                        }
                    }
                }
                ++n6;
            }
            return n2 + n3 > n;
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                limitObjectInput.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, (Object)errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, (Object)errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, (Object)errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, (Object)errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            limitObjectInput.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, (Object)errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                limitObjectInput.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, (Object)errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    private final boolean readRecordFromArray(Object[] objectArray, int n, int[] nArray, int[] nArray2, ArrayInputStream arrayInputStream, StoredRecordHeader storedRecordHeader, ErrorObjectInput errorObjectInput, RecordHandle recordHandle) throws StandardException, IOException {
        try {
            int n2 = storedRecordHeader.getNumberFields();
            int n3 = storedRecordHeader.getFirstField();
            if (n3 > n) {
                return true;
            }
            int n4 = n2 + n3;
            int n5 = nArray == null ? 0 : nArray.length;
            int n6 = arrayInputStream.getPosition();
            int n7 = n3;
            while (n7 <= n) {
                if (nArray != null && (n5 <= n7 || nArray[n7] == 0) || nArray2 != null && nArray2[n7] != 0) {
                    if (n7 < n4) {
                        n6 += StoredFieldHeader.readTotalFieldLength(this.pageData, n6);
                    }
                } else if (n7 < n4) {
                    int n8 = StoredFieldHeader.readStatus(this.pageData, n6);
                    int n9 = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, n6 + 1, n8, this.slotFieldSize, arrayInputStream);
                    Object object = objectArray[n7];
                    OverflowInputStream overflowInputStream = null;
                    if ((n8 & 5) != 5) {
                        int n10;
                        boolean bl;
                        boolean bl2 = bl = (n8 & 2) != 0;
                        if (bl) {
                            long l = CompressedNumber.readLong(arrayInputStream);
                            n10 = CompressedNumber.readInt(arrayInputStream);
                            MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                            overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l, n10, recordHandle);
                        }
                        if (object instanceof DataValueDescriptor) {
                            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                            if ((n8 & 1) == 0) {
                                if (!bl) {
                                    arrayInputStream.setLimit(n9);
                                    errorObjectInput = arrayInputStream;
                                    dataValueDescriptor.readExternalFromArray(arrayInputStream);
                                    errorObjectInput = null;
                                    int n11 = arrayInputStream.clearLimit();
                                    if (n11 != 0) {
                                        arrayInputStream.skipBytes(n11);
                                    }
                                } else {
                                    FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                                    n10 = 1;
                                    if (!(dataValueDescriptor instanceof StreamStorable)) {
                                        n10 = 0;
                                    }
                                    if (n10 != 0) {
                                        ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                                    } else {
                                        errorObjectInput = formatIdInputStream;
                                        dataValueDescriptor.readExternal(formatIdInputStream);
                                        errorObjectInput = null;
                                    }
                                }
                            } else {
                                dataValueDescriptor.restoreToNull();
                            }
                        } else {
                            if (StoredFieldHeader.isNull(n8)) {
                                throw StandardException.newException("XSDA6.S", Integer.toString(n7));
                            }
                            arrayInputStream.setLimit(n9);
                            errorObjectInput = arrayInputStream;
                            objectArray[n7] = arrayInputStream.readObject();
                            errorObjectInput = null;
                            int n12 = arrayInputStream.clearLimit();
                            if (n12 != 0) {
                                arrayInputStream.skipBytes(n12);
                            }
                        }
                    } else if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                    } else {
                        objectArray[n7] = null;
                    }
                    n6 = arrayInputStream.getPosition();
                } else {
                    Object object = objectArray[n7];
                    if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                    } else {
                        objectArray[n7] = null;
                    }
                }
                ++n7;
            }
            return n2 + n3 > n;
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, (Object)errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, (Object)errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, (Object)errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, (Object)errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            arrayInputStream.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, (Object)errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, (Object)errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    public void restorePortionLongColumn(OverflowInputStream overflowInputStream) throws StandardException, IOException {
        int n = this.findRecordById(overflowInputStream.getOverflowId(), 0);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        int n2 = this.getRecordOffset(n);
        int n3 = storedRecordHeader.getNumberFields();
        this.rawDataIn.setPosition(n2 + storedRecordHeader.size());
        int n4 = StoredFieldHeader.readStatus(this.rawDataIn);
        int n5 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n4, this.slotFieldSize);
        ByteHolder byteHolder = overflowInputStream.getByteHolder();
        byteHolder.write(this.rawDataIn, n5);
        overflowInputStream.setByteHolder(byteHolder);
        if (n3 == 1) {
            overflowInputStream.setOverflowPage(-1L);
            overflowInputStream.setOverflowId(-1);
        } else {
            int n6 = n4;
            n4 = StoredFieldHeader.readStatus(this.rawDataIn);
            n5 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n4, this.slotFieldSize);
            long l = CompressedNumber.readLong(this.rawDataIn);
            int n7 = CompressedNumber.readInt(this.rawDataIn);
            overflowInputStream.setOverflowPage(l);
            overflowInputStream.setOverflowId(n7);
        }
    }

    public void logColumn(int n, int n2, Object object, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n3) throws StandardException, IOException {
        int n4 = this.freeSpace;
        int n5 = -1;
        n4 += this.getReservedCount(n);
        this.rawDataIn.setPosition(this.getFieldOffset(n, n2));
        int n6 = StoredFieldHeader.readStatus(this.rawDataIn);
        int n7 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n6, this.slotFieldSize);
        n4 += StoredFieldHeader.size(n6, n7, this.slotFieldSize) + n7;
        try {
            this.setOutputStream(dynamicByteArrayOutputStream);
            n5 = this.rawDataOut.getPosition();
            Object[] objectArray = new Object[]{object};
            if (n4 == this.logColumn(objectArray, 0, dynamicByteArrayOutputStream, n4, 0, n3)) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.rawDataOut.setPosition(n5);
            this.resetOutputStream();
            throw throwable;
        }
        this.rawDataOut.setPosition(n5);
        this.resetOutputStream();
    }

    public int logLongColumn(int n, int n2, Object object, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException, IOException {
        int n3 = this.freeSpace;
        if ((n3 -= this.slotEntrySize) <= 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        this.setOutputStream(dynamicByteArrayOutputStream);
        int n4 = dynamicByteArrayOutputStream.getPosition();
        try {
            int n5 = 1;
            StoredRecordHeader storedRecordHeader = new StoredRecordHeader(n2, n5);
            int n6 = storedRecordHeader.write(this.logicalDataOut);
            if ((n3 -= n6) < 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
            Object[] objectArray = new Object[]{object};
            int n7 = this.logColumn(objectArray, 0, dynamicByteArrayOutputStream, n3, 2, 100);
            Object var8_12 = null;
            this.resetOutputStream();
            return n7;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.resetOutputStream();
            throw throwable;
        }
    }

    private int logColumn(Object[] objectArray, int n, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n2, int n3, int n4) throws StandardException, IOException {
        int n5;
        int n6;
        Object object;
        Object object2;
        Object object3 = object2 = objectArray != null ? objectArray[n] : null;
        if (object2 instanceof RawField) {
            byte[] byArray = ((RawField)object2).getData();
            if (byArray.length <= n2) {
                dynamicByteArrayOutputStream.write(byArray);
                n2 -= byArray.length;
            }
            return n2;
        }
        boolean bl = true;
        int n7 = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
        int n8 = dynamicByteArrayOutputStream.getPosition();
        int n9 = 0;
        int n10 = 0;
        if (object2 instanceof StreamStorable && (object = (StreamStorable)object2).returnStream() != null) {
            object2 = object.returnStream();
        }
        if (object2 == null) {
            n7 = StoredFieldHeader.setNonexistent(n7);
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
        } else if (object2 instanceof InputStream) {
            int n11;
            object = null;
            n5 = 0;
            int n12 = this.getMaxDataLength(n2, n4);
            if (object2 instanceof RememberBytesInputStream) {
                object = (RememberBytesInputStream)object2;
                n5 = ((RememberBytesInputStream)object).numBytesSaved();
            } else {
                object = new RememberBytesInputStream((InputStream)object2, new MemByteHolder(this.maxFieldSize + 1));
                if (objectArray[n] instanceof StreamStorable) {
                    ((StreamStorable)objectArray[n]).setStream((InputStream)object);
                }
            }
            if (n5 < n12 + 1) {
                n5 = (int)((long)n5 + ((RememberBytesInputStream)object).fillBuf(n12 + 1 - n5));
            }
            if (n5 <= n12) {
                n10 = n5;
                n7 = StoredFieldHeader.setFixed(n7, true);
                n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
                ((RememberBytesInputStream)object).putBuf(this.logicalDataOut, n10);
            } else if (n3 == 2) {
                bl = false;
                n10 = n12 - 12 - 2;
                n7 = StoredFieldHeader.setFixed(n7, true);
                n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
                ((RememberBytesInputStream)object).putBuf(this.logicalDataOut, n10);
                n11 = ((RememberBytesInputStream)object).available();
                int n13 = ((RememberBytesInputStream)object).shiftToFront();
            } else {
                n11 = this.maxFieldSize - n5 + 1;
                if (n11 > 0) {
                    n5 = (int)((long)n5 + ((RememberBytesInputStream)object).fillBuf(n11));
                }
                n10 = n5;
                object2 = object;
            }
        } else if (object2 instanceof DataValueDescriptor) {
            object = (DataValueDescriptor)object2;
            n5 = object.isNull();
            if (n5 != 0) {
                n7 = StoredFieldHeader.setNull(n7, true);
            }
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
            if (n5 == 0) {
                try {
                    n9 = dynamicByteArrayOutputStream.getPosition();
                    object.writeExternal(this.logicalDataOut);
                }
                catch (IOException iOException) {
                    Exception exception;
                    if (this.logicalDataOut != null && (exception = this.logicalDataOut.getNestedException()) != null && exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                    throw StandardException.newException("XSDAJ.S", iOException);
                }
                n10 = dynamicByteArrayOutputStream.getPosition() - n8 - n6;
            }
        } else if (object2 instanceof RecordHandle) {
            object = (RecordHandle)object2;
            n7 = StoredFieldHeader.setOverflow(n7, true);
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
            n10 += CompressedNumber.writeLong(dynamicByteArrayOutputStream, object.getPageNumber());
            n10 += CompressedNumber.writeInt(dynamicByteArrayOutputStream, object.getId());
        } else {
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
            this.logicalDataOut.writeObject(object2);
            n10 = dynamicByteArrayOutputStream.getPosition() - n8 - n6;
        }
        n7 = StoredFieldHeader.setFixed(n7, false);
        int n14 = StoredFieldHeader.size(n7, n10, this.slotFieldSize) + n10;
        this.userRowSize += n10;
        n5 = this.isLong(n14, n4) ? 1 : 0;
        if ((n2 < n14 || n5 != 0) && n3 != 2) {
            if (n5 != 0) {
                if (!(object2 instanceof InputStream)) {
                    ByteArray byteArray = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n9, n10);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getArray(), n9, n10);
                    MemByteHolder memByteHolder = new MemByteHolder(n10 + 1);
                    RememberBytesInputStream rememberBytesInputStream = new RememberBytesInputStream(byteArrayInputStream, memByteHolder);
                    object2 = rememberBytesInputStream;
                }
                dynamicByteArrayOutputStream.setPosition(n8);
                LongColumnException longColumnException = new LongColumnException();
                longColumnException.setColumn(object2);
                throw longColumnException;
            }
            dynamicByteArrayOutputStream.setPosition(n8);
            return n2;
        }
        dynamicByteArrayOutputStream.setPosition(n8);
        n7 = StoredFieldHeader.setFixed(n7, true);
        n6 = StoredFieldHeader.write(dynamicByteArrayOutputStream, n7, n10, this.slotFieldSize);
        dynamicByteArrayOutputStream.setPosition(n8 + n10 + n6);
        n2 -= n14;
        if (n3 == 2) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        return n2;
    }

    private int logOverflowRecord(int n, int n2, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException, IOException {
        int n3;
        this.setOutputStream(dynamicByteArrayOutputStream);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        StoredRecordHeader storedRecordHeader2 = this.getOverFlowRecordHeader();
        storedRecordHeader2.setOverflowFields(storedRecordHeader);
        int n4 = storedRecordHeader.size();
        int n5 = storedRecordHeader2.size();
        if (n4 < n5 && n2 < (n3 = n5 - n4)) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        storedRecordHeader2.write(this.logicalDataOut);
        this.logRecordDataPortion(n, 0, storedRecordHeader, null, this.logicalDataOut, null);
        return -1;
    }

    private int logOverflowField(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n, long l, int n2) throws StandardException, IOException {
        int n3;
        int n4;
        int n5 = StoredFieldHeader.setOverflow(StoredFieldHeader.setInitial(), true);
        if ((n -= (n3 += StoredFieldHeader.size(n5, n4 = (n3 = CompressedNumber.sizeLong(l) + CompressedNumber.sizeInt(n2)), this.slotFieldSize))) < 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        StoredFieldHeader.write(this.logicalDataOut, n5, n4, this.slotFieldSize);
        CompressedNumber.writeLong(dynamicByteArrayOutputStream, l);
        CompressedNumber.writeInt(dynamicByteArrayOutputStream, n2);
        return n;
    }

    public void logRecord(int n, int n2, int n3, FormatableBitSet formatableBitSet, OutputStream outputStream, RecordHandle recordHandle) throws StandardException, IOException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (n3 != storedRecordHeader.getId()) {
            StoredRecordHeader storedRecordHeader2 = new StoredRecordHeader(storedRecordHeader);
            storedRecordHeader2.setId(n3);
            storedRecordHeader2.write(outputStream);
            storedRecordHeader2 = null;
        } else {
            storedRecordHeader.write(outputStream);
        }
        this.logRecordDataPortion(n, n2, storedRecordHeader, formatableBitSet, outputStream, recordHandle);
    }

    private void logRecordDataPortion(int n, int n2, StoredRecordHeader storedRecordHeader, FormatableBitSet formatableBitSet, OutputStream outputStream, RecordHandle recordHandle) throws StandardException, IOException {
        int n3 = this.getRecordOffset(n);
        int n4 = storedRecordHeader.size();
        n3 += n4;
        int n5 = storedRecordHeader.getFirstField();
        int n6 = n5 + storedRecordHeader.getNumberFields();
        int n7 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        int n8 = n5;
        while (n8 < n6) {
            this.rawDataIn.setPosition(n3);
            int n9 = StoredFieldHeader.readStatus(this.rawDataIn);
            int n10 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n9, this.slotFieldSize);
            if (formatableBitSet != null && (n7 <= n8 || !formatableBitSet.isSet(n8)) || (n2 & 2) != 0 && !StoredFieldHeader.isOverflow(n9)) {
                n3 += StoredFieldHeader.size(n9, n10, this.slotFieldSize);
                n3 += n10;
                n9 = StoredFieldHeader.setInitial();
                n9 = StoredFieldHeader.setNonexistent(n9);
                StoredFieldHeader.write(outputStream, n9, 0, this.slotFieldSize);
            } else {
                if ((n2 & 1) != 0 && recordHandle != null && StoredFieldHeader.isOverflow(n9) && !this.owner.isTemporaryContainer()) {
                    int n11 = this.rawDataIn.getPosition();
                    long l = CompressedNumber.readLong(this.rawDataIn);
                    int n12 = CompressedNumber.readInt(this.rawDataIn);
                    StoredPage storedPage = this.getOverflowPage(l);
                    PageTimeStamp pageTimeStamp = storedPage.currentTimeStamp();
                    storedPage.unlatch();
                    RawTransaction rawTransaction = this.owner.getTransaction();
                    ReclaimSpace reclaimSpace = new ReclaimSpace(4, recordHandle, n8, l, n12, pageTimeStamp, rawTransaction.getDataFactory(), true);
                    rawTransaction.addPostCommitWork(reclaimSpace);
                    this.rawDataIn.setPosition(n11);
                }
                n3 += StoredFieldHeader.write(outputStream, n9, n10, this.slotFieldSize);
                if (n10 != 0) {
                    outputStream.write(this.pageData, n3, n10);
                    n3 += n10;
                }
            }
            ++n8;
        }
    }

    public void logField(int n, int n2, OutputStream outputStream) throws StandardException, IOException {
        int n3 = this.getFieldOffset(n, n2);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n3);
        int n4 = StoredFieldHeader.readStatus(arrayInputStream);
        int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
        StoredFieldHeader.write(outputStream, n4, n5, this.slotFieldSize);
        if (n5 != 0) {
            outputStream.write(this.pageData, arrayInputStream.getPosition(), n5);
        }
    }

    public RecordHandle insertAtSlot(int n, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n2) throws StandardException {
        try {
            return super.insertAtSlot(n, objectArray, formatableBitSet, logicalUndo, by, n2);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return null;
        }
    }

    public RecordHandle updateFieldAtSlot(int n, int n2, Object object, LogicalUndo logicalUndo) throws StandardException {
        try {
            return super.updateFieldAtSlot(n, n2, object, logicalUndo);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            if (this.slotsInUse == 1) {
                throw StandardException.newException("XSDA3.S");
            }
            throw StandardException.newException("XSDA3.S");
        }
    }

    public int fetchNumFieldsAtSlot(int n) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (!storedRecordHeader.hasOverflow()) {
            return super.fetchNumFieldsAtSlot(n);
        }
        StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
        int n2 = ((BasePage)storedPage).fetchNumFieldsAtSlot(StoredPage.getOverflowSlot(storedPage, storedRecordHeader));
        storedPage.unlatch();
        return n2;
    }

    public void logAction(LogInstant logInstant) throws StandardException {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        if (!this.isActuallyDirty()) {
            this.initialRowCount = !this.isOverflowPage() && (this.getPageStatus() & 1) != 0 ? this.internalNonDeletedRecordCount() : 0;
        }
        this.setDirty();
        this.bumpPageVersion();
        this.updateLastLogInstant(logInstant);
    }

    private void cleanPage() {
        this.setDirty();
        this.clearSection(0, this.getPageSize());
        this.slotsInUse = 0;
        this.deletedRowCount = 0;
        this.headerOutOfDate = true;
        this.clearAllSpace();
    }

    public void initPage(LogInstant logInstant, byte by, int n, boolean bl, boolean bl2) throws StandardException {
        this.logAction(logInstant);
        if (bl2) {
            this.cleanPage();
            super.cleanPageForReuse();
        }
        this.headerOutOfDate = true;
        this.setPageStatus(by);
        this.isOverflowPage = bl;
        this.nextId = n;
    }

    public void setPageStatus(LogInstant logInstant, byte by) throws StandardException {
        this.logAction(logInstant);
        this.headerOutOfDate = true;
        this.setPageStatus(by);
    }

    public void setReservedSpace(LogInstant logInstant, int n, int n2) throws StandardException, IOException {
        this.logAction(logInstant);
        this.headerOutOfDate = true;
        int n3 = n2 - this.getReservedCount(n);
        int n4 = this.getRecordOffset(n) + this.getTotalSpace(n);
        if (n3 > 0) {
            this.expandPage(n4, n3);
        } else {
            this.shrinkPage(n4, -n3);
        }
        this.rawDataOut.setPosition(this.getSlotOffset(n) + 2 * this.slotFieldSize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n2);
        } else {
            this.logicalDataOut.writeInt(n2);
        }
    }

    public void storeRecord(LogInstant logInstant, int n, boolean bl, ObjectInput objectInput) throws StandardException, IOException {
        this.logAction(logInstant);
        if (bl) {
            this.storeRecordForInsert(n, objectInput);
        } else {
            this.storeRecordForUpdate(n, objectInput);
        }
    }

    private void storeRecordForInsert(int n, ObjectInput objectInput) throws StandardException, IOException {
        int n2;
        int n3;
        StoredRecordHeader storedRecordHeader = this.shiftUp(n);
        if (storedRecordHeader == null) {
            storedRecordHeader = new StoredRecordHeader();
            this.setHeaderAtSlot(n, storedRecordHeader);
        }
        this.bumpRecordCount(1);
        storedRecordHeader.read(objectInput);
        if (storedRecordHeader.isDeleted()) {
            ++this.deletedRowCount;
            this.headerOutOfDate = true;
        }
        if (this.nextId <= storedRecordHeader.getId()) {
            this.nextId = storedRecordHeader.getId() + 1;
        }
        int n4 = n3 = this.firstFreeByte;
        int n5 = storedRecordHeader.getNumberFields();
        this.rawDataOut.setPosition(n4);
        n4 += storedRecordHeader.write(this.rawDataOut);
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            n2 = StoredFieldHeader.readStatus(objectInput);
            int n8 = StoredFieldHeader.readFieldDataLength(objectInput, n2, this.slotFieldSize);
            n2 = StoredFieldHeader.setFixed(n2, false);
            this.rawDataOut.setPosition(n4);
            n4 += StoredFieldHeader.write(this.rawDataOut, n2, n8, this.slotFieldSize);
            if (n8 != 0) {
                objectInput.readFully(this.pageData, n4, n8);
                n4 += n8;
                n6 += n8;
            }
            ++n7;
        }
        n7 = n4 - this.firstFreeByte;
        this.freeSpace -= n7;
        this.firstFreeByte += n7;
        n2 = 0;
        if (this.minimumRecordSize > 0 && n6 < this.minimumRecordSize) {
            n2 = this.minimumRecordSize - n6;
            this.freeSpace -= n2;
            this.firstFreeByte += n2;
        }
        this.addSlotEntry(n, n3, n7, n2);
        if (this.firstFreeByte > this.getSlotOffset(n) || this.freeSpace < 0) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
        }
    }

    private void storeRecordForUpdate(int n, ObjectInput objectInput) throws StandardException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        StoredRecordHeader storedRecordHeader2 = new StoredRecordHeader();
        storedRecordHeader2.read(objectInput);
        int n6 = storedRecordHeader.getNumberFields();
        int n7 = storedRecordHeader2.getNumberFields();
        int n8 = storedRecordHeader.getFirstField();
        if (n7 < n6) {
            n5 = this.getFieldOffset(n, n8 + n7);
            n4 = this.getRecordOffset(n) + this.getRecordPortionLength(n) - n5;
            this.updateRecordPortionLength(n, -n4, n4);
        }
        n4 = n5 = this.getRecordOffset(n);
        int n9 = n5;
        int n10 = n7 < n6 ? n7 - 1 : n6 - 1;
        n10 += n8;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
        this.rawDataOut.setPosition(n4);
        int n11 = storedRecordHeader.size();
        int n12 = storedRecordHeader2.size();
        int n13 = n11;
        if (n10 < n8) {
            n13 += this.getReservedCount(n);
        }
        if (n13 >= n12) {
            storedRecordHeader2.write(this.rawDataOut);
            n4 += n12;
            n13 -= n12;
        } else {
            dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(this.getPageSize());
            storedRecordHeader2.write(dynamicByteArrayOutputStream);
        }
        n9 += n11;
        int n14 = n12 - n11;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = n8 + n6;
        int n20 = n8 + n7;
        int n21 = n8;
        while (n21 < n20) {
            int n22;
            n3 = 0;
            if (n21 < n19) {
                this.rawDataIn.setPosition(n9);
                n15 = StoredFieldHeader.readStatus(this.rawDataIn);
                n16 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n15, this.slotFieldSize);
                n3 = StoredFieldHeader.size(n15, n16, this.slotFieldSize) + n16;
            }
            n17 = StoredFieldHeader.readStatus(objectInput);
            n18 = StoredFieldHeader.readFieldDataLength(objectInput, n17, this.slotFieldSize);
            if (StoredFieldHeader.isNonexistent(n17) && n21 < n19) {
                if (dynamicByteArrayOutputStream == null || dynamicByteArrayOutputStream.getUsed() == 0) {
                    if (n4 != n9) {
                        System.arraycopy(this.pageData, n9, this.pageData, n4, n3);
                    }
                    n4 += n3;
                    if (n21 == n10) {
                        n13 += this.getReservedCount(n);
                    }
                } else {
                    n2 = dynamicByteArrayOutputStream.getPosition();
                    dynamicByteArrayOutputStream.setPosition(n2 + n3);
                    System.arraycopy(this.pageData, n9, dynamicByteArrayOutputStream.getByteArray(), n2, n3);
                    n13 += n3;
                    if (n21 == n10) {
                        n13 += this.getReservedCount(n);
                    }
                    n22 = this.moveSavedDataToPage(dynamicByteArrayOutputStream, n13, n4);
                    n4 += n22;
                    n13 -= n22;
                }
                n9 += n3;
            } else {
                int n23;
                n17 = StoredFieldHeader.setFixed(n17, false);
                n2 = StoredFieldHeader.size(n17, n18, this.slotFieldSize);
                n22 = n2 + n18;
                n14 += n22 - n3;
                n13 += n3;
                n9 += n3;
                if (n21 == n10) {
                    n13 += this.getReservedCount(n);
                }
                if (dynamicByteArrayOutputStream != null && dynamicByteArrayOutputStream.getUsed() != 0) {
                    n23 = this.moveSavedDataToPage(dynamicByteArrayOutputStream, n13, n4);
                    n4 += n23;
                    n13 -= n23;
                }
                if ((dynamicByteArrayOutputStream == null || dynamicByteArrayOutputStream.getUsed() == 0) && n13 >= n2) {
                    this.rawDataOut.setPosition(n4);
                    n4 += StoredFieldHeader.write(this.rawDataOut, n17, n18, this.slotFieldSize);
                    n13 -= n2;
                    if (n18 != 0) {
                        int n24 = n23 = n13 >= n18 ? n18 : n13;
                        if (n23 != 0) {
                            objectInput.readFully(this.pageData, n4, n23);
                            n4 += n23;
                            n13 -= n23;
                        }
                        if ((n23 = n18 - n23) != 0) {
                            if (dynamicByteArrayOutputStream == null) {
                                dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(n22 * 2);
                            }
                            int n25 = dynamicByteArrayOutputStream.getPosition();
                            dynamicByteArrayOutputStream.setPosition(n25 + n23);
                            objectInput.readFully(dynamicByteArrayOutputStream.getByteArray(), n25, n23);
                        }
                    }
                } else {
                    if (dynamicByteArrayOutputStream == null) {
                        dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(n22 * 2);
                    }
                    StoredFieldHeader.write(dynamicByteArrayOutputStream, n17, n18, this.slotFieldSize);
                    if (n18 != 0) {
                        n23 = dynamicByteArrayOutputStream.getPosition();
                        dynamicByteArrayOutputStream.setPosition(n23 + n18);
                        objectInput.readFully(dynamicByteArrayOutputStream.getByteArray(), n23, n18);
                    }
                }
            }
            ++n21;
        }
        if (dynamicByteArrayOutputStream != null && dynamicByteArrayOutputStream.getUsed() != 0) {
            n3 = n5 + this.getTotalSpace(n);
            n2 = dynamicByteArrayOutputStream.getUsed() - (n3 - n4);
            if (n2 > this.freeSpace) {
                throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
            }
            this.expandPage(n3, n2);
            this.moveSavedDataToPage(dynamicByteArrayOutputStream, n13 += n2, n4);
            n21 = -1 * this.getReservedCount(n);
        } else {
            n21 = -1 * n14;
        }
        this.updateRecordPortionLength(n, n14, n21);
        this.setHeaderAtSlot(n, storedRecordHeader2);
    }

    private int moveSavedDataToPage(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n, int n2) {
        if (n > dynamicByteArrayOutputStream.getUsed() / 2) {
            int n3 = n <= dynamicByteArrayOutputStream.getUsed() ? n : dynamicByteArrayOutputStream.getUsed();
            System.arraycopy(dynamicByteArrayOutputStream.getByteArray(), 0, this.pageData, n2, n3);
            dynamicByteArrayOutputStream.discardLeft(n3);
            return n3;
        }
        return 0;
    }

    private void createSpaceForUpdate(int n, int n2, int n3, int n4) throws StandardException, IOException {
        int n5;
        if (n4 <= n3) {
            int n6 = n3 - n4;
            if (n6 == 0) {
                return;
            }
            int n7 = this.shiftRemainingData(n, n2, n3, n4);
            this.clearSection(n2 + n4 + n7, n6);
            this.updateRecordPortionLength(n, -n6, n6);
            return;
        }
        int n8 = n4 - n3;
        int n9 = this.getReservedCount(n);
        int n10 = 0;
        int n11 = n8 - n9;
        if (n11 > 0) {
            n5 = this.getRecordOffset(n) + this.getTotalSpace(n);
            this.expandPage(n5, n11);
            n10 = -n9;
        } else {
            n10 = -n8;
        }
        n5 = this.shiftRemainingData(n, n2, n3, n4);
        this.updateRecordPortionLength(n, n8, n10);
    }

    public void storeField(LogInstant logInstant, int n, int n2, ObjectInput objectInput) throws StandardException, IOException {
        this.logAction(logInstant);
        int n3 = this.getFieldOffset(n, n2);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n3);
        int n4 = StoredFieldHeader.readStatus(arrayInputStream);
        int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
        int n6 = StoredFieldHeader.readStatus(objectInput);
        int n7 = StoredFieldHeader.readFieldDataLength(objectInput, n6, this.slotFieldSize);
        n6 = StoredFieldHeader.setFixed(n6, false);
        int n8 = StoredFieldHeader.size(n4, n5, this.slotFieldSize) + n5;
        int n9 = StoredFieldHeader.size(n6, n7, this.slotFieldSize) + n7;
        this.createSpaceForUpdate(n, n3, n8, n9);
        this.rawDataOut.setPosition(n3);
        n3 += StoredFieldHeader.write(this.rawDataOut, n6, n7, this.slotFieldSize);
        if (n7 != 0) {
            objectInput.readFully(this.pageData, n3, n7);
        }
    }

    public void reserveSpaceForSlot(LogInstant logInstant, int n, int n2) throws StandardException, IOException {
        this.logAction(logInstant);
        int n3 = n2 - this.getReservedCount(n);
        if (n3 <= 0) {
            return;
        }
        if (this.freeSpace < n3) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        int n4 = this.getRecordOffset(n);
        int n5 = n4 + this.getTotalSpace(n);
        this.expandPage(n5, n3);
        this.setSlotEntry(n, n4, this.getRecordPortionLength(n), n2);
    }

    public void skipField(ObjectInput objectInput) throws IOException {
        int n = StoredFieldHeader.readStatus(objectInput);
        int n2 = StoredFieldHeader.readFieldDataLength(objectInput, n, this.slotFieldSize);
        if (n2 != 0) {
            objectInput.skipBytes(n2);
        }
    }

    public void skipRecord(ObjectInput objectInput) throws IOException {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader();
        storedRecordHeader.read(objectInput);
        int n = storedRecordHeader.getNumberFields();
        while (n > 0) {
            this.skipField(objectInput);
            --n;
        }
    }

    private int shiftRemainingData(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.getRecordOffset(n) + this.getRecordPortionLength(n) - (n2 + n3);
        if (n5 != 0) {
            System.arraycopy(this.pageData, n2 + n3, this.pageData, n2 + n4, n5);
        }
        return n5;
    }

    public void setDeleteStatus(LogInstant logInstant, int n, boolean bl) throws StandardException, IOException {
        this.logAction(logInstant);
        this.deletedRowCount += super.setDeleteStatus(n, bl);
        this.headerOutOfDate = true;
        int n2 = this.getRecordOffset(n);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        this.rawDataOut.setPosition(n2);
        storedRecordHeader.write(this.logicalDataOut);
    }

    protected int internalDeletedRecordCount() {
        return this.deletedRowCount;
    }

    public void purgeRecord(LogInstant logInstant, int n, int n2) throws StandardException, IOException {
        this.logAction(logInstant);
        if (this.getHeaderAtSlot(n).isDeleted()) {
            --this.deletedRowCount;
        }
        int n3 = this.getRecordOffset(n);
        int n4 = n3 + this.getTotalSpace(n) - 1;
        this.compressPage(n3, n4);
        this.removeSlotEntry(n);
        this.removeAndShiftDown(n);
    }

    private int getFieldOffset(int n, int n2) throws IOException {
        int n3 = this.getRecordOffset(n);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        int n4 = storedRecordHeader.getFirstField();
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n3 + storedRecordHeader.size());
        int n5 = n4;
        while (n5 < n2) {
            this.skipField(arrayInputStream);
            ++n5;
        }
        return this.rawDataIn.getPosition();
    }

    public PageTimeStamp currentTimeStamp() {
        return new PageVersion(this.getPageNumber(), this.getPageVersion());
    }

    public void setTimeStamp(PageTimeStamp pageTimeStamp) throws StandardException {
        if (pageTimeStamp == null) {
            throw StandardException.newException("XSDAB.S");
        }
        if (!(pageTimeStamp instanceof PageVersion)) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        PageVersion pageVersion = (PageVersion)pageTimeStamp;
        pageVersion.setPageNumber(this.getPageNumber());
        pageVersion.setPageVersion(this.getPageVersion());
    }

    public boolean equalTimeStamp(PageTimeStamp pageTimeStamp) throws StandardException {
        if (pageTimeStamp == null) {
            return false;
        }
        if (!(pageTimeStamp instanceof PageVersion)) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        PageVersion pageVersion = (PageVersion)pageTimeStamp;
        if (pageVersion.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        return pageVersion.getPageVersion() == this.getPageVersion();
    }

    public String toString() {
        return null;
    }

    private static String pagedataToHexDump(byte[] byArray) {
        return StringUtil.hexDump(byArray);
    }

    private String pageHeaderToString() {
        return null;
    }

    private String recordToString(int n) {
        return null;
    }

    protected StoredPage getOverflowPage(long l) throws StandardException {
        StoredPage storedPage = (StoredPage)this.owner.getPage(l);
        if (storedPage == null) {
            // empty if block
        }
        return storedPage;
    }

    protected BasePage getNewOverflowPage() throws StandardException {
        FileContainer fileContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
        try {
            BasePage basePage = (BasePage)fileContainer.addPage(this.owner, true);
            Object var3_3 = null;
            this.containerCache.release(fileContainer);
            return basePage;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.containerCache.release(fileContainer);
            throw throwable;
        }
    }

    protected static int getOverflowSlot(BasePage basePage, StoredRecordHeader storedRecordHeader) throws StandardException {
        int n = basePage.findRecordById(storedRecordHeader.getOverflowId(), 0);
        if (n < 0) {
            throw StandardException.newException("XSDA1.S");
        }
        return n;
    }

    public BasePage getOverflowPageForInsert(int n, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        return this.getOverflowPageForInsert(n, objectArray, formatableBitSet, 0);
    }

    public BasePage getOverflowPageForInsert(int n, Object[] objectArray, FormatableBitSet formatableBitSet, int n2) throws StandardException {
        int n3;
        long[] lArray = new long[5];
        int n4 = 0;
        long l = 0L;
        int n5 = 0;
        while (n5 < this.slotsInUse && n4 < lArray.length) {
            block11: {
                StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n5);
                if (storedRecordHeader.hasOverflow()) {
                    long l2 = storedRecordHeader.getOverflowPage();
                    if (n5 == n) {
                        l = l2;
                    } else {
                        n3 = 0;
                        while (n3 < n4) {
                            if (lArray[n3] != l2) {
                                ++n3;
                                continue;
                            }
                            break block11;
                        }
                        lArray[n4++] = l2;
                    }
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            block12: {
                long l3 = lArray[n5];
                if (l3 != l) {
                    StoredPage storedPage = null;
                    n3 = 0;
                    try {
                        storedPage = this.getOverflowPage(l3);
                        if (storedPage.spaceForInsert(objectArray, formatableBitSet, n3, n2, 100)) {
                            return storedPage;
                        }
                        n3 = storedPage.getCurrentFreeSpace();
                        storedPage.unlatch();
                        storedPage = null;
                    }
                    catch (StandardException standardException) {
                        if (storedPage == null) break block12;
                        storedPage.unlatch();
                        storedPage = null;
                    }
                }
            }
            ++n5;
        }
        return this.getNewOverflowPage();
    }

    protected void updateOverflowed(RawTransaction rawTransaction, int n, Object[] objectArray, FormatableBitSet formatableBitSet, StoredRecordHeader storedRecordHeader) throws StandardException {
        StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
        try {
            int n2 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
            ((BasePage)storedPage).doUpdateAtSlot(rawTransaction, n2, storedRecordHeader.getOverflowId(), objectArray, formatableBitSet);
            storedPage.unlatch();
            storedPage = null;
            Object var8_8 = null;
            if (storedPage != null) {
                storedPage.unlatch();
                storedPage = null;
            }
            return;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_9 = null;
                if (storedPage == null) break block3;
                storedPage.unlatch();
                storedPage = null;
            }
            throw throwable;
        }
    }

    public void updateOverflowDetails(RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        long l = recordHandle.getPageNumber();
        if (l == this.getPageNumber()) {
            this.updateOverflowDetails(this, recordHandle, recordHandle2);
            return;
        }
        StoredPage storedPage = (StoredPage)this.owner.getPage(l);
        this.updateOverflowDetails(storedPage, recordHandle, recordHandle2);
        storedPage.unlatch();
    }

    private void updateOverflowDetails(StoredPage storedPage, RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        storedPage.getOverFlowRecordHeader().setOverflowDetails(recordHandle2);
        int n = storedPage.getSlotNumber(recordHandle);
        storedPage.doUpdateAtSlot(this.owner.getTransaction(), n, recordHandle.getId(), null, null);
    }

    public void updateFieldOverflowDetails(RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        Object[] objectArray = new Object[2];
        objectArray[1] = recordHandle2;
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        formatableBitSet.set(1);
        int n = this.getSlotNumber(recordHandle);
        this.doUpdateAtSlot(this.owner.getTransaction(), n, recordHandle.getId(), objectArray, formatableBitSet);
    }

    public int appendOverflowFieldHeader(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, RecordHandle recordHandle) throws StandardException, IOException {
        int n = StoredFieldHeader.setInitial();
        n = StoredFieldHeader.setOverflow(n, true);
        long l = recordHandle.getPageNumber();
        int n2 = recordHandle.getId();
        int n3 = CompressedNumber.sizeLong(l) + CompressedNumber.sizeInt(n2);
        int n4 = StoredFieldHeader.write(dynamicByteArrayOutputStream, n, n3, this.slotFieldSize);
        n4 += CompressedNumber.writeLong(dynamicByteArrayOutputStream, l);
        return n4 += CompressedNumber.writeInt(dynamicByteArrayOutputStream, n2);
    }

    protected int getSlotsInUse() {
        return this.slotsInUse;
    }

    private int getMaxDataLength(int n, int n2) {
        int n3 = this.totalSpace * n2 / 100;
        int n4 = 0;
        n4 = n < 62 ? n - 2 : (n < 16380 ? n - 3 : n - 5);
        return n4 > n3 ? n3 : n4;
    }

    private boolean isLong(int n, int n2) {
        int n3 = this.maxFieldSize * n2 / 100;
        return n > n3;
    }

    public void doUpdateAtSlot(RawTransaction rawTransaction, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        Object object;
        RecordHandle recordHandle;
        RecordHandle recordHandle2 = recordHandle = this.isOverflowPage() ? null : this.getRecordHandleAtSlot(n);
        if (objectArray == null) {
            this.owner.getActionSet().actionUpdate(rawTransaction, this, n, n2, objectArray, formatableBitSet, -1, null, -1, recordHandle);
            return;
        }
        int n3 = RowUtil.nextColumn(objectArray, formatableBitSet, 0);
        if (n3 == -1) {
            return;
        }
        boolean bl = false;
        StoredPage storedPage = this;
        while (true) {
            object = storedPage.getHeaderAtSlot(n);
            int n4 = ((StoredRecordHeader)object).getFirstField();
            int n5 = n4 + ((StoredRecordHeader)object).getNumberFields();
            long l = -1L;
            int n6 = -1;
            int n7 = -1;
            if (!((StoredRecordHeader)object).hasOverflow() || n3 >= n4 && n3 < n5) {
                int n8;
                boolean bl2;
                int n9 = -1;
                Object[] objectArray2 = null;
                DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
                do {
                    try {
                        n9 = this.owner.getActionSet().actionUpdate(rawTransaction, storedPage, n, n2, objectArray, formatableBitSet, n6, dynamicByteArrayOutputStream, n7, recordHandle);
                        bl2 = false;
                    }
                    catch (LongColumnException longColumnException) {
                        if (longColumnException.getRealSpaceOnPage() == -1) {
                            dynamicByteArrayOutputStream = longColumnException.getLogBuffer();
                            objectArray2 = (Object[])longColumnException.getColumn();
                            n6 = longColumnException.getNextColumn();
                            n7 = -1;
                            bl2 = true;
                            continue;
                        }
                        dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(longColumnException.getLogBuffer());
                        RecordHandle recordHandle3 = this.insertLongColumn(storedPage, longColumnException, (byte)2);
                        int n10 = 0;
                        try {
                        }
                        catch (IOException iOException) {
                            throw StandardException.newException("XSDA4.S", iOException);
                        }
                        n6 = longColumnException.getNextColumn() + 1;
                        n7 = longColumnException.getRealSpaceOnPage() - (n10 += this.appendOverflowFieldHeader(dynamicByteArrayOutputStream, recordHandle3));
                        bl2 = true;
                    }
                } while (bl2);
                int n11 = n8 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
                if (n9 != -1) {
                    int n12 = n5;
                    if (!((StoredRecordHeader)object).hasOverflow()) {
                        if (formatableBitSet == null) {
                            if (objectArray.length > n12) {
                                n12 = objectArray.length;
                            }
                        } else if (n8 > n12) {
                            n12 = n8;
                        }
                    }
                    Object[] objectArray3 = new Object[n12];
                    FormatableBitSet formatableBitSet2 = new FormatableBitSet(n12);
                    Object var25_29 = null;
                    int n13 = n9;
                    while (n13 < n12) {
                        if (formatableBitSet == null || n8 > n13 && formatableBitSet.isSet(n13)) {
                            formatableBitSet2.set(n13);
                            objectArray3[n13] = RowUtil.getColumn(objectArray, formatableBitSet, n13);
                        } else if (n13 < n5) {
                            formatableBitSet2.set(n13);
                            objectArray3[n13] = objectArray2[n13 - n9];
                        }
                        ++n13;
                    }
                    RecordHandle recordHandle4 = storedPage.getRecordHandleAtSlot(n);
                    if (((StoredRecordHeader)object).hasOverflow()) {
                        l = ((StoredRecordHeader)object).getOverflowPage();
                        n2 = ((StoredRecordHeader)object).getOverflowId();
                        n3 = RowUtil.nextColumn(objectArray, formatableBitSet, n5);
                    } else {
                        n3 = -1;
                        l = 0L;
                    }
                    if (!bl && recordHandle != null && storedPage != null && !this.owner.isTemporaryContainer()) {
                        bl = storedPage.checkRowReservedSpace(n);
                    }
                    BasePage basePage = storedPage.getOverflowPageForInsert(n, objectArray3, formatableBitSet2, n9);
                    if (storedPage != this) {
                        storedPage.unlatch();
                        storedPage = null;
                    }
                    byte by = 8;
                    if (l != 0L) {
                        by = (byte)(by | 0x10);
                    }
                    RecordHandle recordHandle5 = l == 0L ? null : this.owner.makeRecordHandle(l, n2);
                    RecordHandle recordHandle6 = basePage.insertAllowOverflow(0, objectArray3, formatableBitSet2, n9, by, 100, recordHandle5);
                    if (storedPage == this) {
                        this.updateOverflowDetails(this, recordHandle4, recordHandle6);
                    } else {
                        this.updateOverflowDetails(recordHandle4, recordHandle6);
                    }
                    basePage.unlatch();
                } else {
                    if (!bl && recordHandle != null && storedPage != null && !this.owner.isTemporaryContainer()) {
                        bl = storedPage.checkRowReservedSpace(n);
                    }
                    int n14 = n3 = ((StoredRecordHeader)object).hasOverflow() ? RowUtil.nextColumn(objectArray, formatableBitSet, n5) : -1;
                }
                if (n3 == -1) {
                    if (storedPage == this || storedPage == null) break;
                    storedPage.unlatch();
                    break;
                }
            }
            if (l == -1L) {
                l = ((StoredRecordHeader)object).getOverflowPage();
                n2 = ((StoredRecordHeader)object).getOverflowId();
            }
            if (storedPage != this && storedPage != null) {
                storedPage.unlatch();
            }
            storedPage = (StoredPage)this.owner.getPage(l);
            n = storedPage.findRecordById(n2, 0);
        }
        if (bl) {
            object = this.owner.getTransaction();
            ReclaimSpace reclaimSpace = new ReclaimSpace(3, recordHandle, ((RawTransaction)object).getDataFactory(), true);
            ((RawTransaction)object).addPostCommitWork(reclaimSpace);
        }
    }

    private boolean checkRowReservedSpace(int n) throws StandardException {
        boolean bl = false;
        try {
            int n2 = this.getReservedCount(n);
            int n3 = 12;
            if (n2 > n3) {
                int n4 = this.getRecordPortionLength(n) + n2;
                if (this.isOverflowPage()) {
                    if (n4 > 12 + n3) {
                        bl = true;
                    }
                } else if (n4 > this.minimumRecordSize + 12) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
        return bl;
    }

    protected void compactRecord(RawTransaction rawTransaction, int n, int n2) throws StandardException {
        if (!this.isOverflowPage()) {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
            while (storedRecordHeader.hasOverflow()) {
                StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                try {
                    int n3 = storedRecordHeader.getOverflowId();
                    int n4 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
                    storedPage.compactRecord(rawTransaction, n4, n3);
                    storedRecordHeader = storedPage.getHeaderAtSlot(n4);
                }
                finally {
                    Object var7_9 = null;
                    storedPage.unlatch();
                }
            }
        }
        int n5 = 12;
        try {
            int n6 = this.getReservedCount(n);
            if (n6 > n5) {
                int n7 = this.getRecordPortionLength(n);
                int n8 = n6;
                if (this.isOverflowPage()) {
                    if (n6 + n7 > 12 + n5) {
                        n8 = n7 >= 12 ? 0 : 12 - n7;
                    }
                } else if (n6 + n7 > this.minimumRecordSize + n5) {
                    n8 = n7 >= this.minimumRecordSize ? 0 : this.minimumRecordSize - n7;
                }
                if (n8 < n6) {
                    this.owner.getActionSet().actionShrinkReservedSpace(rawTransaction, this, n, n2, n8, n6);
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }
}

