/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.OrderableAggregator;

public final class MaxMinAggregator
extends OrderableAggregator {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2001, 2004.";
    private boolean isMax;

    public void setup(String string) {
        super.setup(string);
        this.isMax = string.equals("MAX");
    }

    protected void accumulate(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.value == null || this.isMax && this.value.compare(dataValueDescriptor) < 0 || !this.isMax && this.value.compare(dataValueDescriptor) > 0) {
            this.value = dataValueDescriptor.getClone();
        }
    }

    public ExecAggregator newAggregator() {
        MaxMinAggregator maxMinAggregator = new MaxMinAggregator();
        maxMinAggregator.isMax = this.isMax;
        return maxMinAggregator;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isMax);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isMax = objectInput.readBoolean();
    }

    public int getTypeFormatId() {
        return 152;
    }
}

