/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLException;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateViewConstantAction
extends DDLConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private final String tableName;
    private final String schemaName;
    private final String viewText;
    private final int tableType;
    private final int checkOption;
    private final ColumnInfo[] columnInfo;
    private final ProviderInfo[] providerInfo;
    private final UUID compSchemaId;

    public String toString() {
        return this.constructToString("CREATE VIEW ", this.tableName);
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, 'R');
        dataDictionary.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        UUID uUID = tableDescriptor.getUUID();
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[this.columnInfo.length];
        int n = 1;
        int n2 = 0;
        while (n2 < this.columnInfo.length) {
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(this.columnInfo[n2].name, n++, this.columnInfo[n2].dataType, this.columnInfo[n2].defaultValue, this.columnInfo[n2].defaultInfo, tableDescriptor, null, this.columnInfo[n2].autoincStart, this.columnInfo[n2].autoincInc, this.columnInfo[n2].autoincInc != 0L);
            tupleDescriptorArray[n2] = columnDescriptor;
            ++n2;
        }
        dataDictionary.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n3 = 0;
        while (n3 < tupleDescriptorArray.length) {
            columnDescriptorList.add(tupleDescriptorArray[n3]);
            ++n3;
        }
        ViewDescriptor viewDescriptor = dataDescriptorGenerator.newViewDescriptor(uUID, this.tableName, this.viewText, this.checkOption, this.compSchemaId == null ? languageConnectionContext.getDefaultSchema().getUUID() : this.compSchemaId);
        n3 = 0;
        while (n3 < this.providerInfo.length) {
            try {
                Provider provider = (Provider)this.providerInfo[n3].getDependableFinder().getDependable(this.providerInfo[n3].getObjectId());
                if (provider == null) {
                    throw StandardException.newException("42X94", "OBJECT", (Object)this.providerInfo[n3].getObjectId());
                }
                dependencyManager.addDependency(viewDescriptor, provider, languageConnectionContext.getContextManager());
            }
            catch (SQLException sQLException) {
                throw StandardException.plainWrapException(sQLException);
            }
            ++n3;
        }
        dataDictionary.addDescriptor(viewDescriptor, schemaDescriptor, 8, true, transactionController);
    }

    CreateViewConstantAction(String string, String string2, int n, String string3, int n2, ColumnInfo[] columnInfoArray, ProviderInfo[] providerInfoArray, UUID uUID) {
        this.schemaName = string;
        this.tableName = string2;
        this.tableType = n;
        this.viewText = string3;
        this.checkOption = n2;
        this.columnInfo = columnInfoArray;
        this.providerInfo = providerInfoArray;
        this.compSchemaId = uUID;
    }
}

