/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DataDictionaryContext;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class DDdependableFinder
implements DependableFinder,
Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private transient DataDictionary dataDictionary;
    private transient UUIDFactory uuidFactory;
    private final int formatId;

    public String toString() {
        return this.getSQLObjectType();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public final int getTypeFormatId() {
        return this.formatId;
    }

    public final Dependable getDependable(String string) throws SQLException {
        return this.getDependable(this.recreateUUID(string));
    }

    public final Dependable getDependable(UUID uUID) throws SQLException {
        try {
            return this.getDependable(this.getDataDictionary(), uUID);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public final String getSQLObjectName(String string) throws SQLException {
        try {
            return this.getSQLObjectName(this.getDataDictionary(), this.recreateUUID(string));
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public String getSQLObjectType() {
        switch (this.formatId) {
            case 136: {
                return "Alias";
            }
            case 135: {
                return "Conglomerate";
            }
            case 208: {
                return "Constraint";
            }
            case 325: {
                return "Default";
            }
            case 273: {
                return "File";
            }
            case 371: {
                return "Schema";
            }
            case 226: {
                return "StoredPreparedStatement";
            }
            case 137: {
                return "Table";
            }
            case 393: {
                return "ColumnsInTable";
            }
            case 320: {
                return "Trigger";
            }
            case 145: {
                return "View";
            }
        }
        return null;
    }

    private DataDictionary getDataDictionary() throws StandardException {
        if (this.dataDictionary == null) {
            ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
            DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)contextManager.getContext("DataDictionaryContext");
            this.dataDictionary = dataDictionaryContext.getDataDictionary();
        }
        return this.dataDictionary;
    }

    private UUID recreateUUID(String string) {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory.recreateUUID(string);
    }

    protected Dependable getDependable(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        switch (this.formatId) {
            case 136: {
                return dataDictionary.getAliasDescriptor(uUID);
            }
            case 135: {
                return dataDictionary.getConglomerateDescriptor(uUID);
            }
            case 208: {
                return dataDictionary.getConstraintDescriptor(uUID);
            }
            case 325: {
                ColumnDescriptor columnDescriptor = dataDictionary.getColumnDescriptorByDefaultId(uUID);
                DefaultDescriptor defaultDescriptor = new DefaultDescriptor(dataDictionary, columnDescriptor.getDefaultUUID(), columnDescriptor.getReferencingUUID(), columnDescriptor.getPosition());
                return defaultDescriptor;
            }
            case 273: {
                return dataDictionary.getFileInfoDescriptor(uUID);
            }
            case 371: {
                return dataDictionary.getSchemaDescriptor(uUID, null);
            }
            case 226: {
                return dataDictionary.getSPSDescriptor(uUID);
            }
            case 137: {
                return dataDictionary.getTableDescriptor(uUID);
            }
            case 320: {
                return dataDictionary.getTriggerDescriptor(uUID);
            }
            case 145: {
                return dataDictionary.getViewDescriptor(uUID);
            }
        }
        return null;
    }

    protected String getSQLObjectName(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        switch (this.formatId) {
            case 136: {
                return dataDictionary.getAliasDescriptor(uUID).getDescriptorName();
            }
            case 135: {
                return dataDictionary.getConglomerateDescriptor(uUID).getConglomerateName();
            }
            case 208: {
                return dataDictionary.getConstraintDescriptor(uUID).getConstraintName();
            }
            case 325: {
                ColumnDescriptor columnDescriptor = dataDictionary.getColumnDescriptorByDefaultId(uUID);
                TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(columnDescriptor.getReferencingUUID());
                return MessageService.getTextMessage("42Z09.U", tableDescriptor.getQualifiedName() + "." + columnDescriptor.getColumnName());
            }
            case 273: {
                return dataDictionary.getFileInfoDescriptor(uUID).getName();
            }
            case 371: {
                return dataDictionary.getSchemaDescriptor(uUID, null).getSchemaName();
            }
            case 226: {
                return dataDictionary.getSPSDescriptor(uUID).getName();
            }
            case 137: 
            case 393: {
                return this.getDependable(dataDictionary, uUID).getObjectName();
            }
            case 320: {
                return dataDictionary.getTriggerDescriptor(uUID).getName();
            }
            case 145: {
                return dataDictionary.getTableDescriptor(uUID).getName();
            }
        }
        return null;
    }

    public DDdependableFinder(int n) {
        this.formatId = n;
    }
}

