/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.services.daemon.ServiceRecord;

public class BasicDaemon
implements DaemonService,
Runnable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int OPTIMAL_QUEUE_SIZE = 100;
    private int numClients;
    private final Vector subscription;
    protected final ContextService contextService;
    protected final ContextManager contextMgr;
    private final List highPQ;
    private final List normPQ;
    private int nextService;
    private boolean awakened;
    private boolean waiting;
    private boolean inPause;
    private boolean running;
    private boolean stopRequested;
    private boolean stopped;
    private long lastServiceTime;
    private int earlyWakeupCount;

    public int subscribe(Serviceable serviceable, boolean bl) {
        int n;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            n = this.numClients++;
            ServiceRecord serviceRecord = new ServiceRecord(serviceable, bl, true);
            this.subscription.insertElementAt(serviceRecord, n);
        }
        return n;
    }

    public void unsubscribe(int n) {
        if (n < 0 || n > this.subscription.size()) {
            return;
        }
        this.subscription.setElementAt(null, n);
    }

    public void serviceNow(int n) {
        if (n < 0 || n > this.subscription.size()) {
            return;
        }
        ServiceRecord serviceRecord = (ServiceRecord)this.subscription.elementAt(n);
        if (serviceRecord == null) {
            return;
        }
        serviceRecord.called();
        this.wakeUp();
    }

    public boolean enqueue(Serviceable serviceable, boolean bl) {
        int n;
        ServiceRecord serviceRecord = new ServiceRecord(serviceable, false, false);
        List list = bl ? this.highPQ : this.normPQ;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            list.add(serviceRecord);
            n = this.highPQ.size();
        }
        if (bl && !this.awakened) {
            this.wakeUp();
        }
        if (bl) {
            return n > 100;
        }
        return false;
    }

    public synchronized void clear() {
        this.normPQ.clear();
        this.highPQ.clear();
    }

    protected ServiceRecord nextAssignment(boolean bl) {
        ServiceRecord serviceRecord;
        while (this.nextService < this.subscription.size()) {
            if ((serviceRecord = (ServiceRecord)this.subscription.elementAt(this.nextService++)) == null || !serviceRecord.needImmediateService() && (bl || !serviceRecord.needService())) continue;
            return serviceRecord;
        }
        serviceRecord = null;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.highPQ.isEmpty()) {
                serviceRecord = (ServiceRecord)this.highPQ.remove(0);
            }
        }
        if (bl || serviceRecord != null) {
            return serviceRecord;
        }
        serviceRecord = null;
        basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.normPQ.isEmpty()) {
                serviceRecord = (ServiceRecord)this.normPQ.remove(0);
            }
        }
        return serviceRecord;
    }

    protected void serviceClient(ServiceRecord serviceRecord) {
        serviceRecord.serviced();
        Serviceable serviceable = serviceRecord.client;
        if (serviceable == null) {
            return;
        }
        ContextManager contextManager = this.contextMgr;
        try {
            int n = serviceable.performWork(contextManager);
            if (serviceRecord.subscriber) {
                return;
            }
            if (n == 2) {
                List list = serviceable.serviceASAP() ? this.highPQ : this.normPQ;
                BasicDaemon basicDaemon = this;
                synchronized (basicDaemon) {
                    list.add(serviceRecord);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            contextManager.cleanupOnError(throwable);
            return;
        }
    }

    public void run() {
        this.contextService.setCurrentContextManager(this.contextMgr);
        while (!this.stopRequested()) {
            boolean bl = this.rest();
            if (this.stopRequested()) break;
            if (this.inPause()) continue;
            this.work(bl);
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.running = false;
            this.stopped = true;
        }
        this.contextMgr.cleanupOnError(StandardException.normalClose());
        this.contextService.resetCurrentContextManager(this.contextMgr);
    }

    public void pause() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = true;
            while (this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void resume() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = false;
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.stopRequested = true;
            this.notifyAll();
        }
        this.pause();
    }

    public void waitUntilQueueIsEmpty() {
        while (true) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                boolean bl = true;
                int n = 0;
                while (n < this.subscription.size()) {
                    ServiceRecord serviceRecord = (ServiceRecord)this.subscription.elementAt(n);
                    if (serviceRecord != null && serviceRecord.needService()) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (this.highPQ.isEmpty() && bl && !this.running) {
                    Object var2_6 = null;
                    return;
                }
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized boolean stopRequested() {
        return this.stopRequested;
    }

    private synchronized boolean inPause() {
        return this.inPause;
    }

    protected synchronized void wakeUp() {
        if (!this.awakened) {
            this.awakened = true;
            if (this.waiting) {
                this.notifyAll();
            }
        }
    }

    private boolean rest() {
        long l;
        boolean bl;
        boolean bl2 = false;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            try {
                if (!this.awakened) {
                    this.waiting = true;
                    this.wait(10000L);
                    this.waiting = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextService = 0;
            bl = this.awakened;
            if (bl && this.earlyWakeupCount++ > 20) {
                this.earlyWakeupCount = 0;
                bl2 = true;
            }
            this.awakened = false;
        }
        if (bl2 && (l = System.currentTimeMillis()) - this.lastServiceTime > 10000L) {
            this.lastServiceTime = l;
            bl = false;
        }
        return bl;
    }

    private void work(boolean bl) {
        int n = 0;
        int n2 = 10;
        if (bl && this.highPQ.size() > 100) {
            n2 = 2;
        }
        int n3 = 100 / n2;
        ServiceRecord serviceRecord = this.nextAssignment(bl);
        while (serviceRecord != null) {
            block21: {
                Object var9_10;
                BasicDaemon basicDaemon;
                Object var7_8;
                BasicDaemon basicDaemon2 = this;
                synchronized (basicDaemon2) {
                    block25: {
                        block24: {
                            if (this.inPause) break block24;
                            if (!this.stopRequested) break block25;
                        }
                        var7_8 = null;
                        break;
                    }
                    this.running = true;
                }
                try {
                    this.serviceClient(serviceRecord);
                    ++n;
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    basicDaemon = this;
                    synchronized (basicDaemon) {
                        block23: {
                            Object v1;
                            block22: {
                                this.running = false;
                                this.notifyAll();
                                if (this.inPause || this.stopRequested) {
                                    v1 = null;
                                    break block22;
                                }
                                break block23;
                            }
                            var9_10 = v1;
                        }
                        throw throwable;
                    }
                }
                var7_8 = null;
                basicDaemon = this;
                synchronized (basicDaemon) {
                    Object v3;
                    block20: {
                        this.running = false;
                        this.notifyAll();
                        if (this.inPause || this.stopRequested) {
                            v3 = null;
                            break block20;
                        }
                        break block21;
                    }
                    var9_10 = v3;
                }
            }
            if (n % 50 == 0) {
                this.nextService = 0;
            }
            if (n % n3 == 0) {
                this.yield();
            }
            serviceRecord = this.nextAssignment(bl);
        }
    }

    private void yield() {
        Thread thread = Thread.currentThread();
        int n = thread.getPriority();
        if (n <= 1) {
            Thread.yield();
        } else {
            ModuleFactory moduleFactory = Monitor.getMonitor();
            if (moduleFactory != null) {
                moduleFactory.setThreadPriority(1);
            }
            Thread.yield();
            if (moduleFactory != null) {
                moduleFactory.setThreadPriority(n);
            }
        }
    }

    public BasicDaemon(ContextService contextService) {
        this.contextService = contextService;
        this.contextMgr = contextService.newContextManager();
        this.subscription = new Vector(1, 1);
        this.highPQ = new LinkedList();
        this.normPQ = new LinkedList();
        this.lastServiceTime = System.currentTimeMillis();
    }
}

