/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;

public class EmbedDatabaseMetaData
extends ConnectionChild
implements DatabaseMetaData,
PrivilegedAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static Properties queryDescriptions;
    private final String url;
    private GenericConstantActionFactory constantActionFactory;

    protected final Properties getQueryDescriptions() {
        Properties properties = queryDescriptions;
        if (properties != null) {
            return properties;
        }
        queryDescriptions = this.loadQueryDescriptions();
        return queryDescriptions;
    }

    private Properties PBloadQueryDescriptions() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("metadata.properties");
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public boolean allProceduresAreCallable() {
        return true;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public final String getURL() {
        if (this.url == null) {
            return this.url;
        }
        int n = this.url.indexOf(59);
        if (n == -1) {
            return this.url;
        }
        return this.url.substring(0, n);
    }

    public String getUserName() {
        return this.getEmbedConnection().getTR().getUserName();
    }

    public boolean isReadOnly() {
        return this.getLanguageConnectionContext().getDatabase().isReadOnly();
    }

    public boolean nullsAreSortedHigh() {
        return true;
    }

    public boolean nullsAreSortedLow() {
        return false;
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return Monitor.getMonitor().getEngineVersion().getProductName();
    }

    public String getDatabaseProductVersion() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        return productVersionHolder.getVersionBuildString(false);
    }

    public String getDriverName() {
        return "Apache Derby Embedded JDBC Driver";
    }

    public String getDriverVersion() {
        return this.getDatabaseProductVersion();
    }

    public int getDriverMajorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMinorVersion();
    }

    public boolean usesLocalFiles() {
        return true;
    }

    public boolean usesLocalFilePerTable() {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "ALIAS,BIGINT,BOOLEAN,CALL,CLASS,COPY,DB2J_DEBUG,EXECUTE,EXPLAIN,FILE,FILTER," + "GETCURRENTCONNECTION,INDEX,INSTANCEOF,METHOD,NEW,OFF,PROPERTIES,PUBLICATION,RECOMPILE," + "REFRESH,RENAME,RUNTIMESTATISTICS,STATEMENT,STATISTICS,TIMING,WAIT";
    }

    public String getNumericFunctions() {
        return "ABS,SQRT";
    }

    public String getStringFunctions() {
        return "LENGTH,LOWER,LTRIM,RTRIM,SUBSTR,SUBSTRING,UPPER";
    }

    public String getSystemFunctions() {
        return "CURRENT_USER,getCurrentConnection,runTimeStatistics,SESSION_USER,USER,CURRENT SCHEMA";
    }

    public String getTimeDateFunctions() {
        return "CURDATE,CURTIME,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,EXTRACT";
    }

    public String getSearchStringEscape() {
        return "";
    }

    public String getExtraNameCharacters() {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return true;
    }

    public boolean supportsConvert(int n, int n2) {
        return false;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    public boolean supportsOrderByUnrelated() {
        return false;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsMultipleResultSets() {
        return true;
    }

    public boolean supportsMultipleTransactions() {
        return true;
    }

    public boolean supportsNonNullableColumns() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    public String getSchemaTerm() {
        return "SCHEMA";
    }

    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    public String getCatalogTerm() {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public String getCatalogSeparator() {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsPositionedDelete() {
        return true;
    }

    public boolean supportsPositionedUpdate() {
        return true;
    }

    public boolean supportsSelectForUpdate() {
        return true;
    }

    public boolean supportsStoredProcedures() {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 30;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxCursorNameLength() {
        return 18;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public int getMaxSchemaNameLength() {
        return 30;
    }

    public int getMaxProcedureNameLength() {
        return 128;
    }

    public int getMaxCatalogNameLength() {
        return 0;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 30;
    }

    public int getDefaultTransactionIsolation() {
        return 2;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) {
        return n == 8 || n == 4 || n == 2 || n == 1;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getProcedures");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getProcedureColumns");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            ResultSet resultSet = null;
            try {
                try {
                    String string4 = this.getQueryDescriptions().getProperty("getTables");
                    StringBuffer stringBuffer = new StringBuffer(string4);
                    if (stringArray != null && stringArray.length >= 1) {
                        stringBuffer.append(" AND TABLETYPE IN ('");
                        stringBuffer.append(stringArray[0].substring(0, 1));
                        int n = 1;
                        while (n < stringArray.length) {
                            stringBuffer.append("','");
                            stringBuffer.append(stringArray[n].substring(0, 1));
                            ++n;
                        }
                        stringBuffer.append("')");
                    }
                    stringBuffer.append(" ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
                    PreparedStatement preparedStatement = this.getEmbedConnection().prepareMetaDataStatement(stringBuffer.toString());
                    preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
                    preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
                    preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
                    resultSet = preparedStatement.executeQuery();
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            ResultSet resultSet2 = resultSet;
            Object var6_16 = null;
            return resultSet2;
        }
    }

    public ResultSet getSchemas() throws SQLException {
        return this.getSimpleQuery("getSchemas");
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.getSimpleQuery("getCatalogs");
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.getSimpleQuery("getTableTypes");
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getColumns");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getColumnPrivileges");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getTablePrivileges");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        if (string == null) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null) {
            string3 = "%";
        }
        if (n < 0 || n > 2) {
            PreparedStatement preparedStatement = this.getPreparedQuery("getBestRowIdentifierEmpty");
            return preparedStatement.executeQuery();
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getBestRowIdentifierPrimaryKey");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl2 = resultSet.next();
        String string4 = "";
        if (bl2) {
            string4 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery("getBestRowIdentifierPrimaryKeyColumns");
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, string4);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueConstraint");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        resultSet = preparedStatement.executeQuery();
        bl2 = resultSet.next();
        if (bl2) {
            string4 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueKeyColumns");
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, string4);
            preparedStatement.setInt(3, n2);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueIndex");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        resultSet = preparedStatement.executeQuery();
        bl2 = resultSet.next();
        long l = 0L;
        if (bl2) {
            l = resultSet.getLong(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueIndexColumns");
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n2);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierAllColumns");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setInt(4, n);
        preparedStatement.setInt(5, n2);
        return preparedStatement.executeQuery();
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getVersionColumns");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getPrimaryKeys");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getImportedKeys");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(null));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(null));
        preparedStatement.setString(6, EmbedDatabaseMetaData.swapNull(null));
        return preparedStatement.executeQuery();
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(string5));
        preparedStatement.setString(6, EmbedDatabaseMetaData.swapNull(string6));
        return preparedStatement.executeQuery();
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.getSimpleQuery("getTypeInfo");
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        int n = 0;
        if (bl2) {
            n = 1;
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getIndexInfo");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setInt(5, n);
        return preparedStatement.executeQuery();
    }

    public boolean supportsResultSetType(int n) {
        return n == 1003 || n == 1004;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) {
        return n != 1005 && n2 != 1008;
    }

    public boolean ownUpdatesAreVisible(int n) {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) {
        return true;
    }

    public boolean othersDeletesAreVisible(int n) {
        return true;
    }

    public boolean othersInsertsAreVisible(int n) {
        return true;
    }

    public boolean updatesAreDetected(int n) {
        return false;
    }

    public boolean deletesAreDetected(int n) {
        return false;
    }

    public boolean insertsAreDetected(int n) {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            ResultSet resultSet = null;
            int n = 0;
            try {
                String string4 = this.getQueryDescriptions().getProperty("getUDTs");
                if (nArray != null && nArray.length >= 1) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        if (nArray[n2] == 2000) {
                            n = 1;
                        }
                        ++n2;
                    }
                } else {
                    n = 1;
                }
                PreparedStatement preparedStatement = this.getEmbedConnection().prepareMetaDataStatement(string4);
                preparedStatement.setInt(1, 2000);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string3));
                preparedStatement.setInt(5, n);
                resultSet = preparedStatement.executeQuery();
            }
            finally {
                Object var11_11 = null;
                this.restoreContextStack();
            }
            ResultSet resultSet2 = resultSet;
            Object var6_15 = null;
            return resultSet2;
        }
    }

    public Connection getConnection() {
        return this.getEmbedConnection().getApplicationConnection();
    }

    public boolean supportsStatementPooling() {
        return false;
    }

    public boolean supportsSavepoints() {
        return true;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    public boolean supportsResultSetHoldability(int n) {
        return true;
    }

    public int getResultSetHoldability() {
        return 1;
    }

    public int getDatabaseMajorVersion() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        if (productVersionHolder == null) {
            return -1;
        }
        return productVersionHolder.getMajorVersion();
    }

    public int getDatabaseMinorVersion() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        if (productVersionHolder == null) {
            return -1;
        }
        return productVersionHolder.getMinorVersion();
    }

    public int getJDBCMajorVersion() {
        return 3;
    }

    public int getJDBCMinorVersion() {
        return 0;
    }

    public int getSQLStateType() {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw Util.notImplemented();
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw Util.notImplemented();
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw Util.notImplemented();
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw Util.notImplemented();
    }

    private ResultSet getSimpleQuery(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string);
        if (preparedStatement == null) {
            return null;
        }
        return preparedStatement.executeQuery();
    }

    private PreparedStatement getPreparedQuery(String string) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement preparedStatement = null;
            try {
                try {
                    String string2 = this.getQueryDescriptions().getProperty(string);
                    if (string2 == null) {
                        throw Util.notImplemented(string);
                    }
                    preparedStatement = this.prepareSPS(string, string2);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            PreparedStatement preparedStatement2 = preparedStatement;
            Object var3_10 = null;
            return preparedStatement2;
        }
    }

    private PreparedStatement prepareSPS(String string, String string2) throws StandardException, SQLException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        languageConnectionContext.beginNestedTransaction(true);
        DataDictionary dataDictionary = this.getLanguageConnectionContext().getDataDictionary();
        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(string, dataDictionary.getSystemSchemaDescriptor());
        languageConnectionContext.commitNestedTransaction();
        if (sPSDescriptor == null) {
            throw Util.notImplemented(string);
        }
        return this.getEmbedConnection().prepareMetaDataStatement("EXECUTE STATEMENT SYS.\"" + string + "\"");
    }

    protected static final String swapNull(String string) {
        return string == null ? "%" : string;
    }

    private GenericConstantActionFactory getGenericConstantActionFactory() throws StandardException {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory genericExecutionFactory = (GenericExecutionFactory)this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
            this.constantActionFactory = genericExecutionFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return this.getEmbedConnection().getLanguageConnection();
    }

    private final Properties loadQueryDescriptions() {
        return (Properties)AccessController.doPrivileged(this);
    }

    public final Object run() {
        return this.PBloadQueryDescriptions();
    }

    public EmbedDatabaseMetaData(EmbedConnection embedConnection, String string) throws SQLException {
        super(embedConnection);
        this.url = string;
    }
}

