/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class CardinalityCounter
implements RowLocationRetRowSource {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2001, 2004.";
    private RowLocationRetRowSource rowSource;
    private DataValueDescriptor[] prevKey;
    private long[] cardinality;
    private long numRows;

    public boolean needsRowLocation() {
        return this.rowSource.needsRowLocation();
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
        this.rowSource.rowLocation(rowLocation);
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.rowSource.getNextRowFromRowSource();
        if (dataValueDescriptorArray != null) {
            this.keepCount(dataValueDescriptorArray);
        }
        return dataValueDescriptorArray;
    }

    public boolean needsToClone() {
        return this.rowSource.needsToClone();
    }

    public FormatableBitSet getValidColumns() {
        return this.rowSource.getValidColumns();
    }

    public void closeRowSource() {
        this.rowSource.closeRowSource();
    }

    private DataValueDescriptor[] clone(DataValueDescriptor[] dataValueDescriptorArray) {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        int n = 0;
        while (n < dataValueDescriptorArray.length - 1) {
            dataValueDescriptorArray2[n] = dataValueDescriptorArray[n].getClone();
            ++n;
        }
        return dataValueDescriptorArray2;
    }

    public void keepCount(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n = dataValueDescriptorArray.length - 1;
        ++this.numRows;
        if (this.prevKey == null) {
            this.prevKey = this.clone(dataValueDescriptorArray);
            this.cardinality = new long[dataValueDescriptorArray.length - 1];
            int n2 = 0;
            while (n2 < n) {
                this.cardinality[n2] = 1L;
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.prevKey[n3].isNull()) break;
            if (this.prevKey[n3].compare(dataValueDescriptorArray[n3]) != 0) {
                this.prevKey = null;
                this.prevKey = this.clone(dataValueDescriptorArray);
                break;
            }
            ++n3;
        }
        int n4 = n3;
        while (n4 < n) {
            int n5 = n4++;
            this.cardinality[n5] = this.cardinality[n5] + 1L;
        }
    }

    public long[] getCardinality() {
        return this.cardinality;
    }

    public long getRowCount() {
        return this.numRows;
    }

    public CardinalityCounter(RowLocationRetRowSource rowLocationRetRowSource) {
        this.rowSource = rowLocationRetRowSource;
    }
}

