/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregator;

public class AggregateSortObserver
extends BasicSortObserver {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    protected GenericAggregator[] aggsToProcess;
    protected GenericAggregator[] aggsToInitialize;
    private int firstAggregatorColumn;

    public DataValueDescriptor[] insertNonDuplicateKey(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Object[] objectArray = super.insertNonDuplicateKey(dataValueDescriptorArray);
        if (this.aggsToInitialize.length > 0 && objectArray[this.firstAggregatorColumn].isNull()) {
            int n = 0;
            while (n < this.aggsToInitialize.length) {
                GenericAggregator genericAggregator = this.aggsToInitialize[n];
                UserDataValue userDataValue = (UserDataValue)objectArray[genericAggregator.aggregatorColumnId];
                userDataValue.setValue(genericAggregator.getAggregatorInstance());
                genericAggregator.accumulate(objectArray, objectArray);
                ++n;
            }
        }
        return objectArray;
    }

    public DataValueDescriptor[] insertDuplicateKey(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        if (this.aggsToProcess.length == 0) {
            return null;
        }
        int n = 0;
        while (n < this.aggsToProcess.length) {
            GenericAggregator genericAggregator = this.aggsToProcess[n];
            if (dataValueDescriptorArray[genericAggregator.getColumnId()].isNull()) {
                genericAggregator.accumulate(dataValueDescriptorArray, dataValueDescriptorArray2);
            } else {
                genericAggregator.merge(dataValueDescriptorArray, dataValueDescriptorArray2);
            }
            ++n;
        }
        return null;
    }

    public AggregateSortObserver(boolean bl, GenericAggregator[] genericAggregatorArray, GenericAggregator[] genericAggregatorArray2, ExecRow execRow) {
        super(bl, false, execRow, true);
        this.aggsToProcess = genericAggregatorArray;
        this.aggsToInitialize = genericAggregatorArray2;
        if (genericAggregatorArray2.length > 0) {
            this.firstAggregatorColumn = genericAggregatorArray2[0].aggregatorColumnId;
        }
    }
}

