/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class TimestampTypeCompiler
extends BaseTypeCompiler {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";

    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        return this.comparable(this.getTypeId(), typeId, bl, classFactory);
    }

    boolean comparable(TypeId typeId, TypeId typeId2, boolean bl, ClassFactory classFactory) {
        int n = typeId2.getJDBCTypeId();
        if (typeId2.isLongConcatableTypeId()) {
            return false;
        }
        TypeCompiler typeCompiler = this.getTypeCompiler(typeId2);
        if (n == 93 || typeId2.isStringTypeId()) {
            return true;
        }
        if (typeId2.userType()) {
            return typeCompiler.comparable(this.getTypeId(), bl, classFactory);
        }
        return false;
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        if (typeId.isStringTypeId() && !typeId.isLongConcatableTypeId()) {
            return true;
        }
        int n = typeId.getJDBCTypeId();
        if (n == 93) {
            return true;
        }
        return n == 91 || n == 92;
    }

    public boolean compatible(TypeId typeId) {
        if (typeId.isStringTypeId() && !typeId.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == typeId.getTypeFormatId();
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        int n = typeId.getJDBCTypeId();
        if (n == 93 || n == 1 || n == 12) {
            return true;
        }
        return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), "java.sql.Timestamp");
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Timestamp";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 26;
    }

    public double estimatedMemoryUsage(DataTypeDescriptor dataTypeDescriptor) {
        return 12.0;
    }

    protected String nullMethodName() {
        return "getNullTimestamp";
    }
}

