/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;

public class EmbedResultSet20
extends EmbedResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private int fetchDirection;
    private int fetchSize;

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            return bigDecimal.setScale(n2, 5);
        }
        return null;
    }

    public final BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return dataValueDescriptor.getBigDecimal();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumnName(string), n);
    }

    public final Statement getStatement() {
        return this.stmt;
    }

    public final InputStream getUnicodeStream(int n) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    public final InputStream getUnicodeStream(String string) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumnName(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.checkRowPosition(101, "isBeforeFirst");
    }

    public boolean isAfterLast() throws SQLException {
        return this.checkRowPosition(104, "isAfterLast");
    }

    public boolean isFirst() throws SQLException {
        return this.checkRowPosition(102, "isFirst");
    }

    public boolean isLast() throws SQLException {
        return this.checkRowPosition(103, "isLast");
    }

    public void beforeFirst() throws SQLException {
        this.checkScrollCursor("beforeFirst()");
        this.movePosition(5, "beforeFirst");
    }

    public void afterLast() throws SQLException {
        this.checkScrollCursor("afterLast()");
        this.movePosition(6, "afterLast");
    }

    public boolean first() throws SQLException {
        this.checkScrollCursor("first()");
        return this.movePosition(1, "first");
    }

    public boolean last() throws SQLException {
        this.checkScrollCursor("last()");
        return this.movePosition(3, "last");
    }

    public int getRow() throws SQLException {
        this.checkScrollCursor("getRow()");
        return this.theResults.getRowNumber();
    }

    public boolean absolute(int n) throws SQLException {
        this.checkScrollCursor("absolute()");
        return this.movePosition(7, n, "absolute");
    }

    public boolean relative(int n) throws SQLException {
        this.checkScrollCursor("relative()");
        return this.movePosition(8, n, "relative");
    }

    public boolean previous() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, "previous");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkScrollCursor("setFetchDirection()");
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        if (this.fetchDirection == 0) {
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || this.stmt.getMaxRows() != 0 && n > this.stmt.getMaxRows()) {
            throw Util.generateCsSQLException("XJ062.S", new Integer(n));
        }
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    public int getFetchSize() throws SQLException {
        if (this.fetchSize == 0) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw Util.notImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw Util.notImplemented();
    }

    public boolean rowDeleted() throws SQLException {
        throw Util.notImplemented();
    }

    public void updateNull(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateShort(int n, short s) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateLong(int n, long l) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateString(int n, String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateNull(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateShort(String string, short s) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateInt(String string, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateLong(String string, long l) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateString(String string, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw Util.notImplemented();
    }

    public void insertRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void updateRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void deleteRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void refreshRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void cancelRowUpdates() throws SQLException {
        throw Util.notImplemented();
    }

    public void moveToInsertRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void moveToCurrentRow() throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw Util.notImplemented();
    }

    public Ref getRef(int n) throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Blob getBlob(int n) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getBlob");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            EmbedBlob embedBlob;
            boolean bl;
            block14: {
                Blob blob;
                block13: {
                    int n2 = this.getColumnType(n);
                    if (n2 != 2004) {
                        throw this.dataTypeConversion("java.sql.Blob", n);
                    }
                    bl = false;
                    try {
                        try {
                            DataValueDescriptor dataValueDescriptor = this.currentRow.getColumn(n);
                            this.wasNull = dataValueDescriptor.isNull();
                            if (this.wasNull) {
                                blob = null;
                                Object var8_9 = null;
                                if (!bl) {
                                    return blob;
                                }
                                break block13;
                            }
                            if (dataValueDescriptor.getStream() != null) {
                                bl = true;
                            }
                            if (bl) {
                                this.setupContextStack();
                            }
                            embedBlob = new EmbedBlob(dataValueDescriptor, this.getEmbedConnection());
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw this.handleException(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return blob;
            }
            Object var8_10 = null;
            if (!bl) return embedBlob;
            this.restoreContextStack();
            return embedBlob;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Clob getClob(int n) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getClob");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            EmbedClob embedClob;
            boolean bl;
            block14: {
                Clob clob;
                block13: {
                    int n2 = this.getColumnType(n);
                    if (n2 != 2005) {
                        throw this.dataTypeConversion("java.sql.Clob", n);
                    }
                    bl = false;
                    try {
                        try {
                            DataValueDescriptor dataValueDescriptor = this.currentRow.getColumn(n);
                            this.wasNull = dataValueDescriptor.isNull();
                            if (this.wasNull) {
                                clob = null;
                                Object var8_9 = null;
                                if (!bl) {
                                    return clob;
                                }
                                break block13;
                            }
                            if (dataValueDescriptor.getStream() != null) {
                                bl = true;
                            }
                            if (bl) {
                                this.setupContextStack();
                            }
                            embedClob = new EmbedClob(dataValueDescriptor, this.getEmbedConnection());
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw this.handleException(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return clob;
            }
            Object var8_10 = null;
            if (!bl) return embedClob;
            this.restoreContextStack();
            return embedClob;
        }
    }

    public Array getArray(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw Util.notImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public final Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumnName(string));
    }

    public final Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumnName(string));
    }

    public Array getArray(String string) throws SQLException {
        throw Util.notImplemented();
    }

    private void checkScrollCursor(String string) throws SQLException {
        if (this.stmt.getResultSetType() == 1003) {
            throw Util.newEmbedSQLException("XJ061.S", new Object[]{string}, StandardException.getSeverityFromIdentifier("XJ061.S"));
        }
    }

    public URL getURL(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public URL getURL(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRowPosition(int n, String string) throws SQLException {
        this.checkScrollCursor(string);
        this.checkIfClosed(string);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.setupContextStack();
            try {
                try {
                    LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                    StatementContext statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, this.getSQLText(), this.getParameterValueSet(), false);
                    boolean bl2 = this.theResults.checkRowPosition(n);
                    languageConnectionContext.popStatementContext(statementContext, null);
                    bl = bl2;
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    throw this.closeOnTransactionError(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    public EmbedResultSet20(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) {
        super(embedConnection, resultSet, bl, embedStatement, bl2);
    }
}

