/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;

class DateTimeParser {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2004.";
    private String str;
    private String trimmedString;
    private int len;
    private int fieldStart;
    private char currentSeparator;

    int parseInt(int n, boolean bl, char[] cArray, boolean bl2) throws StandardException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (this.fieldStart < this.len) {
            char c = this.str.charAt(this.fieldStart);
            if (!Character.isDigit(c)) break;
            if (n4 >= n) {
                throw StandardException.newException("22007.S.181");
            }
            ++n4;
            n3 = n3 * 10 + Character.digit(c, 10);
            ++this.fieldStart;
        }
        boolean bl3 = bl ? n4 == 0 && !bl2 : n4 != n;
        if (bl3) {
            throw StandardException.newException("22007.S.181");
        }
        this.updateCurrentSeparator();
        if (cArray == null) {
            if (this.fieldStart < this.len) {
                ++this.fieldStart;
            }
        } else {
            n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] != '\u0000') {
                    if (this.currentSeparator == cArray[n2]) {
                        ++this.fieldStart;
                        break;
                    }
                } else {
                    int n5 = this.fieldStart;
                    while (n5 < this.len) {
                        if (this.str.charAt(n5) != ' ') break;
                        ++n5;
                    }
                    if (n5 == this.len) {
                        this.fieldStart = n5;
                        break;
                    }
                }
                ++n2;
            }
            if (n2 >= cArray.length) {
                throw StandardException.newException("22007.S.181");
            }
        }
        if (bl2) {
            n2 = n4;
            while (n2 < n) {
                n3 *= 10;
                ++n2;
            }
        }
        return n3;
    }

    int parseChoice(String[] stringArray) throws StandardException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.length();
            if (this.fieldStart + n2 <= this.len) {
                int n3 = 0;
                while (n3 < n2) {
                    if (string.charAt(n3) != this.str.charAt(this.fieldStart + n3)) break;
                    ++n3;
                }
                if (n3 == n2) {
                    this.fieldStart += n2;
                    this.updateCurrentSeparator();
                    return n;
                }
            }
            ++n;
        }
        throw StandardException.newException("22007.S.181");
    }

    private void updateCurrentSeparator() {
        if (this.fieldStart >= this.len) {
            this.currentSeparator = '\u0000';
        } else {
            this.currentSeparator = this.str.charAt(this.fieldStart);
            if (this.currentSeparator == ' ') {
                int n = this.fieldStart + 1;
                while (n < this.len) {
                    if (this.str.charAt(n) != ' ') {
                        return;
                    }
                    ++n;
                }
                this.currentSeparator = '\u0000';
                this.fieldStart = this.len;
            }
        }
    }

    String checkEnd() throws StandardException {
        int n = this.fieldStart;
        while (this.fieldStart < this.len) {
            if (this.str.charAt(this.fieldStart) != ' ') {
                throw StandardException.newException("22007.S.181");
            }
            ++this.fieldStart;
        }
        this.currentSeparator = '\u0000';
        while (n > 0 && this.str.charAt(n - 1) == ' ') {
            --n;
        }
        this.trimmedString = n == this.len ? this.str : this.str.substring(0, n);
        return this.trimmedString;
    }

    String getTrimmedString() {
        return this.trimmedString;
    }

    char nextSeparator() {
        int n = this.fieldStart + 1;
        while (n < this.len) {
            char c = this.str.charAt(n);
            if (!Character.isLetterOrDigit(c)) {
                return c;
            }
            ++n;
        }
        return '\u0000';
    }

    char getCurrentSeparator() {
        return this.currentSeparator;
    }

    DateTimeParser(String string) {
        this.str = string;
        this.len = string.length();
    }
}

