/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.Qualifier;

public final class FetchDescriptor {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2002, 2004.";
    private static final int ZERO_FILL_LENGTH = 100;
    private static final int[] zero_fill_array = new int[100];
    private int row_length;
    private FormatableBitSet validColumns;
    private Qualifier[][] qualifier_list;
    private int[] materialized_cols;
    private int maxFetchColumnId;
    private int[] validColumnsArray;

    public final FormatableBitSet getValidColumns() {
        return this.validColumns;
    }

    public final int[] getValidColumnsArray() {
        return this.validColumnsArray;
    }

    public final void setValidColumns(FormatableBitSet formatableBitSet) {
        this.validColumns = formatableBitSet;
        this.setMaxFetchColumnId();
        if (this.validColumns != null) {
            this.validColumnsArray = new int[this.maxFetchColumnId + 1];
            int n = this.maxFetchColumnId;
            while (n >= 0) {
                this.validColumnsArray[n] = this.validColumns.isSet(n) ? 1 : 0;
                --n;
            }
        }
    }

    public final Qualifier[][] getQualifierList() {
        return this.qualifier_list;
    }

    public final int[] getMaterializedColumns() {
        return this.materialized_cols;
    }

    public final int getMaxFetchColumnId() {
        return this.maxFetchColumnId;
    }

    private final void setMaxFetchColumnId() {
        this.maxFetchColumnId = this.row_length - 1;
        if (this.validColumns != null) {
            int n = this.validColumns.getLength();
            if (n < this.maxFetchColumnId + 1) {
                this.maxFetchColumnId = n - 1;
            }
            while (this.maxFetchColumnId >= 0) {
                if (this.validColumns.isSet(this.maxFetchColumnId)) break;
                --this.maxFetchColumnId;
            }
        }
    }

    public final void reset() {
        int[] nArray = this.materialized_cols;
        if (nArray != null) {
            if (nArray.length <= 100) {
                System.arraycopy(zero_fill_array, 0, nArray, 0, nArray.length);
            } else {
                int n = 0;
                int n2 = nArray.length;
                while (n2 > 0) {
                    int n3 = n2 > zero_fill_array.length ? zero_fill_array.length : n2;
                    System.arraycopy(zero_fill_array, 0, nArray, n, n3);
                    n2 -= n3;
                    n += n3;
                }
            }
        }
    }

    FetchDescriptor() {
    }

    public FetchDescriptor(int n) {
        this.row_length = n;
    }

    public FetchDescriptor(int n, int n2) {
        this.row_length = n;
        this.maxFetchColumnId = n2;
        this.validColumnsArray = new int[this.maxFetchColumnId + 1];
        this.validColumnsArray[n2] = 1;
    }

    public FetchDescriptor(int n, FormatableBitSet formatableBitSet, Qualifier[][] qualifierArray) {
        this.row_length = n;
        this.qualifier_list = qualifierArray;
        if (this.qualifier_list != null) {
            this.materialized_cols = new int[this.row_length];
        }
        this.setValidColumns(formatableBitSet);
    }
}

