/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class DDUtils {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";

    public static ReferencedKeyConstraintDescriptor locateReferencedConstraint(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, String[] stringArray, ConsInfo consInfo) throws StandardException {
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        if (tableDescriptor2 == null) {
            throw StandardException.newException("X0Y46.S", string, (Object)consInfo.getReferencedTableName());
        }
        ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = null;
        String[] stringArray2 = consInfo.getReferencedColumnNames();
        if (stringArray2 == null || stringArray2.length == 0) {
            referencedKeyConstraintDescriptor = tableDescriptor2.getPrimaryKey();
            if (referencedKeyConstraintDescriptor == null) {
                throw StandardException.newException("X0Y41.S", string, (Object)tableDescriptor2.getQualifiedName());
            }
            ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
            if (columnDescriptorList.size() != referencedKeyConstraintDescriptor.getColumnDescriptors().size()) {
                throw StandardException.newException("X0Y43.S", string, (Object)String.valueOf(columnDescriptorList.size()), (Object)String.valueOf(referencedKeyConstraintDescriptor.getColumnDescriptors().size()));
            }
            if (!referencedKeyConstraintDescriptor.areColumnsComparable(columnDescriptorList)) {
                throw StandardException.newException("X0Y42.S", string);
            }
            return referencedKeyConstraintDescriptor;
        }
        ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n = constraintDescriptorList.size();
        int n2 = 0;
        while (n2 < n) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n2);
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor && constraintDescriptor.areColumnsComparable(columnDescriptorList) && DDUtils.columnNamesMatch(stringArray2, constraintDescriptor.getColumnDescriptors())) {
                return (ReferencedKeyConstraintDescriptor)constraintDescriptor;
            }
            ++n2;
        }
        throw StandardException.newException("X0Y44.S", string, (Object)tableDescriptor2.getQualifiedName());
    }

    public static ColumnDescriptorList getColumnDescriptors(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String[] stringArray) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        int n = 0;
        while (n < stringArray.length) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[n]);
            columnDescriptorList.add(tableDescriptor.getUUID(), columnDescriptor);
            ++n;
        }
        return columnDescriptorList;
    }

    public static boolean columnNamesMatch(String[] stringArray, ColumnDescriptorList columnDescriptorList) throws StandardException {
        if (stringArray.length != columnDescriptorList.size()) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = columnDescriptorList.elementAt(n).getColumnName();
            if (!string.equals(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void validateReferentialActions(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, ConsInfo consInfo, String[] stringArray) throws StandardException {
        int n = consInfo.getReferentialActionDeleteRule();
        if (n == 3) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[n2]);
                if (columnDescriptor.getType().isNullable()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw StandardException.newException("42834", string);
            }
        }
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        Hashtable hashtable = new Hashtable();
        boolean bl = tableDescriptor2.getUUID().equals(tableDescriptor.getUUID());
        String string2 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
        int n3 = DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor, -1, hashtable, false, true);
        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor2, n, hashtable, (Hashtable)hashtable.clone(), true, string, false, new StringBuffer(0), string2, bl, n3);
        if (!bl) {
            DDUtils.checkForAnyExistingDeleteConnectionViolations(dataDictionary, tableDescriptor, n, hashtable, string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int getCurrentDeleteConnections(DataDictionary var0, TableDescriptor var1_1, int var2_2, Hashtable var3_3, boolean var4_4, boolean var5_5) throws StandardException {
        var6_6 = -1;
        var1_1.emptyConstraintDescriptorList();
        var7_7 = var0.getConstraintDescriptors(var1_1);
        var8_8 = var7_7.size();
        var9_9 = var4_4;
        var10_10 = 0;
        while (var10_10 < var8_8) {
            block5: {
                block6: {
                    var11_11 = var7_7.elementAt(var10_10);
                    if (!(var11_11 instanceof ForeignKeyConstraintDescriptor)) break block5;
                    var12_12 = (ForeignKeyConstraintDescriptor)var11_11;
                    var13_13 = var12_12.getConstraintName();
                    var14_14 = var12_12.getRaDeleteRule();
                    var15_15 = var12_12.getRaUpdateRule();
                    if (var5_5 && var12_12.isSelfReferencingFK()) {
                        var6_6 = var14_14;
                        var5_5 = false;
                    }
                    var16_16 = var12_12.getReferencedConstraint();
                    var17_17 = var16_16.getTableDescriptor();
                    var18_18 = var2_2 == -1 ? var14_14 : var2_2;
                    var19_19 = var17_17.getSchemaName() + "." + var17_17.getName();
                    var20_20 = (Integer)var3_3.get(var19_19);
                    if (var20_20 == null) break block6;
                    var4_4 = var9_9;
                    break block5;
                }
                if (var14_14 == 0) ** GOTO lbl31
                if (var4_4) {
                    var4_4 = var9_9;
                } else {
                    var4_4 = true;
lbl31:
                    // 2 sources

                    var3_3.put(var19_19, new Integer(var18_18));
                    if (!var12_12.isSelfReferencingFK()) {
                        DDUtils.getCurrentDeleteConnections(var0, var17_17, var18_18, var3_3, true, false);
                    }
                    var4_4 = var9_9;
                }
            }
            ++var10_10;
        }
        return var6_6;
    }

    /*
     * Unable to fully structure code
     */
    private static void validateDeleteConnection(DataDictionary var0, TableDescriptor var1_1, TableDescriptor var2_2, int var3_3, Hashtable var4_4, Hashtable var5_5, boolean var6_6, String var7_7, boolean var8_8, StringBuffer var9_9, String var10_10, boolean var11_11, int var12_12) throws StandardException {
        var14_13 = var2_2.getSchemaName() + "." + var2_2.getName();
        if (var6_6) {
            var13_14 = (Integer)var4_4.get(var14_13);
            if (var11_11) {
                if (var12_12 != -1) {
                    if (var12_12 != var3_3) {
                        if (var12_12 == 3) {
                            throw DDUtils.generateError("XCL33.S", var7_7, var10_10);
                        }
                        throw DDUtils.generateError("XCL36.S", var7_7, var12_12);
                    }
                    if (var12_12 == 3 && var3_3 == 3) {
                        throw DDUtils.generateError("XCL33.S", var7_7, var10_10);
                    }
                }
                if (var11_11 && var4_4.contains(new Integer(0)) && var3_3 != 0) {
                    throw DDUtils.generateError("XCL37.S", var7_7, 0);
                }
                return;
            }
            if (var12_12 != -1 && var3_3 == 0 && var12_12 != 0) {
                throw DDUtils.generateError("XCL39.S", var7_7);
            }
            if (var13_14 != null) {
                DDUtils.checkForMultiplePathInvalidCases(var13_14, var3_3, var7_7, var10_10);
            }
            if (var3_3 != 0) {
                var8_8 = true;
            }
            var9_9 = var9_9.append(var3_3);
        }
        var15_15 = var8_8;
        var16_16 = true;
        var17_17 = var0.getConstraintDescriptors(var2_2);
        var18_18 = var17_17.size();
        var19_19 = 0;
        while (var19_19 < var18_18) {
            block23: {
                var20_20 = var17_17.elementAt(var19_19);
                if (!(var20_20 instanceof ForeignKeyConstraintDescriptor)) break block23;
                var21_21 = (ForeignKeyConstraintDescriptor)var20_20;
                var22_22 = var21_21.getConstraintName();
                var23_23 = var21_21.getRaDeleteRule();
                var24_24 = var21_21.getRaUpdateRule();
                var25_25 = var21_21.getReferencedConstraint();
                var26_26 = var25_25.getTableDescriptor();
                if (var23_23 == 0) ** GOTO lbl42
                if (var8_8) {
                    var8_8 = var15_15;
                } else {
                    var8_8 = true;
                    var16_16 = false;
lbl42:
                    // 2 sources

                    var27_27 = var21_21.isSelfReferencingFK();
                    var9_9 = var9_9.append(var23_23);
                    var28_28 = var26_26.getUUID().equals(var1_1.getUUID());
                    if (var28_28) {
                        var29_30 = 0;
                        while (var29_30 < var9_9.length()) {
                            var30_31 = Character.getNumericValue(var9_9.charAt(var29_30));
                            if (var30_31 != var3_3) {
                                if (var30_31 != 0) {
                                    throw DDUtils.generateError("XCL40.S", var7_7);
                                }
                                throw DDUtils.generateError("XCL34.S", var7_7, var10_10);
                            }
                            ++var29_30;
                        }
                    }
                    if ((var13_14 = (Integer)var5_5.get(var29_29 = var26_26.getSchemaName() + "." + var26_26.getName())) != null) {
                        if (!var27_27 && var16_16) {
                            DDUtils.checkForMultiplePathInvalidCases(var13_14, var3_3, var7_7, var10_10);
                        }
                    } else {
                        var13_14 = (Integer)var4_4.get(var29_29);
                        if (var13_14 == null) {
                            if (var16_16) {
                                var4_4.put(var29_29, new Integer(var3_3));
                            }
                            if (!var27_27) {
                                DDUtils.validateDeleteConnection(var0, var1_1, var26_26, var3_3, var4_4, var5_5, false, var7_7, var8_8, var9_9, var10_10, var11_11, var12_12);
                            }
                        }
                    }
                    var8_8 = var15_15;
                    var9_9.setLength(var9_9.length() - 1);
                }
            }
            ++var19_19;
        }
    }

    private static void checkForMultiplePathInvalidCases(int n, int n2, String string, String string2) throws StandardException {
        if (n != n2) {
            if (n == 3) {
                throw DDUtils.generateError("XCL35.S", string, string2);
            }
            throw DDUtils.generateError("XCL38.S", string, n);
        }
        if (n == 3 && n2 == 3) {
            throw DDUtils.generateError("XCL35.S", string, string2);
        }
    }

    private static void checkForAnyExistingDeleteConnectionViolations(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n, Hashtable hashtable, String string) throws StandardException {
        if (n != 0) {
            return;
        }
        String string2 = tableDescriptor.getSchemaName() + "." + tableDescriptor.getName();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n2 = constraintDescriptorList.size();
        int n3 = 0;
        while (n3 < n2) {
            ConstraintDescriptorList constraintDescriptorList2;
            int n4;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n3);
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor && (n4 = (constraintDescriptorList2 = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(3))).size()) != 0) {
                Hashtable hashtable2 = new Hashtable();
                int n5 = 0;
                while (n5 < n4) {
                    ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList2.elementAt(n5);
                    TableDescriptor tableDescriptor2 = foreignKeyConstraintDescriptor.getTableDescriptor();
                    int n6 = foreignKeyConstraintDescriptor.getRaDeleteRule();
                    if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                        DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, -1, hashtable2, false, true);
                        Enumeration enumeration = hashtable2.keys();
                        while (enumeration.hasMoreElements()) {
                            int n7;
                            String string3 = (String)enumeration.nextElement();
                            if (string3.equals(string2) || !hashtable.containsKey(string3) || ((n7 = ((Integer)hashtable2.get(string3)).intValue()) != 3 || n6 != 3) && n7 == n6) continue;
                            throw DDUtils.generateError("XCL41.S", string);
                        }
                    }
                    hashtable2.clear();
                    ++n5;
                }
            }
            ++n3;
        }
    }

    private static StandardException generateError(String string, String string2) {
        String string3 = MessageService.getTextMessage(string);
        return StandardException.newException("42915", string2, (Object)string3);
    }

    private static StandardException generateError(String string, String string2, int n) {
        String string3;
        switch (n) {
            case 0: {
                string3 = "XCL42.S";
                break;
            }
            case 1: {
                string3 = "XCL44.S";
                break;
            }
            case 2: {
                string3 = "XCL45.S";
                break;
            }
            case 3: {
                string3 = "XCL43.S";
                break;
            }
            case 4: {
                string3 = "XCL46.S";
                break;
            }
            default: {
                string3 = "XCL45.S";
            }
        }
        String string4 = MessageService.getTextMessage(string3);
        String string5 = MessageService.getTextMessage(string, string4);
        return StandardException.newException("42915", string2, (Object)string5);
    }

    private static StandardException generateError(String string, String string2, String string3) {
        String string4 = MessageService.getTextMessage(string, string3);
        return StandardException.newException("42915", string2, (Object)string4);
    }
}

