/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamUtil {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";

    public static int readUnsignedByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        do {
            if ((n3 = inputStream.read(byArray, n, n2)) < 0) {
                throw new EOFException();
            }
            n += n3;
        } while ((n2 -= n3) != 0);
    }

    public static int readLoop(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        while ((n3 = inputStream.read(byArray, n, n2)) > 0) {
            n += n3;
            if ((n2 -= n3) != 0) continue;
        }
        return n - n4;
    }

    public static long skipBytes(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 < 0L) {
                throw new EOFException();
            }
            l -= l2;
        }
        return l;
    }
}

