/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageRandomAccessFile;

public class Scan
implements StreamLogScan {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public static final byte FORWARD = 1;
    public static final byte BACKWARD = 2;
    public static final byte BACKWARD_FROM_LOG_END = 4;
    private StorageRandomAccessFile scan;
    private LogToFile logFactory;
    private long currentLogFileNumber;
    private long currentLogFileLength;
    private long knownGoodLogEnd;
    private long currentInstant;
    private long stopAt;
    private byte scanDirection;
    private boolean fuzzyLogEnd = false;

    public LogRecord getNextRecord(ArrayInputStream arrayInputStream, TransactionId transactionId, int n) throws StandardException {
        if (this.scan == null) {
            return null;
        }
        LogRecord logRecord = null;
        try {
            try {
                if (this.scanDirection == 2) {
                    logRecord = this.getNextRecordBackward(arrayInputStream, transactionId, n);
                } else if (this.scanDirection == 1) {
                    logRecord = this.getNextRecordForward(arrayInputStream, transactionId, n);
                }
                LogRecord logRecord2 = logRecord;
                Object var6_6 = null;
                if (logRecord == null) {
                    this.close();
                }
                return logRecord2;
            }
            catch (IOException iOException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", iOException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException));
            }
        }
        catch (Throwable throwable) {
            block10: {
                Object var6_7 = null;
                if (logRecord != null) break block10;
                this.close();
            }
            throw throwable;
        }
    }

    private LogRecord getNextRecordBackward(ArrayInputStream arrayInputStream, TransactionId transactionId, int n) throws StandardException, IOException, ClassNotFoundException {
        LogRecord logRecord;
        boolean bl;
        int n2 = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
        if (transactionId != null) {
            n2 += LogRecord.maxTransactionIdStoredSize(transactionId);
        }
        long l = this.scan.getFilePointer();
        do {
            int n3;
            bl = true;
            logRecord = null;
            int n4 = -1;
            if (l == 24L) {
                if (this.stopAt != 0L && LogCounter.getLogFileNumber(this.stopAt) == this.currentLogFileNumber) {
                    return null;
                }
                this.scan.seek(16L);
                long l2 = this.scan.readLong();
                this.scan.close();
                this.currentLogFileNumber = LogCounter.getLogFileNumber(l2);
                this.scan = this.logFactory.getLogFileAtPosition(l2);
                l = this.scan.getFilePointer();
                if (l == 24L) continue;
            }
            this.scan.seek(l - 4L);
            int n5 = this.scan.readInt();
            long l3 = l - (long)n5 - 16L;
            this.scan.seek(l3 + 4L);
            this.currentInstant = this.scan.readLong();
            if (this.currentInstant < this.stopAt && this.stopAt != 0L) {
                this.currentInstant = 0L;
                return null;
            }
            byte[] byArray = arrayInputStream.getData();
            if (byArray.length < n5) {
                byArray = new byte[n5];
                arrayInputStream.setData(byArray);
            }
            if (this.logFactory.databaseEncrypted()) {
                this.scan.readFully(byArray, 0, n5);
                n3 = this.logFactory.decrypt(byArray, 0, n5, byArray, 0);
                arrayInputStream.setLimit(0, n5);
            } else if (n == 0 && transactionId == null) {
                this.scan.readFully(byArray, 0, n5);
                arrayInputStream.setLimit(0, n5);
            } else {
                n4 = n5 > n2 ? n2 : n5;
                this.scan.readFully(byArray, 0, n4);
                arrayInputStream.setLimit(0, n4);
            }
            logRecord = (LogRecord)arrayInputStream.readObject();
            if (n != 0 || transactionId != null) {
                TransactionId transactionId2;
                if (n != 0 && (n & logRecord.group()) == 0) {
                    bl = false;
                }
                if (bl && transactionId != null && !(transactionId2 = logRecord.getTransactionId()).equals(transactionId)) {
                    bl = false;
                }
                if (bl && !this.logFactory.databaseEncrypted() && n4 < n5) {
                    n3 = arrayInputStream.getPosition();
                    this.scan.readFully(byArray, n4, n5 - n4);
                    arrayInputStream.setLimit(0, n5);
                    arrayInputStream.setPosition(n3);
                }
            }
            l = l3;
            this.scan.seek(l);
        } while (!bl);
        return logRecord;
    }

    private LogRecord getNextRecordForward(ArrayInputStream arrayInputStream, TransactionId transactionId, int n) throws StandardException, IOException, ClassNotFoundException {
        LogRecord logRecord;
        boolean bl;
        long l = this.scan.getFilePointer();
        int n2 = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
        if (transactionId != null) {
            n2 += LogRecord.maxTransactionIdStoredSize(transactionId);
        }
        do {
            int n3;
            bl = true;
            logRecord = null;
            int n4 = -1;
            if (l + 4L > this.currentLogFileLength) {
                if (l != this.currentLogFileLength) {
                    this.fuzzyLogEnd = true;
                }
                return null;
            }
            int n5 = this.scan.readInt();
            while (n5 == 0 || l + (long)n5 + 16L > this.currentLogFileLength) {
                if (n5 != 0) {
                    this.fuzzyLogEnd = true;
                    this.scan.close();
                    this.scan = null;
                    return null;
                }
                if (this.stopAt != 0L && LogCounter.getLogFileNumber(this.stopAt) == this.currentLogFileNumber) {
                    return null;
                }
                this.scan.close();
                this.scan = this.logFactory.getLogFileAtBeginning(++this.currentLogFileNumber);
                if (this.scan == null) {
                    return null;
                }
                l = this.scan.getFilePointer();
                this.currentLogFileLength = this.scan.length();
                if (l + 4L >= this.currentLogFileLength) {
                    return null;
                }
                n5 = this.scan.readInt();
            }
            this.currentInstant = this.scan.readLong();
            if (this.currentInstant < this.knownGoodLogEnd) {
                this.fuzzyLogEnd = true;
                return null;
            }
            if (this.stopAt != 0L && this.currentInstant > this.stopAt) {
                this.currentInstant = 0L;
                return null;
            }
            byte[] byArray = arrayInputStream.getData();
            if (byArray.length < n5) {
                byArray = new byte[n5];
                arrayInputStream.setData(byArray);
            }
            if (this.logFactory.databaseEncrypted()) {
                this.scan.readFully(byArray, 0, n5);
                n3 = this.logFactory.decrypt(byArray, 0, n5, byArray, 0);
                arrayInputStream.setLimit(0, n3);
            } else if (n == 0 && transactionId == null) {
                this.scan.readFully(byArray, 0, n5);
                arrayInputStream.setLimit(0, n5);
            } else {
                n4 = n5 > n2 ? n2 : n5;
                this.scan.readFully(byArray, 0, n4);
                arrayInputStream.setLimit(0, n4);
            }
            logRecord = (LogRecord)arrayInputStream.readObject();
            if (n != 0 || transactionId != null) {
                TransactionId transactionId2;
                if (n != 0 && (n & logRecord.group()) == 0) {
                    bl = false;
                }
                if (bl && transactionId != null && !(transactionId2 = logRecord.getTransactionId()).equals(transactionId)) {
                    bl = false;
                }
                if (bl && !this.logFactory.databaseEncrypted() && n4 < n5) {
                    n3 = arrayInputStream.getPosition();
                    this.scan.readFully(byArray, n4, n5 - n4);
                    arrayInputStream.setLimit(0, n5);
                    arrayInputStream.setPosition(n3);
                }
            }
            if (!bl) {
                this.scan.seek(l - 4L);
            }
            if ((n3 = this.scan.readInt()) != n5 && n3 < n5 && n3 < n5) {
                this.fuzzyLogEnd = true;
                return null;
            }
            this.knownGoodLogEnd = LogCounter.makeLogInstantAsLong(this.currentLogFileNumber, l += (long)(n5 + 16));
            this.scan.seek(l);
        } while (!bl);
        return logRecord;
    }

    public void resetPosition(LogInstant logInstant) throws IOException, StandardException {
        long l = ((LogCounter)logInstant).getValueAsLong();
        if (l == 0L || this.stopAt != 0L && this.scanDirection == 1 && l > this.stopAt || this.scanDirection == 1 && l < this.stopAt) {
            this.close();
            throw StandardException.newException("XSLB8.S", logInstant, (Object)new LogCounter(this.stopAt));
        }
        long l2 = ((LogCounter)logInstant).getLogFileNumber();
        if (l2 != this.currentLogFileNumber) {
            this.scan.close();
            this.scan = this.logFactory.getLogFileAtPosition(l);
            this.currentLogFileNumber = l2;
            if (this.scanDirection == 1) {
                this.currentLogFileLength = this.scan.length();
            }
        } else {
            long l3 = ((LogCounter)logInstant).getLogFilePosition();
            this.scan.seek(l3);
            this.currentLogFileLength = this.scan.length();
        }
        this.knownGoodLogEnd = this.currentInstant = l;
    }

    public long getInstant() {
        return this.currentInstant;
    }

    public long getLogRecordEnd() {
        return this.knownGoodLogEnd;
    }

    public boolean isLogEndFuzzy() {
        return this.fuzzyLogEnd;
    }

    public LogInstant getLogInstant() {
        if (this.currentInstant == 0L) {
            return null;
        }
        return new LogCounter(this.currentInstant);
    }

    public void close() {
        if (this.scan != null) {
            try {
                this.scan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scan = null;
        }
        this.logFactory = null;
        this.currentLogFileNumber = -1L;
        this.currentLogFileLength = -1L;
        this.knownGoodLogEnd = 0L;
        this.currentInstant = 0L;
        this.stopAt = 0L;
        this.scanDirection = 0;
    }

    public Scan(LogToFile logToFile, long l, LogInstant logInstant, byte by) throws IOException, StandardException {
        this.logFactory = logToFile;
        this.currentLogFileNumber = LogCounter.getLogFileNumber(l);
        this.currentLogFileLength = -1L;
        this.knownGoodLogEnd = 0L;
        this.currentInstant = 0L;
        this.stopAt = logInstant != null ? ((LogCounter)logInstant).getValueAsLong() : 0L;
        switch (by) {
            case 1: {
                this.scan = logToFile.getLogFileAtPosition(l);
                this.scanDirection = 1;
                this.currentLogFileLength = this.scan.length();
                break;
            }
            case 2: {
                this.scan = logToFile.getLogFileAtPosition(l);
                int n = this.scan.readInt();
                this.scan.seek(this.scan.getFilePointer() + (long)n + 16L - 4L);
                this.scanDirection = (byte)2;
                break;
            }
            case 4: {
                this.scan = logToFile.getLogFileAtPosition(l);
                this.scanDirection = (byte)2;
                break;
            }
        }
    }
}

