/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.LinkedList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.store.raw.log.LogAccessFileBuffer;
import org.apache.derby.io.StorageRandomAccessFile;

public class LogAccessFile
extends OutputStream {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private static final int LOG_RECORD_FIXED_OVERHEAD_SIZE = 16;
    private static final int LOG_NUMBER_LOG_BUFFERS = 3;
    static int mon_numWritesToLog;
    static int mon_numBytesToLog;
    private LinkedList freeBuffers;
    private LinkedList dirtyBuffers;
    private LogAccessFileBuffer currentBuffer;
    private boolean flushInProgress = false;
    private final StorageRandomAccessFile log;
    private final Object logFileSemaphore;

    public void writeLogRecord(int n, long l, byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws StandardException, IOException {
        int n5 = n + 16;
        if (n5 > this.currentBuffer.bytes_free && n5 <= this.currentBuffer.buffer.length) {
            this.switchLogBuffer();
        }
        if (n5 <= this.currentBuffer.bytes_free) {
            byte[] byArray3 = this.currentBuffer.buffer;
            int n6 = this.currentBuffer.position;
            byArray3[n6++] = (byte)(n >>> 24 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 16 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 8 & 0xFF);
            byArray3[n6++] = (byte)(n & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 56) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 48) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 40) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 32) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 24) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 16) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 8) & 0xFF);
            byArray3[n6++] = (byte)((int)l & 0xFF);
            int n7 = n - n4;
            System.arraycopy(byArray, n2, byArray3, n6, n7);
            n6 += n7;
            if (n4 != 0) {
                System.arraycopy(byArray2, n3, byArray3, n6, n4);
                n6 += n4;
            }
            byArray3[n6++] = (byte)(n >>> 24 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 16 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 8 & 0xFF);
            byArray3[n6++] = (byte)(n & 0xFF);
            this.currentBuffer.position = n6;
            this.currentBuffer.bytes_free -= n5;
        } else {
            this.writeInt(n);
            this.writeLong(l);
            this.write(byArray, n2, n - n4);
            if (n4 != 0) {
                this.write(byArray2, n3, n4);
            }
            this.writeInt(n);
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.currentBuffer.bytes_free < 4) {
            this.switchLogBuffer();
        }
        byte[] byArray = this.currentBuffer.buffer;
        int n2 = this.currentBuffer.position;
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        this.currentBuffer.position = n2;
        this.currentBuffer.bytes_free -= 4;
    }

    public void writeLong(long l) throws IOException {
        if (this.currentBuffer.bytes_free < 8) {
            this.switchLogBuffer();
        }
        byte[] byArray = this.currentBuffer.buffer;
        int n = this.currentBuffer.position;
        byArray[n++] = (byte)((int)(l >>> 56) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 48) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 40) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 32) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 24) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 16) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 8) & 0xFF);
        byArray[n++] = (byte)((int)l & 0xFF);
        this.currentBuffer.position = n;
        this.currentBuffer.bytes_free -= 8;
    }

    public void write(int n) throws IOException {
        if (this.currentBuffer.bytes_free == 0) {
            this.switchLogBuffer();
        }
        this.currentBuffer.buffer[this.currentBuffer.position++] = (byte)n;
        --this.currentBuffer.bytes_free;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= this.currentBuffer.bytes_free) {
            System.arraycopy(byArray, n, this.currentBuffer.buffer, this.currentBuffer.position, n2);
            this.currentBuffer.bytes_free -= n2;
            this.currentBuffer.position += n2;
            return;
        }
        if (n2 <= this.currentBuffer.buffer.length) {
            System.arraycopy(byArray, n, this.currentBuffer.buffer, this.currentBuffer.position, this.currentBuffer.bytes_free);
            this.currentBuffer.position += this.currentBuffer.bytes_free;
            this.currentBuffer.bytes_free = 0;
            this.switchLogBuffer();
            System.arraycopy(byArray, n += this.currentBuffer.bytes_free, this.currentBuffer.buffer, 0, n2 -= this.currentBuffer.bytes_free);
            this.currentBuffer.position = n2;
            this.currentBuffer.bytes_free -= n2;
        } else {
            this.flushLogAccessFile();
            this.writeToLog(byArray, n, n2);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void flushDirtyBuffers() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void flushLogAccessFile() throws IOException {
        this.switchLogBuffer();
        this.flushDirtyBuffers();
    }

    public void switchLogBuffer() throws IOException {
        LogAccessFile logAccessFile = this;
        synchronized (logAccessFile) {
            this.dirtyBuffers.addLast(this.currentBuffer);
            if (this.freeBuffers.size() == 0) {
                this.flushDirtyBuffers();
            }
            this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
            this.currentBuffer.init();
        }
    }

    public void syncLogAccessFile() throws IOException, StandardException {
        int n = 0;
        while (true) {
            try {
                LogAccessFile logAccessFile = this;
                synchronized (logAccessFile) {
                    this.log.sync(false);
                }
            }
            catch (SyncFailedException syncFailedException) {
                ++n;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= 20) continue;
                throw StandardException.newException("XSLA4.D", syncFailedException, null);
            }
            break;
        }
    }

    public void corrupt() throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    public void close() throws IOException {
        this.flushLogAccessFile();
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    private void writeToLog(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                int n3 = 0;
                while (true) {
                    try {
                        this.log.write(byArray, n, n2);
                    }
                    catch (IOException iOException) {
                        if (n3 >= 5) {
                            throw iOException;
                        }
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public LogAccessFile(StorageRandomAccessFile storageRandomAccessFile, int n) throws IOException {
        this.log = storageRandomAccessFile;
        this.logFileSemaphore = storageRandomAccessFile;
        this.freeBuffers = new LinkedList();
        this.dirtyBuffers = new LinkedList();
        int n2 = 0;
        while (n2 < 3) {
            LogAccessFileBuffer logAccessFileBuffer = new LogAccessFileBuffer(n);
            this.freeBuffers.addLast(logAccessFileBuffer);
            ++n2;
        }
        this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
    }
}

