/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortScan;

public class MergeScan
extends SortScan {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected SortBuffer sortBuffer;
    protected Vector mergeRuns;
    protected StreamContainerHandle[] openScans;
    private SortObserver sortObserver;

    public boolean next() throws StandardException {
        this.current = this.sortBuffer.removeFirst();
        if (this.current != null) {
            this.mergeARow(this.sortBuffer.getLastAux());
        }
        return this.current != null;
    }

    public void close() {
        if (this.openScans != null) {
            int n = 0;
            while (n < this.openScans.length) {
                if (this.openScans[n] != null) {
                    this.openScans[n].close();
                }
                this.openScans[n] = null;
                ++n;
            }
            this.openScans = null;
        }
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer, this.mergeRuns);
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        super.close();
    }

    public boolean closeForEndTransaction(boolean bl) {
        if (!this.hold || bl) {
            this.close();
            return true;
        }
        return false;
    }

    public boolean init(TransactionManager transactionManager) throws StandardException {
        this.sortBuffer.reset();
        this.openScans = new StreamContainerHandle[this.mergeRuns.size()];
        if (this.openScans == null) {
            return false;
        }
        int n = 0;
        Enumeration enumeration = this.mergeRuns.elements();
        while (enumeration.hasMoreElements()) {
            long l = (Long)enumeration.nextElement();
            Transaction transaction = transactionManager.getRawStoreXact();
            int n2 = -1;
            this.openScans[n++] = transaction.openStreamContainer(n2, l, this.hold);
        }
        n = 0;
        while (n < this.openScans.length) {
            this.mergeARow(n);
            ++n;
        }
        return true;
    }

    void mergeARow(int n) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        do {
            if (!this.openScans[n].fetchNext(dataValueDescriptorArray = this.sortObserver.getArrayClone())) {
                this.openScans[n].close();
                this.openScans[n] = null;
                return;
            }
            this.sortBuffer.setNextAux(n);
        } while (this.sortBuffer.insert(dataValueDescriptorArray) == 1);
    }

    MergeScan(MergeSort mergeSort, TransactionManager transactionManager, SortBuffer sortBuffer, Vector vector, SortObserver sortObserver, boolean bl) {
        super(mergeSort, transactionManager, bl);
        this.sortBuffer = sortBuffer;
        this.mergeRuns = vector;
        this.tran = transactionManager;
        this.sortObserver = sortObserver;
    }
}

